/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.BitSet;
import javax.swing.JComponent;
import javax.swing.Timer;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.ttools.plot.ColorTweaker;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.util.IntList;

public class AnnotationPanel
extends JComponent
implements ActionListener {
    private int[] activePoints_;
    private PlotData data_;
    private DataId dataId_;
    private PointPlacer placer_;
    private static final PulseColorTweaker flasher_ = new PulseColorTweaker();
    private static final MarkStyle CURSOR_STYLE = MarkStyle.targetStyle();
    private static Timer timer_;

    public AnnotationPanel() {
        this.setOpaque(false);
        this.activePoints_ = new int[0];
        this.dataId_ = new DataId(null);
        this.setPulsing(false);
    }

    public void setActivePoints(int[] ipoints) {
        this.activePoints_ = (int[])ipoints.clone();
        this.repaint();
    }

    public int[] getActivePoints() {
        return (int[])this.activePoints_.clone();
    }

    public void clear() {
        this.setActivePoints(new int[0]);
    }

    public void setPlotData(PlotData data) {
        DataId id = new DataId((PointSelection)data);
        if (!id.equals(this.dataId_)) {
            this.dataId_ = id;
            this.clear();
        }
        this.data_ = data;
    }

    public void setPlacer(PointPlacer placer) {
        this.placer_ = placer;
    }

    public PointPlacer getPlacer() {
        return this.placer_;
    }

    protected boolean isIncluded(PointSequence pseq) {
        int nset = this.data_.getSetCount();
        for (int is = 0; is < nset; ++is) {
            if (!pseq.isIncluded(is)) continue;
            return true;
        }
        return false;
    }

    public void dropInvisibles() {
        if (this.activePoints_.length == 0) {
            return;
        }
        if (this.data_ == null) {
            this.activePoints_ = new int[0];
        } else {
            BitSet activeMask = new BitSet();
            for (int i = 0; i < this.activePoints_.length; ++i) {
                activeMask.set(this.activePoints_[i]);
            }
            IntList visibleList = new IntList();
            PointPlacer placer = this.getPlacer();
            PointSequence pseq = this.data_.getPointSequence();
            int ip = 0;
            while (pseq.next()) {
                if (activeMask.get(ip) && this.isIncluded(pseq) && placer.getXY(pseq.getPoint()) != null) {
                    visibleList.add(ip);
                }
                ++ip;
            }
            pseq.close();
            this.activePoints_ = visibleList.toIntArray();
        }
    }

    public void setPulsing(boolean isPulsing) {
        if (isPulsing) {
            AnnotationPanel.getPulseTimer().addActionListener(this);
        } else if (timer_ != null) {
            timer_.removeActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == timer_) {
            this.repaint();
        }
    }

    protected void paintComponent(Graphics g) {
        PointPlacer placer = this.getPlacer();
        if (this.activePoints_.length == 0 || this.data_ == null || placer == null) {
            return;
        }
        BitSet activeMask = new BitSet();
        for (int i = 0; i < this.activePoints_.length; ++i) {
            activeMask.set(this.activePoints_[i]);
        }
        PointSequence pseq = this.data_.getPointSequence();
        int ip = 0;
        while (pseq.next()) {
            Point xy;
            if (activeMask.get(ip) && this.isIncluded(pseq) && (xy = placer.getXY(pseq.getPoint())) != null) {
                CURSOR_STYLE.drawMarker(g, xy.x, xy.y, (ColorTweaker)flasher_);
            }
            ++ip;
        }
        pseq.close();
    }

    private static Timer getPulseTimer() {
        if (timer_ == null) {
            timer_ = new Timer(125, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    flasher_.bump();
                }
            });
            timer_.start();
        }
        return timer_;
    }

    private static class PulseColorTweaker
    implements ColorTweaker {
        private byte quantum_ = (byte)16;
        private byte phase_;
        private float[] rgba_;
        private Color color_;

        PulseColorTweaker() {
            this.configure();
        }

        public void bump() {
            this.phase_ = (byte)(this.phase_ + this.quantum_);
            this.configure();
        }

        public Color tweakColor(Color orig) {
            return this.color_;
        }

        public void tweakColor(float[] rgba) {
            System.arraycopy(this.rgba_, 0, rgba, 0, this.rgba_.length);
        }

        private void configure() {
            float level = (float)Math.abs(this.phase_) / 128.0f;
            this.rgba_ = new float[]{level, level, level, 0.7f};
            this.color_ = new Color(level, level, level, 0.7f);
        }
    }

    private static class DataId {
        private final TopcatModel[] tables_;
        private final int[] isets_;

        DataId(PointSelection psel) {
            if (psel == null) {
                this.tables_ = new TopcatModel[0];
                this.isets_ = new int[0];
            } else {
                SetId[] setIds = psel.getSetIds();
                int nset = setIds.length;
                this.tables_ = new TopcatModel[nset];
                this.isets_ = new int[nset];
                for (int is = 0; is < nset; ++is) {
                    this.isets_[is] = setIds[is].getSetIndex();
                    this.tables_[is] = setIds[is].getPointSelector().getTable();
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof DataId) {
                DataId other = (DataId)o;
                return Arrays.equals(this.tables_, other.tables_) && Arrays.equals(this.isets_, other.isets_);
            }
            return false;
        }

        public int hashCode() {
            int code = 503;
            for (int is = 0; is < this.isets_.length; ++is) {
                code = 23 * code + this.isets_[is];
                code = 23 * code + this.tables_[is].hashCode();
            }
            return code;
        }
    }
}

