/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisDataSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.CartesianAxesSelector;
import uk.ac.starlink.topcat.plot.CartesianPointStore;
import uk.ac.starlink.topcat.plot.ComboBoxBumper;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.topcat.plot.ShaderListCellRenderer;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.util.Wrapper;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class AugmentedAxesSelector
implements AxesSelector,
Wrapper {
    private final AxesSelector baseSelector_;
    private final int naux_;
    private final ToggleButtonModel[] logModels_;
    private final ToggleButtonModel[] flipModels_;
    private final CartesianAxesSelector auxSelector_;
    private final ComboBoxModel[] shaderModels_;
    private final JComponent selectorPanel_;
    private final JComponent auxPanel_;
    private TopcatModel tcModel_;
    private int nVisible_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AugmentedAxesSelector(AxesSelector baseSelector, int naux, ToggleButtonModel[] logModels, ToggleButtonModel[] flipModels, ComboBoxModel[] shaderModels) {
        int i;
        this.baseSelector_ = baseSelector;
        this.naux_ = naux;
        this.logModels_ = logModels;
        this.flipModels_ = flipModels;
        this.shaderModels_ = shaderModels;
        if (logModels != null && logModels.length != naux || flipModels != null && flipModels.length != naux || shaderModels != null && shaderModels.length != naux) {
            throw new IllegalArgumentException();
        }
        String[] auxNames = new String[naux];
        for (i = 0; i < naux; ++i) {
            auxNames[i] = "Aux " + (i + 1);
        }
        this.auxSelector_ = new CartesianAxesSelector(auxNames, logModels, flipModels, new ErrorModeSelectionModel[0]);
        if (this.shaderModels_ != null) {
            for (i = 0; i < naux; ++i) {
                AxisDataSelector selector = this.auxSelector_.getDataSelector(i);
                JComboBox<Object> shaderSelector = new JComboBox<Object>(this.shaderModels_[i]);
                shaderSelector.setRenderer(new ShaderListCellRenderer(shaderSelector));
                Box box = Box.createHorizontalBox();
                box.add((Component)new ShrinkWrapper(shaderSelector));
                box.add(Box.createHorizontalStrut(5));
                box.add(new ComboBoxBumper(shaderSelector));
                box.add(Box.createHorizontalGlue());
                selector.add(box);
            }
        }
        for (i = 0; i < naux; ++i) {
            this.auxSelector_.getDataSelector(i).setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        }
        this.selectorPanel_ = Box.createVerticalBox();
        this.selectorPanel_.add(baseSelector.getColumnSelectorPanel());
        this.auxPanel_ = Box.createVerticalBox();
        this.selectorPanel_.add(this.auxPanel_);
    }

    public Object getBase() {
        return this.baseSelector_;
    }

    public CartesianAxesSelector getAuxSelector() {
        return this.auxSelector_;
    }

    public void setAuxVisible(int nVis) {
        for (int i = 0; i < this.naux_; ++i) {
            boolean wantVis;
            AxisDataSelector csel = this.auxSelector_.getDataSelector(i);
            boolean isVis = i < this.nVisible_;
            boolean bl = wantVis = i < nVis;
            if (isVis && !wantVis) {
                this.auxPanel_.remove(csel);
                continue;
            }
            if (!isVis && wantVis) {
                this.auxPanel_.add(csel);
                continue;
            }
            if (!$assertionsDisabled && isVis != wantVis) {
                throw new AssertionError();
            }
        }
        this.nVisible_ = nVis;
        this.auxPanel_.revalidate();
    }

    public JComponent getColumnSelectorPanel() {
        return this.selectorPanel_;
    }

    public JComboBox[] getColumnSelectors() {
        JComboBox[] baseSelectors = this.baseSelector_.getColumnSelectors();
        JComboBox[] auxSelectors = this.auxSelector_.getColumnSelectors();
        JComboBox[] selectors = new JComboBox[baseSelectors.length + auxSelectors.length];
        System.arraycopy(baseSelectors, 0, selectors, 0, baseSelectors.length);
        System.arraycopy(auxSelectors, 0, selectors, baseSelectors.length, auxSelectors.length);
        return selectors;
    }

    public int getNdim() {
        return this.baseSelector_.getNdim() + this.nVisible_;
    }

    public boolean isReady() {
        return this.baseSelector_.isReady();
    }

    public StarTable getData() {
        StarTable baseData = this.baseSelector_.getData();
        if (this.nVisible_ == 0) {
            return baseData;
        }
        StarTable auxData = this.auxSelector_.getData();
        boolean[] reqAuxCols = new boolean[this.naux_];
        for (int iaux = 0; iaux < this.naux_; ++iaux) {
            reqAuxCols[iaux] = this.auxSelector_.getColumnSelector(iaux).getSelectedItem() != null;
        }
        return new AugmentedDataTable(baseData, auxData, reqAuxCols);
    }

    public StarTable getErrorData() {
        return this.baseSelector_.getErrorData();
    }

    public ErrorMode[] getErrorModes() {
        return this.baseSelector_.getErrorModes();
    }

    public StarTable getLabelData() {
        return this.baseSelector_.getLabelData();
    }

    public AxisEditor[] createAxisEditors() {
        AxisEditor[] baseEds = this.baseSelector_.createAxisEditors();
        AxisEditor[] auxEds = this.auxSelector_.createAxisEditors();
        AxisEditor[] eds = new AxisEditor[baseEds.length + auxEds.length];
        System.arraycopy(baseEds, 0, eds, 0, baseEds.length);
        System.arraycopy(auxEds, 0, eds, baseEds.length, auxEds.length);
        return eds;
    }

    public PointStore createPointStore(int npoint) {
        PointStore baseStore = this.baseSelector_.createPointStore(npoint);
        if (this.nVisible_ == 0) {
            return baseStore;
        }
        if (this.baseSelector_ instanceof CartesianAxesSelector && !baseStore.hasLabels()) {
            return new CartesianPointStore(this.getNdim(), this.getErrorModes(), npoint);
        }
        return new AugmentedPointStore(baseStore, this.nVisible_);
    }

    public void setTable(TopcatModel tcModel) {
        this.baseSelector_.setTable(tcModel);
        this.auxSelector_.setTable(tcModel);
        this.tcModel_ = tcModel;
    }

    public void initialiseSelectors() {
        this.baseSelector_.initialiseSelectors();
    }

    public void addActionListener(ActionListener listener) {
        this.baseSelector_.addActionListener(listener);
        this.auxSelector_.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.baseSelector_.removeActionListener(listener);
        this.auxSelector_.removeActionListener(listener);
    }

    static {
        $assertionsDisabled = !AugmentedAxesSelector.class.desiredAssertionStatus();
    }

    private static class AugmentedPointStore
    implements PointStore,
    Wrapper {
        final PointStore baseStore_;
        final PointStore augStore_;
        final int baseDim_;
        final int augDim_;
        final double[] point_;
        final Object[] baseCoords_;
        final Object[] augCoords_;
        final Object[] augErrors_;

        AugmentedPointStore(PointStore base, int nExtra) {
            this.baseStore_ = base;
            this.augStore_ = new CartesianPointStore(nExtra, new ErrorMode[0], base.getCount());
            this.baseDim_ = this.baseStore_.getNdim();
            this.augDim_ = nExtra;
            this.point_ = new double[this.baseDim_ + this.augDim_];
            this.baseCoords_ = new Object[this.baseDim_];
            this.augCoords_ = new Object[this.augDim_];
            this.augErrors_ = new Object[0];
        }

        public Object getBase() {
            return this.baseStore_;
        }

        public int getCount() {
            return this.baseStore_.getCount();
        }

        public int getNdim() {
            return this.baseDim_ + this.augDim_;
        }

        public int getNerror() {
            return this.baseStore_.getNerror();
        }

        public double[] getPoint(int ipoint) {
            System.arraycopy(this.baseStore_.getPoint(ipoint), 0, this.point_, 0, this.baseDim_);
            System.arraycopy(this.augStore_.getPoint(ipoint), 0, this.point_, this.baseDim_, this.augDim_);
            return this.point_;
        }

        public double[][] getErrors(int ipoint) {
            return this.baseStore_.getErrors(ipoint);
        }

        public boolean hasLabels() {
            return this.baseStore_.hasLabels();
        }

        public String getLabel(int ipoint) {
            return this.baseStore_.getLabel(ipoint);
        }

        public void storePoint(Object[] coordRow, Object[] errorRow, String label) {
            System.arraycopy(coordRow, 0, this.baseCoords_, 0, this.baseDim_);
            System.arraycopy(coordRow, this.baseDim_, this.augCoords_, 0, this.augDim_);
            this.baseStore_.storePoint(this.baseCoords_, errorRow, label);
            this.augStore_.storePoint(this.augCoords_, this.augErrors_, null);
        }
    }

    private static class AugmentedDataTable
    extends WrapperStarTable {
        private final StarTable baseTable_;
        private final StarTable auxTable_;
        private final int[] icolReqs_;
        private final int nbase_;
        private final int nreq_;

        public AugmentedDataTable(StarTable baseTable, StarTable auxTable, boolean[] reqAuxCols) {
            super((StarTable)new JoinStarTable(new StarTable[]{baseTable, auxTable}));
            this.baseTable_ = baseTable;
            this.auxTable_ = auxTable;
            this.nbase_ = baseTable.getColumnCount();
            int[] reqs = new int[reqAuxCols.length];
            int jaux = 0;
            for (int iaux = 0; iaux < reqAuxCols.length; ++iaux) {
                if (!reqAuxCols[iaux]) continue;
                reqs[jaux++] = this.nbase_ + iaux;
            }
            this.nreq_ = jaux;
            this.icolReqs_ = new int[this.nreq_];
            System.arraycopy(reqs, 0, this.icolReqs_, 0, this.nreq_);
        }

        public Object[] getRow(long irow) throws IOException {
            Object[] row = super.getRow(irow);
            boolean ok = true;
            for (int ireq = 0; ok && ireq < this.nreq_; ++ireq) {
                int ic = this.icolReqs_[ireq];
                ok = ok && this.notBlank(row[ic]);
            }
            if (!ok) {
                for (int ic = 0; ic < this.nbase_; ++ic) {
                    row[ic] = null;
                }
            }
            return row;
        }

        public Object getCell(long irow, int icol) throws IOException {
            if (icol < this.nbase_) {
                boolean ok = true;
                for (int ireq = 0; ok && ireq < this.nreq_; ++ireq) {
                    int ic = this.icolReqs_[ireq];
                    ok = ok && this.notBlank(super.getCell(irow, ic));
                }
                return ok ? super.getCell(irow, icol) : null;
            }
            return super.getCell(irow, icol);
        }

        public RowSequence getRowSequence() throws IOException {
            return new WrapperRowSequence(this, super.getRowSequence()){
                private final /* synthetic */ AugmentedDataTable this$0;
                {
                    this.this$0 = this$0;
                    super(x0);
                }

                public Object[] getRow() throws IOException {
                    Object[] row = super.getRow();
                    boolean ok = true;
                    for (int ireq = 0; ok && ireq < AugmentedDataTable.access$000(this.this$0); ++ireq) {
                        int ic = AugmentedDataTable.access$100(this.this$0)[ireq];
                        ok = ok && AugmentedDataTable.access$200(this.this$0, row[ic]);
                    }
                    if (!ok) {
                        for (int ic = 0; ic < AugmentedDataTable.access$300(this.this$0); ++ic) {
                            row[ic] = null;
                        }
                    }
                    return row;
                }

                public Object getCell(int icol) throws IOException {
                    if (icol < AugmentedDataTable.access$300(this.this$0)) {
                        boolean ok = true;
                        for (int ireq = 0; ok && ireq < AugmentedDataTable.access$000(this.this$0); ++ireq) {
                            int ic = AugmentedDataTable.access$100(this.this$0)[ireq];
                            ok = ok && AugmentedDataTable.access$200(this.this$0, super.getCell(ic));
                        }
                        return ok ? super.getCell(icol) : null;
                    }
                    return super.getCell(icol);
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof AugmentedDataTable) {
                AugmentedDataTable other = (AugmentedDataTable)((Object)o);
                return other.baseTable_.equals(this.baseTable_) && other.auxTable_.equals(this.auxTable_);
            }
            return false;
        }

        public int hashCode() {
            int code = 5501;
            code = 23 * code + this.baseTable_.hashCode();
            code = 23 * code + this.auxTable_.hashCode();
            return code;
        }

        private boolean notBlank(Object value) {
            return value instanceof Number && !Double.isNaN(((Number)value).doubleValue());
        }

        static /* synthetic */ int access$000(AugmentedDataTable x0) {
            return x0.nreq_;
        }

        static /* synthetic */ int[] access$100(AugmentedDataTable x0) {
            return x0.icolReqs_;
        }

        static /* synthetic */ boolean access$200(AugmentedDataTable x0, Object x1) {
            return x0.notBlank(x1);
        }

        static /* synthetic */ int access$300(AugmentedDataTable x0) {
            return x0.nbase_;
        }
    }
}

