/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.topcat.ColumnDataComboBoxModel;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.ComboBoxBumper;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class AxisDataSelector
extends JPanel {
    private final JComponent extrasBox_;
    private final JComboBox atSelector_;
    private final JComboBox loSelector_;
    private final JComboBox hiSelector_;
    private final JComboBox lhSelector_;
    private final Map extentMap_;
    private final ActionForwarder actionForwarder_;
    private ErrorMode errorMode_ = ErrorMode.NONE;
    private static final ColumnSelectionTracker colSelectionTracker_;
    private static final Pattern ERR_NAME_REGEX;
    private static final Pattern ERR_UCD_REGEX;
    private static final ErrorType LO;
    private static final ErrorType HI;
    private static final ErrorType LH;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Number;

    public AxisDataSelector(String axisName, String[] toggleNames, ToggleButtonModel[] toggleModels) {
        this.setLayout(new BoxLayout(this, 0));
        this.actionForwarder_ = new ActionForwarder();
        this.atSelector_ = ColumnDataComboBoxModel.createComboBox();
        this.loSelector_ = ColumnDataComboBoxModel.createComboBox();
        this.hiSelector_ = ColumnDataComboBoxModel.createComboBox();
        this.lhSelector_ = ColumnDataComboBoxModel.createComboBox();
        JComboBox[] selectors = this.getSelectors();
        if (!$assertionsDisabled && selectors.length != 4) {
            throw new AssertionError();
        }
        for (int i = 0; i < selectors.length; ++i) {
            selectors[i].addActionListener(this.actionForwarder_);
        }
        this.atSelector_.addActionListener(new ColumnSelectionListener(null));
        this.loSelector_.addActionListener(new ColumnSelectionListener(LO));
        this.hiSelector_.addActionListener(new ColumnSelectionListener(HI));
        this.lhSelector_.addActionListener(new ColumnSelectionListener(LH));
        this.extentMap_ = new HashMap();
        this.extentMap_.put(ErrorMode.LOWER_EXTENT, this.loSelector_);
        this.extentMap_.put(ErrorMode.UPPER_EXTENT, this.hiSelector_);
        this.extentMap_.put(ErrorMode.BOTH_EXTENT, this.lhSelector_);
        this.placeSelector(this, axisName + " Axis:", this.atSelector_);
        int ntog = toggleNames != null ? toggleNames.length : 0;
        this.extrasBox_ = Box.createHorizontalBox();
        this.add(this.extrasBox_);
        for (int itog = 0; itog < ntog; ++itog) {
            String name = toggleNames[itog];
            ToggleButtonModel model = toggleModels[itog];
            if (name == null || model == null) continue;
            JCheckBox checkBox = model.createCheckBox();
            checkBox.setText(name);
            this.add(Box.createHorizontalStrut(5));
            this.add(checkBox);
        }
        this.add(Box.createHorizontalGlue());
    }

    public void addActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionForwarder_.removeListener(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JComboBox[] selectors = this.getSelectors();
        for (int i = 0; i < selectors.length; ++i) {
            ((JComponent)selectors[i]).setEnabled(enabled);
        }
    }

    public JComboBox getMainSelector() {
        return this.atSelector_;
    }

    public JComboBox[] getErrorSelectors() {
        ErrorMode.Extent[] extents = this.errorMode_.getExtents();
        int nex = extents.length;
        JComboBox[] selectors = new JComboBox[nex];
        for (int i = 0; i < nex; ++i) {
            selectors[i] = (JComboBox)this.extentMap_.get(extents[i]);
        }
        return selectors;
    }

    public void setErrorMode(ErrorMode errorMode) {
        if (errorMode.equals(this.errorMode_)) {
            return;
        }
        this.extrasBox_.removeAll();
        ErrorMode.Extent[] extents = errorMode.getExtents();
        for (int i = 0; i < extents.length; ++i) {
            ErrorMode.Extent extent = extents[i];
            this.placeSelector(this.extrasBox_, extent.getLabel(), (JComboBox)this.extentMap_.get(extent));
        }
        this.errorMode_ = errorMode;
        this.revalidate();
    }

    public void setTable(TopcatModel tcModel) {
        JComboBox[] selectors = this.getSelectors();
        for (int i = 0; i < selectors.length; ++i) {
            JComboBox s = selectors[i];
            if (tcModel == null) {
                s.setSelectedItem(null);
                s.setEnabled(false);
                continue;
            }
            s.setModel(new ColumnDataComboBoxModel(tcModel, class$java$lang$Number == null ? AxisDataSelector.class$("java.lang.Number") : class$java$lang$Number, true));
            s.setEnabled(true);
        }
    }

    public JComboBox[] getSelectors() {
        return new JComboBox[]{this.atSelector_, this.loSelector_, this.hiSelector_, this.lhSelector_};
    }

    private void placeSelector(JComponent box, String label, JComboBox selector) {
        box.add(Box.createHorizontalStrut(5));
        box.add(new JLabel(label + " "));
        box.add((Component)new ShrinkWrapper((Component)selector));
        box.add(Box.createHorizontalStrut(5));
        box.add(new ComboBoxBumper(selector));
        box.add(Box.createHorizontalStrut(5));
    }

    private static ColumnData guessColumn(ColumnData mainCol, ErrorType type, JComboBox selector) {
        ColumnInfo mainInfo = mainCol.getColumnInfo();
        int ncol = selector.getItemCount();
        int iMain = -1;
        int bestScore = 0;
        ColumnData bestCol = null;
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnData auxCol = (ColumnData)selector.getItemAt(icol);
            if (auxCol == null) continue;
            if (auxCol.equals(mainCol)) {
                iMain = icol;
                continue;
            }
            int score = type.getLikeness(mainInfo, auxCol.getColumnInfo());
            if (score > 0 && iMain >= 0 && icol - iMain <= 2) {
                score += 4;
            }
            if (score <= bestScore) continue;
            bestScore = score;
            bestCol = auxCol;
        }
        return bestCol;
    }

    private static int getErrorLikeness(ColumnInfo mainInfo, ColumnInfo auxInfo) {
        String ucdDiff;
        int score = 0;
        String nameDiff = AxisDataSelector.getInsertion(mainInfo.getName(), auxInfo.getName());
        if (nameDiff != null && ERR_NAME_REGEX.matcher(nameDiff).matches()) {
            score += 5;
        }
        if ((ucdDiff = AxisDataSelector.getInsertion(mainInfo.getUCD(), auxInfo.getUCD())) != null && ERR_UCD_REGEX.matcher(ucdDiff).matches()) {
            score += 8;
        }
        return score;
    }

    private static String getInsertion(String s0, String s1) {
        if (s0 == null || s1 == null || s0.length() == 0 || s1.length() == 0 || s0.length() >= s1.length()) {
            return null;
        }
        int l0 = s0.length();
        int l1 = s1.length();
        int nPre = 0;
        for (int i = 0; i < l0 && s0.charAt(i) == s1.charAt(i); ++i) {
            ++nPre;
        }
        int nPost = 0;
        for (int i = 0; i < l0 && s0.charAt(l0 - 1 - i) == s1.charAt(l1 - 1 - i); ++i) {
            ++nPost;
        }
        return nPost + nPre == l0 ? s1.substring(nPre, l1 - nPost) : null;
    }

    static {
        $assertionsDisabled = !AxisDataSelector.class.desiredAssertionStatus();
        colSelectionTracker_ = new ColumnSelectionTracker();
        ERR_NAME_REGEX = Pattern.compile("[\\-\\._ ]*(err|error|sig|sigma|sd|stdev|st.dev)[\\-\\._ ]*", 2);
        ERR_UCD_REGEX = Pattern.compile(".*(stat\\.error|stat\\.stdev|meta\\.code\\.error).*", 2);
        LO = new ErrorType("Lower"){

            public JComboBox getSelector(AxisDataSelector axSel) {
                return axSel.loSelector_;
            }
        };
        HI = new ErrorType("Upper"){

            public JComboBox getSelector(AxisDataSelector axSel) {
                return axSel.hiSelector_;
            }
        };
        LH = new ErrorType("LowerUpper"){

            public JComboBox getSelector(AxisDataSelector axSel) {
                return axSel.lhSelector_;
            }
        };
    }

    private static class ColumnSelectionTracker {
        private final Map errColMap_ = new HashMap();

        private ColumnSelectionTracker() {
        }

        public void mainSelected(AxisDataSelector axSel, ColumnData mainCol) {
            if (mainCol == null) {
                axSel.loSelector_.setSelectedItem(null);
                axSel.hiSelector_.setSelectedItem(null);
                axSel.lhSelector_.setSelectedItem(null);
            } else {
                Iterator<Object> it = Arrays.asList(LO, HI, LH).iterator();
                while (it.hasNext()) {
                    ErrorType type = (ErrorType)it.next();
                    Object key = ColumnSelectionTracker.getKey(mainCol, type);
                    JComboBox selector = type.getSelector(axSel);
                    ColumnData col = this.errColMap_.containsKey(key) ? (ColumnData)this.errColMap_.get(key) : AxisDataSelector.guessColumn(mainCol, type, selector);
                    selector.setSelectedItem(col);
                }
            }
        }

        public void auxSelected(AxisDataSelector axSel, ErrorType type, ColumnData col) {
            ColumnData mainCol = (ColumnData)axSel.atSelector_.getSelectedItem();
            if (mainCol != null) {
                Object key = ColumnSelectionTracker.getKey(mainCol, type);
                if (col != null || this.errColMap_.containsKey(key)) {
                    this.errColMap_.put(key, col);
                }
            }
        }

        private static Object getKey(ColumnData mainCol, ErrorType type) {
            return Arrays.asList(mainCol, type);
        }
    }

    private static abstract class ErrorType {
        private final String name_;

        private ErrorType(String name) {
            this.name_ = name;
        }

        public abstract JComboBox getSelector(AxisDataSelector var1);

        public int getLikeness(ColumnInfo mainInfo, ColumnInfo auxInfo) {
            return AxisDataSelector.getErrorLikeness(mainInfo, auxInfo);
        }

        public String toString() {
            return this.name_;
        }
    }

    private class ColumnSelectionListener
    implements ActionListener {
        private final ErrorType errorType_;
        private ColumnData lastCol_;

        public ColumnSelectionListener(ErrorType errorType) {
            this.errorType_ = errorType;
        }

        public void actionPerformed(ActionEvent evt) {
            JComboBox src = (JComboBox)evt.getSource();
            ColumnData col = (ColumnData)src.getSelectedItem();
            if (col == this.lastCol_) {
                return;
            }
            this.lastCol_ = col;
            AxisDataSelector axSel = AxisDataSelector.this;
            if (this.errorType_ == null) {
                colSelectionTracker_.mainSelected(axSel, col);
            } else {
                colSelectionTracker_.auxSelected(axSel, this.errorType_, col);
            }
        }
    }
}

