/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.ttools.plot.Range;

public class AxisEditor
extends JPanel {
    private final JTextField labelField_;
    private final JComponent mainBox_;
    protected final JTextField loField_;
    protected final JTextField hiField_;
    private final ActionForwarder actionForwarder_;
    private final List ranges_;
    private ValueInfo axis_;

    AxisEditor(String axname) {
        super(new BorderLayout());
        int i;
        JLabel[] labels = new JLabel[2];
        this.labelField_ = new JTextField();
        this.loField_ = new JTextField(10);
        this.hiField_ = new JTextField(10);
        this.ranges_ = new ArrayList();
        this.actionForwarder_ = new ActionForwarder();
        AxisListener axListener = new AxisListener();
        this.loField_.addActionListener(axListener);
        this.hiField_.addActionListener(axListener);
        Box labelBox = Box.createHorizontalBox();
        labels[0] = new JLabel("Label: ");
        labelBox.add(labels[0]);
        labelBox.add(this.labelField_);
        Box rangeBox = Box.createHorizontalBox();
        labels[1] = new JLabel("Range: ");
        rangeBox.add(labels[1]);
        rangeBox.add(this.loField_);
        rangeBox.add(new JLabel("  \u2014  "));
        rangeBox.add(this.hiField_);
        this.mainBox_ = Box.createVerticalBox();
        this.mainBox_.add(labelBox);
        this.mainBox_.add(Box.createVerticalStrut(5));
        this.mainBox_.add(rangeBox);
        this.setTitle(axname + " Axis");
        this.add(this.mainBox_);
        int wmax = 0;
        for (i = 0; i < labels.length; ++i) {
            wmax = Math.max(wmax, labels[i].getPreferredSize().width);
        }
        for (i = 0; i < labels.length; ++i) {
            Dimension size = labels[i].getPreferredSize();
            size.width = wmax;
            labels[i].setPreferredSize(size);
        }
        this.setAxis(null);
    }

    public void setAxis(ValueInfo axis) {
        this.labelField_.removeActionListener(this.actionForwarder_);
        this.loField_.removeActionListener(this.actionForwarder_);
        this.hiField_.removeActionListener(this.actionForwarder_);
        if (axis == null) {
            this.labelField_.setText("");
            this.loField_.setText("");
            this.hiField_.setText("");
        } else if (!axis.equals(this.axis_)) {
            String name = axis.getName();
            String unit = axis.getUnitString();
            String txt = unit != null && unit.trim().length() > 0 ? name + " / " + unit : name;
            this.labelField_.setText(txt);
            this.loField_.setText("");
            this.hiField_.setText("");
        }
        this.axis_ = axis;
        this.labelField_.setEnabled(axis != null);
        this.loField_.setEnabled(axis != null);
        this.hiField_.setEnabled(axis != null);
        this.labelField_.addActionListener(this.actionForwarder_);
        this.loField_.addActionListener(this.actionForwarder_);
        this.hiField_.addActionListener(this.actionForwarder_);
    }

    public String getLabel() {
        return this.labelField_.getText();
    }

    public void addMaintainedRange(Range range) {
        this.ranges_.add(range);
    }

    public void removeMaintainedRange(Range range) {
        Iterator it = this.ranges_.iterator();
        while (it.hasNext()) {
            if (it.next() != range) continue;
            it.remove();
        }
    }

    public double[] getAxisBounds() {
        double high;
        double low = this.getLow();
        if (low > (high = this.getHigh())) {
            this.loField_.setText("");
            this.hiField_.setText("");
            return new double[]{Double.NaN, Double.NaN};
        }
        return new double[]{low, high};
    }

    public void clearBounds() {
        this.setAxisBounds(Double.NaN, Double.NaN);
    }

    private void setAxisBounds(double low, double high) {
        this.loField_.removeActionListener(this.actionForwarder_);
        this.hiField_.removeActionListener(this.actionForwarder_);
        this.loField_.setText(Double.isNaN(low) ? "" : Double.toString(low));
        this.hiField_.setText(Double.isNaN(high) ? "" : Double.toString(high));
        this.loField_.addActionListener(this.actionForwarder_);
        this.hiField_.addActionListener(this.actionForwarder_);
    }

    public void addActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionForwarder_.removeListener(listener);
    }

    public void setTitle(String title) {
        this.mainBox_.setBorder(AuxWindow.makeTitledBorder(title));
    }

    protected double getLow() {
        String txt = this.loField_.getText();
        if (txt == null || txt.trim().length() == 0) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(txt);
        }
        catch (NumberFormatException e) {
            this.loField_.setText("");
            return Double.NaN;
        }
    }

    protected double getHigh() {
        String txt = this.hiField_.getText();
        if (txt == null || txt.trim().length() == 0) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(txt);
        }
        catch (NumberFormatException e) {
            this.hiField_.setText("");
            return Double.NaN;
        }
    }

    public void updateRanges() {
        Iterator it = this.ranges_.iterator();
        while (it.hasNext()) {
            double[] bounds = this.getAxisBounds();
            ((Range)it.next()).setBounds(bounds[0], bounds[1]);
        }
    }

    private class AxisListener
    implements ActionListener {
        private AxisListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == AxisEditor.this.loField_) {
                if (AxisEditor.this.getLow() > AxisEditor.this.getHigh()) {
                    AxisEditor.this.hiField_.setText("");
                }
            } else if (src == AxisEditor.this.hiField_ && AxisEditor.this.getHigh() < AxisEditor.this.getLow()) {
                AxisEditor.this.loField_.setText("");
            }
            AxisEditor.this.updateRanges();
        }
    }
}

