/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.topcat.HelpAction;
import uk.ac.starlink.topcat.plot.AxisEditor;

public class AxisWindow
extends JDialog {
    private final Action applyAction_;
    private final Action cancelAction_;
    private final Action okAction_;
    private final ActionForwarder forwarder_;
    private final Frame parent_;
    private final JComponent edBox_;
    private AxisEditor[] editors_;
    private boolean seen_;

    public AxisWindow(Frame parent) {
        super(parent);
        this.parent_ = parent;
        this.setTitle("Axis Configuration");
        this.forwarder_ = new ActionForwarder();
        this.edBox_ = Box.createVerticalBox();
        this.edBox_.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.edBox_, "Center");
        this.applyAction_ = new AxisAction("Apply");
        this.cancelAction_ = new AxisAction("Cancel");
        this.okAction_ = new AxisAction("OK");
        Box controlBox = Box.createHorizontalBox();
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(new JButton(this.cancelAction_));
        controlBox.add(Box.createHorizontalStrut(10));
        controlBox.add(new JButton(this.applyAction_));
        controlBox.add(Box.createHorizontalStrut(10));
        controlBox.add(new JButton(this.okAction_));
        controlBox.add(Box.createHorizontalGlue());
        controlBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)controlBox, "South");
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(new HelpAction("axisConfig", this));
        toolBar.addSeparator();
        this.getContentPane().add((Component)toolBar, "North");
    }

    public AxisEditor[] getEditors() {
        return this.editors_;
    }

    public void setEditors(AxisEditor[] editors) {
        this.edBox_.removeAll();
        this.editors_ = editors;
        for (int i = 0; i < editors.length; ++i) {
            this.edBox_.add(editors[i]);
        }
        this.pack();
    }

    public void clearRanges() {
        for (int i = 0; i < this.editors_.length; ++i) {
            this.editors_[i].clearBounds();
        }
    }

    public void addActionListener(ActionListener listener) {
        this.forwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.forwarder_.removeListener(listener);
    }

    public void show() {
        if (!this.seen_) {
            this.positionNear(this.parent_);
            this.seen_ = true;
        }
        super.show();
    }

    private void positionNear(Frame parent) {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (gc.equals(parent.getGraphicsConfiguration())) {
            Rectangle ppos = parent.getBounds();
            int bot = ppos.y + ppos.height;
            int side = ppos.x;
            Rectangle dpos = this.getBounds();
            int y = bot - dpos.height;
            int x = Math.max(side - dpos.width + 10, 0);
            this.setLocation(x, y);
        }
    }

    private class AxisAction
    extends AbstractAction {
        AxisAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == AxisWindow.this.okAction_ || this == AxisWindow.this.applyAction_) {
                for (int i = 0; i < AxisWindow.this.editors_.length; ++i) {
                    AxisWindow.this.editors_[i].updateRanges();
                }
                AxisWindow.this.forwarder_.actionPerformed(evt);
            }
            if (this == AxisWindow.this.okAction_ || this == AxisWindow.this.cancelAction_) {
                AxisWindow.this.dispose();
            }
        }
    }
}

