/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.topcat.plot.ZoomDrag;
import uk.ac.starlink.topcat.plot.ZoomRegion;

public abstract class AxisZoomRegion
extends ZoomRegion {
    private final boolean isX_;
    private static final int BOX = 32;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$AxisZoomRegion;

    public AxisZoomRegion(boolean isX) {
        this.isX_ = isX;
        this.setCursor(Cursor.getPredefinedCursor(isX ? 10 : 8));
    }

    public AxisZoomRegion(boolean isX, Rectangle target, Rectangle display) {
        this(isX);
        this.setTarget(target);
        this.setDisplay(display);
    }

    public ZoomDrag createDrag(Component comp, Point start) {
        return new AxisDrag(comp, start);
    }

    private class AxisDrag
    implements ZoomDrag {
        final Point start_;
        final Point origin_;
        final Graphics g_;
        Point last_;
        Boolean sense_;
        int lastDist_;
        static final /* synthetic */ boolean $assertionsDisabled;

        AxisDrag(Component comp, Point start) {
            this.g_ = comp.getGraphics();
            this.start_ = start;
            this.origin_ = comp.getLocation();
            this.g_.setXORMode(Color.YELLOW);
        }

        public void dragTo(Point point) {
            int dist;
            int n = dist = AxisZoomRegion.this.isX_ ? point.x - this.start_.x : point.y - this.start_.y;
            if (this.lastDist_ < 0 || dist != this.lastDist_) {
                this.lastDist_ = dist;
                if (this.sense_ != null || dist != 0) {
                    if (this.sense_ == null) {
                        if (!$assertionsDisabled && dist == 0) {
                            throw new AssertionError();
                        }
                        this.sense_ = dist > 0;
                    } else {
                        if (!$assertionsDisabled && this.last_ == null) {
                            throw new AssertionError();
                        }
                        this.xorRegion(this.start_, this.last_);
                    }
                    if (!$assertionsDisabled && this.sense_ == null) {
                        throw new AssertionError();
                    }
                    this.last_ = this.sense_ == dist > 0 ? point : this.start_;
                    this.xorRegion(this.start_, this.last_);
                }
            }
        }

        public double[][] boundsAt(Point end) {
            if (this.sense_ != null) {
                int dist;
                this.xorRegion(this.start_, this.last_);
                Rectangle target = AxisZoomRegion.this.getTarget();
                if (this.sense_.booleanValue()) {
                    Object object;
                    double v1;
                    double v0 = AxisZoomRegion.this.isX_ ? (double)(this.start_.x - target.x) / (double)target.width : (double)(this.start_.y - target.y) / (double)target.height;
                    double d = v1 = AxisZoomRegion.this.isX_ ? (double)(end.x - target.x) / (double)target.width : (double)(end.y - target.y) / (double)target.height;
                    if (v1 > v0) {
                        double[][] dArrayArray = new double[1][];
                        object = dArrayArray;
                        dArrayArray[0] = new double[]{v0, v1};
                    } else {
                        object = null;
                    }
                    return object;
                }
                int n = dist = AxisZoomRegion.this.isX_ ? this.start_.x - end.x : this.start_.y - end.y;
                if (dist > 0) {
                    double range = (double)(2 * dist + 32) / 32.0;
                    double centre = AxisZoomRegion.this.isX_ ? (double)(this.start_.x - target.x) / (double)target.width : (double)(this.start_.y - target.y) / (double)target.height;
                    double v0 = centre - range * 0.5;
                    double v1 = centre + range * 0.5;
                    return new double[][]{{v0, v1}};
                }
                return null;
            }
            return null;
        }

        private void xorRegion(Point p0, Point p1) {
            int[] nArray;
            int v1;
            int v0 = AxisZoomRegion.this.isX_ ? p0.x : p0.y;
            int n = v1 = AxisZoomRegion.this.isX_ ? p1.x : p1.y;
            if (v0 <= v1) {
                int[] nArray2 = new int[2];
                nArray2[0] = v0;
                nArray = nArray2;
                nArray2[1] = v1;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = v1;
                nArray = nArray3;
                nArray3[1] = v0;
            }
            int[] range = nArray;
            Rectangle rect = new Rectangle(AxisZoomRegion.this.getDisplay());
            rect.translate(-this.origin_.x, -this.origin_.y);
            if (AxisZoomRegion.this.isX_) {
                rect.x = range[0];
                rect.width = range[1] - range[0];
                ++rect.y;
                rect.height -= 2;
            } else {
                rect.y = range[0];
                rect.height = range[1] - range[0];
                ++rect.x;
                rect.width -= 2;
            }
            if (this.sense_.booleanValue()) {
                this.g_.drawRect(rect.x, rect.y, rect.width, rect.height);
            } else {
                Rectangle r1 = new Rectangle(rect);
                Rectangle r2 = new Rectangle(rect);
                if (AxisZoomRegion.this.isX_) {
                    r1.x += 16 + (range[1] - range[0]);
                    r2.x -= 16;
                } else {
                    r1.y += 16 + (range[1] - range[0]);
                    r2.y -= 16;
                }
                this.g_.drawRect(r1.x, r1.y, r1.width, r1.height);
                this.g_.drawRect(r2.x, r2.y, r2.width, r2.height);
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$AxisZoomRegion == null ? (class$uk$ac$starlink$topcat$plot$AxisZoomRegion = AxisZoomRegion.class$("uk.ac.starlink.topcat.plot.AxisZoomRegion")) : class$uk$ac$starlink$topcat$plot$AxisZoomRegion).desiredAssertionStatus();
        }
    }
}

