/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.plot.ColorComboBox;
import uk.ac.starlink.topcat.plot.ComboBoxBumper;
import uk.ac.starlink.topcat.plot.DashComboBox;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.ThicknessComboBox;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.BarStyles;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.util.gui.RenderingComboBox;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.util.gui.ValueButtonGroup;

public class BarStyleEditor
extends StyleEditor {
    private final ColorComboBox colorSelector_ = new ColorComboBox();
    private final JComboBox formSelector_;
    private final ValueButtonGroup placeSelector_;
    private final ThicknessComboBox thickSelector_;
    private final DashComboBox dashSelector_;
    private static final int MAX_THICK = 8;
    private static final BarStyle.Form[] FORMS = new BarStyle.Form[]{BarStyle.FORM_FILLED, BarStyle.FORM_OPEN, BarStyle.FORM_TOP, BarStyle.FORM_SPIKE};

    public BarStyleEditor() {
        this.colorSelector_.addActionListener(this);
        this.thickSelector_ = new ThicknessComboBox(8);
        this.thickSelector_.addActionListener(this);
        this.dashSelector_ = new DashComboBox();
        this.dashSelector_.addActionListener(this);
        JRadioButton overButton = new JRadioButton("Over", true);
        JRadioButton adjButton = new JRadioButton("Adjacent");
        this.placeSelector_ = new ValueButtonGroup();
        this.placeSelector_.add((AbstractButton)overButton, (Object)BarStyle.PLACE_OVER);
        this.placeSelector_.add((AbstractButton)adjButton, (Object)BarStyle.PLACE_ADJACENT);
        this.placeSelector_.addChangeListener((ChangeListener)this);
        this.formSelector_ = new RenderingComboBox(FORMS){

            protected Icon getRendererIcon(Object form) {
                return BarStyles.getIcon((BarStyle.Form)((BarStyle.Form)form));
            }
        };
        this.formSelector_.addActionListener(this);
        Box colorBox = Box.createHorizontalBox();
        colorBox.add(new JLabel("Colour: "));
        colorBox.add((Component)new ShrinkWrapper((Component)((Object)this.colorSelector_)));
        colorBox.add(Box.createHorizontalStrut(5));
        colorBox.add(new ComboBoxBumper((JComboBox)((Object)this.colorSelector_)));
        colorBox.add(Box.createHorizontalGlue());
        Box formBox = Box.createHorizontalBox();
        formBox.add(new JLabel("Bar Form: "));
        formBox.add((Component)new ShrinkWrapper((Component)this.formSelector_));
        formBox.add(Box.createHorizontalStrut(5));
        formBox.add(new ComboBoxBumper(this.formSelector_));
        formBox.add(Box.createHorizontalGlue());
        Box placeBox = Box.createHorizontalBox();
        placeBox.add(new JLabel("Bar Placement: "));
        placeBox.add(overButton);
        placeBox.add(Box.createHorizontalStrut(10));
        placeBox.add(adjButton);
        placeBox.add(Box.createHorizontalStrut(5));
        placeBox.add(Box.createHorizontalGlue());
        Box lineBox = Box.createHorizontalBox();
        lineBox.add(new JLabel("Line"));
        lineBox.add(Box.createHorizontalStrut(10));
        lineBox.add(new JLabel("Thickness: "));
        lineBox.add((Component)new ShrinkWrapper((Component)((Object)this.thickSelector_)));
        lineBox.add(Box.createHorizontalStrut(5));
        lineBox.add(new ComboBoxBumper((JComboBox)((Object)this.thickSelector_)));
        lineBox.add(Box.createHorizontalStrut(10));
        lineBox.add(new JLabel("Dash: "));
        lineBox.add((Component)new ShrinkWrapper((Component)((Object)this.dashSelector_)));
        lineBox.add(Box.createHorizontalStrut(5));
        lineBox.add(new ComboBoxBumper((JComboBox)((Object)this.dashSelector_)));
        lineBox.add(Box.createHorizontalStrut(5));
        lineBox.add(Box.createHorizontalGlue());
        Box barBox = Box.createVerticalBox();
        barBox.add(colorBox);
        barBox.add(Box.createVerticalStrut(5));
        barBox.add(formBox);
        barBox.add(Box.createVerticalStrut(5));
        barBox.add(placeBox);
        barBox.add(Box.createVerticalStrut(5));
        barBox.add(lineBox);
        barBox.add(Box.createVerticalStrut(5));
        barBox.setBorder(AuxWindow.makeTitledBorder("Bars"));
        this.add(barBox);
    }

    public void setStyle(Style st) {
        BarStyle style = (BarStyle)st;
        this.colorSelector_.setSelectedColor(style.getColor());
        this.formSelector_.setSelectedItem(style.getForm());
        this.placeSelector_.setValue((Object)style.getPlacement());
        this.thickSelector_.setSelectedThickness(style.getLineWidth());
        this.dashSelector_.setSelectedDash(style.getDash());
    }

    public Style getStyle() {
        return BarStyleEditor.getStyle(this.colorSelector_.getSelectedColor(), (BarStyle.Form)this.formSelector_.getSelectedItem(), (BarStyle.Placement)this.placeSelector_.getValue(), this.thickSelector_.getSelectedThickness(), this.dashSelector_.getSelectedDash());
    }

    public String getHelpID() {
        return "BarStyleEditor";
    }

    private static Style getStyle(Color color, BarStyle.Form form, BarStyle.Placement placement, int thick, float[] dash) {
        if (form == BarStyle.FORM_TOP) {
            placement = BarStyle.PLACE_OVER;
        }
        BarStyle style = new BarStyle(color, form, placement);
        style.setLineWidth(thick);
        style.setDash(dash);
        return style;
    }
}

