/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import uk.ac.starlink.topcat.ResourceIcon;

public class BlobPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    private List blobs_;
    private GeneralPath dragPath_;
    private Action blobAction_;
    private Color fillColor_ = new Color(0, 0, 0, 64);
    private Color pathColor_ = new Color(0, 0, 0, 128);
    private boolean isActive_;

    public BlobPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                BlobPanel.this.clear();
            }
        });
        this.setOpaque(false);
        this.clear();
        this.blobAction_ = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if (BlobPanel.this.isActive()) {
                    if (!BlobPanel.this.blobs_.isEmpty()) {
                        BlobPanel.this.blobCompleted(BlobPanel.this.getBlob());
                    }
                    BlobPanel.this.clear();
                    BlobPanel.this.setActive(false);
                } else {
                    BlobPanel.this.setActive(true);
                }
            }
        };
        this.setActive(false);
    }

    public Shape getBlob() {
        Area area = new Area();
        Iterator it = this.blobs_.iterator();
        while (it.hasNext()) {
            area.add(new Area((Shape)it.next()));
        }
        return BlobPanel.simplify(area);
    }

    public void setBlob(Shape blob) {
        this.blobs_ = new ArrayList();
        this.blobs_.add(blob);
        this.repaint();
    }

    public void clear() {
        this.blobs_ = new ArrayList();
        this.repaint();
    }

    public Action getBlobAction() {
        return this.blobAction_;
    }

    public void setActive(boolean active) {
        this.isActive_ = active;
        this.clear();
        this.setVisible(active);
        this.blobAction_.putValue("Name", active ? "Finish Drawing Region" : "Draw Subset Region");
        this.blobAction_.putValue("SmallIcon", active ? ResourceIcon.BLOB_SUBSET_END : ResourceIcon.BLOB_SUBSET);
        this.blobAction_.putValue("ShortDescription", active ? "Define susbset from currently-drawn region" : "Draw a region on the plot to define a new row subset");
    }

    public boolean isActive() {
        return this.isActive_;
    }

    protected void blobCompleted(Shape blob) {
    }

    public void setColors(Color fillColor, Color pathColor) {
        this.fillColor_ = fillColor;
        this.pathColor_ = pathColor;
    }

    protected void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Area area = new Area();
        Iterator it = this.blobs_.iterator();
        while (it.hasNext()) {
            area.add(new Area((Shape)it.next()));
        }
        if (this.dragPath_ != null) {
            area.add(new Area(this.dragPath_));
            g2.setColor(this.pathColor_);
            g2.draw(this.dragPath_);
        }
        g2.setColor(this.fillColor_);
        g2.fill(area);
        g.setColor(oldColor);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
        if (this.dragPath_ != null) {
            this.dragPath_ = null;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            int nblob = this.blobs_.size();
            if (nblob > 0) {
                this.blobs_.remove(nblob - 1);
            }
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() == 1) {
            Point p = evt.getPoint();
            this.dragPath_ = new GeneralPath();
            this.dragPath_.moveTo(p.x, p.y);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.getButton() == 1 && this.dragPath_ != null) {
            this.blobs_.add(BlobPanel.simplify(this.dragPath_));
            this.dragPath_ = null;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.dragPath_ != null) {
            Point p = evt.getPoint();
            this.dragPath_.lineTo(p.x, p.y);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    private static Shape simplify(Shape shape) {
        return shape;
    }
}

