/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisDataSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.CartesianPointStore;
import uk.ac.starlink.topcat.plot.ColumnDataTable;
import uk.ac.starlink.topcat.plot.ConstantColumnData;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.ttools.plot.ErrorMode;

public class CartesianAxesSelector
implements AxesSelector {
    private final String[] axisNames_;
    private final int ndim_;
    private final ErrorModeSelectionModel[] errorModeModels_;
    private final AxisDataSelector[] dataSelectors_;
    private final JComponent entryBox_;
    private TopcatModel tcModel_;

    public CartesianAxesSelector(String[] axisNames, ToggleButtonModel[] logModels, ToggleButtonModel[] flipModels, ErrorModeSelectionModel[] errorModeModels) {
        this.axisNames_ = axisNames;
        this.errorModeModels_ = errorModeModels;
        this.ndim_ = axisNames.length;
        this.entryBox_ = Box.createVerticalBox();
        this.dataSelectors_ = new AxisDataSelector[this.ndim_];
        for (int idim = 0; idim < this.ndim_; ++idim) {
            String[] togNames = new String[]{"Log", "Flip"};
            ToggleButtonModel[] togModels = new ToggleButtonModel[]{logModels != null && logModels.length > idim ? logModels[idim] : null, flipModels != null && flipModels.length > idim ? flipModels[idim] : null};
            this.dataSelectors_[idim] = new AxisDataSelector(axisNames[idim], togNames, togModels);
            this.dataSelectors_[idim].setEnabled(false);
            this.entryBox_.add(Box.createVerticalStrut(5));
            this.entryBox_.add(this.dataSelectors_[idim]);
        }
        this.entryBox_.add(Box.createVerticalStrut(5));
        if (this.errorModeModels_.length > 0) {
            int id = 0;
            while (id < this.ndim_) {
                final int idim = id++;
                ActionListener listener = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        CartesianAxesSelector.this.dataSelectors_[idim].setErrorMode(CartesianAxesSelector.this.errorModeModels_[idim].getErrorMode());
                    }
                };
                this.errorModeModels_[idim].addActionListener(listener);
                listener.actionPerformed(null);
            }
        }
    }

    public JComponent getColumnSelectorPanel() {
        return this.entryBox_;
    }

    public JComboBox[] getColumnSelectors() {
        ArrayList<JComboBox> selectorList = new ArrayList<JComboBox>();
        for (int idim = 0; idim < this.ndim_; ++idim) {
            selectorList.addAll(Arrays.asList(this.dataSelectors_[idim].getSelectors()));
        }
        return selectorList.toArray(new JComboBox[0]);
    }

    public int getNdim() {
        return this.ndim_;
    }

    public boolean isReady() {
        if (this.tcModel_ == null) {
            return false;
        }
        ColumnData[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] != null) continue;
            return false;
        }
        return true;
    }

    public StarTable getData() {
        return new ColumnDataTable(this.tcModel_, this.getColumns());
    }

    public StarTable getErrorData() {
        ArrayList<ColumnData> colList = new ArrayList<ColumnData>();
        for (int idim = 0; idim < this.ndim_; ++idim) {
            JComboBox[] errorSelectors = this.dataSelectors_[idim].getErrorSelectors();
            for (int isel = 0; isel < errorSelectors.length; ++isel) {
                colList.add((ColumnData)errorSelectors[isel].getSelectedItem());
            }
        }
        ColumnData[] cols = colList.toArray(new ColumnData[0]);
        for (int icol = 0; icol < cols.length; ++icol) {
            if (cols[icol] != null) continue;
            cols[icol] = ConstantColumnData.ZERO;
        }
        return new ColumnDataTable(this.tcModel_, cols);
    }

    public ErrorMode[] getErrorModes() {
        int nerr = this.errorModeModels_.length;
        ErrorMode[] modes = new ErrorMode[nerr];
        for (int ierr = 0; ierr < nerr; ++ierr) {
            modes[ierr] = this.errorModeModels_[ierr].getErrorMode();
        }
        return modes;
    }

    public StarTable getLabelData() {
        return null;
    }

    public AxisDataSelector getDataSelector(int icol) {
        return this.dataSelectors_[icol];
    }

    public JComboBox getColumnSelector(int icol) {
        return this.dataSelectors_[icol].getMainSelector();
    }

    public AxisEditor[] createAxisEditors() {
        AxisEditor[] eds = new AxisEditor[this.ndim_];
        for (int i = 0; i < this.ndim_; ++i) {
            final AxisEditor axed = new AxisEditor(this.axisNames_[i]);
            final JComboBox csel = this.dataSelectors_[i].getMainSelector();
            csel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ColumnData cdata = (ColumnData)csel.getSelectedItem();
                    axed.setAxis((ValueInfo)(cdata == null ? null : cdata.getColumnInfo()));
                }
            });
            eds[i] = axed;
        }
        return eds;
    }

    public PointStore createPointStore(int npoint) {
        return new CartesianPointStore(this.getNdim(), this.getErrorModes(), npoint);
    }

    public void setTable(TopcatModel tcModel) {
        for (int i = 0; i < this.ndim_; ++i) {
            this.dataSelectors_[i].setTable(tcModel);
        }
        this.tcModel_ = tcModel;
    }

    public TopcatModel getTable() {
        return this.tcModel_;
    }

    public void initialiseSelectors() {
        HashSet<Object> usedCols = new HashSet<Object>();
        usedCols.add(null);
        for (int id = 0; id < this.ndim_; ++id) {
            AxisDataSelector dataSelector = this.dataSelectors_[id];
            JComboBox colSelector = dataSelector.getMainSelector();
            boolean done = false;
            for (int ic = 0; ic < colSelector.getItemCount() && !done; ++ic) {
                ColumnData col = (ColumnData)colSelector.getItemAt(ic);
                if (usedCols.contains(col)) continue;
                colSelector.setSelectedItem(col);
                JComboBox[] errSels = dataSelector.getSelectors();
                for (int isel = 0; isel < errSels.length; ++isel) {
                    usedCols.add(errSels[isel].getSelectedItem());
                }
                done = true;
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        for (int i = 0; i < this.dataSelectors_.length; ++i) {
            this.dataSelectors_[i].addActionListener(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        for (int i = 0; i < this.dataSelectors_.length; ++i) {
            this.dataSelectors_[i].removeActionListener(listener);
        }
    }

    private ColumnData[] getColumns() {
        ColumnData[] cols = new ColumnData[this.ndim_];
        for (int i = 0; i < this.ndim_; ++i) {
            ColumnData cdata = (ColumnData)this.dataSelectors_[i].getMainSelector().getSelectedItem();
            cols[i] = cdata == null ? ConstantColumnData.NAN : cdata;
        }
        return cols;
    }
}

