/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.util.ArrayList;
import java.util.Date;
import uk.ac.starlink.table.ValueStore;
import uk.ac.starlink.table.storage.ArrayPrimitiveStore;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.ttools.plot.ErrorMode;

public class CartesianPointStore
implements PointStore {
    private final int ndim_;
    private final ErrorReader[] errorReaders_;
    private final int nword_;
    private final long lnword_;
    private final int nerrWord_;
    private final double[] point_;
    private final double[] centre_;
    private final double[][] errors_;
    private final double[] buf1_;
    private final ValueStore valueStore_;
    private final int npoint_;
    private int ipoint_;
    private static final double MILLISECONDS_PER_YEAR = 3.15576E10;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CartesianPointStore(int ndim, ErrorMode[] errorModes, int npoint) {
        this.ndim_ = ndim;
        this.npoint_ = npoint;
        ArrayList<ErrorReader> rdrList = new ArrayList<ErrorReader>();
        int nerrWord = 0;
        for (int idim = 0; idim < errorModes.length; ++idim) {
            ErrorReader rdr = this.createErrorReader(idim, errorModes[idim]);
            if (rdr == null) continue;
            rdrList.add(rdr);
            nerrWord += rdr.getWordCount();
        }
        this.nerrWord_ = nerrWord;
        this.errorReaders_ = rdrList.toArray(new ErrorReader[0]);
        this.nword_ = this.ndim_ + nerrWord;
        this.lnword_ = this.nword_;
        this.buf1_ = new double[1];
        this.point_ = new double[this.ndim_];
        this.centre_ = new double[this.ndim_];
        this.errors_ = new double[this.errorReaders_.length * 2][];
        this.valueStore_ = new ArrayPrimitiveStore(Double.TYPE, this.nword_ * this.npoint_);
        if (!$assertionsDisabled && !Double.TYPE.equals(this.valueStore_.getType())) {
            throw new AssertionError();
        }
    }

    public void storePoint(Object[] coordRow, Object[] errorRow, String label) {
        int i;
        long ioff = (long)this.ipoint_ * this.lnword_;
        for (i = 0; i < this.ndim_; ++i) {
            this.buf1_[0] = CartesianPointStore.doubleValue(coordRow[i]);
            this.valueStore_.put(ioff++, (Object)this.buf1_, 0, 1);
        }
        for (i = 0; i < this.nerrWord_; ++i) {
            this.buf1_[0] = CartesianPointStore.doubleValue(errorRow[i]);
            this.valueStore_.put(ioff++, (Object)this.buf1_, 0, 1);
        }
        if (!$assertionsDisabled && ioff != (long)(this.ipoint_ + 1) * this.lnword_) {
            throw new AssertionError();
        }
        ++this.ipoint_;
    }

    public int getCount() {
        return this.npoint_;
    }

    public int getNdim() {
        return this.ndim_;
    }

    public double[] getPoint(int ipoint) {
        this.valueStore_.get((long)ipoint * this.lnword_, (Object)this.point_, 0, this.ndim_);
        return this.point_;
    }

    public int getNerror() {
        return this.errorReaders_.length * 2;
    }

    public double[][] getErrors(int ipoint) {
        this.valueStore_.get((long)ipoint * this.lnword_, (Object)this.centre_, 0, this.ndim_);
        long off = ipoint * this.nword_ + this.ndim_;
        int ierr = 0;
        for (int ir = 0; ir < this.errorReaders_.length; ++ir) {
            ErrorReader rdr = this.errorReaders_[ir];
            double[][] errs = rdr.readErrors(this.centre_, this.valueStore_, off);
            this.errors_[ierr++] = errs[0];
            this.errors_[ierr++] = errs[1];
            off += (long)rdr.getWordCount();
        }
        if (!$assertionsDisabled && ierr != this.errorReaders_.length * 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && off != (long)((ipoint + 1) * this.nword_)) {
            throw new AssertionError();
        }
        return this.errors_;
    }

    public boolean hasLabels() {
        return false;
    }

    public String getLabel(int ipoint) {
        return null;
    }

    public static double doubleValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Date) {
            long milliseconds = ((Date)value).getTime();
            return 1970.0 + (double)milliseconds / 3.15576E10;
        }
        return Double.NaN;
    }

    private ErrorReader createErrorReader(final int idim, ErrorMode mode) {
        if (ErrorMode.SYMMETRIC.equals(mode)) {
            return new ErrorReader(1){
                final double[] lo;
                final double[] hi;
                {
                    super(x0);
                    this.lo = new double[CartesianPointStore.this.ndim_];
                    this.hi = new double[CartesianPointStore.this.ndim_];
                }

                protected void convertErrors(double[] point, double[] rawErrs, double[][] errCoords) {
                    double off = rawErrs[0];
                    if (off > 0.0) {
                        for (int id = 0; id < CartesianPointStore.this.ndim_; ++id) {
                            this.lo[id] = point[id];
                            this.hi[id] = point[id];
                        }
                        int n = idim;
                        this.lo[n] = this.lo[n] - off;
                        int n2 = idim;
                        this.hi[n2] = this.hi[n2] + off;
                        errCoords[0] = this.lo;
                        errCoords[1] = this.hi;
                    } else {
                        errCoords[0] = null;
                        errCoords[1] = null;
                    }
                }
            };
        }
        if (ErrorMode.LOWER.equals(mode)) {
            return new ErrorReader(1){
                final double[] lo;
                {
                    super(x0);
                    this.lo = new double[CartesianPointStore.this.ndim_];
                }

                protected void convertErrors(double[] point, double[] rawErrs, double[][] errCoords) {
                    double off = rawErrs[0];
                    if (off > 0.0) {
                        for (int id = 0; id < CartesianPointStore.this.ndim_; ++id) {
                            this.lo[id] = point[id];
                        }
                        int n = idim;
                        this.lo[n] = this.lo[n] - off;
                        errCoords[0] = this.lo;
                    } else {
                        errCoords[0] = null;
                    }
                    errCoords[1] = null;
                }
            };
        }
        if (ErrorMode.UPPER.equals(mode)) {
            return new ErrorReader(1){
                final double[] hi;
                {
                    super(x0);
                    this.hi = new double[CartesianPointStore.this.ndim_];
                }

                protected void convertErrors(double[] point, double[] rawErrs, double[][] errCoords) {
                    double off = rawErrs[0];
                    if (off > 0.0) {
                        for (int id = 0; id < CartesianPointStore.this.ndim_; ++id) {
                            this.hi[id] = point[id];
                        }
                        int n = idim;
                        this.hi[n] = this.hi[n] + off;
                        errCoords[1] = this.hi;
                    } else {
                        errCoords[1] = null;
                    }
                    errCoords[0] = null;
                }
            };
        }
        if (ErrorMode.BOTH.equals(mode)) {
            return new ErrorReader(2){
                final double[] lo;
                final double[] hi;
                {
                    super(x0);
                    this.lo = new double[CartesianPointStore.this.ndim_];
                    this.hi = new double[CartesianPointStore.this.ndim_];
                }

                protected void convertErrors(double[] point, double[] rawErrs, double[][] errCoords) {
                    int id;
                    double loOff = rawErrs[0];
                    double hiOff = rawErrs[1];
                    if (loOff > 0.0) {
                        for (id = 0; id < CartesianPointStore.this.ndim_; ++id) {
                            this.lo[id] = point[id];
                        }
                        int n = idim;
                        this.lo[n] = this.lo[n] - loOff;
                        errCoords[0] = this.lo;
                    } else {
                        errCoords[0] = null;
                    }
                    if (hiOff > 0.0) {
                        for (id = 0; id < CartesianPointStore.this.ndim_; ++id) {
                            this.hi[id] = point[id];
                        }
                        int n = idim;
                        this.hi[n] = this.hi[n] + hiOff;
                        errCoords[1] = this.hi;
                    } else {
                        errCoords[1] = null;
                    }
                }
            };
        }
        return null;
    }

    static {
        $assertionsDisabled = !CartesianPointStore.class.desiredAssertionStatus();
    }

    private abstract class ErrorReader {
        private final int wordCount_;
        private final double[] buf_;
        private final double[][] pair_;

        ErrorReader(int wordCount) {
            this.wordCount_ = wordCount;
            this.buf_ = new double[wordCount];
            this.pair_ = new double[2][];
        }

        public int getWordCount() {
            return this.wordCount_;
        }

        public double[][] readErrors(double[] centre, ValueStore store, long off) {
            store.get(off, (Object)this.buf_, 0, this.wordCount_);
            this.convertErrors(centre, this.buf_, this.pair_);
            return this.pair_;
        }

        protected abstract void convertErrors(double[] var1, double[] var2, double[][] var3);
    }
}

