/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.topcat.plot.ZoomDrag;
import uk.ac.starlink.topcat.plot.ZoomRegion;

public abstract class CentreZoomRegion
extends ZoomRegion {
    private final boolean isX_;
    private static final int BOX = 32;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$CentreZoomRegion;

    public CentreZoomRegion(boolean isX) {
        this.isX_ = isX;
        this.setCursor(Cursor.getPredefinedCursor(isX ? 10 : 8));
    }

    public ZoomDrag createDrag(Component comp, Point start) {
        return new CentreDrag(comp, start);
    }

    public abstract Rectangle getTarget();

    public abstract Rectangle getDisplay();

    private class CentreDrag
    implements ZoomDrag {
        final Point start_;
        final Graphics g_;
        final Rectangle target_;
        final Rectangle display_;
        final Point centre_;
        final double aspect_;
        Point last_;
        Boolean sense_;
        int lastDist_;
        static final /* synthetic */ boolean $assertionsDisabled;

        CentreDrag(Component comp, Point start) {
            this.g_ = comp.getGraphics();
            this.start_ = start;
            this.g_.setXORMode(Color.YELLOW);
            Point origin = comp.getLocation();
            this.target_ = new Rectangle(CentreZoomRegion.this.getTarget());
            this.display_ = new Rectangle(CentreZoomRegion.this.getDisplay());
            this.target_.translate(-origin.x, -origin.y);
            this.display_.translate(-origin.x, -origin.y);
            this.centre_ = new Point(this.display_.x + this.display_.width / 2, this.display_.y + this.display_.height / 2);
            this.aspect_ = (double)this.display_.height / (double)this.display_.width;
        }

        public void dragTo(Point point) {
            int dist;
            int n = dist = CentreZoomRegion.this.isX_ ? point.x - this.start_.x : point.y - this.start_.y;
            if (this.lastDist_ < 0 || dist != this.lastDist_) {
                this.lastDist_ = dist;
                if (this.sense_ != null || dist != 0) {
                    if (this.sense_ == null) {
                        if (!$assertionsDisabled && dist == 0) {
                            throw new AssertionError();
                        }
                        this.sense_ = dist > 0;
                    } else {
                        if (!$assertionsDisabled && this.last_ == null) {
                            throw new AssertionError();
                        }
                        this.xorRegion(this.start_, this.last_);
                    }
                    if (!$assertionsDisabled && this.sense_ == null) {
                        throw new AssertionError();
                    }
                    this.last_ = this.sense_ == dist > 0 ? point : this.start_;
                    this.xorRegion(this.start_, this.last_);
                }
            }
        }

        public double[][] boundsAt(Point end) {
            if (this.sense_ != null) {
                this.xorRegion(this.start_, this.last_);
                int range = Math.abs(CentreZoomRegion.this.isX_ ? end.x - this.start_.x : end.y - this.start_.y);
                if (range > 3) {
                    if (this.sense_.booleanValue()) {
                        double scale = 2.0 * (double)range / (double)(CentreZoomRegion.this.isX_ ? this.target_.width : this.target_.height);
                        return new double[][]{{scale}};
                    }
                    double scale = 1.0 + 2.0 * (double)range / 32.0;
                    return new double[][]{{scale}};
                }
                return null;
            }
            return null;
        }

        private void xorRegion(Point p0, Point p1) {
            int yrange;
            int range = Math.abs(CentreZoomRegion.this.isX_ ? p0.x - p1.x : p0.y - p1.y);
            int xrange = CentreZoomRegion.this.isX_ ? range : (int)((double)range / this.aspect_);
            int n = yrange = CentreZoomRegion.this.isX_ ? (int)((double)range * this.aspect_) : range;
            if (this.sense_.booleanValue()) {
                this.g_.drawRect(this.centre_.x - xrange, this.centre_.y - yrange, 2 * xrange, 2 * yrange);
            } else {
                int xbox = CentreZoomRegion.this.isX_ ? 32 : (int)(32.0 / this.aspect_);
                int ybox = CentreZoomRegion.this.isX_ ? (int)(32.0 * this.aspect_) : 32;
                this.g_.drawRect(this.centre_.x - xbox / 2, this.centre_.y - ybox / 2, xbox, ybox);
                this.g_.drawRect(this.centre_.x - xbox / 2 - range, this.centre_.y - ybox / 2 - range, xbox + 2 * range, ybox + 2 * range);
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$CentreZoomRegion == null ? (class$uk$ac$starlink$topcat$plot$CentreZoomRegion = CentreZoomRegion.class$("uk.ac.starlink.topcat.plot.CentreZoomRegion")) : class$uk$ac$starlink$topcat$plot$CentreZoomRegion).desiredAssertionStatus();
        }
    }
}

