/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;

public class ComboBoxBumper
extends JPanel {
    private final JComboBox comboBox_;
    private final Action[] bumpActions_;

    public ComboBoxBumper(JComboBox comboBox) {
        this.comboBox_ = comboBox;
        this.setLayout(new BoxLayout(this, 0));
        this.bumpActions_ = new Action[]{new BumpAction("Prev", ResourceIcon.SMALL_DEC, "Select previous column", -1), new BumpAction("Next", ResourceIcon.SMALL_INC, "Select next column", 1)};
        for (int i = 0; i < this.bumpActions_.length; ++i) {
            JButton butt = new JButton(this.bumpActions_[i]);
            butt.setText(null);
            butt.setMargin(new Insets(1, 1, 1, 1));
            butt.setMaximumSize(new Dimension(butt.getMaximumSize().width, Integer.MAX_VALUE));
            this.add(butt);
        }
        this.comboBox_.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ComboBoxBumper.this.setEnabled(ComboBoxBumper.this.comboBox_.isEnabled());
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.comboBox_.getPreferredSize().height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.bumpActions_.length; ++i) {
            this.bumpActions_[i].setEnabled(enabled);
        }
    }

    private class BumpAction
    extends BasicAction {
        private final int inc_;

        public BumpAction(String name, Icon icon, String desc, int inc) {
            super(name, icon, desc);
            this.inc_ = inc;
        }

        public void actionPerformed(ActionEvent evt) {
            int nItem = ComboBoxBumper.this.comboBox_.getItemCount();
            int isel = -1;
            Object sel = ComboBoxBumper.this.comboBox_.getSelectedItem();
            for (int i = 0; i < nItem && isel < 0; ++i) {
                Object item = ComboBoxBumper.this.comboBox_.getItemAt(i);
                if (!(item == null ? sel == null : item.equals(sel))) continue;
                isel = i;
            }
            isel = isel >= 0 ? (isel + this.inc_ + nItem) % nItem : 0;
            ComboBoxBumper.this.comboBox_.setSelectedIndex(isel);
        }
    }
}

