/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Font;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class CountsLabel
extends JLabel {
    private final String[] titles_;
    private final NumberFormat format_;

    public CountsLabel(String[] titles) {
        this.titles_ = titles;
        this.format_ = new DecimalFormat();
        ((DecimalFormat)this.format_).setGroupingSize(3);
        ((DecimalFormat)this.format_).setGroupingUsed(true);
        this.setFont(new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize()));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setValues(null);
    }

    public void setValues(int[] values) {
        int nval = this.titles_.length;
        Object[] sValues = new String[nval];
        if (values == null) {
            Arrays.fill(sValues, "   ");
        } else {
            if (values.length != nval) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < nval; ++i) {
                sValues[i] = this.format_.format(values[i]);
            }
        }
        int maxLeng = 0;
        for (int i = 0; i < nval; ++i) {
            maxLeng = Math.max(maxLeng, ((String)sValues[i]).length());
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < nval; ++i) {
            sbuf.append(' ').append(this.titles_[i]).append(": ");
            int pad = maxLeng - ((String)sValues[i]).length();
            for (int j = 0; j < pad; ++j) {
                sbuf.append(' ');
            }
            sbuf.append((String)sValues[i]);
        }
        sbuf.append(' ');
        this.setText(sbuf.toString());
    }
}

