/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CutChooser
extends JPanel {
    private final JSlider loSlider_;
    private final JSlider hiSlider_;
    private final List changeListeners_;
    private boolean percentileLabels_ = true;
    private double min_ = 0.001;
    private static final int SCALE = 10000;

    public CutChooser() {
        this.setLayout(new BoxLayout(this, 0));
        this.loSlider_ = new JSlider((int)(Math.log(this.min_) * 10000.0), (int)(Math.log(0.5) * 10000.0));
        this.hiSlider_ = new JSlider((int)(-(Math.log(0.5) * 10000.0)), (int)(-(Math.log(this.min_) * 10000.0)));
        Hashtable<Integer, JLabel> loLabels = new Hashtable<Integer, JLabel>();
        Hashtable<Integer, JLabel> hiLabels = new Hashtable<Integer, JLabel>();
        double[] points = new double[]{0.5, 0.1, 0.01, 0.001};
        for (int i = 0; i < points.length; ++i) {
            double point = points[i];
            loLabels.put(new Integer((int)(Math.log(point) * 10000.0)), new JLabel(this.formatLabel(point)));
            hiLabels.put(new Integer((int)(-Math.log(point) * 10000.0)), new JLabel(this.formatLabel(1.0 - point)));
        }
        this.loSlider_.setLabelTable(loLabels);
        this.hiSlider_.setLabelTable(hiLabels);
        this.loSlider_.setPaintLabels(true);
        this.hiSlider_.setPaintLabels(true);
        this.loSlider_.setPaintTicks(false);
        this.hiSlider_.setPaintTicks(false);
        this.add(this.loSlider_);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.hiSlider_);
        this.changeListeners_ = new ArrayList();
        ChangeListener changer = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (!((JSlider)evt.getSource()).getValueIsAdjusting()) {
                    ChangeEvent fevt = new ChangeEvent(CutChooser.this);
                    Iterator it = CutChooser.this.changeListeners_.iterator();
                    while (it.hasNext()) {
                        ((ChangeListener)it.next()).stateChanged(fevt);
                    }
                }
            }
        };
        this.loSlider_.addChangeListener(changer);
        this.hiSlider_.addChangeListener(changer);
    }

    public void setLowValue(double val) {
        val = Math.min(Math.max(val, this.min_), 0.5);
        this.loSlider_.setValue((int)(Math.log(val) * 10000.0));
    }

    public void setHighValue(double val) {
        val = Math.min(Math.max(val, 0.5), 1.0 - this.min_);
        this.hiSlider_.setValue((int)(-Math.log(1.0 - val) * 10000.0));
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners_.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners_.remove(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.loSlider_.setEnabled(enabled);
        this.hiSlider_.setEnabled(enabled);
    }

    public double getLowValue() {
        return Math.exp((double)this.loSlider_.getValue() / 10000.0);
    }

    public double getHighValue() {
        return 1.0 - Math.exp((double)(-this.hiSlider_.getValue()) / 10000.0);
    }

    private String formatLabel(double frac) {
        double perc = (double)(this.percentileLabels_ ? 100 : 1) * frac;
        if (perc == (double)((int)perc)) {
            return Integer.toString((int)perc);
        }
        return Float.toString((float)perc);
    }
}

