/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.ttools.plot.DensityStyle;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.util.gui.RenderingComboBox;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class DensityStyleEditor
extends StyleEditor {
    final RenderingComboBox styleSelector_;

    public DensityStyleEditor(DensityStyle[] styles, final ToggleButtonModel rgbModel) {
        Box colorBox = Box.createHorizontalBox();
        this.styleSelector_ = new RenderingComboBox(styles){

            protected Icon getRendererIcon(Object item) {
                return ((Style)item).getLegendIcon();
            }
        };
        this.styleSelector_.addActionListener((ActionListener)this);
        final JLabel chanLabel = new JLabel("Channel: ");
        colorBox.add(chanLabel);
        colorBox.add((Component)new ShrinkWrapper((Component)this.styleSelector_));
        colorBox.add(Box.createHorizontalStrut(5));
        colorBox.add(Box.createHorizontalGlue());
        colorBox.setBorder(AuxWindow.makeTitledBorder("Colour"));
        this.add(colorBox);
        this.add(Box.createHorizontalStrut(300));
        ChangeListener rgbListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                boolean isRgb = rgbModel.isSelected();
                chanLabel.setEnabled(isRgb);
                DensityStyleEditor.this.styleSelector_.setEnabled(isRgb);
            }
        };
        rgbModel.addChangeListener(rgbListener);
        rgbListener.stateChanged(null);
    }

    public void setStyle(Style style) {
        this.styleSelector_.setSelectedItem((Object)style);
    }

    public Style getStyle() {
        return (Style)this.styleSelector_.getSelectedItem();
    }

    public String getHelpID() {
        return "DensityStyleEditor";
    }
}

