/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SuffixFileFilter;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.interop.Transmitter;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.AxisWindow;
import uk.ac.starlink.topcat.plot.BlobPanel;
import uk.ac.starlink.topcat.plot.CartesianAxesSelector;
import uk.ac.starlink.topcat.plot.ComboBoxBumper;
import uk.ac.starlink.topcat.plot.CutChooser;
import uk.ac.starlink.topcat.plot.DensityStyleEditor;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.GraphicsWindow;
import uk.ac.starlink.topcat.plot.PlotStatsLabel;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.PointSelectorSet;
import uk.ac.starlink.topcat.plot.PositionLabel;
import uk.ac.starlink.topcat.plot.ShaderListCellRenderer;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.SurfaceZoomRegionList;
import uk.ac.starlink.topcat.plot.WeightedAxesSelector;
import uk.ac.starlink.topcat.plot.Zoomer;
import uk.ac.starlink.ttools.func.Maths;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.plot.BinGrid;
import uk.ac.starlink.ttools.plot.DensityPlot;
import uk.ac.starlink.ttools.plot.DensityPlotEvent;
import uk.ac.starlink.ttools.plot.DensityPlotState;
import uk.ac.starlink.ttools.plot.DensityStyle;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotListener;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PtPlotSurface;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.SurfacePlot;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.util.gui.ChangingComboBoxModel;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class DensityWindow
extends GraphicsWindow {
    private final JComponent plotPanel_;
    private final BlobPanel blobPanel_;
    private final Action blobAction_;
    private final ToggleButtonModel rgbModel_;
    private final ToggleButtonModel zLogModel_;
    private final ToggleButtonModel weightModel_;
    private final CutChooser cutter_;
    private final JLabel cutLabel_;
    private final PixelSizeAction pixIncAction_;
    private final PixelSizeAction pixDecAction_;
    private final Action fitsAction_;
    private final DensityStyle[] styles_;
    private final List rgbRepaintList_;
    private final ComboBoxModel shaderModel_;
    private int pixelSize_ = 1;
    private static FileFilter fitsFilter_;
    private static final String[] AXIS_NAMES;
    static final Shader[] INDEXED_SHADERS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DensityWindow(Component parent) {
        super("Density Map", (TablePlot)new DensityPlot((PlotSurface)new PtPlotSurface()), AXIS_NAMES, 0, false, new ErrorModeSelectionModel[0], parent);
        final DensityPlot plot = (DensityPlot)this.getPlot();
        this.styles_ = new DensityStyle[]{new DStyle(DensityStyle.RED), new DStyle(DensityStyle.GREEN), new DStyle(DensityStyle.BLUE)};
        PlotSurface surface = plot.getSurface();
        this.setPadRatio(0.0);
        ((PtPlotSurface)surface)._tickLength = 0;
        this.getGridModel().setSelected(false);
        final SurfaceZoomRegionList zoomRegions = new SurfaceZoomRegionList((SurfacePlot)plot){

            protected void requestZoom(double[][] bounds) {
                for (int idim = 0; idim < 2; ++idim) {
                    if (bounds[idim] == null) continue;
                    DensityWindow.this.getAxisWindow().getEditors()[idim].clearBounds();
                    DensityWindow.this.getViewRanges()[idim].setBounds(bounds[idim]);
                }
                DensityWindow.this.replot();
            }
        };
        Zoomer zoomer = new Zoomer();
        zoomer.setRegions(zoomRegions);
        zoomer.setCursorComponent((Component)plot);
        JComponent scomp = surface.getComponent();
        scomp.addMouseListener(zoomer);
        scomp.addMouseMotionListener(zoomer);
        plot.addPlotListener(new PlotListener(){

            public void plotChanged(PlotEvent evt) {
                zoomRegions.reconfigure();
                DensityPlotEvent devt = (DensityPlotEvent)evt;
                String cutter = DensityWindow.getCutLabelText(devt.getLoCuts(), devt.getHiCuts(), ((DensityPlotState)devt.getPlotState()).getWeighted());
                DensityWindow.this.cutLabel_.setText(cutter);
            }
        });
        this.plotPanel_ = new JPanel();
        this.plotPanel_.setOpaque(false);
        this.blobPanel_ = new BlobPanel(){

            protected void blobCompleted(Shape blob) {
                DensityWindow.this.addNewSubsets(plot.getPlottedPointIterator().getContainedPoints(blob));
            }
        };
        this.blobPanel_.setColors(new Color(-2136956768, true), new Color(-1063214944, true));
        this.blobAction_ = this.blobPanel_.getBlobAction();
        this.plotPanel_.setLayout(new OverlayLayout(this.plotPanel_));
        this.plotPanel_.add(this.blobPanel_);
        this.plotPanel_.add((Component)plot);
        PlotStatsLabel plotStatus = new PlotStatsLabel();
        plot.addPlotListener((PlotListener)plotStatus);
        PositionLabel posStatus = new PositionLabel(surface);
        posStatus.setMaximumSize(new Dimension(Integer.MAX_VALUE, posStatus.getMaximumSize().height));
        this.getStatusBox().add(plotStatus);
        this.getStatusBox().add(Box.createHorizontalStrut(5));
        this.getStatusBox().add(posStatus);
        ActionListener legendPainter = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Iterator it = DensityWindow.this.rgbRepaintList_.iterator();
                while (it.hasNext()) {
                    ((JComponent)it.next()).repaint();
                }
            }
        };
        this.rgbModel_ = new ToggleButtonModel("RGB", ResourceIcon.COLOR, "Select red/green/blue or indexed rendering");
        this.rgbModel_.setSelected(true);
        this.rgbModel_.addActionListener(this.getReplotListener());
        this.rgbRepaintList_ = new ArrayList();
        this.rgbModel_.addActionListener(legendPainter);
        this.shaderModel_ = new ChangingComboBoxModel((Object[])INDEXED_SHADERS);
        Shader[] customShaders = Shaders.getCustomShaders();
        for (int is = 0; is < customShaders.length; ++is) {
            ((ChangingComboBoxModel)this.shaderModel_).insertElementAt((Object)customShaders[is], 0);
        }
        this.shaderModel_.setSelectedItem(this.shaderModel_.getElementAt(0));
        ((ChangingComboBoxModel)this.shaderModel_).addChangeListener((ChangeListener)this.getReplotListener());
        ((ChangingComboBoxModel)this.shaderModel_).addActionListener(legendPainter);
        this.zLogModel_ = new ToggleButtonModel("Log Intensity", ResourceIcon.COLOR_LOG, "Pixel colours represent log of counts");
        this.zLogModel_.setSelected(false);
        this.zLogModel_.addActionListener(this.getReplotListener());
        this.weightModel_ = new ToggleButtonModel("Weight Counts", ResourceIcon.WEIGHT, "Allow weighting of histogram counts");
        this.weightModel_.addActionListener(this.getReplotListener());
        this.pixIncAction_ = new PixelSizeAction("Bigger Pixels", ResourceIcon.ROUGH, "Increase number of screen pixels per bin", 1);
        this.pixDecAction_ = new PixelSizeAction("Smaller Pixels", ResourceIcon.FINE, "Decrease number of screen pixels per bin", -1);
        this.fitsAction_ = new GraphicsWindow.ExportAction("FITS", (Icon)ResourceIcon.FITS, "Save image as FITS array", fitsFilter_){

            public void exportTo(OutputStream out) throws IOException {
                try {
                    DensityWindow.this.exportFits(out);
                }
                catch (FitsException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
        };
        Transmitter imageTransmitter = ControlWindow.getInstance().getCommunicator().createImageTransmitter(this);
        this.getExportMenu().add(this.fitsAction_);
        this.getExportMenu().addSeparator();
        this.getExportMenu().add(imageTransmitter.getBroadcastAction());
        this.getExportMenu().add(imageTransmitter.createSendMenu());
        this.cutter_ = new CutChooser();
        this.cutter_.setLowValue(0.1);
        this.cutter_.setHighValue(0.9);
        this.cutter_.addChangeListener(this.getReplotListener());
        this.cutLabel_ = new JLabel("0 \u2014 0");
        Box cutBox = Box.createVerticalBox();
        cutBox.setBorder(DensityWindow.makeTitledBorder("Cut Percentile Levels"));
        Box clbox = Box.createHorizontalBox();
        clbox.add(Box.createHorizontalGlue());
        clbox.add(this.cutLabel_);
        clbox.add(Box.createHorizontalGlue());
        cutBox.add(this.cutter_);
        cutBox.add(clbox);
        Box shBox = Box.createHorizontalBox();
        final JComboBox<Object> shaderSelector = new JComboBox<Object>(this.shaderModel_);
        shaderSelector.setRenderer(new ShaderListCellRenderer(shaderSelector));
        shBox.add(Box.createHorizontalStrut(5));
        shBox.add((Component)new ShrinkWrapper(shaderSelector));
        shBox.add(Box.createHorizontalStrut(5));
        shBox.add(new ComboBoxBumper(shaderSelector));
        shBox.add(Box.createHorizontalStrut(5));
        Box shaderBox = Box.createVerticalBox();
        shaderBox.add(shBox);
        shaderBox.add(Box.createVerticalGlue());
        shaderBox.setBorder(DensityWindow.makeTitledBorder("Indexed Colours"));
        this.rgbModel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                shaderSelector.setEnabled(!DensityWindow.this.rgbModel_.isSelected());
            }
        });
        shaderSelector.setEnabled(!this.rgbModel_.isSelected());
        Box controlBox = Box.createHorizontalBox();
        controlBox.add(cutBox);
        controlBox.add(shaderBox);
        this.getExtrasPanel().add(controlBox);
        JMenu plotMenu = new JMenu("Plot");
        plotMenu.setMnemonic(80);
        plotMenu.add(this.weightModel_.createMenuItem());
        plotMenu.add(this.getRescaleAction());
        plotMenu.add(this.getAxisEditAction());
        plotMenu.add(this.getLegendModel().createMenuItem());
        plotMenu.add(this.getReplotAction());
        this.getJMenuBar().add(plotMenu);
        JMenu axisMenu = new JMenu("Axes");
        axisMenu.setMnemonic(65);
        axisMenu.add(this.getFlipModels()[0].createMenuItem());
        axisMenu.add(this.getFlipModels()[1].createMenuItem());
        axisMenu.addSeparator();
        axisMenu.add(this.getLogModels()[0].createMenuItem());
        axisMenu.add(this.getLogModels()[1].createMenuItem());
        axisMenu.add(this.zLogModel_.createMenuItem());
        this.getJMenuBar().add(axisMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        axisMenu.add(this.rgbModel_.createMenuItem());
        axisMenu.add(this.pixIncAction_);
        axisMenu.add(this.pixDecAction_);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        BasicAction fromVisibleAction = new BasicAction("New subset from visible", ResourceIcon.VISIBLE_SUBSET, "Define a new row subset containing only currently visible data"){

            public void actionPerformed(ActionEvent evt) {
                DensityWindow.this.addNewSubsets(plot.getPlottedPointIterator().getAllPoints());
            }
        };
        subsetMenu.add(this.blobAction_);
        subsetMenu.add(fromVisibleAction);
        this.getJMenuBar().add(subsetMenu);
        JMenu interopMenu = new JMenu("Interop");
        interopMenu.setMnemonic(73);
        interopMenu.add(imageTransmitter.getBroadcastAction());
        interopMenu.add(imageTransmitter.createSendMenu());
        this.getJMenuBar().add(interopMenu);
        this.getPointSelectorToolBar().addSeparator();
        this.getPointSelectorToolBar().add(this.weightModel_.createToolbarButton());
        this.getToolBar().add(this.fitsAction_);
        this.getToolBar().add(this.getRescaleAction());
        this.getToolBar().add(this.zLogModel_.createToolbarButton());
        this.getToolBar().add(this.rgbModel_.createToolbarButton());
        this.getToolBar().add(this.getLegendModel().createToolbarButton());
        this.getToolBar().add(this.pixIncAction_);
        this.getToolBar().add(this.pixDecAction_);
        this.getToolBar().add(this.blobAction_);
        this.getToolBar().add(fromVisibleAction);
        this.getToolBar().addSeparator();
        this.addHelp("DensityWindow");
        this.replot();
    }

    protected void init() {
        super.init();
        AxisWindow axwin = this.getAxisWindow();
        AxisEditor[] axes = axwin.getEditors();
        axwin.setEditors(new AxisEditor[]{axes[0], axes[1]});
    }

    protected JComponent getPlotPanel() {
        return this.plotPanel_;
    }

    protected StyleEditor createStyleEditor() {
        DensityStyleEditor editor = new DensityStyleEditor(this.styles_, this.rgbModel_);
        this.rgbRepaintList_.add(editor);
        return editor;
    }

    protected PointSelector createPointSelector() {
        CartesianAxesSelector axsel = new CartesianAxesSelector(AXIS_NAMES, this.getLogModels(), this.getFlipModels(), new ErrorModeSelectionModel[0]);
        final WeightedAxesSelector waxsel = new WeightedAxesSelector(axsel){

            public AxisEditor[] createAxisEditors() {
                AxisEditor[] xyeds = super.createAxisEditors();
                AxisEditor zed = new AxisEditor("Colour");
                return new AxisEditor[]{xyeds[0], xyeds[1], zed};
            }
        };
        waxsel.enableWeights(this.weightModel_.isSelected());
        this.weightModel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waxsel.enableWeights(DensityWindow.this.weightModel_.isSelected());
            }
        });
        PointSelector psel = new PointSelector(waxsel, this.getStyles());
        this.rgbRepaintList_.add(psel);
        return psel;
    }

    private boolean hasWeights() {
        PointSelectorSet psels = this.getPointSelectors();
        for (int ip = 0; ip < psels.getSelectorCount(); ++ip) {
            if (!((WeightedAxesSelector)psels.getSelector(ip).getAxesSelector()).hasWeights()) continue;
            return true;
        }
        return false;
    }

    public int getMainRangeCount() {
        return 2;
    }

    protected PlotState createPlotState() {
        return new DensityPlotState();
    }

    public PlotState getPlotState() {
        DensityPlotState state = (DensityPlotState)super.getPlotState();
        boolean valid = state != null && state.getValid();
        state.setRgb(this.rgbModel_.isSelected());
        state.setLogZ(this.zLogModel_.isSelected());
        state.setLoCut(this.cutter_.getLowValue());
        state.setHiCut(this.cutter_.getHighValue());
        state.setPixelSize(this.pixelSize_);
        state.setWeighted(this.hasWeights());
        state.setIndexedShader(this.rgbModel_.isSelected() ? null : (Shader)this.shaderModel_.getSelectedItem());
        this.pixIncAction_.configureEnabledness();
        this.pixDecAction_.configureEnabledness();
        return state;
    }

    protected void doReplot(PlotState state) {
        this.blobPanel_.setActive(false);
        super.doReplot(state);
    }

    public StyleSet getDefaultStyles(int npoint) {
        return new StyleSet(){

            public String getName() {
                return "RGB";
            }

            public Style getStyle(int index) {
                return DensityWindow.this.styles_[index % DensityWindow.this.styles_.length];
            }
        };
    }

    protected boolean isLegendInteresting(PlotState state) {
        return super.isLegendInteresting(state) && ((DensityPlotState)state).getRgb();
    }

    private static String getCutLabelText(double[] loCuts, double[] hiCuts, boolean weighted) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; loCuts != null && i < loCuts.length; ++i) {
            if (i > 0) {
                sbuf.append(";  ");
            }
            if (weighted) {
                sbuf.append((float)loCuts[i]).append(" \u2014 ").append((float)hiCuts[i]);
                continue;
            }
            sbuf.append((int)loCuts[i]).append(" \u2014 ").append((int)hiCuts[i]);
        }
        return sbuf.toString();
    }

    public void exportFits(OutputStream ostrm) throws IOException, FitsException {
        abstract class NumWriter {
            NumWriter() {
            }

            abstract void writeNum(double var1) throws IOException;

            abstract int size();
        }
        NumWriter numWriter;
        int bitpix;
        final DataOutputStream out = new DataOutputStream(ostrm);
        DensityPlot plot = (DensityPlot)this.getPlot();
        BinGrid[] grids = plot.getBinnedData();
        DensityPlotState state = (DensityPlotState)plot.getState();
        boolean weighted = state.getWeighted();
        int ngrid = grids.length;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < ngrid; ++i) {
            max = Math.max(max, grids[i].getMaxSum());
            min = Math.min(min, grids[i].getMinSum());
        }
        if (weighted) {
            bitpix = -64;
            numWriter = new NumWriter(){
                {
                }

                void writeNum(double value) throws IOException {
                    out.writeDouble(value);
                }

                int size() {
                    return 8;
                }
            };
        } else if (max < Math.pow(2.0, 7.0)) {
            bitpix = 8;
            numWriter = new NumWriter(){
                {
                }

                void writeNum(double value) throws IOException {
                    out.writeByte((int)value);
                }

                int size() {
                    return 1;
                }
            };
        } else if (max < Math.pow(2.0, 15.0)) {
            bitpix = 16;
            numWriter = new NumWriter(){
                {
                }

                void writeNum(double value) throws IOException {
                    out.writeShort((int)value);
                }

                int size() {
                    return 2;
                }
            };
        } else {
            bitpix = 32;
            numWriter = new NumWriter(){
                {
                }

                void writeNum(double value) throws IOException {
                    out.writeInt((int)value);
                }

                int size() {
                    return 4;
                }
            };
        }
        int nx = grids[0].getSizeX();
        int ny = grids[0].getSizeY();
        for (int i = 0; i < ngrid; ++i) {
            if (!$assertionsDisabled && grids[i].getSizeX() != nx) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && grids[i].getSizeY() != ny) {
                throw new AssertionError();
            }
        }
        int psize = state.getPixelSize();
        ValueInfo[] axes = state.getAxes();
        String name1 = this.looksLike(axes[0], (ValueInfo)Tables.RA_INFO) ? "RA---CAR" : axes[0].getName();
        String name2 = this.looksLike(axes[1], (ValueInfo)Tables.DEC_INFO) ? "DEC--CAR" : axes[1].getName();
        boolean log1 = state.getLogFlags()[0];
        boolean log2 = state.getLogFlags()[1];
        if (state.getLogFlags()[0]) {
            name1 = "log(" + name1 + ")";
        }
        if (state.getLogFlags()[1]) {
            name2 = "log(" + name2 + ")";
        }
        PlotSurface surface = plot.getSurface();
        Rectangle bbox = surface.getClip().getBounds();
        int x0 = bbox.x;
        int y0 = bbox.y;
        double[] p0 = surface.graphicsToData(x0, y0, false);
        double[] p1 = surface.graphicsToData(x0 + psize, y0 + psize, false);
        Header hdr = new Header();
        hdr.addValue("SIMPLE", true, "");
        hdr.addValue("BITPIX", (long)bitpix, "Data type");
        hdr.addValue("NAXIS", ngrid == 1 ? 2L : 3L, "Number of axes");
        hdr.addValue("NAXIS1", (long)nx, "X dimension");
        hdr.addValue("NAXIS2", (long)ny, "Y dimension");
        if (ngrid > 1) {
            hdr.addValue("NAXIS3", (long)ngrid, "Number of channels");
        }
        hdr.addValue("DATE", Times.mjdToIso((double)Times.unixMillisToMjd((long)System.currentTimeMillis())), "HDU creation date");
        hdr.addValue("CTYPE1", name1, axes[0].getDescription());
        hdr.addValue("CTYPE2", name2, axes[1].getDescription());
        if (ngrid > 1) {
            hdr.addValue("CTYPE3", "RGB", "Separate histograms stored in different planes");
        }
        if (!weighted) {
            hdr.addValue("BUNIT", "COUNTS", "Number of points per pixel (bin)");
        }
        if (max >= min) {
            hdr.addValue("DATAMIN", min, "Minimum value");
            hdr.addValue("DATAMAX", max, "Maximum value");
        }
        hdr.addValue("CRVAL1", 0.0, "Reference pixel X position");
        hdr.addValue("CRVAL2", 0.0, "Reference pixel Y position");
        Point origin = surface.dataToGraphics(log1 ? 1.0 : 0.0, log2 ? 1.0 : 0.0, false);
        if (origin != null) {
            hdr.addValue("CRPIX1", (double)(origin.x - x0) / (double)psize, "Reference pixel X index");
            hdr.addValue("CRPIX2", (double)(y0 + bbox.height - origin.y) / (double)psize, "Reference pixel Y index");
            if (ngrid > 1) {
                hdr.addValue("CRVAL3", 0.0, "Reference pixel plane index position");
                hdr.addValue("CRPIX3", 0.0, "Reference pixel plane index");
            }
            hdr.addValue("CDELT1", log1 ? Maths.log10((double)(p1[0] / p0[0])) : p1[0] - p0[0], "X extent of reference pixel");
            hdr.addValue("CDELT2", log2 ? Maths.log10((double)(p0[1] / p1[1])) : p0[1] - p1[1], "Y extent of reference pixel");
            if (ngrid > 1) {
                hdr.addValue("CDELT3", 1.0, "Plane index extent of reference pixel");
            }
        }
        hdr.addValue("ORIGIN", "TOPCAT " + TopcatUtils.getVersion() + " (" + this.getClass().getName() + ")", null);
        FitsConstants.writeHeader((DataOutput)out, (Header)hdr);
        for (int i = 0; i < ngrid; ++i) {
            double[] data = grids[i].getSums();
            for (int iy = 0; iy < ny; ++iy) {
                int yoff = (ny - 1 - iy) * nx;
                for (int ix = 0; ix < nx; ++ix) {
                    numWriter.writeNum(data[yoff + ix]);
                }
            }
        }
        int nbyte = nx * ny * ngrid * numWriter.size();
        int over = nbyte % 2880;
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
        out.flush();
    }

    private boolean looksLike(ValueInfo test, ValueInfo target) {
        try {
            String selectedName = this.getPointSelectors().getMainSelector().getTable().getColumnSelectorModel(target).getColumnData().getColumnInfo().getName();
            if (selectedName.equals(test.getName())) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return target.getName().equalsIgnoreCase(test.getName());
    }

    static {
        $assertionsDisabled = !DensityWindow.class.desiredAssertionStatus();
        fitsFilter_ = new SuffixFileFilter(new String[]{".fits", ".fit", ".fts"});
        AXIS_NAMES = new String[]{"X", "Y"};
        INDEXED_SHADERS = new Shader[]{Shaders.LUT_HEAT, Shaders.LUT_LIGHT, Shaders.LUT_PASTEL, Shaders.BLACK_WHITE, Shaders.LUT_RAINBOW, Shaders.RED_BLUE, Shaders.LUT_STAIRCASE, Shaders.LUT_MANYCOL};
    }

    private class PixelSizeAction
    extends BasicAction {
        final int MAX_SIZE = 20;
        final int MIN_SIZE = 1;
        final int inc_;

        PixelSizeAction(String name, Icon icon, String desc, int inc) {
            super(name, icon, desc);
            this.MAX_SIZE = 20;
            this.MIN_SIZE = 1;
            this.inc_ = inc;
        }

        public void actionPerformed(ActionEvent evt) {
            DensityWindow.this.pixelSize_ = Math.min(Math.max(DensityWindow.this.pixelSize_ + this.inc_, 1), 20);
            this.configureEnabledness();
            DensityWindow.this.replot();
        }

        void configureEnabledness() {
            this.setEnabled(DensityWindow.this.pixelSize_ + this.inc_ >= 1 && DensityWindow.this.pixelSize_ + this.inc_ <= 20);
        }
    }

    private class DStyle
    extends DensityStyle {
        DStyle(DensityStyle.Channel channel) {
            super(channel);
        }

        protected boolean isRGB() {
            return DensityWindow.this.rgbModel_.isSelected();
        }

        public Shader getShader() {
            return (Shader)DensityWindow.this.shaderModel_.getSelectedItem();
        }
    }
}

