/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataListener;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;

public class ErrorModeSelectionModel
implements ErrorModeSelection,
ComboBoxModel,
ActionListener {
    private final int iaxis_;
    private final String axisName_;
    private final ErrorMode[] options_;
    private final ActionForwarder actionForwarder_;
    private final ErrorRenderer errorRenderer_;
    private final List controlList_;
    private boolean enabled_;
    private int iOpt_;

    public ErrorModeSelectionModel(int iaxis, String axisName) {
        this.iaxis_ = iaxis;
        this.axisName_ = axisName;
        this.options_ = ErrorMode.getOptions();
        this.actionForwarder_ = new ActionForwarder();
        this.errorRenderer_ = ErrorRenderer.EXAMPLE;
        this.enabled_ = true;
        this.controlList_ = new ArrayList();
        this.setMode(ErrorMode.NONE);
    }

    public ErrorMode getErrorMode() {
        return this.options_[this.iOpt_];
    }

    public void setMode(ErrorMode mode) {
        this.actionPerformed(new ActionEvent(this, 0, mode.toString()));
    }

    public void setEnabled(boolean enabled) {
        Iterator it = this.controlList_.iterator();
        while (it.hasNext()) {
            ((JComponent)it.next()).setEnabled(enabled);
        }
        this.enabled_ = enabled;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void actionPerformed(ActionEvent evt) {
        String modeName = evt.getActionCommand();
        for (int i = 0; i < this.options_.length; ++i) {
            if (!this.options_[i].toString().equals(modeName)) continue;
            if (this.iOpt_ != i) {
                this.iOpt_ = i;
                this.actionForwarder_.actionPerformed(evt);
            }
            return;
        }
        throw new IllegalArgumentException("No such mode " + modeName);
    }

    public JMenuItem[] createMenuItems() {
        int nmode = this.options_.length;
        JMenuItem[] items = new JRadioButtonMenuItem[nmode];
        ButtonGroup bGrp = new ButtonGroup();
        for (int imode = 0; imode < nmode; ++imode) {
            ErrorMode mode = this.options_[imode];
            String modeName = mode.toString();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(" " + this.axisName_ + " " + mode, this.getIcon(mode, 24, 24, 1, 1));
            final int im = imode;
            item.setModel(new DefaultButtonModel(){

                public boolean isSelected() {
                    return im == ErrorModeSelectionModel.this.iOpt_;
                }
            });
            items[imode] = item;
            item.setActionCommand(mode.toString());
            bGrp.add(item);
            item.addActionListener(this);
            this.controlList_.add(item);
        }
        return items;
    }

    public AbstractButton createOnOffToolbarButton() {
        AbstractButton button = this.createOnOffButton();
        button.setText(null);
        return button;
    }

    public AbstractButton createOnOffButton() {
        DefaultButtonModel model = new DefaultButtonModel(){
            ErrorMode lastOnMode = ErrorMode.SYMMETRIC;

            public String getActionCommand() {
                ErrorMode currentMode = ErrorModeSelectionModel.this.getErrorMode();
                if (currentMode == ErrorMode.NONE) {
                    return this.lastOnMode.toString();
                }
                this.lastOnMode = currentMode;
                return ErrorMode.NONE.toString();
            }
        };
        final JToggleButton button = new JToggleButton(this.axisName_ + " Errors", this.getIcon(ErrorMode.SYMMETRIC, 24, 24, 1, 1));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                button.setSelected(ErrorModeSelectionModel.this.getErrorMode() != ErrorMode.NONE);
            }
        });
        model.addActionListener(this);
        button.setModel(model);
        button.setToolTipText("Toggle " + this.axisName_ + " error bars on/off");
        this.controlList_.add(button);
        return button;
    }

    public Object getElementAt(int index) {
        return this.options_[index];
    }

    public int getSize() {
        return this.options_.length;
    }

    public Object getSelectedItem() {
        return this.getErrorMode();
    }

    public void setSelectedItem(Object mode) {
        this.setMode((ErrorMode)mode);
    }

    public void addListDataListener(ListDataListener listener) {
    }

    public void removeListDataListener(ListDataListener listener) {
    }

    public void addActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public Icon getIcon(ErrorMode mode, int width, int height, int xpad, int ypad) {
        ErrorMode[] modes = new ErrorMode[this.iaxis_ + 1];
        for (int i = 0; i < modes.length; ++i) {
            modes[i] = i == this.iaxis_ ? mode : ErrorMode.NONE;
        }
        return ErrorModeSelectionModel.markCentre(this.errorRenderer_.getLegendIcon(modes, width, height, xpad, ypad));
    }

    private static Icon markCentre(final Icon icon) {
        return new Icon(){

            public int getIconHeight() {
                return icon.getIconHeight();
            }

            public int getIconWidth() {
                return icon.getIconWidth();
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color oldColor = g.getColor();
                g.setColor(Color.BLACK);
                icon.paintIcon(c, g, x, y);
                g.setColor(Color.WHITE);
                int radius = 2;
                g.drawOval(x + this.getIconWidth() / 2 - radius, y + this.getIconHeight() / 2 - radius, radius * 2, radius * 2);
                g.setColor(oldColor);
            }
        };
    }
}

