/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SubsetConsumer;
import uk.ac.starlink.topcat.SuffixFileFilter;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.plot.AugmentedAxesSelector;
import uk.ac.starlink.topcat.plot.AuxLegendZoomRegion;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.AxisWindow;
import uk.ac.starlink.topcat.plot.CartesianAxesSelector;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.LabelledAxesSelector;
import uk.ac.starlink.topcat.plot.MutableStyleSet;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.PointSelectorSet;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.PoolStyleSet;
import uk.ac.starlink.topcat.plot.SizeWrapper;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.Zoomer;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.plot.AuxLegend;
import uk.ac.starlink.ttools.plot.ErrorMarkStyleSet;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Legend;
import uk.ac.starlink.ttools.plot.MarkStyles;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.util.WrapUtils;
import uk.ac.starlink.util.gui.ChangingComboBoxModel;
import uk.ac.starlink.util.gui.ErrorDialog;

public abstract class GraphicsWindow
extends AuxWindow {
    private final TablePlot plot_;
    private final int ndim_;
    private final int naux_;
    private final boolean hasLabels_;
    private final PointSelectorSet pointSelectors_;
    private final ReplotListener replotListener_;
    private final Action replotAction_;
    private final Action axisEditAction_;
    private final Action rescaleAction_;
    private final Action incAuxAction_;
    private final Action decAuxAction_;
    private final String[] axisNames_;
    private final ToggleButtonModel gridModel_;
    private final ToggleButtonModel[] flipModels_;
    private final ToggleButtonModel[] logModels_;
    private final ErrorModeSelectionModel[] errorModeModels_;
    private final JMenu exportMenu_;
    private final JProgressBar progBar_;
    private final BoundedRangeModel noProgress_;
    private final BoundedRangeModel auxVisibleModel_;
    private final ComboBoxModel[] auxShaderModels_;
    private final ToggleButtonModel labelsModel_;
    private final JComponent plotArea_;
    private final JComponent controlArea_;
    private final Legend legend_;
    private final AuxLegend[] auxLegends_;
    private final JToolBar pselToolbar_;
    private final JComponent extrasPanel_;
    private final JComponent legendBox_;
    private final ToggleButtonModel legendModel_;
    private StyleSet styleSet_;
    private BitSet usedStyles_;
    private Points points_;
    private PointSelection lastPointSelection_;
    private PlotState lastState_;
    private Points lastPoints_;
    private Box statusBox_;
    private boolean initialised_;
    private int guidePointCount_;
    private AxisWindow axisWindow_;
    private Range[] dataRanges_;
    private Range[] viewRanges_;
    private boolean forceReread_;
    private double padRatio_ = 0.02;
    private PointsReader pointsReader_;
    private int nPlot_;
    private int nRead_;
    private boolean legendEverVisible_;
    private static JFileChooser exportSaver_;
    private static final Logger logger_;
    private static final Shader[] SHADERS;
    private static final StyleSet MARKERS1;
    private static final StyleSet MARKERS2;
    private static final StyleSet[] MARK_STYLE_SETS;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$convert$ValueConverter;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$AugmentedAxesSelector;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GraphicsWindow(String viewName, TablePlot plot, String[] axisNames, int naux, boolean hasLabels, ErrorModeSelectionModel[] errorModeModels, Component parent) {
        super(viewName, parent);
        this.plot_ = plot;
        this.axisNames_ = axisNames;
        this.ndim_ = axisNames.length;
        this.naux_ = naux;
        this.hasLabels_ = hasLabels;
        this.replotListener_ = new ReplotListener();
        this.flipModels_ = new ToggleButtonModel[this.ndim_ + this.naux_];
        this.logModels_ = new ToggleButtonModel[this.ndim_ + this.naux_];
        for (int i = 0; i < this.ndim_ + this.naux_; ++i) {
            String ax = i < this.ndim_ ? axisNames[i] : "Aux " + (i - this.ndim_ + 1);
            this.flipModels_[i] = new ToggleButtonModel("Flip " + ax + " Axis", null, "Reverse the sense of the " + ax + " axis");
            this.logModels_[i] = new ToggleButtonModel("Log " + ax + " Axis", null, "Logarithmic scale for the " + ax + " axis");
            this.flipModels_[i].addActionListener(this.replotListener_);
            this.logModels_[i].addActionListener(this.replotListener_);
        }
        if (this.ndim_ > 0) {
            this.flipModels_[0].setIcon(ResourceIcon.XFLIP);
            this.logModels_[0].setIcon(ResourceIcon.XLOG);
            if (this.ndim_ > 1) {
                this.flipModels_[1].setIcon(ResourceIcon.YFLIP);
                this.logModels_[1].setIcon(ResourceIcon.YLOG);
            }
        }
        this.errorModeModels_ = (ErrorModeSelectionModel[])errorModeModels.clone();
        for (int ierr = 0; ierr < this.errorModeModels_.length; ++ierr) {
            this.errorModeModels_[ierr].addActionListener(this.replotListener_);
        }
        this.auxVisibleModel_ = new DefaultBoundedRangeModel(0, 0, 0, this.naux_);
        this.incAuxAction_ = new GraphicsAction("Add Aux Axis", ResourceIcon.ADD_COLORS, "Add an auxiliary axis");
        this.decAuxAction_ = new GraphicsAction("Remove Aux Axis", ResourceIcon.REMOVE_COLORS, "Remove the highest-numbered auxiliary axis");
        this.auxVisibleModel_.addChangeListener(this.replotListener_);
        ChangeListener auxEnabler = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                int val = GraphicsWindow.this.auxVisibleModel_.getValue();
                GraphicsWindow.this.incAuxAction_.setEnabled(val < GraphicsWindow.this.auxVisibleModel_.getMaximum());
                GraphicsWindow.this.decAuxAction_.setEnabled(val > GraphicsWindow.this.auxVisibleModel_.getMinimum());
            }
        };
        this.auxVisibleModel_.addChangeListener(auxEnabler);
        auxEnabler.stateChanged(null);
        this.labelsModel_ = new ToggleButtonModel("Draw Labels", ResourceIcon.LABEL, "Draw text labels for plotted points");
        this.labelsModel_.addChangeListener(this.replotListener_);
        this.auxShaderModels_ = new ComboBoxModel[naux];
        Shader[] customShaders = Shaders.getCustomShaders();
        for (int i = 0; i < naux; ++i) {
            ChangingComboBoxModel shaderModel = new ChangingComboBoxModel((Object[])SHADERS);
            for (int is = 0; is < customShaders.length; ++is) {
                shaderModel.insertElementAt((Object)customShaders[is], 1);
            }
            shaderModel.setSelectedItem(shaderModel.getElementAt(1));
            shaderModel.addChangeListener((ChangeListener)this.replotListener_);
            this.auxShaderModels_[i] = shaderModel;
        }
        this.legend_ = new Legend();
        this.legendModel_ = new ToggleButtonModel("Show Legend", ResourceIcon.LEGEND, "Display legend at right of plot");
        this.legendModel_.addChangeListener(new ChangeListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void stateChanged(ChangeEvent evt) {
                boolean selected = GraphicsWindow.this.legendModel_.isSelected();
                GraphicsWindow.this.legendEverVisible_ = GraphicsWindow.this.legendEverVisible_ || selected;
                boolean contained = Arrays.asList(GraphicsWindow.this.legendBox_.getComponents()).contains(GraphicsWindow.this.legend_);
                if (selected && !contained) {
                    GraphicsWindow.this.legendBox_.add((Component)GraphicsWindow.this.legend_, 0);
                    GraphicsWindow.this.legend_.resetWidth();
                    GraphicsWindow.this.plotArea_.revalidate();
                    GraphicsWindow.this.legend_.repaint();
                } else if (!selected && contained) {
                    GraphicsWindow.this.legendBox_.remove((Component)GraphicsWindow.this.legend_);
                    GraphicsWindow.this.plotArea_.revalidate();
                    GraphicsWindow.this.legend_.repaint();
                } else if (!$assertionsDisabled && selected != contained) {
                    throw new AssertionError();
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$GraphicsWindow == null ? (class$uk$ac$starlink$topcat$plot$GraphicsWindow = GraphicsWindow.class$("uk.ac.starlink.topcat.plot.GraphicsWindow")) : class$uk$ac$starlink$topcat$plot$GraphicsWindow).desiredAssertionStatus();
            }
        });
        this.legendModel_.addActionListener(this.replotListener_);
        this.pointSelectors_ = new PointSelectorSet(){

            protected PointSelector createSelector() {
                return GraphicsWindow.this.createPointSelector();
            }

            protected StyleEditor createStyleEditor() {
                return GraphicsWindow.this.createStyleEditor();
            }
        };
        JPanel pselBox = new JPanel(new BorderLayout());
        pselBox.add((Component)this.pointSelectors_, "Center");
        this.controlArea_ = new ScrollableBox();
        this.extrasPanel_ = new JPanel();
        this.extrasPanel_.setLayout(new BoxLayout(this.extrasPanel_, 1));
        this.controlArea_.add(this.extrasPanel_);
        this.controlArea_.add(new SizeWrapper(pselBox));
        this.plotArea_ = new JPanel(new BorderLayout());
        this.plotArea_.setOpaque(false);
        this.legendBox_ = Box.createVerticalBox();
        this.plotArea_.add((Component)this.legendBox_, "East");
        this.auxLegends_ = new AuxLegend[this.naux_];
        if (this.naux_ > 0) {
            for (int iaux = 0; iaux < this.naux_; ++iaux) {
                AuxLegend auxLegend;
                this.auxLegends_[iaux] = auxLegend = new AuxLegend(false, 16);
                int xpad = iaux > 0 ? 10 : 0;
                auxLegend.setBorder(BorderFactory.createEmptyBorder(0, xpad, 0, 0));
                final int idim = iaux + this.getMainRangeCount();
                AuxLegendZoomRegion zoomRegion = new AuxLegendZoomRegion(auxLegend){

                    protected void dataZoomed(double lo, double hi) {
                        GraphicsWindow.this.getAxisWindow().getEditors()[idim].clearBounds();
                        GraphicsWindow.this.getViewRanges()[idim].setBounds(new double[]{lo, hi});
                        GraphicsWindow.this.replot();
                    }
                };
                Zoomer zoomer = new Zoomer();
                zoomer.setCursorComponent((Component)auxLegend);
                zoomer.setRegions(Collections.singletonList(zoomRegion));
                auxLegend.addMouseListener((MouseListener)zoomer);
                auxLegend.addMouseMotionListener((MouseMotionListener)zoomer);
            }
            final Box auxLegendBox = Box.createHorizontalBox();
            this.legendBox_.add(auxLegendBox);
            ChangeListener auxVisListener = new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    if (!GraphicsWindow.this.auxVisibleModel_.getValueIsAdjusting()) {
                        auxLegendBox.removeAll();
                        int nvis = GraphicsWindow.this.auxVisibleModel_.getValue();
                        for (int i = 0; i < nvis; ++i) {
                            auxLegendBox.add((Component)GraphicsWindow.this.auxLegends_[i]);
                        }
                        auxLegendBox.add(Box.createHorizontalGlue());
                    }
                }
            };
            auxVisListener.stateChanged(null);
            this.auxVisibleModel_.addChangeListener(auxVisListener);
        }
        this.pselToolbar_ = new JToolBar(0);
        this.pselToolbar_.setFloatable(false);
        pselBox.add((Component)this.pselToolbar_, "North");
        this.pselToolbar_.add(this.pointSelectors_.getAddSelectorAction());
        this.pselToolbar_.add(this.pointSelectors_.getRemoveSelectorAction());
        if (this.naux_ > 0) {
            this.pselToolbar_.addSeparator();
            this.pselToolbar_.add(this.incAuxAction_);
            this.pselToolbar_.add(this.decAuxAction_);
        }
        if (hasLabels) {
            this.pselToolbar_.addSeparator();
            this.pselToolbar_.add(this.labelsModel_.createToolbarButton());
        }
        this.pointSelectors_.addActionListener(this.replotListener_);
        final ToggleButtonModel splitModel = new ToggleButtonModel("Split Window", ResourceIcon.SPLIT, "Make the data control panel at the bottom of this window resizable");
        splitModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphicsWindow.this.placeMainComponents(splitModel.isSelected());
            }
        });
        this.getFileMenu().insert(splitModel.createMenuItem(), 1);
        this.progBar_ = this.placeProgressBar();
        this.noProgress_ = new DefaultBoundedRangeModel();
        GraphicExportAction gifAction = new GraphicExportAction(GraphicExporter.GIF, ResourceIcon.IMAGE, "Save plot as a GIF file");
        GraphicExportAction epsAction = new GraphicExportAction(GraphicExporter.EPS, ResourceIcon.PRINT, "Export to Encapsulated Postscript file");
        GraphicExportAction epsgzAction = new GraphicExportAction(GraphicExporter.EPS_GZIP, ResourceIcon.PRINT, "Export to Gzipped Encapsulated Postscript file");
        GraphicExportAction jpegAction = new GraphicExportAction(GraphicExporter.JPEG, ResourceIcon.JPEG, "Save plot as a JPEG file");
        GraphicExportAction pngAction = new GraphicExportAction(GraphicExporter.PNG, ResourceIcon.IMAGE, "Save plot as a PNG file");
        this.exportMenu_ = new JMenu("Export");
        this.exportMenu_.setMnemonic(69);
        this.exportMenu_.add(epsAction);
        this.exportMenu_.add(epsgzAction);
        this.exportMenu_.add(gifAction);
        this.exportMenu_.add(jpegAction);
        this.exportMenu_.add(pngAction);
        this.getJMenuBar().add(this.exportMenu_);
        this.replotAction_ = new GraphicsAction("Replot", ResourceIcon.REDO, "Redraw the plot");
        this.rescaleAction_ = new GraphicsAction("Rescale", ResourceIcon.RESIZE, "Rescale the plot to show all points");
        this.gridModel_ = new ToggleButtonModel("Show Grid", ResourceIcon.GRID_ON, "Select whether grid lines are drawn");
        this.gridModel_.setSelected(true);
        this.gridModel_.addActionListener(this.replotListener_);
        this.axisEditAction_ = new GraphicsAction("Configure Axes", ResourceIcon.AXIS_EDIT, "Set axis labels and ranges");
        this.getToolBar().add(splitModel.createToolbarButton());
        this.getToolBar().add(this.replotAction_);
        this.getToolBar().add(this.axisEditAction_);
        this.getToolBar().add(epsAction);
        this.getToolBar().add(gifAction);
    }

    private void placeMainComponents(boolean split) {
        JPanel mainArea = this.getMainArea();
        mainArea.removeAll();
        if (split) {
            JSplitPane splitter = new JSplitPane(0);
            splitter.setTopComponent(this.plotArea_);
            splitter.setOneTouchExpandable(true);
            splitter.setBottomComponent(new JScrollPane(this.controlArea_, 20, 31));
            splitter.setResizeWeight(1.0);
            splitter.setDividerLocation(this.plotArea_.getHeight());
            mainArea.add((Component)splitter, "Center");
        } else {
            mainArea.add((Component)this.plotArea_, "Center");
            mainArea.add((Component)this.controlArea_, "South");
        }
        mainArea.revalidate();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.ensureInitialised();
            if (this.lastState_ == null) {
                this.lastState_ = this.getPlotState();
                this.lastState_.setValid(false);
            }
        }
        super.setVisible(visible);
    }

    private void ensureInitialised() {
        if (!this.initialised_) {
            this.init();
            this.initialised_ = true;
            this.replot();
        }
    }

    protected void init() {
        this.placeMainComponents(false);
        this.plotArea_.add((Component)this.getPlotPanel(), "Center");
        PointSelector mainSel = this.createPointSelector();
        this.pointSelectors_.addNewSelector(mainSel);
        this.pointSelectors_.revalidate();
        final AxisEditor[] axeds = mainSel.getAxesSelector().createAxisEditors();
        int nax = axeds.length;
        this.dataRanges_ = new Range[nax];
        this.viewRanges_ = new Range[nax];
        for (int i = 0; i < nax; ++i) {
            this.viewRanges_[i] = new Range();
            axeds[i].addMaintainedRange(this.viewRanges_[i]);
            axeds[i].addActionListener(this.replotListener_);
        }
        this.axisWindow_ = new AxisWindow(this);
        this.axisWindow_.addActionListener(this.replotListener_);
        if (this.naux_ > 0) {
            ChangeListener auxVisListener = new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    if (!GraphicsWindow.this.auxVisibleModel_.getValueIsAdjusting()) {
                        int nvis = GraphicsWindow.this.getMainRangeCount() + GraphicsWindow.this.auxVisibleModel_.getValue();
                        AxisEditor[] eds = new AxisEditor[nvis];
                        System.arraycopy(axeds, 0, eds, 0, nvis);
                        GraphicsWindow.this.axisWindow_.setEditors(eds);
                    }
                }
            };
            this.auxVisibleModel_.addChangeListener(auxVisListener);
            auxVisListener.stateChanged(null);
        } else {
            this.axisWindow_.setEditors(axeds);
        }
        long npoint = 0L;
        if (this.guidePointCount_ > 0) {
            npoint = this.guidePointCount_;
        } else {
            TopcatModel selectedTable = this.getPointSelectors().getMainSelector().getTable();
            if (selectedTable != null) {
                npoint = selectedTable.getDataModel().getRowCount();
            } else {
                ListModel tablesList = ControlWindow.getInstance().getTablesListModel();
                npoint = 10000L;
                for (int i = 0; i < tablesList.getSize(); ++i) {
                    npoint = Math.min(npoint, ((TopcatModel)tablesList.getElementAt(i)).getDataModel().getRowCount());
                }
            }
        }
        this.setStyles(this.getDefaultStyles((int)Math.min(npoint, Integer.MAX_VALUE)));
        mainSel.setStyles(this.getStyles());
        this.legend_.setErrorModeSelections((ErrorModeSelection[])this.getErrorModeModels());
    }

    public JComponent getExtrasPanel() {
        return this.extrasPanel_;
    }

    public int getMainRangeCount() {
        return this.ndim_;
    }

    public void setGuidePointCount(int npoint) {
        this.guidePointCount_ = npoint;
    }

    public void setPadRatio(double pad) {
        this.padRatio_ = pad;
    }

    public double getPadRatio() {
        return this.padRatio_;
    }

    public JToolBar getPointSelectorToolBar() {
        return this.pselToolbar_;
    }

    public JMenu getExportMenu() {
        return this.exportMenu_;
    }

    public JMenu createMarkerStyleMenu(StyleSet[] styleSets) {
        JMenu styleMenu = new JMenu("Marker Style");
        styleMenu.setMnemonic(77);
        for (int i = 0; i < styleSets.length; ++i) {
            final StyleSet styleSet = styleSets[i];
            String name = styleSet.getName();
            Icon icon = MarkStyles.getIcon((StyleSet)styleSet);
            BasicAction stylesAct = new BasicAction(name, icon, "Set marker plotting style to " + name){

                public void actionPerformed(ActionEvent evt) {
                    GraphicsWindow.this.setStyles(styleSet);
                    GraphicsWindow.this.replot();
                }
            };
            styleMenu.add(stylesAct);
        }
        return styleMenu;
    }

    public JMenu createErrorModeMenu() {
        JMenu errorMenu = new JMenu("Errors");
        ErrorModeSelectionModel[] errorModeModels = this.getErrorModeModels();
        for (int ierr = 0; ierr < errorModeModels.length; ++ierr) {
            if (ierr > 0) {
                errorMenu.addSeparator();
            }
            JMenuItem[] errItems = errorModeModels[ierr].createMenuItems();
            for (int imode = 0; imode < errItems.length; ++imode) {
                errorMenu.add(errItems[imode]);
            }
        }
        return errorMenu;
    }

    public JMenu createErrorRendererMenu(final ErrorRenderer[] renderers) {
        final ErrorModeSelectionModel[] modeModels = this.getErrorModeModels();
        final JMenu styleMenu = new JMenu("Error Style");
        ActionListener errStyleListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphicsWindow.this.updateErrorRendererMenu(styleMenu, 0, renderers, modeModels);
            }
        };
        for (int ierr = 0; ierr < modeModels.length; ++ierr) {
            modeModels[ierr].addActionListener(errStyleListener);
        }
        errStyleListener.actionPerformed(null);
        return styleMenu;
    }

    private void updateErrorRendererMenu(JMenu errorMenu, int nfixed, ErrorRenderer[] renderers, ErrorModeSelectionModel[] modeModels) {
        while (errorMenu.getItemCount() > nfixed) {
            errorMenu.remove(errorMenu.getItemCount() - 1);
        }
        if (nfixed > 0) {
            errorMenu.addSeparator();
        }
        int ndim = 0;
        ErrorMode[] modes = new ErrorMode[modeModels.length];
        for (int idim = 0; idim < modeModels.length; ++idim) {
            modes[idim] = modeModels[idim].getErrorMode();
            if (ErrorMode.NONE.equals(modes[idim])) continue;
            ++ndim;
        }
        int nAdded = 0;
        for (int ir = 0; ir < renderers.length; ++ir) {
            final ErrorRenderer erend = renderers[ir];
            if (!erend.supportsDimensionality(ndim)) continue;
            Icon icon = erend.getLegendIcon(modes, 30, 20, 1, 1);
            String name = erend.getName();
            BasicAction rendAct = new BasicAction(name, icon, "Reset all error styles"){

                public void actionPerformed(ActionEvent evt) {
                    GraphicsWindow.this.setStyles((StyleSet)new ErrorMarkStyleSet(GraphicsWindow.this.styleSet_, erend));
                    GraphicsWindow.this.replot();
                }
            };
            errorMenu.add(rendAct);
            ++nAdded;
        }
        if (nAdded == 0) {
            errorMenu.add("No error bars").setEnabled(false);
        }
    }

    public PointSelectorSet getPointSelectors() {
        return this.pointSelectors_;
    }

    public Range[] getDataRanges() {
        return this.dataRanges_;
    }

    public Range[] getViewRanges() {
        return this.viewRanges_;
    }

    public ToggleButtonModel[] getFlipModels() {
        return this.flipModels_;
    }

    public ToggleButtonModel[] getLogModels() {
        return this.logModels_;
    }

    public ErrorModeSelectionModel[] getErrorModeModels() {
        return this.errorModeModels_;
    }

    public ToggleButtonModel getLegendModel() {
        return this.legendModel_;
    }

    public Points getPoints() {
        return this.points_;
    }

    public Box getStatusBox() {
        if (this.statusBox_ == null) {
            this.statusBox_ = Box.createHorizontalBox();
            JPanel panel = this.getControlPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(Box.createVerticalStrut(5));
            panel.add(this.statusBox_);
        }
        return this.statusBox_;
    }

    public int getAuxAxisCount() {
        return this.naux_;
    }

    public int getVisibleAuxAxisCount() {
        return this.auxVisibleModel_.getValue();
    }

    public TablePlot getPlot() {
        return this.plot_;
    }

    protected abstract JComponent getPlotPanel();

    protected void doReplot(PlotState state) {
        this.plot_.setState(state);
        this.plot_.repaint();
    }

    protected PointSelector createPointSelector() {
        ErrorModeSelectionModel[] errorModeModels = this.getErrorModeModels();
        AxesSelector axsel = new CartesianAxesSelector(this.axisNames_, this.logModels_, this.flipModels_, errorModeModels);
        axsel = this.addExtraAxes(axsel);
        PointSelector psel = new PointSelector(axsel, this.getStyles());
        ActionListener errorModeListener = psel.getErrorModeListener();
        for (int i = 0; i < errorModeModels.length; ++i) {
            errorModeModels[i].addActionListener(errorModeListener);
        }
        return psel;
    }

    protected AxesSelector addExtraAxes(AxesSelector axsel) {
        if (this.naux_ > 0) {
            ToggleButtonModel[] auxLogModels = new ToggleButtonModel[this.naux_];
            ToggleButtonModel[] auxFlipModels = new ToggleButtonModel[this.naux_];
            System.arraycopy(this.logModels_, this.ndim_, auxLogModels, 0, this.naux_);
            System.arraycopy(this.flipModels_, this.ndim_, auxFlipModels, 0, this.naux_);
            final AugmentedAxesSelector augsel = new AugmentedAxesSelector(axsel, this.naux_, auxLogModels, auxFlipModels, this.auxShaderModels_);
            this.auxVisibleModel_.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    if (!GraphicsWindow.this.auxVisibleModel_.getValueIsAdjusting()) {
                        augsel.setAuxVisible(GraphicsWindow.this.auxVisibleModel_.getValue());
                    }
                }
            });
            augsel.setAuxVisible(this.auxVisibleModel_.getValue());
            axsel = augsel;
        }
        if (this.hasLabels_) {
            final LabelledAxesSelector labsel = new LabelledAxesSelector(axsel);
            this.labelsModel_.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent evt) {
                    labsel.enableLabels(GraphicsWindow.this.labelsModel_.isSelected());
                }
            });
            labsel.enableLabels(this.labelsModel_.isSelected());
            axsel = labsel;
        }
        return axsel;
    }

    protected abstract StyleEditor createStyleEditor();

    public abstract StyleSet getDefaultStyles(int var1);

    public void setStyles(StyleSet styleSet) {
        this.styleSet_ = styleSet;
        this.usedStyles_ = new BitSet();
        int nsel = this.pointSelectors_.getSelectorCount();
        for (int isel = 0; isel < nsel; ++isel) {
            this.pointSelectors_.getSelector(isel).setStyles(this.getStyles());
        }
    }

    public MutableStyleSet getStyles() {
        return new PoolStyleSet(this.styleSet_, this.usedStyles_);
    }

    protected PlotState createPlotState() {
        return new PlotState();
    }

    public PlotState getPlotState() {
        PlotState state = this.createPlotState();
        if (!this.pointSelectors_.getMainSelector().isReady()) {
            state.setValid(false);
            return state;
        }
        state.setMainNdim(this.getMainRangeCount());
        StarTable mainData = this.pointSelectors_.getMainSelector().getAxesSelector().getData();
        int nd = mainData.getColumnCount();
        ColumnInfo[] axinfos = new ColumnInfo[nd];
        boolean[] flipFlags = new boolean[nd];
        boolean[] logFlags = new boolean[nd];
        ValueConverter[] converters = new ValueConverter[nd];
        for (int i = 0; i < nd; ++i) {
            ColumnInfo cinfo;
            axinfos[i] = cinfo = mainData.getColumnInfo(i);
            converters[i] = (ValueConverter)cinfo.getAuxDatumValue(TopcatUtils.NUMERIC_CONVERTER_INFO, class$uk$ac$starlink$ttools$convert$ValueConverter == null ? GraphicsWindow.class$("uk.ac.starlink.ttools.convert.ValueConverter") : class$uk$ac$starlink$ttools$convert$ValueConverter);
            if (this.flipModels_.length > i) {
                flipFlags[i] = this.flipModels_[i].isSelected();
            }
            if (this.logModels_.length <= i) continue;
            logFlags[i] = this.logModels_[i].isSelected();
        }
        state.setAxes((ValueInfo[])axinfos);
        state.setConverters(converters);
        state.setLogFlags(logFlags);
        state.setFlipFlags(flipFlags);
        BitSet activeShaders = new BitSet();
        int nvis = this.auxVisibleModel_.getValue();
        if (nvis > 0) {
            int nsel = this.pointSelectors_.getSelectorCount();
            for (int ivis = 0; ivis < nvis; ++ivis) {
                boolean isActive = false;
                for (int isel = 0; isel < nsel && !isActive; ++isel) {
                    AugmentedAxesSelector augSel = (AugmentedAxesSelector)WrapUtils.getWrapped((Object)this.pointSelectors_.getSelector(isel).getAxesSelector(), (Class)(class$uk$ac$starlink$topcat$plot$AugmentedAxesSelector == null ? GraphicsWindow.class$("uk.ac.starlink.topcat.plot.AugmentedAxesSelector") : class$uk$ac$starlink$topcat$plot$AugmentedAxesSelector));
                    CartesianAxesSelector auxSel = augSel.getAuxSelector();
                    ColumnData auxCol = (ColumnData)auxSel.getColumnSelector(ivis).getSelectedItem();
                    isActive = isActive || auxCol != null;
                }
                activeShaders.set(ivis, isActive);
            }
        }
        int nShader = activeShaders.length();
        if (!$assertionsDisabled && nShader > nvis) {
            throw new AssertionError();
        }
        Shader[] shaders = new Shader[nShader];
        for (int i = 0; i < nShader; ++i) {
            if (!activeShaders.get(i)) continue;
            shaders[i] = (Shader)this.auxShaderModels_[i].getSelectedItem();
        }
        state.setShaders(shaders);
        state.setGrid(this.gridModel_.isSelected());
        PointSelection pointSelection = this.pointSelectors_.getPointSelection();
        state.setPlotData((PlotData)pointSelection);
        boolean sameData = pointSelection.sameData(this.lastPointSelection_);
        if (!sameData || this.forceReread_) {
            this.forceReread_ = false;
            if (!pointSelection.sameAxes(this.lastPointSelection_)) {
                for (int i = 0; i < this.viewRanges_.length; ++i) {
                    this.viewRanges_[i].clear();
                }
            }
            if (this.pointsReader_ != null) {
                PointsReader pr = this.pointsReader_;
                this.pointsReader_ = null;
                pr.interrupt();
            }
            if (!$assertionsDisabled && this.pointsReader_ != null) {
                throw new AssertionError();
            }
            this.pointsReader_ = new PointsReader(pointSelection, state);
            this.pointsReader_.start();
            this.points_ = pointSelection.getEmptyPoints();
            this.dataRanges_ = this.calculateRanges(pointSelection, this.points_, state);
            this.lastPointSelection_ = pointSelection;
        }
        AxisEditor[] eds = this.axisWindow_.getEditors();
        String[] labels = new String[eds.length];
        for (int i = 0; i < eds.length; ++i) {
            AxisEditor ed = eds[i];
            labels[i] = ed.getLabel();
        }
        state.setAxisLabels(labels);
        double[][] bounds = new double[this.dataRanges_.length][];
        for (int i = 0; i < this.dataRanges_.length; ++i) {
            Range range = new Range(this.dataRanges_[i]);
            range.limit(this.viewRanges_[i]);
            bounds[i] = range.getFiniteBounds(logFlags[i]);
        }
        state.setRanges((double[][])bounds);
        state.setValid(true);
        return state;
    }

    public ToggleButtonModel getGridModel() {
        return this.gridModel_;
    }

    public Action getReplotAction() {
        return this.replotAction_;
    }

    public Action getRescaleAction() {
        return this.rescaleAction_;
    }

    public Action getAxisEditAction() {
        return this.axisEditAction_;
    }

    public void setMainTable(TopcatModel tcModel) {
        PointSelector mainSel = this.pointSelectors_.getMainSelector();
        mainSel.setTable(tcModel, true);
    }

    public void replot() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GraphicsWindow.this.performReplot();
            }
        });
    }

    private void performReplot() {
        if (!this.initialised_) {
            return;
        }
        PlotState state = this.getPlotState();
        if (!$assertionsDisabled && !state.equals((Object)this.getPlotState())) {
            throw new AssertionError((Object)state.compare(this.getPlotState()));
        }
        if (!state.equals((Object)this.lastState_) || this.points_ != this.lastPoints_) {
            this.configureLegends(state);
            PointSelection psel = (PointSelection)state.getPlotData();
            if (psel != null) {
                psel.setPoints(this.points_);
            }
            this.doReplot(state);
            logger_.info("Replot " + ++this.nPlot_);
            this.lastState_ = state;
            this.lastPoints_ = this.points_;
        }
    }

    private void configureLegends(PlotState state) {
        Rectangle containerRegion = this.plotArea_.getBounds();
        Rectangle plotRegion = this.plot_.getPlotBounds();
        int topgap = plotRegion.y;
        int botgap = containerRegion.height - plotRegion.height - topgap;
        Border border = BorderFactory.createEmptyBorder(topgap, 0, 10, 0);
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(Color.BLACK));
        border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 10));
        this.legend_.setBorder(border);
        PlotData data = state.getPlotData();
        if (data == null) {
            this.legend_.setStyles(new Style[0], new String[0]);
        } else {
            int nset = data.getSetCount();
            Style[] styles = new Style[nset];
            String[] labels = new String[nset];
            for (int is = 0; is < nset; ++is) {
                styles[is] = data.getSetStyle(is);
                labels[is] = data.getSetName(is);
            }
            this.legend_.setStyles(styles, labels);
            if (!this.legendEverVisible_ && this.isLegendInteresting(state)) {
                this.legendModel_.setSelected(true);
                if (!$assertionsDisabled && !this.legendEverVisible_) {
                    throw new AssertionError();
                }
            }
        }
        int nvis = this.getVisibleAuxAxisCount();
        for (int i = 0; i < nvis; ++i) {
            this.auxLegends_[i].setLengthPadding(topgap, botgap);
            this.auxLegends_[i].configure(state, i);
        }
    }

    protected boolean isLegendInteresting(PlotState state) {
        PlotData data = state.getPlotData();
        int nLabel = 0;
        if (data != null) {
            int nset = data.getSetCount();
            for (int is = 0; is < nset; ++is) {
                String label = data.getSetName(is);
                if (label == null || label.length() <= 0) continue;
                ++nLabel;
            }
        }
        return nLabel > 1;
    }

    protected ReplotListener getReplotListener() {
        return this.replotListener_;
    }

    public AxisWindow getAxisWindow() {
        return this.axisWindow_;
    }

    protected void addNewSubsets(BitSet pointsMask) {
        if (pointsMask.cardinality() == 0) {
            JOptionPane.showMessageDialog(this, "Empty subset", "Blank Selection", 0);
            return;
        }
        SubsetConsumer consumer = this.getPointSelectors().getMainSelector().getTable().enquireNewSubsetConsumer(this);
        if (consumer == null) {
            return;
        }
        PointSelection.TableMask[] tableMasks = ((PointSelection)this.lastState_.getPlotData()).getTableMasks(pointsMask);
        for (int i = 0; i < tableMasks.length; ++i) {
            TopcatModel tcModel = tableMasks[i].getTable();
            BitSet tmask = tableMasks[i].getMask();
            if (tmask.cardinality() <= 0) continue;
            consumer.consumeSubset(tcModel, tmask);
        }
    }

    private Range[] calculateRanges(PointSelection pointSelection, Points points, PlotState state) {
        return this.calculateRanges(pointSelection.createPlotData(points), state);
    }

    public Range[] calculateRanges(PlotData data, PlotState state) {
        Range[] ranges = this.plot_.calculateBounds(data, state).getRanges();
        for (int idim = 0; idim < ranges.length; ++idim) {
            ranges[idim].pad(this.getPadRatio());
        }
        return ranges;
    }

    private void rescale() {
        PlotState state = this.getPlotState();
        Points points = this.points_;
        if (state.getValid() && points != null) {
            this.getAxisWindow().clearRanges();
            this.dataRanges_ = this.calculateRanges((PointSelection)state.getPlotData(), points, state);
            for (int i = 0; i < this.viewRanges_.length; ++i) {
                this.viewRanges_[i].clear();
            }
        }
    }

    private JFileChooser getExportSaver() {
        if (exportSaver_ == null) {
            exportSaver_ = new JFileChooser(".");
            exportSaver_.setAcceptAllFileFilterUsed(true);
        }
        return exportSaver_;
    }

    public int getColumnIndex(TableColumn tcol) {
        return tcol.getModelIndex();
    }

    public void dispose() {
        super.dispose();
        if (this.pointsReader_ != null) {
            PointsReader pr = this.pointsReader_;
            this.pointsReader_ = null;
            pr.interrupt();
        }
        TopcatModel dummyModel = TopcatModel.createDummyModel();
        PointSelectorSet psels = this.getPointSelectors();
        for (int i = 0; i < psels.getSelectorCount(); ++i) {
            psels.getSelector(i).configureForTable(dummyModel);
        }
    }

    public static ErrorModeSelectionModel[] createErrorModeModels(String[] axisNames) {
        int nerror = axisNames.length;
        ErrorModeSelectionModel[] errorModeModels = new ErrorModeSelectionModel[nerror];
        for (int ierr = 0; ierr < nerror; ++ierr) {
            errorModeModels[ierr] = new ErrorModeSelectionModel(ierr, axisNames[ierr]);
        }
        return errorModeModels;
    }

    public static StyleSet[] getStandardMarkStyleSets() {
        return (StyleSet[])MARK_STYLE_SETS.clone();
    }

    public static StyleSet[] fixDefaultErrorRenderers(ErrorRenderer erend, StyleSet[] styleSets) {
        styleSets = (StyleSet[])styleSets.clone();
        for (int i = 0; i < styleSets.length; ++i) {
            styleSets[i] = new ErrorMarkStyleSet(styleSets[i], erend);
        }
        return styleSets;
    }

    static /* synthetic */ JProgressBar access$1900(GraphicsWindow x0) {
        return x0.progBar_;
    }

    static /* synthetic */ Points access$2302(GraphicsWindow x0, Points x1) {
        x0.points_ = x1;
        return x0.points_;
    }

    static /* synthetic */ Range[] access$2402(GraphicsWindow x0, Range[] x1) {
        x0.dataRanges_ = x1;
        return x1;
    }

    static /* synthetic */ Range[] access$2500(GraphicsWindow x0, PointSelection x1, Points x2, PlotState x3) {
        return x0.calculateRanges(x1, x2, x3);
    }

    static /* synthetic */ BoundedRangeModel access$2600(GraphicsWindow x0) {
        return x0.noProgress_;
    }

    static /* synthetic */ PointsReader access$1602(GraphicsWindow x0, PointsReader x1) {
        x0.pointsReader_ = x1;
        return x0.pointsReader_;
    }

    static {
        $assertionsDisabled = !GraphicsWindow.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat.plot");
        SHADERS = new Shader[]{Shaders.NULL, Shaders.LUT_RAINBOW, Shaders.TRANSPARENCY, Shaders.LUT_PASTEL, Shaders.LUT_STANDARD, Shaders.LUT_HEAT, Shaders.LUT_COLOR, Shaders.FIX_HUE, Shaders.WHITE_BLACK, Shaders.RED_BLUE, Shaders.FIX_INTENSITY, Shaders.FIX_RED, Shaders.FIX_GREEN, Shaders.FIX_BLUE, Shaders.HSV_H, Shaders.HSV_S, Shaders.HSV_V, Shaders.FIX_Y, Shaders.FIX_U, Shaders.FIX_V};
        MARKERS1 = MarkStyles.points((String)"Pixels");
        MARK_STYLE_SETS = new StyleSet[]{MARKERS1, MARKERS2 = MarkStyles.spots((String)"Dots", (int)1), MarkStyles.spots((String)"Spots", (int)2), MarkStyles.filledShapes((String)"Small Coloured Shapes", (int)3, null), MarkStyles.filledShapes((String)"Medium Coloured Shapes", (int)4, null), MarkStyles.filledShapes((String)"Large Coloured Shapes", (int)5, null), MarkStyles.filledShapes((String)"Small Black Shapes", (int)3, (Color)Color.black), MarkStyles.filledShapes((String)"Medium Black Shapes", (int)4, (Color)Color.black), MarkStyles.filledShapes((String)"Large Black Shapes", (int)5, (Color)Color.black), MarkStyles.openShapes((String)"Small Coloured Outlines", (int)3, null), MarkStyles.openShapes((String)"Medium Coloured Outlines", (int)4, null), MarkStyles.openShapes((String)"Large Coloured Outlines", (int)5, null), MarkStyles.openShapes((String)"Small Black Outlines", (int)3, (Color)Color.black), MarkStyles.openShapes((String)"Medium Black Outlines", (int)4, (Color)Color.black), MarkStyles.openShapes((String)"Large Black Outlines", (int)5, (Color)Color.black), MarkStyles.faded((String)"Faint Transparent Pixels", (StyleSet)MARKERS1, (int)20), MarkStyles.faded((String)"Faint Transparent Dots", (StyleSet)MARKERS2, (int)20), MarkStyles.faded((String)"Medium Transparent Pixels", (StyleSet)MARKERS1, (int)5), MarkStyles.faded((String)"Medium Transparent Dots", (StyleSet)MARKERS2, (int)5)};
    }

    private static class ScrollableBox
    extends Box
    implements Scrollable {
        ScrollableBox() {
            super(1);
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? visibleRect.height : visibleRect.width;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 24;
        }
    }

    protected class ReplotListener
    implements ActionListener,
    ItemListener,
    ListSelectionListener,
    ChangeListener {
        protected ReplotListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            GraphicsWindow.this.replot();
        }

        public void itemStateChanged(ItemEvent evt) {
            GraphicsWindow.this.replot();
        }

        public void valueChanged(ListSelectionEvent evt) {
            GraphicsWindow.this.replot();
        }

        public void stateChanged(ChangeEvent evt) {
            GraphicsWindow.this.replot();
        }
    }

    private class GraphicsAction
    extends BasicAction {
        GraphicsAction(String name, Icon icon, String desc) {
            super(name, icon, desc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == GraphicsWindow.this.replotAction_) {
                GraphicsWindow.this.forceReread_ = true;
                GraphicsWindow.this.lastState_ = null;
                GraphicsWindow.this.replot();
            } else if (this == GraphicsWindow.this.axisEditAction_) {
                GraphicsWindow.this.axisWindow_.show();
            } else if (this == GraphicsWindow.this.rescaleAction_) {
                GraphicsWindow.this.rescale();
                GraphicsWindow.this.replot();
            } else if (this == GraphicsWindow.this.incAuxAction_) {
                GraphicsWindow.this.auxVisibleModel_.setValue(GraphicsWindow.this.auxVisibleModel_.getValue() + 1);
            } else if (this == GraphicsWindow.this.decAuxAction_) {
                GraphicsWindow.this.auxVisibleModel_.setValue(GraphicsWindow.this.auxVisibleModel_.getValue() - 1);
            }
        }
    }

    private class PointsReader
    extends Thread {
        final PointSelection pointSelection_;
        final PlotState prState_;
        final long start_;

        PointsReader(PointSelection pointSelection, PlotState state) {
            super("Point Reader");
            this.pointSelection_ = pointSelection;
            this.prState_ = state;
            this.start_ = System.currentTimeMillis();
        }

        private boolean isActive() {
            return this == GraphicsWindow.this.pointsReader_;
        }

        public void run() {
            if (!this.isActive()) {
                return;
            }
            DefaultBoundedRangeModel progModel = new DefaultBoundedRangeModel();
            SwingUtilities.invokeLater(new Runnable(this, progModel){
                private final /* synthetic */ BoundedRangeModel val$progModel;
                private final /* synthetic */ PointsReader this$1;
                {
                    this.this$1 = this$1;
                    this.val$progModel = val$progModel;
                }

                public void run() {
                    if (PointsReader.access$1700(this.this$1)) {
                        GraphicsWindow.access$1900(PointsReader.access$1800(this.this$1)).setModel(this.val$progModel);
                    }
                }
            });
            Points points = null;
            Throwable error = null;
            boolean success = false;
            try {
                points = this.pointSelection_.readPoints(progModel);
                error = null;
                success = true;
                GraphicsWindow.this.nPlot_ = 0;
                logger_.info("Data read " + ++GraphicsWindow.this.nRead_ + " (" + points.getCount() + " in " + (System.currentTimeMillis() - this.start_) + "ms)");
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                points = null;
                error = e;
                success = false;
            }
            if (!this.isActive()) {
                return;
            }
            Points points1 = points;
            Throwable error1 = error;
            boolean success1 = success;
            SwingUtilities.invokeLater(new Runnable(this, success1, points1, error1){
                private final /* synthetic */ boolean val$success1;
                private final /* synthetic */ Points val$points1;
                private final /* synthetic */ Throwable val$error1;
                private final /* synthetic */ PointsReader this$1;
                {
                    this.this$1 = this$1;
                    this.val$success1 = val$success1;
                    this.val$points1 = val$points1;
                    this.val$error1 = val$error1;
                }

                public void run() {
                    if (!PointsReader.access$1700(this.this$1)) {
                        return;
                    }
                    if (this.val$success1) {
                        GraphicsWindow.access$2302(PointsReader.access$1800(this.this$1), this.val$points1);
                        GraphicsWindow.access$2402(PointsReader.access$1800(this.this$1), GraphicsWindow.access$2500(PointsReader.access$1800(this.this$1), this.this$1.pointSelection_, this.val$points1, this.this$1.prState_));
                        PointsReader.access$1800(this.this$1).replot();
                    } else if (this.val$error1 instanceof OutOfMemoryError) {
                        TopcatUtils.memoryError((OutOfMemoryError)this.val$error1);
                    } else {
                        ErrorDialog.showError((Component)PointsReader.access$1800(this.this$1), (String)"Read Error", (Throwable)this.val$error1);
                    }
                    GraphicsWindow.access$1900(PointsReader.access$1800(this.this$1)).setModel(GraphicsWindow.access$2600(PointsReader.access$1800(this.this$1)));
                    GraphicsWindow.access$1602(PointsReader.access$1800(this.this$1), null);
                }
            });
        }

        static /* synthetic */ boolean access$1700(PointsReader x0) {
            return x0.isActive();
        }

        static /* synthetic */ GraphicsWindow access$1800(PointsReader x0) {
            return x0.GraphicsWindow.this;
        }
    }

    private class GraphicExportAction
    extends ExportAction {
        private final GraphicExporter gExporter_;

        GraphicExportAction(GraphicExporter gExporter, Icon icon, String descrip) {
            super(gExporter.getName(), icon, descrip, gExporter.getFileSuffixes());
            this.gExporter_ = gExporter;
        }

        public void exportTo(OutputStream out) throws IOException {
            this.gExporter_.exportGraphic(GraphicsWindow.this.plotArea_, out);
        }
    }

    protected abstract class ExportAction
    extends BasicAction {
        final String formatName_;
        final FileFilter filter_;

        ExportAction(String formatName, Icon icon, String descrip, String[] extensions) {
            this(formatName, icon, descrip, new SuffixFileFilter(extensions));
        }

        ExportAction(String formatName, Icon icon, String descrip, FileFilter filter) {
            super("Export as " + formatName, icon, descrip);
            this.formatName_ = formatName;
            this.filter_ = filter;
        }

        public abstract void exportTo(OutputStream var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent evt) {
            GraphicsWindow parent = GraphicsWindow.this;
            JFileChooser chooser = GraphicsWindow.this.getExportSaver();
            chooser.setDialogTitle("Export Plot As " + this.formatName_);
            chooser.setFileFilter(this.filter_);
            if (chooser.showDialog(parent, "Write " + this.formatName_) != 0) return;
            OutputStream ostrm = null;
            File file = chooser.getSelectedFile();
            ostrm = new BufferedOutputStream(new FileOutputStream(file));
            this.exportTo(ostrm);
            Object var7_7 = null;
            if (ostrm == null) return;
            try {
                ostrm.close();
                return;
            }
            catch (IOException e2) {}
            return;
            {
                catch (IOException e) {
                    ErrorDialog.showError((Component)parent, (String)"Write Error", (Throwable)e);
                    Object var7_8 = null;
                    if (ostrm == null) return;
                    try {
                        ostrm.close();
                        return;
                    }
                    catch (IOException e2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (ostrm == null) throw throwable;
                try {
                    ostrm.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

