/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.IteratorRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSource;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.AxisWindow;
import uk.ac.starlink.topcat.plot.BarStyleEditor;
import uk.ac.starlink.topcat.plot.CartesianAxesSelector;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.GraphicsWindow;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.PointSelectorSet;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.RoundingSpinner;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.SurfaceZoomRegionList;
import uk.ac.starlink.topcat.plot.WeightedAxesSelector;
import uk.ac.starlink.topcat.plot.Zoomer;
import uk.ac.starlink.ttools.plot.BarStyles;
import uk.ac.starlink.ttools.plot.BinnedData;
import uk.ac.starlink.ttools.plot.Histogram;
import uk.ac.starlink.ttools.plot.HistogramPlotState;
import uk.ac.starlink.ttools.plot.MapBinnedData;
import uk.ac.starlink.ttools.plot.NormalisedBinnedData;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotListener;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.PtPlotSurface;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Rounder;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.SurfacePlot;
import uk.ac.starlink.ttools.plot.TablePlot;

public class HistogramWindow
extends GraphicsWindow {
    private final SurfaceZoomRegionList zoomRegionList_;
    private final Action[] validityActions_;
    private final ToggleButtonModel yLogModel_;
    private final ToggleButtonModel cumulativeModel_;
    private final ToggleButtonModel weightModel_;
    private final ToggleButtonModel normaliseModel_;
    private final JCheckBox offsetSelector_;
    private final RoundingSpinner binSizer_;
    private final RoundingSpinner.RoundingSpinnerModel linearBinModel_;
    private final RoundingSpinner.RoundingSpinnerModel logBinModel_;
    private Range autoYRange_;
    private Range autoYRangeCum_;
    private Range autoYRangeNorm_;
    private Range autoYRangeCumNorm_;
    private double autoLinearBinWidth_;
    private double autoLogBinWidth_;
    private static final int DEFAULT_BINS = 20;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HistogramWindow(Component parent) {
        super("Histogram", (TablePlot)new Histogram((PlotSurface)new PtPlotSurface()), new String[]{"X"}, 0, false, new ErrorModeSelectionModel[0], parent);
        final Histogram plot = (Histogram)this.getPlot();
        plot.setPreferredSize(new Dimension(500, 300));
        plot.addPlotListener(new PlotListener(){

            public void plotChanged(PlotEvent evt) {
                HistogramWindow.this.zoomRegionList_.reconfigure();
            }
        });
        this.zoomRegionList_ = new SurfaceZoomRegionList((SurfacePlot)plot){

            protected void requestZoom(double[][] bounds) {
                double[] ybounds;
                double[] xbounds = bounds[0];
                if (xbounds != null) {
                    HistogramWindow.this.getAxisWindow().getEditors()[0].clearBounds();
                    HistogramWindow.this.getViewRanges()[0].setBounds(xbounds);
                }
                if ((ybounds = bounds[1]) != null && ybounds[1] > 0.0) {
                    HistogramWindow.this.getAxisWindow().getEditors()[1].clearBounds();
                    HistogramWindow.this.getViewRanges()[1].setBounds(Math.max(0.0, ybounds[0]), ybounds[1]);
                }
                HistogramWindow.this.replot();
            }
        };
        Zoomer zoomer = new Zoomer();
        zoomer.setRegions(this.zoomRegionList_);
        zoomer.setCursorComponent((Component)plot);
        JComponent scomp = plot.getSurface().getComponent();
        scomp.addMouseListener(zoomer);
        scomp.addMouseMotionListener(zoomer);
        RescaleAction rescaleActionXY = new RescaleAction("Rescale", ResourceIcon.RESIZE, "Rescale the plot to fit all data", true, true);
        RescaleAction rescaleActionX = new RescaleAction("Rescale X", ResourceIcon.RESIZE_X, "Rescale the X axis to fit all data", true, false);
        RescaleAction rescaleActionY = new RescaleAction("Rescale Y", ResourceIcon.RESIZE_Y, "Rescale the Y axis to fit all data", false, true);
        this.yLogModel_ = new ToggleButtonModel("Log Y Axis", ResourceIcon.YLOG, "Logarithmic scale for the Y axis");
        this.yLogModel_.addActionListener(this.getReplotListener());
        this.cumulativeModel_ = new ToggleButtonModel("Cumulative Plot", ResourceIcon.CUMULATIVE, "Plot cumulative bars rather than counts");
        this.cumulativeModel_.addActionListener(this.getReplotListener());
        this.weightModel_ = new ToggleButtonModel("Weight Counts", ResourceIcon.WEIGHT, "Allow weighting of histogram counts");
        this.weightModel_.addActionListener(this.getReplotListener());
        this.normaliseModel_ = new ToggleButtonModel("Normalisation", ResourceIcon.NORMALISE, "Normalise histogram counts to unity");
        this.normaliseModel_.addActionListener(this.getReplotListener());
        TableSource binSrc = new TableSource(){

            public StarTable getStarTable() {
                return HistogramWindow.this.getBinDataTable();
            }
        };
        Action saveAct = this.createSaveTableAction("binned data", binSrc);
        Action importAct = this.createImportTableAction("binned data", binSrc, "histogram");
        this.getExportMenu().addSeparator();
        this.getExportMenu().add(saveAct);
        this.getExportMenu().add(importAct);
        this.binSizer_ = new RoundingSpinner();
        this.linearBinModel_ = new RoundingSpinner.RoundingSpinnerModel(this.binSizer_);
        this.logBinModel_ = new RoundingSpinner.RoundingSpinnerModel(this.binSizer_);
        this.binSizer_.setModel(this.linearBinModel_);
        this.getLogModels()[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean isLog = HistogramWindow.this.getLogModels()[0].isSelected();
                HistogramWindow.this.binSizer_.setLogarithmic(isLog);
                HistogramWindow.this.binSizer_.setModel(isLog ? HistogramWindow.this.logBinModel_ : HistogramWindow.this.linearBinModel_);
            }
        });
        this.binSizer_.addChangeListener(this.getReplotListener());
        this.offsetSelector_ = new JCheckBox("Offset:");
        this.offsetSelector_.setHorizontalTextPosition(2);
        this.offsetSelector_.addChangeListener(this.getReplotListener());
        Box binBox = Box.createHorizontalBox();
        binBox.add(this.offsetSelector_);
        binBox.add(Box.createHorizontalStrut(15));
        binBox.add(new JLabel("Width: "));
        binBox.add(this.binSizer_);
        binBox.setBorder(HistogramWindow.makeTitledBorder("Bin Placement"));
        this.getExtrasPanel().add(binBox);
        JMenu plotMenu = new JMenu("Plot");
        plotMenu.setMnemonic(80);
        plotMenu.add(this.cumulativeModel_.createMenuItem());
        plotMenu.add(this.weightModel_.createMenuItem());
        plotMenu.add(this.normaliseModel_.createMenuItem());
        plotMenu.add(rescaleActionXY);
        plotMenu.add(rescaleActionX);
        plotMenu.add(rescaleActionY);
        plotMenu.add(this.getAxisEditAction());
        plotMenu.add(this.getGridModel().createMenuItem());
        plotMenu.add(this.getLegendModel().createMenuItem());
        plotMenu.add(this.getReplotAction());
        this.getJMenuBar().add(plotMenu);
        JMenu axisMenu = new JMenu("Axes");
        axisMenu.setMnemonic(65);
        axisMenu.add(this.getFlipModels()[0].createMenuItem());
        axisMenu.addSeparator();
        axisMenu.add(this.getLogModels()[0].createMenuItem());
        axisMenu.add(this.yLogModel_.createMenuItem());
        this.getJMenuBar().add(axisMenu);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        BasicAction fromVisibleAction = new BasicAction("New subset from visible", ResourceIcon.RANGE_SUBSET, "Define a new row subset containing only currently visible range"){

            public void actionPerformed(ActionEvent evt) {
                HistogramWindow.this.addNewSubsets(plot.getVisiblePoints());
            }
        };
        subsetMenu.add(fromVisibleAction);
        this.getJMenuBar().add(subsetMenu);
        JMenu styleMenu = new JMenu("Bar Style");
        styleMenu.setMnemonic(66);
        StyleSet[] styleSets = this.getStyleSets();
        for (int i = 0; i < styleSets.length; ++i) {
            final StyleSet styleSet = styleSets[i];
            String name = styleSet.getName();
            Icon icon = BarStyles.getIcon((StyleSet)styleSet);
            BasicAction stylesAct = new BasicAction(name, icon, "Set bar plotting style to " + name){

                public void actionPerformed(ActionEvent evt) {
                    HistogramWindow.this.setStyles(styleSet);
                    HistogramWindow.this.replot();
                }
            };
            styleMenu.add(stylesAct);
        }
        this.getJMenuBar().add(styleMenu);
        this.getPointSelectorToolBar().addSeparator();
        this.getPointSelectorToolBar().add(this.weightModel_.createToolbarButton());
        this.getToolBar().add(rescaleActionXY);
        this.getToolBar().add(rescaleActionX);
        this.getToolBar().add(rescaleActionY);
        this.getToolBar().add(this.getGridModel().createToolbarButton());
        this.getToolBar().add(this.getLegendModel().createToolbarButton());
        this.getToolBar().add(this.cumulativeModel_.createToolbarButton());
        this.getToolBar().add(this.normaliseModel_.createToolbarButton());
        this.getToolBar().add(this.yLogModel_.createToolbarButton());
        this.getToolBar().add(fromVisibleAction);
        this.getToolBar().addSeparator();
        ArrayList<Action> actList = new ArrayList<Action>();
        actList.add(rescaleActionXY);
        actList.add(rescaleActionX);
        actList.add(rescaleActionY);
        actList.add(fromVisibleAction);
        actList.add(this.getReplotAction());
        this.validityActions_ = actList.toArray(new Action[0]);
        this.addHelp("HistogramWindow");
        this.replot();
    }

    protected JComponent getPlotPanel() {
        return this.getPlot();
    }

    protected PointSelector createPointSelector() {
        ActionListener weightAction = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AxisEditor yaxed;
                AxisWindow axwin = HistogramWindow.this.getAxisWindow();
                AxisEditor axisEditor = yaxed = axwin == null ? null : axwin.getEditors()[1];
                if (yaxed != null) {
                    SwingUtilities.invokeLater(new Runnable(this, yaxed){
                        private final /* synthetic */ AxisEditor val$yaxed;
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$yaxed = val$yaxed;
                        }

                        public void run() {
                            ValueInfo axinfo = Histogram.getYInfo((boolean)HistogramWindow.access$600(7.access$500(this.this$1)), (boolean)HistogramWindow.access$700(7.access$500(this.this$1)));
                            this.val$yaxed.setAxis(axinfo);
                        }
                    });
                }
            }

            static /* synthetic */ HistogramWindow access$500(7 x0) {
                return x0.HistogramWindow.this;
            }
        };
        this.weightModel_.addActionListener(weightAction);
        this.normaliseModel_.addActionListener(weightAction);
        CartesianAxesSelector axsel = new CartesianAxesSelector(new String[]{"X"}, this.getLogModels(), this.getFlipModels(), new ErrorModeSelectionModel[0]);
        final WeightedAxesSelector waxsel = new WeightedAxesSelector(axsel){

            public AxisEditor[] createAxisEditors() {
                AxisEditor yaxed = new AxisEditor("Y");
                ValueInfo axinfo = Histogram.getYInfo((boolean)HistogramWindow.this.hasWeights(), (boolean)HistogramWindow.this.isNormalised());
                yaxed.setAxis(axinfo);
                return new AxisEditor[]{super.createAxisEditors()[0], yaxed};
            }
        };
        waxsel.enableWeights(this.weightModel_.isSelected());
        waxsel.getWeightSelector().addActionListener(weightAction);
        this.weightModel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                waxsel.enableWeights(HistogramWindow.this.weightModel_.isSelected());
            }
        });
        weightAction.actionPerformed(null);
        return new PointSelector(waxsel, this.getStyles());
    }

    public int getMainRangeCount() {
        return 1;
    }

    public StyleSet getDefaultStyles(int npoint) {
        return BarStyles.sideFilled((String)"Filled Adjacent");
    }

    public StyleSet[] getStyleSets() {
        return new StyleSet[]{BarStyles.sideFilled((String)"Filled Adjacent"), BarStyles.sideOpen((String)"Open Adjacent", (boolean)true, (boolean)false), BarStyles.tops((String)"Outlines", (boolean)true, (boolean)false), BarStyles.filled((String)"Filled Overplot"), BarStyles.filled3d((String)"Bevelled Overplot"), BarStyles.open((String)"Open Overplot", (boolean)true, (boolean)false), BarStyles.spikes((String)"Spikes", (boolean)true, (boolean)false), BarStyles.sideOpen((String)"Black Open Adjacent", (boolean)false, (boolean)true), BarStyles.tops((String)"Black Outlines", (boolean)false, (boolean)true), BarStyles.open((String)"Black Open Overplot", (boolean)false, (boolean)true), BarStyles.spikes((String)"Black Spikes", (boolean)false, (boolean)true)};
    }

    protected StyleEditor createStyleEditor() {
        return new BarStyleEditor();
    }

    protected PlotState createPlotState() {
        HistogramPlotState state = new HistogramPlotState();
        return state;
    }

    public PlotState getPlotState() {
        boolean valid;
        HistogramPlotState state = (HistogramPlotState)super.getPlotState();
        boolean bl = valid = state != null && state.getValid();
        if (valid) {
            Range yRange;
            double bw = this.binSizer_.getNumericValue();
            if (bw > 0.0) {
                state.setBinWidth(bw);
            }
            double binBase = this.getLogModels()[0].isSelected() ? (this.offsetSelector_.isSelected() ? 1.0 : Math.sqrt(bw)) : (this.offsetSelector_.isSelected() ? -bw / 2.0 : 0.0);
            state.setBinBase(binBase);
            state.setCumulative(this.cumulativeModel_.isSelected());
            state.setLogFlags(new boolean[]{state.getLogFlags()[0], this.yLogModel_.isSelected()});
            state.setFlipFlags(new boolean[]{state.getFlipFlags()[0], false});
            boolean isNorm = this.isNormalised();
            boolean ylog = this.yLogModel_.isSelected();
            if (this.cumulativeModel_.isSelected()) {
                yRange = new Range(isNorm ? this.autoYRangeCumNorm_ : this.autoYRangeCum_);
            } else {
                yRange = new Range(isNorm ? this.autoYRangeNorm_ : this.autoYRange_);
                double factor = state.getLogFlags()[0] ? Math.log(bw) / Math.log(this.autoLogBinWidth_) : bw / this.autoLinearBinWidth_;
                double[] bnds = yRange.getFiniteBounds(ylog);
                yRange = new Range(bnds[0] * factor, bnds[1] * factor);
            }
            yRange.pad(this.getPadRatio());
            yRange.limit(this.getViewRanges()[1]);
            double[] yBounds = yRange.getFiniteBounds(ylog);
            if (!ylog) {
                yBounds[0] = 0.0;
            }
            state.setRanges((double[][])new double[][]{state.getRanges()[0], yBounds});
            state.setWeighted(this.hasWeights());
            state.setNormalised(isNorm);
        }
        for (int i = 0; i < this.validityActions_.length; ++i) {
            this.validityActions_[i].setEnabled(valid);
        }
        return state;
    }

    private boolean hasWeights() {
        PointSelectorSet psels = this.getPointSelectors();
        for (int ip = 0; ip < psels.getSelectorCount(); ++ip) {
            if (!((WeightedAxesSelector)psels.getSelector(ip).getAxesSelector()).hasWeights()) continue;
            return true;
        }
        return false;
    }

    private boolean isNormalised() {
        return this.normaliseModel_.isSelected();
    }

    public Range[] calculateRanges(PlotData data, PlotState state) {
        Range xRange = super.calculateRanges(data, state)[0];
        boolean xlog = this.getLogModels()[0].isSelected();
        double[] xBounds = xRange.getFiniteBounds(xlog);
        this.calculateMaxCount(data, xBounds, true);
        return new Range[]{xRange};
    }

    private void calculateMaxCount(PlotData data, double[] xBounds, boolean autoWidth) {
        int is;
        double binWidth;
        double binBase;
        if (autoWidth || !(this.linearBinModel_.getValue() instanceof Number) || !(this.logBinModel_.getValue() instanceof Number)) {
            double[] multBounds = new Range(xBounds).getFiniteBounds(true);
            double factor = Math.exp(Math.log(multBounds[1] / multBounds[0]) / 20.0);
            double bwLog = Rounder.LOG.round(factor);
            this.logBinModel_.setValue(new Double(bwLog));
            double gap = (xBounds[1] - xBounds[0]) / 20.0;
            if (!$assertionsDisabled && !(gap > 0.0)) {
                throw new AssertionError();
            }
            Class clazz = this.getPointSelectors().getMainSelector().getAxesSelector().getData().getColumnInfo(0).getContentClass();
            double bwLinear = Rounder.LINEAR.round(gap);
            if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class) {
                gap = Math.ceil(gap);
            }
            this.linearBinModel_.setValue(new Double(bwLinear));
        }
        double bwLog = ((Number)this.logBinModel_.getValue()).doubleValue();
        double bwLinear = ((Number)this.linearBinModel_.getValue()).doubleValue();
        int nset = data.getSetCount();
        boolean xlog = this.getLogModels()[0].isSelected();
        boolean offset = this.offsetSelector_.isSelected();
        if (xlog) {
            binBase = offset ? 1.0 : Math.sqrt(bwLog);
            binWidth = bwLog;
        } else {
            binBase = offset ? bwLinear / 2.0 : 0.0;
            binWidth = bwLinear;
        }
        MapBinnedData.BinMapper mapper = MapBinnedData.createBinMapper((boolean)xlog, (double)binWidth, (double)binBase);
        MapBinnedData binned = new MapBinnedData(nset, mapper);
        NormalisedBinnedData binnedNorm = new NormalisedBinnedData((BinnedData)new MapBinnedData(nset, mapper));
        double xlo = mapper.getBounds((Object)mapper.getKey(xBounds[0]))[0];
        double xhi = mapper.getBounds((Object)mapper.getKey(xBounds[1]))[1];
        boolean[] setFlags = new boolean[nset];
        PointSequence pseq = data.getPointSequence();
        while (pseq.next()) {
            double[] coords = pseq.getPoint();
            double x = coords[0];
            double w = coords[1];
            if (!(x >= xlo) || !(x <= xhi) || Double.isNaN(w)) continue;
            for (is = 0; is < nset; ++is) {
                setFlags[is] = pseq.isIncluded(is);
            }
            binned.submitDatum(x, w, setFlags);
            binnedNorm.submitDatum(x, w, setFlags);
        }
        pseq.close();
        Range yRange = new Range();
        Range yRangeCum = new Range();
        double[] ytots = new double[nset];
        Iterator binIt = binned.getBinIterator(false);
        while (binIt.hasNext()) {
            BinnedData.Bin bin = (BinnedData.Bin)binIt.next();
            for (is = 0; is < nset; ++is) {
                double s = bin.getWeightedCount(is);
                int n = is;
                ytots[n] = ytots[n] + s;
                yRange.submit(s);
                yRangeCum.submit(ytots[is]);
            }
        }
        Range yRangeNorm = new Range();
        Range yRangeCumNorm = new Range();
        double[] yntots = new double[nset];
        Iterator binIt2 = binnedNorm.getBinIterator(false);
        while (binIt2.hasNext()) {
            BinnedData.Bin bin = (BinnedData.Bin)binIt2.next();
            for (int is2 = 0; is2 < nset; ++is2) {
                double s = bin.getWeightedCount(is2);
                int n = is2;
                yntots[n] = yntots[n] + s;
                yRangeNorm.submit(s);
                yRangeCumNorm.submit(yntots[is2]);
            }
        }
        this.autoLinearBinWidth_ = bwLinear;
        this.autoLogBinWidth_ = bwLog;
        this.autoYRange_ = yRange;
        this.autoYRangeNorm_ = yRangeNorm;
        this.autoYRangeCum_ = yRangeCum;
        this.autoYRangeCumNorm_ = yRangeCumNorm;
    }

    private StarTable getBinDataTable() {
        Histogram plot = (Histogram)this.getPlot();
        final BinnedData binData = plot.getBinnedData();
        HistogramPlotState state = (HistogramPlotState)plot.getState();
        boolean weighted = state.getWeighted();
        final boolean isInt = binData.isInteger();
        SetId[] setIds = this.getPointSelectors().getPointSelection().getSetIds();
        final int nset = setIds.length;
        int ipre = 2;
        final ColumnInfo[] infos = new ColumnInfo[2 + nset];
        int icol = 0;
        infos[icol++] = new ColumnInfo("LOW", Double.class, "Bin lower bound");
        infos[icol++] = new ColumnInfo("HIGH", Double.class, "Bin upper bound");
        if (!$assertionsDisabled && icol != 2) {
            throw new AssertionError();
        }
        SetNamer namer = this.createSetNamer(setIds);
        for (int is = 0; is < nset; ++is) {
            RowSubset rset;
            SetId setId = setIds[is];
            ColumnInfo weightInfo = HistogramWindow.getWeightInfo(setId);
            TopcatModel tcModel = setId.getPointSelector().getTable();
            StringBuffer descrip = new StringBuffer();
            descrip.append(state.getNormalised() ? "Normalised count" : "Count");
            if (weightInfo != null) {
                descrip.append(" weighted by ").append(weightInfo.getName());
            }
            if ((rset = (RowSubset)tcModel.getSubsets().get(setId.getSetIndex())) != RowSubset.ALL) {
                descrip.append(" for row subset ").append(rset.getName());
            }
            descrip.append(" in table ").append(tcModel.getLabel());
            ColumnInfo colInfo = new ColumnInfo(namer.getName(setId), isInt ? (class$java$lang$Integer == null ? HistogramWindow.class$("java.lang.Integer") : class$java$lang$Integer) : (class$java$lang$Double == null ? HistogramWindow.class$("java.lang.Double") : class$java$lang$Double), descrip.toString());
            if (weightInfo != null) {
                colInfo.setUnitString(weightInfo.getUnitString());
            }
            infos[icol++] = colInfo;
        }
        if (!$assertionsDisabled && icol != infos.length) {
            throw new AssertionError();
        }
        AbstractStarTable binsTable = new AbstractStarTable(){

            public int getColumnCount() {
                return infos.length;
            }

            public long getRowCount() {
                return -1L;
            }

            public ColumnInfo getColumnInfo(int icol) {
                return infos[icol];
            }

            public RowSequence getRowSequence() {
                Iterator binIt = binData.getBinIterator(true);
                Iterator rowIt = new Iterator(this, binIt){
                    static final /* synthetic */ boolean $assertionsDisabled;
                    private final /* synthetic */ Iterator val$binIt;
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$binIt = val$binIt;
                    }

                    public boolean hasNext() {
                        return this.val$binIt.hasNext();
                    }

                    public Object next() {
                        BinnedData.Bin bin = (BinnedData.Bin)this.val$binIt.next();
                        Object[] row = new Object[2 + 11.access$900(this.this$1)];
                        int icol = 0;
                        row[icol++] = new Double(bin.getLowBound());
                        row[icol++] = new Double(bin.getHighBound());
                        for (int iset = 0; iset < 11.access$900(this.this$1); ++iset) {
                            double sum = bin.getWeightedCount(iset);
                            if (!$assertionsDisabled && 11.access$1000(this.this$1) && sum != (double)((int)sum)) {
                                throw new AssertionError(sum);
                            }
                            row[icol++] = 11.access$1000(this.this$1) ? (Number)new Integer((int)sum) : (Number)new Double(sum);
                        }
                        return row;
                    }

                    public void remove() {
                        this.val$binIt.remove();
                    }

                    static {
                        $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$HistogramWindow == null ? (class$uk$ac$starlink$topcat$plot$HistogramWindow = HistogramWindow.class$("uk.ac.starlink.topcat.plot.HistogramWindow")) : class$uk$ac$starlink$topcat$plot$HistogramWindow).desiredAssertionStatus();
                    }
                };
                return new IteratorRowSequence(rowIt);
            }

            static /* synthetic */ int access$900(11 x0) {
                return x0.nset;
            }

            static /* synthetic */ boolean access$1000(11 x0) {
                return x0.isInt;
            }
        };
        binsTable.setName("Histogram");
        return binsTable;
    }

    private static final ColumnInfo getWeightInfo(SetId setId) {
        AxesSelector axsel = setId.getPointSelector().getAxesSelector();
        if (axsel instanceof WeightedAxesSelector) {
            WeightedAxesSelector waxsel = (WeightedAxesSelector)axsel;
            return waxsel.hasWeights() ? ((ColumnData)waxsel.getWeightSelector().getSelectedItem()).getColumnInfo() : null;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private SetNamer createSetNamer(SetId[] setIds) {
        int nset = setIds.length;
        if (nset == 1) {
            return new SetNamer(){

                String getName(SetId setId) {
                    return this.getBaseName(setId);
                }
            };
        }
        boolean multiTable = false;
        boolean multiSet = false;
        TopcatModel table0 = setIds[0].getPointSelector().getTable();
        for (int is = 0; is < nset; ++is) {
            multiTable = multiTable || setIds[is].getPointSelector().getTable() != table0;
            multiSet = multiSet || setIds[is].getSetIndex() != 0;
        }
        final boolean useTable = multiTable;
        final boolean useSet = multiSet;
        return new SetNamer(){

            String getName(SetId setId) {
                TopcatModel tcModel = setId.getPointSelector().getTable();
                StringBuffer sbuf = new StringBuffer();
                if (useTable) {
                    sbuf.append("t");
                    sbuf.append(tcModel.getID());
                }
                if (useTable && useSet) {
                    sbuf.append('_');
                }
                if (useSet) {
                    RowSubset rset = (RowSubset)tcModel.getSubsets().get(setId.getSetIndex());
                    sbuf.append(rset.getName());
                }
                ColumnInfo weightInfo = HistogramWindow.getWeightInfo(setId);
                sbuf.append('_').append(this.getBaseName(setId));
                return sbuf.toString();
            }
        };
    }

    static {
        $assertionsDisabled = !HistogramWindow.class.desiredAssertionStatus();
    }

    private class RescaleAction
    extends BasicAction {
        final boolean scaleX_;
        final boolean scaleY_;

        RescaleAction(String name, Icon icon, String shortdesc, boolean scaleX, boolean scaleY) {
            super(name, icon, shortdesc);
            this.scaleX_ = scaleX;
            this.scaleY_ = scaleY;
        }

        public void actionPerformed(ActionEvent evt) {
            PlotState state = HistogramWindow.this.getPlotState();
            Points points = HistogramWindow.this.getPoints();
            if (state.getValid() && points != null) {
                double[] xBounds;
                PlotData data = ((PointSelection)state.getPlotData()).createPlotData(points);
                if (this.scaleX_) {
                    Range xRange;
                    HistogramWindow.this.getDataRanges()[0] = xRange = HistogramWindow.super.calculateRanges(data, state)[0];
                    HistogramWindow.this.getViewRanges()[0].clear();
                    HistogramWindow.this.getAxisWindow().getEditors()[0].clearBounds();
                    xBounds = xRange.getFiniteBounds(state.getLogFlags()[0]);
                } else {
                    xBounds = state.getRanges()[0];
                }
                if (this.scaleY_) {
                    HistogramWindow.this.calculateMaxCount(data, xBounds, this.scaleX_);
                    HistogramWindow.this.getViewRanges()[1].clear();
                    HistogramWindow.this.getAxisWindow().getEditors()[1].clearBounds();
                }
                HistogramWindow.this.replot();
            }
        }
    }

    private abstract class SetNamer {
        private SetNamer() {
        }

        abstract String getName(SetId var1);

        String getBaseName(SetId setId) {
            ColumnInfo weightInfo = HistogramWindow.getWeightInfo(setId);
            return weightInfo == null ? "COUNT" : "SUM_" + weightInfo.getName();
        }
    }
}

