/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.ColumnDataComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.ColumnDataTable;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.util.Wrapper;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class LabelledAxesSelector
implements AxesSelector,
Wrapper {
    private final AxesSelector baseSelector_;
    private final JComboBox labelSelector_;
    private final JComponent labelPanel_;
    private final JComponent labelContainer_;
    private final JComponent selectorPanel_;
    private TopcatModel tcModel_;
    private boolean labelsEnabled_;

    public LabelledAxesSelector(AxesSelector baseSelector) {
        this.baseSelector_ = baseSelector;
        this.labelSelector_ = ColumnDataComboBoxModel.createComboBox();
        this.selectorPanel_ = Box.createVerticalBox();
        this.selectorPanel_.add(baseSelector.getColumnSelectorPanel());
        this.labelContainer_ = Box.createVerticalBox();
        this.labelPanel_ = Box.createHorizontalBox();
        this.labelPanel_.add(Box.createHorizontalStrut(5));
        this.labelPanel_.add(new JLabel("Point Labels: "));
        this.labelPanel_.add((Component)new ShrinkWrapper((Component)this.labelSelector_));
        this.labelPanel_.add(Box.createHorizontalGlue());
        this.selectorPanel_.add(this.labelContainer_);
    }

    public Object getBase() {
        return this.baseSelector_;
    }

    public void enableLabels(boolean enabled) {
        if (enabled != this.labelsEnabled_) {
            if (enabled) {
                this.labelContainer_.add(this.labelPanel_);
            } else {
                this.labelContainer_.remove(this.labelPanel_);
            }
            this.labelsEnabled_ = enabled;
            this.labelContainer_.revalidate();
        }
    }

    public JComponent getColumnSelectorPanel() {
        return this.selectorPanel_;
    }

    public JComboBox[] getColumnSelectors() {
        JComboBox[] baseSelectors = this.baseSelector_.getColumnSelectors();
        JComboBox[] selectors = new JComboBox[baseSelectors.length + 1];
        System.arraycopy(baseSelectors, 0, selectors, 0, baseSelectors.length);
        selectors[baseSelectors.length] = this.labelSelector_;
        return selectors;
    }

    public int getNdim() {
        return this.baseSelector_.getNdim();
    }

    public boolean isReady() {
        return this.baseSelector_.isReady();
    }

    public StarTable getData() {
        return this.baseSelector_.getData();
    }

    public StarTable getErrorData() {
        return this.baseSelector_.getErrorData();
    }

    public ErrorMode[] getErrorModes() {
        return this.baseSelector_.getErrorModes();
    }

    public StarTable getLabelData() {
        if (this.labelsEnabled_) {
            ColumnData col = (ColumnData)this.labelSelector_.getSelectedItem();
            if (col != null) {
                return new ColumnDataTable(this.tcModel_, new ColumnData[]{col});
            }
            return null;
        }
        return null;
    }

    public AxisEditor[] createAxisEditors() {
        return this.baseSelector_.createAxisEditors();
    }

    public PointStore createPointStore(int npoint) {
        PointStore baseStore = this.baseSelector_.createPointStore(npoint);
        return this.labelsEnabled_ ? new LabelledPointStore(baseStore) : baseStore;
    }

    public void setTable(TopcatModel tcModel) {
        this.baseSelector_.setTable(tcModel);
        if (tcModel == null) {
            this.labelSelector_.setSelectedItem(null);
            this.labelSelector_.setEnabled(false);
        } else {
            this.labelSelector_.setModel(new ColumnDataComboBoxModel(tcModel, Object.class, true));
            this.labelSelector_.setEnabled(true);
        }
        this.tcModel_ = tcModel;
    }

    public void addActionListener(ActionListener listener) {
        this.baseSelector_.addActionListener(listener);
        this.labelSelector_.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.baseSelector_.removeActionListener(listener);
        this.baseSelector_.removeActionListener(listener);
    }

    public void initialiseSelectors() {
        this.baseSelector_.initialiseSelectors();
    }

    private static class LabelledPointStore
    implements PointStore,
    Wrapper {
        private final PointStore base_;
        private final String[] labels_;
        private int nStore_;

        LabelledPointStore(PointStore base) {
            this.base_ = base;
            this.labels_ = new String[base.getCount()];
        }

        public Object getBase() {
            return this.base_;
        }

        public int getCount() {
            return this.base_.getCount();
        }

        public int getNdim() {
            return this.base_.getNdim();
        }

        public double[] getPoint(int ipoint) {
            return this.base_.getPoint(ipoint);
        }

        public int getNerror() {
            return this.base_.getNerror();
        }

        public double[][] getErrors(int ipoint) {
            return this.base_.getErrors(ipoint);
        }

        public boolean hasLabels() {
            return true;
        }

        public void storePoint(Object[] coordRow, Object[] errorRow, String label) {
            this.base_.storePoint(coordRow, errorRow, label);
            this.labels_[this.nStore_++] = label;
        }

        public String getLabel(int ipoint) {
            return this.labels_[ipoint];
        }
    }
}

