/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.plot.ColorComboBox;
import uk.ac.starlink.topcat.plot.ComboBoxBumper;
import uk.ac.starlink.topcat.plot.DashComboBox;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.MarkStyleEditor;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.ThicknessComboBox;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.util.gui.ValueButtonGroup;

public class LinesStyleEditor
extends StyleEditor {
    private final ErrorModeSelectionModel[] errorModeModels_;
    private final ColorComboBox colorSelector_;
    private final ThicknessComboBox thickSelector_;
    private final DashComboBox dashSelector_;
    private final JComboBox shapeSelector_;
    private final JComboBox sizeSelector_;
    private final JComboBox errorSelector_;
    private final ValueButtonGroup lineMarkSelector_;
    private static final int MAX_THICK = 6;

    public LinesStyleEditor(ErrorRenderer[] errorRenderers, ErrorRenderer defaultRenderer, ErrorModeSelectionModel[] errorModeModels) {
        this.errorModeModels_ = errorModeModels;
        JRadioButton lineButton = new JRadioButton("Line", true);
        JRadioButton markButton = new JRadioButton("Markers");
        JRadioButton bothButton = new JRadioButton("Both");
        this.lineMarkSelector_ = new ValueButtonGroup();
        this.lineMarkSelector_.add((AbstractButton)lineButton, (Object)LinesStyleEditor.booleanList(true, false));
        this.lineMarkSelector_.add((AbstractButton)markButton, (Object)LinesStyleEditor.booleanList(false, true));
        this.lineMarkSelector_.add((AbstractButton)bothButton, (Object)LinesStyleEditor.booleanList(true, true));
        this.lineMarkSelector_.addChangeListener((ChangeListener)this);
        this.colorSelector_ = new ColorComboBox();
        this.colorSelector_.addActionListener(this);
        this.thickSelector_ = new ThicknessComboBox(6);
        this.thickSelector_.addActionListener(this);
        this.dashSelector_ = new DashComboBox();
        this.dashSelector_.addActionListener(this);
        this.shapeSelector_ = MarkStyleEditor.createShapeSelector();
        this.shapeSelector_.addActionListener(this);
        this.sizeSelector_ = MarkStyleEditor.createSizeSelector();
        this.sizeSelector_.addActionListener(this);
        this.errorSelector_ = MarkStyleEditor.createErrorSelector(errorRenderers, defaultRenderer, errorModeModels);
        this.errorSelector_.addActionListener(this);
        for (int idim = 0; idim < errorModeModels.length; ++idim) {
            errorModeModels[idim].addActionListener(this);
        }
        Box colorBox = Box.createHorizontalBox();
        colorBox.add(new JLabel("Colour: "));
        colorBox.add((Component)new ShrinkWrapper((Component)((Object)this.colorSelector_)));
        colorBox.add(Box.createHorizontalStrut(5));
        colorBox.add(new ComboBoxBumper((JComboBox)((Object)this.colorSelector_)));
        colorBox.add(Box.createHorizontalStrut(5));
        colorBox.add(Box.createHorizontalGlue());
        Box lineMarkBox = Box.createHorizontalBox();
        lineMarkBox.add(lineButton);
        lineMarkBox.add(Box.createHorizontalStrut(5));
        lineMarkBox.add(markButton);
        lineMarkBox.add(Box.createHorizontalStrut(5));
        lineMarkBox.add(bothButton);
        lineMarkBox.add(Box.createHorizontalGlue());
        Box lineBox = Box.createHorizontalBox();
        lineBox.add(new JLabel("Thickness: "));
        lineBox.add((Component)new ShrinkWrapper((Component)((Object)this.thickSelector_)));
        lineBox.add(Box.createHorizontalStrut(5));
        lineBox.add(new ComboBoxBumper((JComboBox)((Object)this.thickSelector_)));
        lineBox.add(Box.createHorizontalStrut(10));
        lineBox.add(new JLabel("Dash: "));
        lineBox.add((Component)new ShrinkWrapper((Component)((Object)this.dashSelector_)));
        lineBox.add(Box.createHorizontalStrut(5));
        lineBox.add(new ComboBoxBumper((JComboBox)((Object)this.dashSelector_)));
        lineBox.add(Box.createHorizontalStrut(5));
        lineBox.add(Box.createHorizontalGlue());
        Box markBox = Box.createHorizontalBox();
        markBox.add(new JLabel("Size: "));
        markBox.add((Component)new ShrinkWrapper((Component)this.sizeSelector_));
        markBox.add(Box.createHorizontalStrut(5));
        markBox.add(new ComboBoxBumper(this.sizeSelector_));
        markBox.add(Box.createHorizontalStrut(10));
        markBox.add(new JLabel("Shape: "));
        markBox.add((Component)new ShrinkWrapper((Component)this.shapeSelector_));
        markBox.add(Box.createHorizontalStrut(5));
        markBox.add(new ComboBoxBumper(this.shapeSelector_));
        markBox.add(Box.createHorizontalStrut(5));
        markBox.add(Box.createHorizontalGlue());
        Box errorBox = Box.createHorizontalBox();
        errorBox.add(new JLabel("Error Bars: "));
        errorBox.add((Component)new ShrinkWrapper((Component)this.errorSelector_));
        errorBox.add(Box.createHorizontalStrut(5));
        errorBox.add(new ComboBoxBumper(this.errorSelector_));
        errorBox.add(Box.createHorizontalStrut(5));
        errorBox.add(Box.createHorizontalGlue());
        Box displayBox = Box.createVerticalBox();
        Box d1Box = Box.createHorizontalBox();
        d1Box.add(colorBox);
        d1Box.add(Box.createHorizontalStrut(10));
        d1Box.add(errorBox);
        displayBox.add(d1Box);
        displayBox.add(Box.createVerticalStrut(5));
        displayBox.add(lineMarkBox);
        displayBox.setBorder(AuxWindow.makeTitledBorder("Display"));
        this.add(displayBox);
        lineBox.setBorder(AuxWindow.makeTitledBorder("Line"));
        this.add(lineBox);
        markBox.setBorder(AuxWindow.makeTitledBorder("Markers"));
        this.add(markBox);
    }

    public void setStyle(Style style) {
        MarkStyle mstyle = (MarkStyle)style;
        this.shapeSelector_.setSelectedItem(mstyle.getShapeId());
        this.sizeSelector_.setSelectedIndex(mstyle.getSize());
        this.colorSelector_.setSelectedItem(mstyle.getColor());
        this.lineMarkSelector_.setValue((Object)LinesStyleEditor.booleanList(mstyle.getLine() == MarkStyle.DOT_TO_DOT, !mstyle.getHidePoints()));
        this.thickSelector_.setSelectedThickness(mstyle.getLineWidth());
        this.dashSelector_.setSelectedDash(mstyle.getDash());
        this.errorSelector_.setSelectedItem(mstyle.getErrorRenderer());
    }

    public Style getStyle() {
        List lineMark = (List)this.lineMarkSelector_.getValue();
        return LinesStyleEditor.getStyle((MarkShape)this.shapeSelector_.getSelectedItem(), this.sizeSelector_.getSelectedIndex(), this.colorSelector_.getSelectedColor(), (Boolean)lineMark.get(0), (Boolean)lineMark.get(1), (ErrorRenderer)this.errorSelector_.getSelectedItem(), this.thickSelector_.getSelectedThickness(), this.dashSelector_.getSelectedDash());
    }

    public String getHelpID() {
        return "LinesStyleEditor";
    }

    protected void refreshState() {
        super.refreshState();
        List lineMark = (List)this.lineMarkSelector_.getValue();
        boolean hasLine = (Boolean)lineMark.get(0);
        boolean hasMark = (Boolean)lineMark.get(1);
        boolean hasError = this.errorModeModels_[0].getErrorMode() != ErrorMode.NONE || this.errorModeModels_[1].getErrorMode() != ErrorMode.NONE;
        this.thickSelector_.setEnabled(hasLine);
        this.dashSelector_.setEnabled(hasLine);
        this.sizeSelector_.setEnabled(hasMark);
        this.shapeSelector_.setEnabled(hasMark);
        this.errorSelector_.setEnabled(hasError);
    }

    private static MarkStyle getStyle(MarkShape shape, int size, Color color, boolean hasLine, boolean hasMark, ErrorRenderer errorRenderer, int thick, float[] dash) {
        MarkStyle style = size == 0 ? MarkShape.POINT.getStyle(color, 0) : shape.getStyle(color, size);
        style.setLine((MarkStyle.Line)(hasLine ? MarkStyle.DOT_TO_DOT : null));
        style.setHidePoints(!hasMark);
        style.setErrorRenderer(errorRenderer);
        style.setLineWidth(thick);
        style.setDash(dash);
        return style;
    }

    private static List booleanList(boolean flag1, boolean flag2) {
        return Arrays.asList(flag1, flag2);
    }
}

