/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ColumnDataComboBoxModel;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.plot.AnnotationPanel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.AxisZoomRegion;
import uk.ac.starlink.topcat.plot.CartesianAxesSelector;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.GraphicsWindow;
import uk.ac.starlink.topcat.plot.LinesStyleEditor;
import uk.ac.starlink.topcat.plot.MutableStyleSet;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.PointSelectorSet;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.PoolStyleSet;
import uk.ac.starlink.topcat.plot.PositionReporter;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.ZoomRegion;
import uk.ac.starlink.topcat.plot.Zoomer;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.LinesPlot;
import uk.ac.starlink.ttools.plot.LinesPlotState;
import uk.ac.starlink.ttools.plot.MarkStyles;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotListener;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.Styles;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.WrapUtils;

public class LinesWindow
extends GraphicsWindow
implements TopcatListener {
    private final JComponent plotPanel_;
    private final ToggleButtonModel antialiasModel_;
    private final ToggleButtonModel vlineModel_;
    private final ToggleButtonModel zeroLineModel_;
    private final Map yViewRangeMap_ = new HashMap();
    private Range[] yDataRanges_;
    private StyleSet styles_;
    private Annotator annotator_ = new Annotator();
    private static final Color[] COLORS;
    private static final ErrorRenderer DEFAULT_ERROR_RENDERER;
    private static final StyleSet[] STYLE_SETS;
    private static final StyleSet LINES;
    private static final StyleSet POINTS;
    private static final ErrorRenderer[] ERROR_RENDERERS;
    private static final String[] AXIS_NAMES;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$ttools$convert$ValueConverter;
    static /* synthetic */ Class class$java$lang$Number;

    public LinesWindow(Component parent) {
        super("Line Plot", (TablePlot)new LinesPlot(), AXIS_NAMES, 0, true, LinesWindow.createErrorModeModels(AXIS_NAMES), parent);
        final LinesPlot plot = (LinesPlot)this.getPlot();
        plot.setPreferredSize(new Dimension(400, 400));
        plot.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        this.plotPanel_ = new JPanel();
        this.plotPanel_.setOpaque(false);
        this.plotPanel_.setLayout(new OverlayLayout(this.plotPanel_));
        this.plotPanel_.add(this.annotator_);
        this.plotPanel_.add((Component)plot);
        final Zoomer zoomer = new Zoomer();
        zoomer.setCursorComponent((Component)plot);
        plot.addPlotListener(new PlotListener(){

            public void plotChanged(PlotEvent evt) {
                zoomer.setRegions(Arrays.asList(LinesWindow.this.createZoomRegions(plot)));
            }
        });
        plot.addMouseListener((MouseListener)zoomer);
        plot.addMouseMotionListener((MouseMotionListener)zoomer);
        this.getPointSelectors().addActionListener(new AxisWindowUpdater());
        final ToggleButtonModel gridModel = this.getGridModel();
        gridModel.setSelected(false);
        gridModel.setText("Full Grid");
        gridModel.setDescription("Draw all X and Y grid lines");
        this.zeroLineModel_ = new ToggleButtonModel("y=0 Grid Lines", ResourceIcon.Y0_LINE, "Draw grid line only at y=0");
        this.zeroLineModel_.addActionListener(this.getReplotListener());
        ActionListener gridListener = new ActionListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void actionPerformed(ActionEvent evt) {
                if (LinesWindow.this.zeroLineModel_.isSelected() && gridModel.isSelected()) {
                    if (evt.getSource() == LinesWindow.this.zeroLineModel_) {
                        gridModel.setSelected(false);
                    } else {
                        if (!$assertionsDisabled && evt.getSource() != gridModel) {
                            throw new AssertionError();
                        }
                        LinesWindow.this.zeroLineModel_.setSelected(false);
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$LinesWindow == null ? (class$uk$ac$starlink$topcat$plot$LinesWindow = LinesWindow.class$("uk.ac.starlink.topcat.plot.LinesWindow")) : class$uk$ac$starlink$topcat$plot$LinesWindow).desiredAssertionStatus();
            }
        };
        gridModel.addActionListener(gridListener);
        this.zeroLineModel_.addActionListener(gridListener);
        LinesPositionLabel posLabel = new LinesPositionLabel(plot);
        posLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, posLabel.getMaximumSize().height));
        this.getStatusBox().add(posLabel);
        this.getStatusBox().add(Box.createHorizontalGlue());
        plot.addMouseListener((MouseListener)new PointClickListener());
        this.getPointSelectors().addTopcatListener(this);
        RescaleAction rescaleActionXY = new RescaleAction("Rescale", ResourceIcon.RESIZE, "Rescale all plots to fit all data", true, true);
        RescaleAction rescaleActionX = new RescaleAction("Rescale", ResourceIcon.RESIZE_X, "Rescale the X axis to fit all data", true, false);
        RescaleAction rescaleActionY = new RescaleAction("Rescale", ResourceIcon.RESIZE_Y, "Rescale Y axis on all plots to fit all data", false, true);
        this.antialiasModel_ = new ToggleButtonModel("Antialias", ResourceIcon.ANTIALIAS, "Select whether lines are drawn with antialiasing");
        this.antialiasModel_.setSelected(true);
        this.antialiasModel_.addActionListener(this.getReplotListener());
        BasicAction fromXRangeAction = new BasicAction("New subset from X range", ResourceIcon.XRANGE_SUBSET, "Define a new subset for each plotted table containing only points in the visible X range"){

            public void actionPerformed(ActionEvent evt) {
                LinesWindow.this.addNewSubsets(plot.getPointsInRange());
            }
        };
        this.vlineModel_ = new ToggleButtonModel("Show vertical crosshair", ResourceIcon.Y_CURSOR, "Display a vertical line which follows the mouse");
        new CrosshairListener(plot, this.vlineModel_);
        JMenu plotMenu = new JMenu("Plot");
        plotMenu.setMnemonic(80);
        plotMenu.add(rescaleActionXY);
        plotMenu.add(rescaleActionX);
        plotMenu.add(rescaleActionY);
        plotMenu.add(this.getAxisEditAction());
        plotMenu.add(this.getGridModel().createMenuItem());
        plotMenu.add(this.getLegendModel().createMenuItem());
        plotMenu.add(this.zeroLineModel_.createMenuItem());
        plotMenu.add(this.getReplotAction());
        plotMenu.add(this.vlineModel_.createMenuItem());
        this.getJMenuBar().add(plotMenu);
        JMenu renderMenu = new JMenu("Rendering");
        renderMenu.setMnemonic(82);
        renderMenu.add(this.antialiasModel_.createMenuItem());
        this.getJMenuBar().add(renderMenu);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        subsetMenu.add(fromXRangeAction);
        this.getJMenuBar().add(subsetMenu);
        this.getJMenuBar().add(this.createErrorModeMenu());
        JMenu styleMenu = new JMenu("Line Style");
        styleMenu.setMnemonic(76);
        for (int i = 0; i < STYLE_SETS.length; ++i) {
            final StyleSet styleSet = STYLE_SETS[i];
            String name = styleSet.getName();
            Icon icon = MarkStyles.getIcon((StyleSet)styleSet);
            BasicAction stylesAct = new BasicAction(name, icon, "Set line plotting style to " + name){

                public void actionPerformed(ActionEvent evt) {
                    LinesWindow.this.setStyles(styleSet);
                    LinesWindow.this.replot();
                }
            };
            styleMenu.add(stylesAct);
        }
        this.getJMenuBar().add(styleMenu);
        this.getJMenuBar().add(this.createErrorRendererMenu(ERROR_RENDERERS));
        this.getPointSelectorToolBar().addSeparator();
        this.getPointSelectorToolBar().add(this.getErrorModeModels()[0].createOnOffToolbarButton());
        this.getPointSelectorToolBar().add(this.getErrorModeModels()[1].createOnOffToolbarButton());
        this.getToolBar().add(rescaleActionXY);
        this.getToolBar().add(rescaleActionX);
        this.getToolBar().add(rescaleActionY);
        this.getToolBar().add(this.getGridModel().createToolbarButton());
        this.getToolBar().add(this.getLegendModel().createToolbarButton());
        this.getToolBar().add(this.zeroLineModel_.createToolbarButton());
        this.getToolBar().add(this.vlineModel_.createToolbarButton());
        this.getToolBar().add(this.antialiasModel_.createToolbarButton());
        this.getToolBar().add(fromXRangeAction);
        this.getToolBar().addSeparator();
        this.addHelp("LinesWindow");
        this.replot();
    }

    protected JComponent getPlotPanel() {
        return this.plotPanel_;
    }

    protected void doReplot(PlotState state) {
        this.annotator_.setState(state);
        super.doReplot(state);
    }

    protected PlotState createPlotState() {
        return new LinesPlotState(this.getPointSelectors().getSelectorCount());
    }

    public PlotState getPlotState() {
        LinesPlotState state = (LinesPlotState)super.getPlotState();
        if (!state.getValid()) {
            return state;
        }
        PointSelectorSet pointSelectors = this.getPointSelectors();
        int nsel = pointSelectors.getSelectorCount();
        AxisEditor[] axEds = this.getAxisWindow().getEditors();
        ValueInfo[] yAxes = new ValueInfo[nsel];
        ValueConverter[] yConverters = new ValueConverter[nsel];
        String[] yAxisLabels = new String[nsel];
        double[][] yBounds = new double[nsel][];
        boolean[] yLogFlags = new boolean[nsel];
        boolean[] yFlipFlags = new boolean[nsel];
        ArrayList<PointSelector> pselList = new ArrayList<PointSelector>(nsel);
        for (int isel = 0; isel < nsel; ++isel) {
            Range yRange;
            PointSelector psel = pointSelectors.getSelector(isel);
            pselList.add(psel);
            LinesAxesSelector axsel = LinesWindow.findLinesAxesSelector(psel.getAxesSelector());
            if (psel.isReady()) {
                AxisEditor yAxEd = axEds[1 + isel];
                ColumnInfo cinfo = psel.getAxesSelector().getData().getColumnInfo(1);
                yAxes[isel] = cinfo;
                yConverters[isel] = (ValueConverter)cinfo.getAuxDatumValue(TopcatUtils.NUMERIC_CONVERTER_INFO, class$uk$ac$starlink$ttools$convert$ValueConverter == null ? LinesWindow.class$("uk.ac.starlink.ttools.convert.ValueConverter") : class$uk$ac$starlink$ttools$convert$ValueConverter);
                yAxisLabels[isel] = yAxEd.getLabel();
                yLogFlags[isel] = axsel.getYLogModel().isSelected();
                yFlipFlags[isel] = axsel.getYFlipModel().isSelected();
                yRange = new Range(this.yDataRanges_[isel]);
                if (this.yViewRangeMap_.containsKey(psel)) {
                    yRange.limit((Range)this.yViewRangeMap_.get(psel));
                }
            } else {
                yRange = new Range();
            }
            yBounds[isel] = yRange.getFiniteBounds(yLogFlags[isel]);
        }
        state.setYAxes(yAxes);
        state.setYConverters(yConverters);
        state.setYAxisLabels(yAxisLabels);
        state.setYRanges((double[][])yBounds);
        state.setYLogFlags(yLogFlags);
        state.setYFlipFlags(yFlipFlags);
        SetId[] setIds = ((PointSelection)state.getPlotData()).getSetIds();
        int nset = setIds.length;
        int[] graphIndices = new int[nset];
        for (int iset = 0; iset < nset; ++iset) {
            graphIndices[iset] = pselList.indexOf(setIds[iset].getPointSelector());
        }
        state.setGraphIndices(graphIndices);
        state.setAntialias(this.antialiasModel_.isSelected());
        state.setYZeroFlag(this.zeroLineModel_.isSelected());
        return state;
    }

    protected PointSelector createPointSelector() {
        ToggleButtonModel logModel = new ToggleButtonModel(this.getLogModels()[1].getText(), this.getLogModels()[1].getIcon(), this.getLogModels()[1].getDescription());
        ToggleButtonModel flipModel = new ToggleButtonModel(this.getFlipModels()[1].getText(), this.getFlipModels()[1].getIcon(), this.getFlipModels()[1].getDescription());
        logModel.addActionListener(this.getReplotListener());
        flipModel.addActionListener(this.getReplotListener());
        AxesSelector axsel = new LinesAxesSelector(logModel, flipModel, this.getErrorModeModels());
        axsel = this.addExtraAxes(axsel);
        PointSelector newSelector = new PointSelector(axsel, this.getStyles());
        PointSelectorSet pointSelectors = this.getPointSelectors();
        PointSelector mainSel = pointSelectors.getMainSelector();
        TopcatModel mainTable = null;
        Object mainXAxis = null;
        if (mainSel != null && mainSel.isReady()) {
            mainTable = mainSel.getTable();
            mainXAxis = LinesWindow.findLinesAxesSelector(mainSel.getAxesSelector()).getColumnSelector(0).getSelectedItem();
            for (int i = 0; mainTable != null && mainXAxis != null && i < pointSelectors.getSelectorCount(); ++i) {
                PointSelector psel = pointSelectors.getSelector(i);
                if (!psel.isReady()) continue;
                TopcatModel table = psel.getTable();
                Object xAxis = LinesWindow.findLinesAxesSelector(psel.getAxesSelector()).getColumnSelector(0).getSelectedItem();
                if ((table == null || table.equals(mainTable)) && (xAxis == null || xAxis.equals(mainXAxis))) continue;
                mainTable = null;
                mainXAxis = null;
                break;
            }
        }
        if (mainTable != null) {
            newSelector.setTable(mainTable, false);
            if (mainXAxis != null) {
                LinesWindow.findLinesAxesSelector(axsel).getColumnSelector(0).setSelectedItem(mainXAxis);
            }
        }
        return newSelector;
    }

    protected StyleEditor createStyleEditor() {
        return new LinesStyleEditor(ERROR_RENDERERS, DEFAULT_ERROR_RENDERER, this.getErrorModeModels());
    }

    public void setStyles(StyleSet styles) {
        this.styles_ = styles;
        super.setStyles(styles);
    }

    public MutableStyleSet getStyles() {
        if (this.styles_ == null) {
            this.styles_ = this.getDefaultStyles(0);
        }
        return new PoolStyleSet(this.styles_, new BitSet());
    }

    public StyleSet getDefaultStyles(int npoint) {
        return npoint < 20000 ? LINES : POINTS;
    }

    public Range[] calculateRanges(PlotData data, PlotState state) {
        Range xRange = this.getViewRanges()[0];
        double[] xLimits = xRange.isClear() ? null : xRange.getFiniteBounds(false);
        DataBounds xyBounds = ((LinesPlot)this.getPlot()).calculateBounds(data, state, xLimits);
        Range[] xyRanges = xyBounds.getRanges();
        this.yDataRanges_ = new Range[xyRanges.length - 1];
        System.arraycopy(xyRanges, 1, this.yDataRanges_, 0, xyRanges.length - 1);
        return new Range[]{xyRanges[0]};
    }

    protected boolean isLegendInteresting(PlotState state) {
        boolean hasMultiples = false;
        SetId[] setIds = ((PointSelection)state.getPlotData()).getSetIds();
        HashSet<PointSelector> pselSet = new HashSet<PointSelector>();
        for (int i = 0; !hasMultiples && i < setIds.length; ++i) {
            PointSelector psel = setIds[i].getPointSelector();
            if (pselSet.contains(psel)) {
                hasMultiples = true;
                continue;
            }
            pselSet.add(psel);
        }
        return hasMultiples;
    }

    private static LinesAxesSelector findLinesAxesSelector(AxesSelector axsel) {
        return (LinesAxesSelector)WrapUtils.getWrapped((Object)axsel, (Class)LinesAxesSelector.class);
    }

    public void modelChanged(TopcatEvent evt) {
        Object datum;
        if (evt.getCode() == 5 && (datum = evt.getDatum()) instanceof Long) {
            TopcatModel tcModel = evt.getModel();
            PointSelection psel = (PointSelection)this.getPlot().getState().getPlotData();
            long lrow = (Long)datum;
            long[] lps = psel.getPointsForRow(tcModel, lrow);
            int[] ips = new int[lps.length];
            for (int i = 0; i < lps.length; ++i) {
                ips[i] = Tables.checkedLongToInt((long)lps[i]);
            }
            this.annotator_.setActivePoints(ips);
            this.replot();
        }
    }

    private ZoomRegion[] createZoomRegions(LinesPlot plot) {
        LinesPlotState state = (LinesPlotState)plot.getState();
        int ngraph = state.getGraphCount();
        PlotSurface[] surfaces = plot.getSurfaces();
        ZoomRegion[] regions = new ZoomRegion[ngraph + 1];
        for (int igraph = 0; igraph < ngraph; ++igraph) {
            final int ig = igraph;
            final PlotSurface surface = surfaces[igraph];
            final boolean flip = state.getYFlipFlags()[igraph];
            Rectangle displayBox = surface.getClip().getBounds();
            final int xPos = displayBox.x;
            final int yPos = displayBox.y;
            final int yInc = displayBox.height;
            Rectangle yAxisBox = new Rectangle(0, displayBox.y, displayBox.x, yInc);
            AxisZoomRegion yZoom = new AxisZoomRegion(false, yAxisBox, displayBox){

                public void zoomed(double[][] bounds) {
                    double v0 = bounds[0][0];
                    double v1 = bounds[0][1];
                    int y0 = (int)Math.round((double)yPos + v0 * (double)yInc);
                    int y1 = (int)Math.round((double)yPos + v1 * (double)yInc);
                    LinesWindow.this.requestZoomY(ig, surface.graphicsToData(xPos, flip ? y0 : y1, false)[1], surface.graphicsToData(xPos, flip ? y1 : y0, false)[1]);
                }
            };
            regions[igraph] = yZoom;
        }
        final PlotSurface surface0 = surfaces[ngraph - 1];
        Rectangle displayBox = plot.getPlotBounds();
        final int xPos = displayBox.x;
        final int xInc = displayBox.width;
        Rectangle xAxisBox = new Rectangle(xPos, displayBox.y + displayBox.height, xInc, plot.getHeight());
        AxisZoomRegion xZoom = new AxisZoomRegion(true, xAxisBox, displayBox){

            public void zoomed(double[][] bounds) {
                double v0 = bounds[0][0];
                double v1 = bounds[0][1];
                int x0 = (int)Math.round((double)xPos + v0 * (double)xInc);
                int x1 = (int)Math.round((double)xPos + v1 * (double)xInc);
                LinesWindow.this.requestZoomX(surface0.graphicsToData(x0, 0, false)[0], surface0.graphicsToData(x1, 0, false)[0]);
            }
        };
        regions[ngraph] = xZoom;
        return regions;
    }

    private void requestZoomX(double x0, double x1) {
        this.getAxisWindow().getEditors()[0].clearBounds();
        this.getViewRanges()[0].setBounds(x0, x1);
        this.replot();
    }

    private void requestZoomY(int igraph, double y0, double y1) {
        this.getAxisWindow().getEditors()[1 + igraph].clearBounds();
        PointSelector psel = this.getPointSelectors().getSelector(igraph);
        if (this.yViewRangeMap_.containsKey(psel)) {
            ((Range)this.yViewRangeMap_.get(psel)).setBounds(y0, y1);
        }
        this.replot();
    }

    static {
        $assertionsDisabled = !LinesWindow.class.desiredAssertionStatus();
        COLORS = new Color[Styles.COLORS.length + 1];
        LinesWindow.COLORS[0] = Color.BLACK;
        System.arraycopy(Styles.COLORS, 0, COLORS, 1, Styles.COLORS.length);
        DEFAULT_ERROR_RENDERER = ErrorRenderer.EXAMPLE;
        STYLE_SETS = LinesWindow.fixDefaultErrorRenderers(DEFAULT_ERROR_RENDERER, new StyleSet[]{MarkStyles.lines((String)"Black/Coloured Lines", (Color[])COLORS), MarkStyles.lines((String)"Lines"), MarkStyles.dashedLines((String)"Dashed Lines"), MarkStyles.points((String)"Black/Coloured Points", (Color[])COLORS), MarkStyles.points((String)"Points"), MarkStyles.spots((String)"Dots", (int)1), MarkStyles.spots((String)"Spots", (int)2), MarkStyles.openShapes((String)"Small Coloured Outlines", (int)3, null), MarkStyles.openShapes((String)"Medium Coloured Outlines", (int)4, null), MarkStyles.openShapes((String)"Small Black Outlines", (int)3, (Color)Color.black), MarkStyles.openShapes((String)"Medium Black Outlines", (int)4, (Color)Color.black)});
        LINES = STYLE_SETS[0];
        POINTS = STYLE_SETS[3];
        if (!$assertionsDisabled && !LINES.getName().equals("Black/Coloured Lines")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !POINTS.getName().equals("Black/Coloured Points")) {
            throw new AssertionError();
        }
        ERROR_RENDERERS = ErrorRenderer.getOptions2d();
        AXIS_NAMES = new String[]{"X", "Y"};
    }

    private static class LinesPositionLabel
    extends JLabel
    implements MouseMotionListener {
        private final LinesPlot plot_;
        private int isurf_;
        private PlotSurface surface_;
        private PositionReporter reporter_;

        LinesPositionLabel(LinesPlot plot) {
            this.plot_ = plot;
            Font font = this.getFont();
            this.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            plot.addMouseMotionListener((MouseMotionListener)this);
            this.reportPosition(null);
        }

        public void mouseMoved(MouseEvent evt) {
            this.reportPosition(evt.getPoint());
        }

        public void mouseDragged(MouseEvent evt) {
            this.reportPosition(evt.getPoint());
        }

        private void reportPosition(Point p) {
            String[] fc;
            PositionReporter reporter = this.getReporter(p);
            StringBuffer sbuf = new StringBuffer("Position: ");
            if (reporter != null && (fc = reporter.formatPosition(p.x, p.y)) != null) {
                sbuf.append('(').append(fc[0]).append(", ").append(fc[1]).append(')');
            }
            this.setText(sbuf.toString());
        }

        private PositionReporter getReporter(Point p) {
            LinesPlotState state = (LinesPlotState)this.plot_.getState();
            PlotSurface[] surfaces = this.plot_.getSurfaces();
            if (p == null || state == null || !state.getValid()) {
                return null;
            }
            if (this.isurf_ < surfaces.length && this.surface_ == surfaces[this.isurf_] && this.surface_.getClip().contains(p)) {
                return this.reporter_;
            }
            for (int is = 0; is < surfaces.length; ++is) {
                PlotSurface surf = surfaces[is];
                if (!surf.getClip().contains(p)) continue;
                ValueConverter xConv = state.getConverters()[0];
                ValueConverter yConv = state.getYConverters()[is];
                this.isurf_ = is;
                this.surface_ = surf;
                this.reporter_ = new PositionReporter(this, surf, xConv, yConv){
                    private final /* synthetic */ LinesPositionLabel this$0;
                    {
                        this.this$0 = this$0;
                        super(x0, x1, x2);
                    }

                    protected void reportPosition(String[] coords) {
                    }
                };
                return this.reporter_;
            }
            return null;
        }
    }

    private static class LinesAxesSelector
    extends CartesianAxesSelector {
        private final ToggleButtonModel yLogModel_;
        private final ToggleButtonModel yFlipModel_;

        LinesAxesSelector(ToggleButtonModel yLogModel, ToggleButtonModel yFlipModel, ErrorModeSelectionModel[] errorModeModels) {
            super(AXIS_NAMES, new ToggleButtonModel[]{null, yLogModel}, new ToggleButtonModel[]{null, yFlipModel}, errorModeModels);
            this.yLogModel_ = yLogModel;
            this.yFlipModel_ = yFlipModel;
        }

        public ToggleButtonModel getYLogModel() {
            return this.yLogModel_;
        }

        public ToggleButtonModel getYFlipModel() {
            return this.yFlipModel_;
        }

        public void setTable(TopcatModel tcModel) {
            super.setTable(tcModel);
            if (tcModel != null) {
                this.getColumnSelector(0).setModel(new ColumnDataComboBoxModel(tcModel, class$java$lang$Number == null ? (class$java$lang$Number = LinesWindow.class$("java.lang.Number")) : class$java$lang$Number, true, true));
            }
        }

        public void initialiseSelectors() {
            ComboBoxModel xModel = this.getColumnSelector(0).getModel();
            ColumnData timeCol = xModel instanceof ColumnDataComboBoxModel ? ((ColumnDataComboBoxModel)xModel).getColumnData(TopcatUtils.TIME_INFO) : null;
            xModel.setSelectedItem(timeCol == null ? xModel.getElementAt(1) : timeCol);
            ComboBoxModel yModel = this.getColumnSelector(1).getModel();
            for (int i = 0; i < yModel.getSize(); ++i) {
                Object item = yModel.getElementAt(i);
                if (item == null || item.equals(xModel.getSelectedItem())) continue;
                yModel.setSelectedItem(item);
                break;
            }
        }
    }

    public class RescaleAction
    extends BasicAction {
        final boolean scaleX_;
        final boolean scaleY_;

        RescaleAction(String name, Icon icon, String shortdesc, boolean scaleX, boolean scaleY) {
            super(name, icon, shortdesc);
            this.scaleX_ = scaleX;
            this.scaleY_ = scaleY;
        }

        public void actionPerformed(ActionEvent evt) {
            PlotState state = LinesWindow.this.getPlotState();
            PointSelection psel = (PointSelection)state.getPlotData();
            Points points = LinesWindow.this.getPoints();
            if (state.getValid() && points != null) {
                double[] xLimits = this.scaleY_ && !this.scaleX_ ? state.getRanges()[0] : null;
                Range[] ranges = ((LinesPlot)LinesWindow.this.getPlot()).calculateBounds(psel.createPlotData(points), state, xLimits).getRanges();
                LinesWindow.this.getAxisWindow().clearRanges();
                if (this.scaleX_) {
                    LinesWindow.this.getDataRanges()[0] = ranges[0];
                    LinesWindow.this.getViewRanges()[0].clear();
                }
                if (this.scaleY_) {
                    System.arraycopy(ranges, 1, LinesWindow.this.yDataRanges_, 0, ranges.length - 1);
                    Iterator it = LinesWindow.this.yViewRangeMap_.entrySet().iterator();
                    while (it.hasNext()) {
                        ((Range)it.next().getValue()).clear();
                    }
                }
                LinesWindow.this.replot();
            }
        }
    }

    private static class CrosshairListener
    extends MouseInputAdapter
    implements ChangeListener {
        final LinesPlot linesPlot_;
        final ButtonModel switchModel_;
        final Rectangle vLine_;
        final Color lineColor_;
        Graphics g_;
        boolean visible_;
        boolean on_;

        CrosshairListener(LinesPlot linesPlot, ButtonModel switchModel) {
            this.linesPlot_ = linesPlot;
            this.switchModel_ = switchModel;
            this.vLine_ = new Rectangle();
            this.vLine_.width = 1;
            switchModel.addChangeListener(this);
            this.lineColor_ = new Color(~new Color(32768).getRGB());
        }

        public void mouseEntered(MouseEvent evt) {
            if (this.on_) {
                this.g_ = this.linesPlot_.getGraphics();
                this.g_.setXORMode(this.lineColor_);
            }
            this.redraw(evt.getPoint());
        }

        public void mouseExited(MouseEvent evt) {
            this.redraw(null);
        }

        public void mouseMoved(MouseEvent evt) {
            this.redraw(evt.getPoint());
        }

        public void stateChanged(ChangeEvent evt) {
            this.updateState();
        }

        public void updateState() {
            boolean on = this.switchModel_.isSelected();
            if (on != this.on_) {
                this.on_ = on;
                if (this.on_) {
                    this.g_ = this.linesPlot_.getGraphics();
                    this.g_.setXORMode(this.lineColor_);
                    this.linesPlot_.addMouseListener((MouseListener)this);
                    this.linesPlot_.addMouseMotionListener((MouseMotionListener)this);
                } else {
                    this.redraw(null);
                    this.g_.dispose();
                    this.linesPlot_.removeMouseListener((MouseListener)this);
                    this.linesPlot_.removeMouseListener((MouseListener)this);
                }
            }
        }

        private void redraw(Point p) {
            Rectangle zone;
            if (this.visible_) {
                this.g_.fillRect(this.vLine_.x, this.vLine_.y, this.vLine_.width, this.vLine_.height);
                this.visible_ = false;
            }
            if (p != null && this.on_ && (zone = this.linesPlot_.getPlotBounds()).contains(p)) {
                this.vLine_.x = p.x;
                this.vLine_.y = zone.y;
                this.vLine_.height = zone.height;
                this.g_.fillRect(this.vLine_.x, this.vLine_.y, this.vLine_.width, this.vLine_.height);
                this.visible_ = true;
            }
        }
    }

    private class Annotator
    extends AnnotationPanel {
        private LinesPlotState state_;

        private Annotator() {
        }

        public void setState(PlotState state) {
            this.state_ = (LinesPlotState)state;
        }

        protected void paintComponent(Graphics g) {
            int[] activePoints = this.getActivePoints();
            if (activePoints.length == 0 || this.state_ == null) {
                return;
            }
            PointPlacer[] placers = ((LinesPlot)LinesWindow.this.getPlot()).getPointPlacers();
            int ngraph = placers.length;
            BitSet activeMask = new BitSet();
            for (int i = 0; i < activePoints.length; ++i) {
                activeMask.set(activePoints[i]);
            }
            PlotData data = this.state_.getPlotData();
            int nset = data.getSetCount();
            int[] graphIndices = this.state_.getGraphIndices();
            IntList[] activeLists = new IntList[ngraph];
            for (int ig = 0; ig < ngraph; ++ig) {
                activeLists[ig] = new IntList();
            }
            PointSequence pseq = data.getPointSequence();
            int ip = 0;
            while (pseq.next()) {
                if (activeMask.get(ip)) {
                    for (int is = 0; is < nset; ++is) {
                        if (!pseq.isIncluded(is)) continue;
                        activeLists[graphIndices[is]].add(ip);
                    }
                }
                ++ip;
            }
            for (int ig = 0; ig < ngraph; ++ig) {
                int[] ips = activeLists[ig].toIntArray();
                if (ips.length <= 0) continue;
                AnnotationPanel ann = new AnnotationPanel();
                ann.setPlotData(data);
                ann.setPlacer(placers[ig]);
                ann.setActivePoints(ips);
                ann.paintComponent(g);
            }
        }
    }

    private class PointClickListener
    extends MouseAdapter {
        private PointClickListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            LinesPlot plot = (LinesPlot)LinesWindow.this.getPlot();
            if (evt.getButton() == 1) {
                PointIterator pit = plot.getPlottedPointIterator();
                int ip = pit.getClosestPoint(evt.getPoint(), 4);
                if (ip >= 0) {
                    PointSelection psel = (PointSelection)plot.getState().getPlotData();
                    psel.getPointTable(ip).highlightRow(psel.getPointRow(ip));
                } else {
                    LinesWindow.this.annotator_.setActivePoints(new int[0]);
                    LinesWindow.this.replot();
                }
            }
        }
    }

    private class AxisWindowUpdater
    implements ActionListener {
        int nsel_;
        AxisEditor xAxEd_;
        Map yAxEdMap_;
        static final /* synthetic */ boolean $assertionsDisabled;

        private AxisWindowUpdater() {
        }

        private void ensureInitialised() {
            if (this.xAxEd_ == null) {
                if (!$assertionsDisabled && this.yAxEdMap_ != null) {
                    throw new AssertionError();
                }
                PointSelector mainSel = LinesWindow.this.getPointSelectors().getMainSelector();
                AxisEditor[] mainEds = mainSel.getAxesSelector().createAxisEditors();
                this.xAxEd_ = mainEds[0];
                this.xAxEd_.addMaintainedRange(LinesWindow.this.getViewRanges()[0]);
                this.xAxEd_.addActionListener(LinesWindow.this.getReplotListener());
                AxisEditor yAxEd = mainEds[1];
                yAxEd.setTitle("Y Axis (Main)");
                yAxEd.addActionListener(LinesWindow.this.getReplotListener());
                Range yRange = new Range();
                yAxEd.addMaintainedRange(yRange);
                LinesWindow.this.yViewRangeMap_.put(mainSel, yRange);
                this.yAxEdMap_ = new HashMap();
                this.yAxEdMap_.put(mainSel, yAxEd);
            }
            if (!$assertionsDisabled && this.xAxEd_ == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.yAxEdMap_ == null) {
                throw new AssertionError();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            PointSelectorSet pointSelectors = LinesWindow.this.getPointSelectors();
            int nsel = pointSelectors.getSelectorCount();
            if (nsel != this.nsel_) {
                this.nsel_ = nsel;
                this.updateAxisWindow();
            }
        }

        private void updateAxisWindow() {
            this.ensureInitialised();
            PointSelectorSet pointSelectors = LinesWindow.this.getPointSelectors();
            int nsel = pointSelectors.getSelectorCount();
            AxisEditor[] axEds = new AxisEditor[1 + nsel];
            axEds[0] = this.xAxEd_;
            for (int isel = 0; isel < nsel; ++isel) {
                PointSelector psel = pointSelectors.getSelector(isel);
                if (!this.yAxEdMap_.containsKey(psel)) {
                    AxisEditor yAxEd = psel.getAxesSelector().createAxisEditors()[1];
                    yAxEd.setTitle("Y Axis (" + psel.getLabel() + ")");
                    yAxEd.addActionListener(LinesWindow.this.getReplotListener());
                    this.yAxEdMap_.put(psel, yAxEd);
                    Range yRange = new Range();
                    yAxEd.addMaintainedRange(yRange);
                    LinesWindow.this.yViewRangeMap_.put(psel, yRange);
                }
                axEds[1 + isel] = (AxisEditor)this.yAxEdMap_.get(psel);
            }
            LinesWindow.this.getAxisWindow().setEditors(axEds);
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$LinesWindow == null ? (class$uk$ac$starlink$topcat$plot$LinesWindow = LinesWindow.class$("uk.ac.starlink.topcat.plot.LinesWindow")) : class$uk$ac$starlink$topcat$plot$LinesWindow).desiredAssertionStatus();
        }
    }
}

