/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.plot.ColorComboBox;
import uk.ac.starlink.topcat.plot.ColoredIcon;
import uk.ac.starlink.topcat.plot.ComboBoxBumper;
import uk.ac.starlink.topcat.plot.DashComboBox;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.LogSlider;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.ThicknessComboBox;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.XYStats;
import uk.ac.starlink.util.gui.ShrinkWrapper;
import uk.ac.starlink.util.gui.ValueButtonGroup;

public class MarkStyleEditor
extends StyleEditor {
    private final JCheckBox markFlagger_;
    private final JComboBox shapeSelector_;
    private final JComboBox sizeSelector_;
    private final ColorComboBox colorSelector_;
    private final LogSlider opaqueSlider_;
    private final ThicknessComboBox thickSelector_;
    private final DashComboBox dashSelector_;
    private final ValueButtonGroup lineSelector_;
    private final JComboBox errorSelector_;
    private final ErrorModeSelectionModel[] errorModeModels_;
    private final JLabel corrLabel_;
    private final Map statMap_ = new HashMap();
    private final String helpId_;
    private static final int MAX_SIZE = 5;
    private static final int MAX_THICK = 10;
    private static final MarkShape[] SHAPES = new MarkShape[]{MarkShape.FILLED_CIRCLE, MarkShape.OPEN_CIRCLE, MarkShape.CROSS, MarkShape.CROXX, MarkShape.OPEN_SQUARE, MarkShape.OPEN_DIAMOND, MarkShape.OPEN_TRIANGLE_UP, MarkShape.OPEN_TRIANGLE_DOWN, MarkShape.FILLED_SQUARE, MarkShape.FILLED_DIAMOND, MarkShape.FILLED_TRIANGLE_UP, MarkShape.FILLED_TRIANGLE_DOWN};

    public MarkStyleEditor(boolean withLines, boolean withTransparency, ErrorRenderer[] errorRenderers, ErrorRenderer defaultRenderer, ErrorModeSelectionModel[] errorModeModels) {
        boolean withErrors = errorModeModels.length > 0;
        this.helpId_ = withLines ? "MarkStyleEditor" : "MarkStyleEditorNoLines";
        this.shapeSelector_ = MarkStyleEditor.createShapeSelector();
        this.shapeSelector_.addActionListener(this);
        this.sizeSelector_ = MarkStyleEditor.createSizeSelector();
        this.sizeSelector_.addActionListener(this);
        this.colorSelector_ = new ColorComboBox();
        this.colorSelector_.addActionListener(this);
        this.opaqueSlider_ = new LogSlider(1000);
        final JLabel opaqueLabel = new JLabel("", 4);
        this.opaqueSlider_.addChangeListener(new ChangeListener(){
            Dimension size;

            public void stateChanged(ChangeEvent evt) {
                if (this.size == null) {
                    opaqueLabel.setText("9999");
                    this.size = opaqueLabel.getPreferredSize();
                }
                opaqueLabel.setText(Integer.toString(MarkStyleEditor.this.opaqueSlider_.getValue1()));
                opaqueLabel.setPreferredSize(this.size);
                if (!MarkStyleEditor.this.opaqueSlider_.getValueIsAdjusting()) {
                    MarkStyleEditor.this.stateChanged(evt);
                }
            }
        });
        this.errorModeModels_ = errorModeModels;
        this.errorSelector_ = MarkStyleEditor.createErrorSelector(errorRenderers, defaultRenderer, errorModeModels);
        for (int idim = 0; idim < this.errorModeModels_.length; ++idim) {
            this.errorModeModels_[idim].addActionListener(this);
        }
        this.errorSelector_.addActionListener(this);
        this.markFlagger_ = new JCheckBox("Hide Markers");
        this.markFlagger_.setSelected(false);
        this.markFlagger_.addActionListener(this);
        this.thickSelector_ = new ThicknessComboBox(10);
        this.thickSelector_.addActionListener(this);
        this.dashSelector_ = new DashComboBox();
        this.dashSelector_.addActionListener(this);
        JRadioButton noneButton = new JRadioButton("None", true);
        JRadioButton dotsButton = new JRadioButton("Dot to Dot");
        JRadioButton corrButton = new JRadioButton("Linear Correlation");
        this.lineSelector_ = new ValueButtonGroup();
        this.lineSelector_.add((AbstractButton)noneButton, null);
        this.lineSelector_.add((AbstractButton)dotsButton, (Object)MarkStyle.DOT_TO_DOT);
        this.lineSelector_.add((AbstractButton)corrButton, (Object)MarkStyle.LINEAR);
        this.lineSelector_.addChangeListener((ChangeListener)this);
        this.corrLabel_ = new JLabel();
        Box formBox = Box.createHorizontalBox();
        formBox.add(new JLabel("Shape: "));
        formBox.add((Component)new ShrinkWrapper((Component)this.shapeSelector_));
        formBox.add(Box.createHorizontalStrut(5));
        formBox.add(new ComboBoxBumper(this.shapeSelector_));
        formBox.add(Box.createHorizontalStrut(10));
        formBox.add(new JLabel("Size: "));
        formBox.add((Component)new ShrinkWrapper((Component)this.sizeSelector_));
        formBox.add(Box.createHorizontalStrut(5));
        formBox.add((Component)new ShrinkWrapper((Component)new ComboBoxBumper(this.sizeSelector_)));
        formBox.add(Box.createHorizontalStrut(5));
        formBox.add(Box.createHorizontalGlue());
        Box colorBox = Box.createHorizontalBox();
        colorBox.add(new JLabel("Colour: "));
        colorBox.add((Component)new ShrinkWrapper((Component)((Object)this.colorSelector_)));
        colorBox.add(Box.createHorizontalStrut(5));
        colorBox.add(new ComboBoxBumper((JComboBox)((Object)this.colorSelector_)));
        colorBox.add(Box.createHorizontalStrut(5));
        colorBox.add(Box.createHorizontalGlue());
        Box opaqueBox = Box.createHorizontalBox();
        opaqueBox.add(new JLabel("Transparency: "));
        opaqueBox.add(this.opaqueSlider_);
        opaqueBox.add(Box.createHorizontalStrut(5));
        opaqueBox.add(opaqueLabel);
        opaqueBox.add(Box.createHorizontalStrut(5));
        opaqueBox.add(Box.createHorizontalGlue());
        Box errorBox = Box.createHorizontalBox();
        errorBox.add(new JLabel("Error Bars: "));
        errorBox.add((Component)new ShrinkWrapper((Component)this.errorSelector_));
        errorBox.add(Box.createHorizontalStrut(5));
        errorBox.add(new ComboBoxBumper(this.errorSelector_));
        errorBox.add(Box.createHorizontalStrut(5));
        errorBox.add(Box.createHorizontalGlue());
        Box hideBox = Box.createHorizontalBox();
        hideBox.add(this.markFlagger_);
        hideBox.add(Box.createHorizontalGlue());
        Box markBox = Box.createVerticalBox();
        markBox.add(formBox);
        markBox.add(Box.createVerticalStrut(5));
        markBox.add(colorBox);
        if (withTransparency) {
            markBox.add(Box.createVerticalStrut(5));
            markBox.add(opaqueBox);
        }
        if (withErrors) {
            markBox.add(Box.createVerticalStrut(5));
            markBox.add(errorBox);
        }
        markBox.add(Box.createVerticalStrut(5));
        markBox.add(hideBox);
        markBox.setBorder(AuxWindow.makeTitledBorder("Marker"));
        this.add(markBox);
        if (withLines) {
            Box lineStyleBox = Box.createHorizontalBox();
            lineStyleBox.add(new JLabel("Thickness: "));
            lineStyleBox.add((Component)new ShrinkWrapper((Component)((Object)this.thickSelector_)));
            lineStyleBox.add(Box.createHorizontalStrut(5));
            lineStyleBox.add(new ComboBoxBumper((JComboBox)((Object)this.thickSelector_)));
            lineStyleBox.add(Box.createHorizontalStrut(10));
            lineStyleBox.add(new JLabel("Dash: "));
            lineStyleBox.add((Component)new ShrinkWrapper((Component)((Object)this.dashSelector_)));
            lineStyleBox.add(Box.createHorizontalStrut(5));
            lineStyleBox.add(new ComboBoxBumper((JComboBox)((Object)this.dashSelector_)));
            lineStyleBox.add(Box.createHorizontalStrut(5));
            lineStyleBox.add(Box.createHorizontalGlue());
            Box noneLineBox = Box.createHorizontalBox();
            noneLineBox.add(noneButton);
            noneLineBox.add(Box.createHorizontalGlue());
            Box dotsLineBox = Box.createHorizontalBox();
            dotsLineBox.add(dotsButton);
            dotsLineBox.add(Box.createHorizontalGlue());
            Box corrLineBox = Box.createHorizontalBox();
            corrLineBox.add(corrButton);
            corrLineBox.add(this.corrLabel_);
            corrLineBox.add(Box.createHorizontalGlue());
            Box lineBox = Box.createVerticalBox();
            lineBox.add(lineStyleBox);
            lineBox.add(noneLineBox);
            lineBox.add(dotsLineBox);
            lineBox.add(corrLineBox);
            lineBox.setBorder(AuxWindow.makeTitledBorder("Line"));
            this.add(lineBox);
        }
    }

    public void setStyle(Style style) {
        MarkStyle mstyle = (MarkStyle)style;
        this.shapeSelector_.setSelectedItem(mstyle.getShapeId());
        this.sizeSelector_.setSelectedIndex(mstyle.getSize());
        this.colorSelector_.setSelectedItem(mstyle.getColor());
        int opaqueLimit = mstyle.getOpaqueLimit();
        this.opaqueSlider_.setValue1(opaqueLimit);
        this.thickSelector_.setSelectedThickness(mstyle.getLineWidth());
        this.dashSelector_.setSelectedDash(mstyle.getDash());
        this.lineSelector_.setValue((Object)mstyle.getLine());
        this.markFlagger_.setSelected(mstyle.getHidePoints());
        this.errorSelector_.setSelectedItem(mstyle.getErrorRenderer());
    }

    public Style getStyle() {
        return MarkStyleEditor.getStyle((MarkShape)this.shapeSelector_.getSelectedItem(), this.sizeSelector_.getSelectedIndex(), this.colorSelector_.getSelectedColor(), this.opaqueSlider_.getValue1(), this.markFlagger_.isEnabled() && this.markFlagger_.isSelected(), (ErrorRenderer)this.errorSelector_.getSelectedItem(), (MarkStyle.Line)this.lineSelector_.getValue(), this.thickSelector_.getSelectedThickness(), this.dashSelector_.getSelectedDash(), this.errorModeModels_);
    }

    public String getHelpID() {
        return this.helpId_;
    }

    private static MarkStyle getStyle(MarkShape shape, int size, Color color, int opaqueLimit, boolean hidePoints, ErrorRenderer errorRenderer, MarkStyle.Line line, int thick, float[] dash, ErrorModeSelectionModel[] errModels) {
        MarkStyle style = size == 0 ? MarkShape.POINT.getStyle(color, 0) : shape.getStyle(color, size);
        style.setOpaqueLimit(opaqueLimit);
        style.setLine(line);
        style.setHidePoints(hidePoints);
        style.setErrorRenderer(errorRenderer);
        style.setLineWidth(thick);
        style.setDash(dash);
        style.setErrorModeModels((ErrorModeSelection[])errModels);
        return style;
    }

    public void setStats(SetId[] setIds, XYStats[] stats) {
        this.statMap_.clear();
        if (setIds.length != stats.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < setIds.length; ++i) {
            this.statMap_.put(setIds[i], stats[i]);
        }
        this.refreshState();
    }

    protected void refreshState() {
        super.refreshState();
        SetId setId = this.getSetId();
        XYStats stats = (XYStats)this.statMap_.get(setId);
        String statText = stats != null ? " - " + "m=" + (float)stats.getLinearCoefficients()[1] + "; c=" + (float)stats.getLinearCoefficients()[0] + "; r=" + (float)stats.getCorrelation() : "";
        this.corrLabel_.setText(statText);
        boolean permitErrors = !ErrorMode.allBlank((ErrorMode[])this.getErrorModes());
        this.errorSelector_.setEnabled(permitErrors);
        boolean visibleErrors = permitErrors && !ErrorRenderer.NONE.equals((ErrorRenderer)this.errorSelector_.getSelectedItem());
        this.markFlagger_.setEnabled(this.lineSelector_.getValue() != null || visibleErrors);
    }

    private ErrorMode[] getErrorModes() {
        int ndim = this.errorModeModels_.length;
        ErrorMode[] modes = new ErrorMode[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            modes[idim] = this.errorModeModels_[idim].getErrorMode();
        }
        return modes;
    }

    public Icon getLegendIcon() {
        return ((MarkStyle)this.getStyle()).getLegendIcon(this.getErrorModes());
    }

    public static JComboBox createShapeSelector() {
        final JComboBox<MarkShape> selector = new JComboBox<MarkShape>(SHAPES);
        selector.setRenderer(new MarkRenderer(){

            public MarkShape getMarkShape(int index) {
                return (MarkShape)selector.getItemAt(index);
            }

            public MarkShape getMarkShape() {
                return (MarkShape)selector.getSelectedItem();
            }

            public Color getMarkColor() {
                return Color.BLACK;
            }

            public int getMarkSize() {
                return 5;
            }
        });
        return selector;
    }

    public static JComboBox createSizeSelector() {
        final JComboBox<Object> selector = new JComboBox<Object>(MarkStyleEditor.createNumberedModel(6));
        selector.setRenderer(new MarkRenderer(true){

            public int getMarkSize(int index) {
                return index;
            }

            public int getMarkSize() {
                return selector.getSelectedIndex();
            }

            public Color getMarkColor() {
                return Color.BLACK;
            }

            public MarkShape getMarkShape() {
                return MarkShape.OPEN_SQUARE;
            }
        });
        return selector;
    }

    public static JComboBox createErrorSelector(ErrorRenderer[] errorRenderers, ErrorRenderer defaultRenderer, ErrorModeSelectionModel[] errorModeModels) {
        ErrorRendererComboBoxModel model = new ErrorRendererComboBoxModel(errorRenderers, defaultRenderer, errorModeModels);
        ErrorRendererRenderer renderer = new ErrorRendererRenderer(errorModeModels);
        JComboBox<Object> errorSelector = new JComboBox<Object>(model);
        errorSelector.setRenderer(renderer);
        return errorSelector;
    }

    private static class ErrorRendererRenderer
    extends BasicComboBoxRenderer {
        private final ErrorModeSelectionModel[] errModels_;

        ErrorRendererRenderer(ErrorModeSelectionModel[] errorModeModels) {
            this.errModels_ = errorModeModels;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                Icon icon = null;
                if (value instanceof ErrorRenderer) {
                    ErrorRenderer er = (ErrorRenderer)value;
                    ErrorMode[] modes = new ErrorMode[this.errModels_.length];
                    for (int imode = 0; imode < modes.length; ++imode) {
                        modes[imode] = this.errModels_[imode].getErrorMode();
                    }
                    icon = er.getLegendIcon(modes, 40, 15, 5, 1);
                    icon = new ColoredIcon(icon, c.getForeground());
                }
                label.setText(icon == null ? "??" : null);
                label.setIcon(icon);
            }
            return c;
        }
    }

    private static class ErrorRendererComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ActionListener {
        private final ErrorRenderer[] allRenderers_;
        private final ErrorRenderer defaultRenderer_;
        private final ErrorModeSelectionModel[] modeModels_;
        private List activeRendererList_;
        private ErrorRenderer selected_;

        ErrorRendererComboBoxModel(ErrorRenderer[] renderers, ErrorRenderer defaultRenderer, ErrorModeSelectionModel[] modeModels) {
            this.allRenderers_ = renderers;
            this.defaultRenderer_ = defaultRenderer;
            this.modeModels_ = modeModels;
            this.selected_ = defaultRenderer;
            this.updateState();
            for (int idim = 0; idim < modeModels.length; ++idim) {
                modeModels[idim].addActionListener(this);
            }
        }

        public Object getElementAt(int index) {
            return (ErrorRenderer)this.activeRendererList_.get(index);
        }

        public int getSize() {
            return this.activeRendererList_.size();
        }

        public Object getSelectedItem() {
            return this.selected_;
        }

        public void setSelectedItem(Object item) {
            if (!this.activeRendererList_.contains(item)) {
                throw new IllegalArgumentException("No such selection " + item);
            }
            this.selected_ = (ErrorRenderer)item;
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateState();
        }

        private void updateState() {
            int ndim = 0;
            for (int idim = 0; idim < this.modeModels_.length; ++idim) {
                if (ErrorMode.NONE.equals(this.modeModels_[idim].getErrorMode())) continue;
                ++ndim;
            }
            ArrayList<ErrorRenderer> rendererList = new ArrayList<ErrorRenderer>();
            for (int ir = 0; ir < this.allRenderers_.length; ++ir) {
                ErrorRenderer renderer = this.allRenderers_[ir];
                if (!renderer.supportsDimensionality(ndim)) continue;
                rendererList.add(renderer);
            }
            if (!rendererList.contains(this.selected_)) {
                this.selected_ = this.defaultRenderer_;
            }
            this.activeRendererList_ = rendererList;
            this.fireContentsChanged(this, 0, this.activeRendererList_.size() - 1);
        }
    }

    private static abstract class MarkRenderer
    extends BasicComboBoxRenderer {
        private boolean useText_;

        MarkRenderer() {
            this(false);
        }

        MarkRenderer(boolean useText) {
            this.useText_ = useText;
        }

        MarkShape getMarkShape(int itemIndex) {
            return this.getMarkShape();
        }

        abstract MarkShape getMarkShape();

        int getMarkSize(int itemIndex) {
            return this.getMarkSize();
        }

        abstract int getMarkSize();

        Color getMarkColor(int itemIndex) {
            return this.getMarkColor();
        }

        abstract Color getMarkColor();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                if (!this.useText_) {
                    this.setText(null);
                }
                MarkStyle style = index >= 0 ? MarkStyleEditor.getStyle(this.getMarkShape(index), this.getMarkSize(index), this.getMarkColor(index), 1, false, ErrorRenderer.NONE, null, 1, null, new ErrorModeSelectionModel[0]) : MarkStyleEditor.getStyle(this.getMarkShape(), this.getMarkSize(), this.getMarkColor(), 1, false, ErrorRenderer.NONE, null, 1, null, new ErrorModeSelectionModel[0]);
                label.setIcon(style.getLegendIcon());
            }
            return c;
        }
    }
}

