/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AnnotationPanel;
import uk.ac.starlink.topcat.plot.BlobPanel;
import uk.ac.starlink.topcat.plot.CentreZoomRegion;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.GraphicsWindow;
import uk.ac.starlink.topcat.plot.PlotStatsLabel;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.ZoomRegion;
import uk.ac.starlink.topcat.plot.Zoomer;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot.Plot3DState;
import uk.ac.starlink.ttools.plot.PlotListener;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PointIterator;
import uk.ac.starlink.ttools.plot.PointPlacer;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.TablePlot;

public abstract class Plot3DWindow
extends GraphicsWindow
implements TopcatListener {
    private final JComponent plotPanel_;
    private final ToggleButtonModel fogModel_;
    private final ToggleButtonModel antialiasModel_;
    private final ToggleButtonModel northModel_;
    private final BlobPanel blobPanel_;
    private final AnnotationPanel annotations_;
    private final Action blobAction_;
    private final Action fromVisibleAction_;
    private double[] rotation_;
    private boolean isRotating_;
    private double zoom_ = 1.0;
    private static final StyleSet[] STYLE_SETS;
    private static final StyleSet MARKERS1;
    private static final StyleSet MARKERS2;
    private static final StyleSet MARKERS3;
    private static final StyleSet MARKERS4;
    private static final StyleSet MARKERS5;
    private static final double[] INITIAL_ROTATION;
    private static final double CLICK_ZOOM_UNIT = 1.2;
    private static final boolean CAN_ZOOM = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Plot3DWindow(String viewName, String[] axisNames, int naux, Component parent, ErrorModeSelectionModel[] errorModeModels, final Plot3D plot) {
        super(viewName, (TablePlot)plot, axisNames, naux, true, errorModeModels, parent);
        plot.setBorder(BorderFactory.createEmptyBorder(10, 32, 10, 10));
        Zoomer zoomer = new Zoomer();
        zoomer.setRegions(Arrays.asList(this.createZoomRegions()));
        zoomer.setCursorComponent((Component)plot);
        plot.addMouseListener((MouseListener)zoomer);
        plot.addMouseMotionListener((MouseMotionListener)zoomer);
        plot.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                int nclick = evt.getWheelRotation();
                if (nclick != 0) {
                    double factor = Math.pow(1.2, -nclick);
                    Plot3DWindow.this.doZoom(((Plot3DState)plot.getState()).getZoomScale() * factor);
                }
            }
        });
        this.annotations_ = new AnnotationPanel(){

            public PointPlacer getPlacer() {
                return plot.getPointPlacer();
            }
        };
        this.plotPanel_ = new JPanel();
        this.plotPanel_.setOpaque(false);
        this.blobPanel_ = new BlobPanel(){

            protected void blobCompleted(Shape blob) {
                Plot3DWindow.this.addNewSubsets(plot.getPlottedPointIterator().getContainedPoints(blob));
            }
        };
        this.blobAction_ = this.blobPanel_.getBlobAction();
        this.plotPanel_.setLayout(new OverlayLayout(this.plotPanel_));
        this.plotPanel_.add(this.blobPanel_);
        this.plotPanel_.add(this.annotations_);
        this.plotPanel_.add((Component)plot);
        this.getPointSelectors().addTopcatListener(this);
        DragListener rotListener = new DragListener();
        plot.addMouseMotionListener((MouseMotionListener)rotListener);
        plot.addMouseListener((MouseListener)rotListener);
        plot.addMouseListener((MouseListener)new PointClickListener());
        PlotStatsLabel plotStatus = new PlotStatsLabel();
        plotStatus.setMaximumSize(new Dimension(Integer.MAX_VALUE, plotStatus.getMaximumSize().height));
        plot.addPlotListener((PlotListener)plotStatus);
        this.getStatusBox().add(plotStatus);
        BasicAction reorientAction = new BasicAction("Reorient", ResourceIcon.XYZ, "Reorient the plot to initial position"){

            public void actionPerformed(ActionEvent evt) {
                Plot3DWindow.this.setRotation(INITIAL_ROTATION);
                Plot3DWindow.this.zoom_ = 1.0;
                Plot3DWindow.this.replot();
            }
        };
        this.fromVisibleAction_ = new BasicAction("New subset from visible", ResourceIcon.VISIBLE_SUBSET, "Define a new row subset containing only currently visible points"){

            public void actionPerformed(ActionEvent evt) {
                Plot3DWindow.this.addNewSubsets(plot.getPlottedPointIterator().getAllPoints());
            }
        };
        this.fogModel_ = new ToggleButtonModel("Fog", ResourceIcon.FOG, "Select whether fog obscures distant points");
        this.fogModel_.setSelected(true);
        this.fogModel_.addActionListener(this.getReplotListener());
        this.antialiasModel_ = new ToggleButtonModel("Antialias", ResourceIcon.ANTIALIAS, "Select whether text is antialiased");
        this.antialiasModel_.setSelected(false);
        this.antialiasModel_.addActionListener(this.getReplotListener());
        this.northModel_ = new ToggleButtonModel("Stay Upright", ResourceIcon.NORTH, "Select whether the Z axis is always vertical on the screen");
        this.northModel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Plot3DWindow.this.setRotation(Plot3DWindow.this.rotation_);
                Plot3DWindow.this.getReplotListener().actionPerformed(evt);
            }
        });
        this.northModel_.setSelected(false);
        JMenu plotMenu = new JMenu("Plot");
        plotMenu.setMnemonic(80);
        plotMenu.add(this.getRescaleAction());
        plotMenu.add(reorientAction);
        plotMenu.add(this.northModel_.createMenuItem());
        plotMenu.add(this.getAxisEditAction());
        plotMenu.add(this.getGridModel().createMenuItem());
        plotMenu.add(this.getLegendModel().createMenuItem());
        plotMenu.add(this.getReplotAction());
        this.getJMenuBar().add(plotMenu);
        JMenu renderMenu = new JMenu("Rendering");
        renderMenu.setMnemonic(82);
        renderMenu.add(this.fogModel_.createMenuItem());
        renderMenu.add(this.antialiasModel_.createMenuItem());
        this.getJMenuBar().add(renderMenu);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        subsetMenu.add(this.blobAction_);
        subsetMenu.add(this.fromVisibleAction_);
        this.getJMenuBar().add(subsetMenu);
        this.getToolBar().add(this.getRescaleAction());
        this.getToolBar().add(reorientAction);
        this.getToolBar().add(this.northModel_.createToolbarButton());
        this.getToolBar().add(this.getGridModel().createToolbarButton());
        this.getToolBar().add(this.getLegendModel().createToolbarButton());
        this.getToolBar().add(this.fogModel_.createToolbarButton());
        this.getToolBar().add(this.blobAction_);
        this.getToolBar().add(this.fromVisibleAction_);
        this.setRotation(INITIAL_ROTATION);
        this.replot();
    }

    public void setRotation(double[] matrix) {
        double[] rot = (double[])matrix.clone();
        if (this.northModel_.isSelected()) {
            double theta = Math.atan2(rot[2], rot[5]);
            double[] correction = Plot3D.rotate((double[])rot, (double[])new double[]{0.0, 0.0, 1.0}, (double)theta);
            rot = Matrices.mmMult((double[])rot, (double[])correction);
        }
        this.rotation_ = rot;
    }

    protected JComponent getPlotPanel() {
        return this.plotPanel_;
    }

    protected PlotState createPlotState() {
        return new Plot3DState();
    }

    public PlotState getPlotState() {
        Plot3DState state = (Plot3DState)super.getPlotState();
        state.setRotation(this.rotation_);
        state.setRotating(this.isRotating_);
        state.setZoomScale(this.zoom_);
        state.setFogginess(this.fogModel_.isSelected() ? 2.0 : 0.0);
        state.setAntialias(this.antialiasModel_.isSelected());
        return state;
    }

    public StyleSet getDefaultStyles(int npoint) {
        if (npoint > 20000) {
            return MARKERS1;
        }
        if (npoint > 2000) {
            return MARKERS2;
        }
        if (npoint > 200) {
            return MARKERS3;
        }
        if (npoint > 20) {
            return MARKERS4;
        }
        if (npoint >= 1) {
            return MARKERS5;
        }
        return MARKERS2;
    }

    protected void doReplot(PlotState state) {
        this.blobPanel_.setActive(false);
        this.annotations_.setPlotData(state.getPlotData());
        super.doReplot(state);
    }

    public ToggleButtonModel getNorthModel() {
        return this.northModel_;
    }

    public void modelChanged(TopcatEvent evt) {
        if (evt.getCode() == 5) {
            Object datum = evt.getDatum();
            if (datum instanceof Long) {
                Plot3D plot = (Plot3D)this.getPlot();
                TopcatModel tcModel = evt.getModel();
                PointSelection psel = (PointSelection)plot.getState().getPlotData();
                long lrow = (Long)datum;
                long[] lps = psel.getPointsForRow(tcModel, lrow);
                int[] ips = new int[lps.length];
                for (int i = 0; i < lps.length; ++i) {
                    ips[i] = Tables.checkedLongToInt((long)lps[i]);
                }
                this.annotations_.setActivePoints(ips);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private void doZoom(double zoom) {
        this.zoom_ = Math.max(1.0, zoom);
        this.replot();
    }

    private final ZoomRegion[] createZoomRegions() {
        return new ZoomRegion[]{new ZoomRegion3D(false){

            protected Rectangle getTarget(Rectangle display, Rectangle bounds) {
                int x = display.x + display.width;
                int width = bounds.width - x;
                int y = display.y;
                int height = display.height;
                return new Rectangle(x, y, width, height);
            }
        }, new ZoomRegion3D(false){

            protected Rectangle getTarget(Rectangle display, Rectangle bounds) {
                return new Rectangle(0, display.y, display.x, display.height);
            }
        }};
    }

    static {
        $assertionsDisabled = !Plot3DWindow.class.desiredAssertionStatus();
        STYLE_SETS = Plot3DWindow.getStandardMarkStyleSets();
        MARKERS1 = STYLE_SETS[0];
        MARKERS2 = STYLE_SETS[1];
        MARKERS3 = STYLE_SETS[2];
        MARKERS4 = STYLE_SETS[3];
        MARKERS5 = STYLE_SETS[4];
        if (!$assertionsDisabled && !MARKERS1.getName().equals("Pixels")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS2.getName().equals("Dots")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS3.getName().equals("Spots")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS4.getName().startsWith("Small")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS5.getName().startsWith("Medium")) {
            throw new AssertionError();
        }
        INITIAL_ROTATION = Plot3D.rotateXY((double[])Plot3D.rotateXY((double[])new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, -1.0}, (double)0.5, (double)1.5707963267948966), (double)0.0, (double)-0.3141592653589793);
    }

    private class PointClickListener
    extends MouseAdapter {
        private PointClickListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            int butt = evt.getButton();
            if (butt == 1) {
                int ip;
                Plot3D plot = (Plot3D)Plot3DWindow.this.getPlot();
                Point point = evt.getPoint();
                PointIterator pointIt = plot.getPlottedPointIterator();
                int n = ip = pointIt == null ? -1 : pointIt.getClosestPoint(point, 4);
                if (ip >= 0) {
                    PointSelection psel = (PointSelection)plot.getState().getPlotData();
                    psel.getPointTable(ip).highlightRow(psel.getPointRow(ip));
                } else {
                    Plot3DWindow.this.annotations_.setActivePoints(new int[0]);
                }
            }
        }
    }

    private class DragListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point posBase_;
        private double[] rotBase_;
        private boolean relevant_;

        private DragListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this.relevant_ = Plot3DWindow.this.getPlot().getPlotBounds().contains(evt.getPoint());
        }

        public void mouseDragged(MouseEvent evt) {
            if (!this.relevant_) {
                return;
            }
            Plot3DWindow.this.isRotating_ = true;
            Point pos = evt.getPoint();
            if (this.posBase_ == null) {
                this.posBase_ = pos;
                this.rotBase_ = Plot3DWindow.this.rotation_;
            } else {
                Plot3D plot = (Plot3D)Plot3DWindow.this.getPlot();
                double scale = Math.min(plot.getWidth(), plot.getHeight());
                double xf = (double)(-(pos.x - this.posBase_.x)) / scale / Plot3DWindow.this.zoom_;
                double yf = (double)(-(pos.y - this.posBase_.y)) / scale / Plot3DWindow.this.zoom_;
                double phi = xf * Math.PI / 2.0;
                double psi = yf * Math.PI / 2.0;
                Plot3DWindow.this.setRotation(Plot3D.rotateXY((double[])this.rotBase_, (double)phi, (double)psi));
                Plot3DWindow.this.replot();
            }
        }

        public void mouseMoved(MouseEvent evt) {
            this.posBase_ = null;
            this.rotBase_ = null;
        }

        public void mouseReleased(MouseEvent evt) {
            if (Plot3DWindow.this.isRotating_) {
                Plot3DWindow.this.isRotating_ = false;
                Plot3DWindow.this.replot();
            }
        }
    }

    private abstract class ZoomRegion3D
    extends CentreZoomRegion {
        ZoomRegion3D(boolean isX) {
            super(isX);
        }

        protected abstract Rectangle getTarget(Rectangle var1, Rectangle var2);

        public Rectangle getDisplay() {
            return ((Plot3D)Plot3DWindow.this.getPlot()).getDisplayBounds();
        }

        public Rectangle getTarget() {
            TablePlot plot = Plot3DWindow.this.getPlot();
            return this.getTarget(plot.getPlotBounds(), plot.getBounds());
        }

        public void zoomed(double[][] bounds) {
            Plot3DWindow.this.doZoom(((Plot3DState)Plot3DWindow.this.getPlot().getState()).getZoomScale() / bounds[0][0]);
        }
    }
}

