/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AnnotationPanel;
import uk.ac.starlink.topcat.plot.BlobPanel;
import uk.ac.starlink.topcat.plot.GraphicsWindow;
import uk.ac.starlink.topcat.plot.MarkStyleEditor;
import uk.ac.starlink.topcat.plot.PlotStatsLabel;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.PositionLabel;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.SurfaceZoomRegionList;
import uk.ac.starlink.topcat.plot.Zoomer;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkStyles;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotListener;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PtPlotSurface;
import uk.ac.starlink.ttools.plot.ScatterPlot;
import uk.ac.starlink.ttools.plot.ScatterPlotEvent;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.SurfacePlot;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plot.XYStats;

public class PlotWindow
extends GraphicsWindow
implements TopcatListener {
    private final JComponent plotPanel_;
    private final BlobPanel blobPanel_;
    private final AnnotationPanel annotations_;
    private final Action blobAction_;
    private final Action fromVisibleAction_;
    private final SurfaceZoomRegionList zoomRegionList_;
    private static final ErrorRenderer DEFAULT_ERROR_RENDERER;
    private static final StyleSet[] STYLE_SETS;
    private static final StyleSet MARKERS1;
    private static final StyleSet MARKERS2;
    private static final StyleSet MARKERS3;
    private static final StyleSet MARKERS4;
    private static final StyleSet MARKERS5;
    private static final String[] AXIS_NAMES;
    private static final ErrorRenderer[] ERROR_RENDERERS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlotWindow(Component parent) {
        super("Scatter Plot", (TablePlot)new ScatterPlot((PlotSurface)new PtPlotSurface()), AXIS_NAMES, 3, true, PlotWindow.createErrorModeModels(AXIS_NAMES), parent);
        final ScatterPlot plot = (ScatterPlot)this.getPlot();
        PlotSurface surface = plot.getSurface();
        plot.addPlotListener(new PlotListener(){

            public void plotChanged(PlotEvent evt) {
                ScatterPlotEvent sevt = (ScatterPlotEvent)evt;
                PlotWindow.this.zoomRegionList_.reconfigure();
                boolean someVisible = evt.getVisiblePointCount() > 0;
                PlotWindow.this.fromVisibleAction_.setEnabled(someVisible);
                PlotWindow.this.blobAction_.setEnabled(someVisible);
                XYStats[] xyStats = sevt.getXYStats();
                SetId[] setIds = ((PointSelection)evt.getPlotState().getPlotData()).getSetIds();
                ((MarkStyleEditor)PlotWindow.this.getPointSelectors().getStyleWindow().getEditor()).setStats(setIds, xyStats);
            }
        });
        this.annotations_ = new AnnotationPanel();
        this.zoomRegionList_ = new SurfaceZoomRegionList((SurfacePlot)plot){

            protected void requestZoom(double[][] bounds) {
                for (int idim = 0; idim < 2; ++idim) {
                    if (bounds[idim] == null) continue;
                    PlotWindow.this.getAxisWindow().getEditors()[idim].clearBounds();
                    PlotWindow.this.getViewRanges()[idim].setBounds(bounds[idim]);
                }
                PlotWindow.this.replot();
            }
        };
        Zoomer zoomer = new Zoomer();
        zoomer.setRegions(this.zoomRegionList_);
        zoomer.setCursorComponent((Component)plot);
        JComponent scomp = plot.getSurface().getComponent();
        scomp.addMouseListener(zoomer);
        scomp.addMouseMotionListener(zoomer);
        this.plotPanel_ = new JPanel();
        this.plotPanel_.setOpaque(false);
        this.blobPanel_ = new BlobPanel(){

            protected void blobCompleted(Shape blob) {
                PlotWindow.this.addNewSubsets(plot.getPlottedPointIterator().getContainedPoints(blob));
            }
        };
        this.blobAction_ = this.blobPanel_.getBlobAction();
        this.plotPanel_.setLayout(new OverlayLayout(this.plotPanel_));
        this.plotPanel_.add(this.blobPanel_);
        this.plotPanel_.add(this.annotations_);
        this.plotPanel_.add((Component)plot);
        this.plotPanel_.setPreferredSize(new Dimension(500, 400));
        surface.getComponent().addMouseListener(new PointClickListener());
        this.getPointSelectors().addTopcatListener(this);
        PositionLabel posStatus = new PositionLabel(surface);
        posStatus.setMaximumSize(new Dimension(Integer.MAX_VALUE, posStatus.getMaximumSize().height));
        PlotStatsLabel plotStatus = new PlotStatsLabel();
        plot.addPlotListener((PlotListener)plotStatus);
        this.getStatusBox().add(plotStatus);
        this.getStatusBox().add(Box.createHorizontalStrut(5));
        this.getStatusBox().add(posStatus);
        this.getStatusBox().add(Box.createHorizontalGlue());
        JMenu plotMenu = new JMenu("Plot");
        plotMenu.setMnemonic(80);
        plotMenu.add(this.getRescaleAction());
        plotMenu.add(this.getAxisEditAction());
        plotMenu.add(this.getGridModel().createMenuItem());
        plotMenu.add(this.getLegendModel().createMenuItem());
        plotMenu.add(this.getReplotAction());
        this.getJMenuBar().add(plotMenu);
        JMenu axisMenu = new JMenu("Axes");
        axisMenu.setMnemonic(65);
        axisMenu.add(this.getFlipModels()[0].createMenuItem());
        axisMenu.add(this.getFlipModels()[1].createMenuItem());
        axisMenu.addSeparator();
        axisMenu.add(this.getLogModels()[0].createMenuItem());
        axisMenu.add(this.getLogModels()[1].createMenuItem());
        this.getJMenuBar().add(axisMenu);
        JMenu subsetMenu = new JMenu("Subsets");
        subsetMenu.setMnemonic(83);
        this.blobAction_.setEnabled(false);
        this.fromVisibleAction_ = new BasicAction("New subset from visible", ResourceIcon.VISIBLE_SUBSET, "Define a new row subset containing only currently visible points"){

            public void actionPerformed(ActionEvent evt) {
                PlotWindow.this.addNewSubsets(plot.getPlottedPointIterator().getAllPoints());
            }
        };
        this.fromVisibleAction_.setEnabled(false);
        subsetMenu.add(this.blobAction_);
        subsetMenu.add(this.fromVisibleAction_);
        this.getJMenuBar().add(subsetMenu);
        this.getJMenuBar().add(this.createErrorModeMenu());
        this.getJMenuBar().add(this.createMarkerStyleMenu(STYLE_SETS));
        this.getJMenuBar().add(this.createErrorRendererMenu(ERROR_RENDERERS));
        this.getPointSelectorToolBar().addSeparator();
        this.getPointSelectorToolBar().add(this.getErrorModeModels()[0].createOnOffToolbarButton());
        this.getPointSelectorToolBar().add(this.getErrorModeModels()[1].createOnOffToolbarButton());
        this.getToolBar().add(this.getRescaleAction());
        this.getToolBar().add(this.getGridModel().createToolbarButton());
        this.getToolBar().add(this.getLegendModel().createToolbarButton());
        this.getToolBar().add(this.blobAction_);
        this.getToolBar().add(this.fromVisibleAction_);
        this.getToolBar().addSeparator();
        this.addHelp("PlotWindow");
        this.replot();
    }

    protected JComponent getPlotPanel() {
        return this.plotPanel_;
    }

    protected void doReplot(PlotState state) {
        this.annotations_.setPlotData(state.getPlotData());
        this.annotations_.setPlacer(((ScatterPlot)this.getPlot()).getPointPlacer());
        this.blobPanel_.setActive(false);
        super.doReplot(state);
    }

    protected StyleEditor createStyleEditor() {
        return new MarkStyleEditor(true, true, ERROR_RENDERERS, DEFAULT_ERROR_RENDERER, this.getErrorModeModels());
    }

    public void modelChanged(TopcatEvent evt) {
        if (evt.getCode() == 5) {
            ScatterPlot plot = (ScatterPlot)this.getPlot();
            Object datum = evt.getDatum();
            if (datum instanceof Long) {
                TopcatModel tcModel = evt.getModel();
                PointSelection psel = (PointSelection)plot.getState().getPlotData();
                long lrow = (Long)datum;
                long[] lps = psel.getPointsForRow(tcModel, lrow);
                int[] ips = new int[lps.length];
                for (int i = 0; i < lps.length; ++i) {
                    ips[i] = Tables.checkedLongToInt((long)lps[i]);
                }
                this.annotations_.setActivePoints(ips);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    public StyleSet getDefaultStyles(int npoint) {
        if (npoint > 100000) {
            int opaqueLimit = npoint / 50000;
            return MarkStyles.faded((String)("Ghost " + opaqueLimit), (StyleSet)MARKERS1, (int)opaqueLimit);
        }
        if (npoint > 10000) {
            return MARKERS1;
        }
        if (npoint > 2000) {
            return MARKERS2;
        }
        if (npoint > 200) {
            return MARKERS3;
        }
        if (npoint > 20) {
            return MARKERS4;
        }
        if (npoint >= 1) {
            return MARKERS5;
        }
        return MARKERS2;
    }

    static {
        $assertionsDisabled = !PlotWindow.class.desiredAssertionStatus();
        DEFAULT_ERROR_RENDERER = ErrorRenderer.EXAMPLE;
        STYLE_SETS = PlotWindow.fixDefaultErrorRenderers(DEFAULT_ERROR_RENDERER, PlotWindow.getStandardMarkStyleSets());
        MARKERS1 = STYLE_SETS[0];
        MARKERS2 = STYLE_SETS[1];
        MARKERS3 = STYLE_SETS[2];
        MARKERS4 = STYLE_SETS[3];
        MARKERS5 = STYLE_SETS[4];
        if (!$assertionsDisabled && !MARKERS1.getName().equals("Pixels")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS2.getName().equals("Dots")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS3.getName().equals("Spots")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS4.getName().startsWith("Small")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !MARKERS5.getName().startsWith("Medium")) {
            throw new AssertionError();
        }
        AXIS_NAMES = new String[]{"X", "Y"};
        ERROR_RENDERERS = ErrorRenderer.getOptions2d();
    }

    private class PointClickListener
    extends MouseAdapter {
        private PointClickListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            ScatterPlot plot = (ScatterPlot)PlotWindow.this.getPlot();
            int butt = evt.getButton();
            if (butt == 1) {
                int ip = plot.getPlottedPointIterator().getClosestPoint(evt.getPoint(), 4);
                if (ip >= 0) {
                    PointSelection psel = (PointSelection)plot.getState().getPlotData();
                    psel.getPointTable(ip).highlightRow(psel.getPointRow(ip));
                } else {
                    PlotWindow.this.annotations_.setActivePoints(new int[0]);
                }
            }
        }
    }
}

