/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.WrapperPlotData;

public class PointSelection
implements PlotData {
    private final int ndim_;
    private final int nTable_;
    private final TopcatModel[] tcModels_;
    private final long[] nrows_;
    private final StarTable[] dataTables_;
    private final StarTable[] errorTables_;
    private final StarTable[] labelTables_;
    private final ErrorMode[] errorModes_;
    private final RowSubset[] subsets_;
    private final Style[] styles_;
    private final SetId[] setIds_;
    private final PointSelector mainSelector_;
    private Points points_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PointSelection(PointSelector[] selectors, int[][] subsetPointers, String[] subsetNames) {
        this.nTable_ = selectors.length;
        this.mainSelector_ = selectors[0];
        this.ndim_ = this.mainSelector_.getAxesSelector().getNdim();
        for (int i = 0; i < this.nTable_; ++i) {
            if (selectors[i].getAxesSelector().getNdim() == this.ndim_) continue;
            throw new IllegalArgumentException();
        }
        this.errorModes_ = (ErrorMode[])this.mainSelector_.getAxesSelector().getErrorModes().clone();
        this.tcModels_ = new TopcatModel[this.nTable_];
        this.dataTables_ = new StarTable[this.nTable_];
        this.errorTables_ = new StarTable[this.nTable_];
        this.labelTables_ = new StarTable[this.nTable_];
        this.nrows_ = new long[this.nTable_];
        long[] offsets = new long[this.nTable_];
        long offset = 0L;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            PointSelector psel = selectors[itab];
            this.tcModels_[itab] = psel.getTable();
            AxesSelector axsel = psel.getAxesSelector();
            this.dataTables_[itab] = axsel.getData();
            this.errorTables_[itab] = axsel.getErrorData();
            this.labelTables_[itab] = axsel.getLabelData();
            this.nrows_[itab] = this.tcModels_[itab].getDataModel().getRowCount();
            offsets[itab] = offset;
            offset += this.nrows_[itab];
        }
        ArrayList<RowSubset> subsetList = new ArrayList<RowSubset>();
        ArrayList<Style> styleList = new ArrayList<Style>();
        ArrayList<SetId> idList = new ArrayList<SetId>();
        for (int isub = 0; isub < subsetPointers.length; ++isub) {
            int[] subsetPointer = subsetPointers[isub];
            int itab = subsetPointer[0];
            int itsub = subsetPointer[1];
            RowSubset rset = (RowSubset)this.tcModels_[itab].getSubsets().get(itsub);
            rset = new OffsetRowSubset(rset, offsets[itab], this.nrows_[itab], subsetNames[isub]);
            subsetList.add(rset);
            styleList.add(selectors[itab].getStyle(itsub));
            idList.add(new SetId(selectors[itab], itsub));
        }
        this.subsets_ = subsetList.toArray(new RowSubset[0]);
        this.styles_ = styleList.toArray(new Style[0]);
        this.setIds_ = idList.toArray(new SetId[0]);
        this.points_ = this.getEmptyPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Points readPoints(BoundedRangeModel progress) throws IOException, InterruptedException {
        int npoint = 0;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            npoint += Tables.checkedLongToInt((long)this.tcModels_[itab].getDataModel().getRowCount());
        }
        PointStore pointStore = this.mainSelector_.getAxesSelector().createPointStore(npoint);
        if (progress != null) {
            progress.setMinimum(0);
            progress.setMaximum(npoint);
        }
        int step = Math.max(npoint / 100, 1000);
        int ipoint = 0;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            RowSequence labSeq;
            RowSequence errSeq;
            block28: {
                Object var16_16;
                RowSequence datSeq = null;
                errSeq = null;
                labSeq = null;
                try {
                    datSeq = this.dataTables_[itab].getRowSequence();
                    if (this.errorTables_[itab] != null) {
                        errSeq = this.errorTables_[itab].getRowSequence();
                    }
                    if (this.labelTables_[itab] != null) {
                        labSeq = this.labelTables_[itab].getRowSequence();
                    }
                    while (datSeq.next()) {
                        String label;
                        boolean hasNext;
                        Object[] errRow;
                        Object[] datRow = datSeq.getRow();
                        if (errSeq == null) {
                            errRow = null;
                        } else {
                            hasNext = errSeq.next();
                            if (!$assertionsDisabled && !hasNext) {
                                throw new AssertionError();
                            }
                            errRow = errSeq.getRow();
                        }
                        if (labSeq == null) {
                            label = null;
                        } else {
                            hasNext = labSeq.next();
                            if (!$assertionsDisabled && !hasNext) {
                                throw new AssertionError();
                            }
                            Object obj = labSeq.getCell(0);
                            label = obj == null ? null : obj.toString();
                        }
                        pointStore.storePoint(datRow, errRow, label);
                        if (++ipoint % step != 0) continue;
                        if (progress != null) {
                            progress.setValue(ipoint);
                        }
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException();
                    }
                    if (!$assertionsDisabled && errSeq != null && errSeq.next()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && labSeq != null && labSeq.next()) {
                        throw new AssertionError();
                    }
                    var16_16 = null;
                    if (datSeq == null) break block28;
                }
                catch (Throwable throwable) {
                    var16_16 = null;
                    if (datSeq != null) {
                        if (!$assertionsDisabled && datSeq.next()) {
                            throw new AssertionError();
                        }
                        datSeq.close();
                    }
                    if (errSeq != null) {
                        if (!$assertionsDisabled && errSeq.next()) {
                            throw new AssertionError();
                        }
                        errSeq.close();
                    }
                    if (labSeq != null) {
                        if (!$assertionsDisabled && labSeq.next()) {
                            throw new AssertionError();
                        }
                        labSeq.close();
                    }
                    throw throwable;
                }
                if (!$assertionsDisabled && datSeq.next()) {
                    throw new AssertionError();
                }
                datSeq.close();
            }
            if (errSeq != null) {
                if (!$assertionsDisabled && errSeq.next()) {
                    throw new AssertionError();
                }
                errSeq.close();
            }
            if (labSeq == null) continue;
            if (!$assertionsDisabled && labSeq.next()) {
                throw new AssertionError();
            }
            labSeq.close();
            {
                continue;
            }
        }
        if (!$assertionsDisabled && ipoint != npoint) {
            throw new AssertionError();
        }
        return pointStore;
    }

    public Points getEmptyPoints() {
        return new EmptyPoints();
    }

    public RowSubset[] getSubsets() {
        return this.subsets_;
    }

    public Style[] getStyles() {
        return this.styles_;
    }

    public int getSetCount() {
        return this.subsets_.length;
    }

    public String getSetName(int iset) {
        return this.subsets_[iset].getName();
    }

    public Style getSetStyle(int iset) {
        return this.styles_[iset];
    }

    public int getNdim() {
        return this.points_.getNdim();
    }

    public int getNerror() {
        return this.points_.getNerror();
    }

    public boolean hasLabels() {
        return this.points_.hasLabels();
    }

    public PlotData createPlotData(final Points points) {
        return new WrapperPlotData(this){

            public int getNdim() {
                return points.getNdim();
            }

            public int getNerror() {
                return points.getNerror();
            }

            public boolean hasLabels() {
                return points.hasLabels();
            }

            public PointSequence getPointSequence() {
                return new SelectionPointSequence(points);
            }
        };
    }

    public PointSequence getPointSequence() {
        return new SelectionPointSequence(this.points_);
    }

    public void setPoints(Points points) {
        this.points_ = points;
    }

    public Points getPoints() {
        return this.points_;
    }

    public SetId[] getSetIds() {
        return this.setIds_;
    }

    public TopcatModel getPointTable(long ipoint) {
        for (int itab = 0; itab < this.nTable_; ++itab) {
            if (ipoint >= 0L && ipoint < this.nrows_[itab]) {
                return this.tcModels_[itab];
            }
            ipoint -= this.nrows_[itab];
        }
        return null;
    }

    public long getPointRow(long ipoint) {
        for (int itab = 0; itab < this.nTable_; ++itab) {
            if (ipoint >= 0L && ipoint < this.nrows_[itab]) {
                return ipoint;
            }
            ipoint -= this.nrows_[itab];
        }
        return -1L;
    }

    public long[] getPointsForRow(TopcatModel tcModel, long lrow) {
        ArrayList<Long> ipList = new ArrayList<Long>();
        long offset = 0L;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            if (this.tcModels_[itab] == tcModel) {
                ipList.add(new Long(offset + lrow));
            }
            offset += this.nrows_[itab];
        }
        long[] ips = new long[ipList.size()];
        for (int i = 0; i < ips.length; ++i) {
            ips[i] = (Long)ipList.get(i);
        }
        return ips;
    }

    public TableMask[] getTableMasks(BitSet pointMask) {
        int igrp;
        int[] starts = new int[this.nTable_];
        int[] ends = new int[this.nTable_];
        long offset = 0L;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            starts[itab] = (int)Math.min(offset, Integer.MAX_VALUE);
            ends[itab] = (int)Math.min(offset += this.nrows_[itab], Integer.MAX_VALUE);
        }
        ArrayList<TopcatModel> tableList = new ArrayList<TopcatModel>();
        ArrayList indexList = new ArrayList();
        for (int itab = 0; itab < this.nTable_; ++itab) {
            TopcatModel tcModel = this.tcModels_[itab];
            if (tcModel == null) continue;
            igrp = tableList.indexOf(tcModel);
            if (igrp < 0) {
                igrp = tableList.size();
                tableList.add(tcModel);
                indexList.add(new ArrayList());
            }
            ((List)indexList.get(igrp)).add(new Integer(itab));
        }
        int ngrp = tableList.size();
        if (!$assertionsDisabled && ngrp != indexList.size()) {
            throw new AssertionError();
        }
        ArrayList<TableMask> tableMaskList = new ArrayList<TableMask>();
        for (igrp = 0; igrp < ngrp; ++igrp) {
            TopcatModel tcModel = (TopcatModel)tableList.get(igrp);
            BitSet tMask = new BitSet();
            Integer[] ixs = ((List)indexList.get(igrp)).toArray(new Integer[0]);
            for (int iix = 0; iix < ixs.length; ++iix) {
                int itab = ixs[iix];
                tMask.or(pointMask.get(starts[itab], ends[itab]));
            }
            if (tMask.cardinality() <= 0) continue;
            tableMaskList.add(new TableMask(tcModel, tMask));
        }
        return tableMaskList.toArray(new TableMask[0]);
    }

    public boolean sameAxes(PointSelection other) {
        return other != null && Arrays.equals(this.dataTables_, other.dataTables_);
    }

    public boolean sameData(PointSelection other) {
        return other != null && Arrays.equals(this.dataTables_, other.dataTables_) && Arrays.equals(this.errorTables_, other.errorTables_) && Arrays.equals(this.errorModes_, other.errorModes_) && Arrays.equals(this.labelTables_, other.labelTables_);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof PointSelection)) {
            return false;
        }
        PointSelection other = (PointSelection)otherObject;
        return this.sameData(other) && Arrays.equals(this.subsets_, other.subsets_) && Arrays.equals(this.styles_, other.styles_);
    }

    public int hashCode() {
        int code = 555;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            code = 23 * code + this.dataTables_[itab].hashCode();
            code = 23 * code + (this.errorTables_[itab] == null ? 99 : this.errorTables_[itab].hashCode());
            code = 23 * code + (this.labelTables_[itab] == null ? 199 : this.labelTables_[itab].hashCode());
        }
        for (int ie = 0; ie < this.errorModes_.length; ++ie) {
            code = 23 * code + this.errorModes_[ie].hashCode();
        }
        for (int is = 0; is < this.subsets_.length; ++is) {
            code = 23 * code + this.subsets_[is].hashCode();
            code = 23 * code + this.styles_[is].hashCode();
        }
        return code;
    }

    static {
        $assertionsDisabled = !PointSelection.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat.plot");
    }

    private class EmptyPoints
    implements Points {
        private EmptyPoints() {
        }

        public int getNdim() {
            return PointSelection.this.ndim_;
        }

        public int getNerror() {
            return 0;
        }

        public int getCount() {
            return 0;
        }

        public double[] getPoint(int ipoint) {
            throw new IllegalArgumentException("no data");
        }

        public double[][] getErrors(int ipoint) {
            throw new IllegalArgumentException("no data");
        }

        public boolean hasLabels() {
            return false;
        }

        public String getLabel(int ipoint) {
            return null;
        }
    }

    private static class OffsetRowSubset
    implements RowSubset {
        private final RowSubset base_;
        private final long lolim_;
        private final long hilim_;
        private String name_;

        OffsetRowSubset(RowSubset base, long offset, long nrow, String name) {
            this.base_ = base;
            this.lolim_ = offset;
            this.hilim_ = offset + nrow - 1L;
            this.name_ = name;
        }

        public String getName() {
            return this.name_;
        }

        public boolean isIncluded(long lrow) {
            return lrow >= this.lolim_ && lrow <= this.hilim_ && this.base_.isIncluded(lrow - this.lolim_);
        }

        public boolean equals(Object o) {
            if (o instanceof OffsetRowSubset) {
                OffsetRowSubset other = (OffsetRowSubset)o;
                return this.base_.equals(other.base_) && this.name_.equals(other.name_) && this.lolim_ == other.lolim_ && this.hilim_ == other.hilim_;
            }
            return false;
        }

        public int hashCode() {
            int code = 555;
            code = 23 * code + this.base_.hashCode();
            code = 23 * code + this.name_.hashCode();
            code = 23 * code + (int)this.lolim_;
            code = 23 * code + (int)this.hilim_;
            return code;
        }
    }

    public static class TableMask {
        private final TopcatModel tcModel_;
        private final BitSet mask_;

        private TableMask(TopcatModel tcModel, BitSet mask) {
            this.tcModel_ = tcModel;
            this.mask_ = mask;
        }

        public TopcatModel getTable() {
            return this.tcModel_;
        }

        public BitSet getMask() {
            return this.mask_;
        }
    }

    private final class SelectionPointSequence
    implements PointSequence {
        private final Points psPoints_;
        private final int npoint_;
        private int ip_ = -1;

        SelectionPointSequence(Points points) {
            this.psPoints_ = points == null ? new EmptyPoints() : points;
            this.npoint_ = this.psPoints_.getCount();
        }

        public boolean next() {
            return ++this.ip_ < this.npoint_;
        }

        public double[] getPoint() {
            return this.psPoints_.getPoint(this.ip_);
        }

        public double[][] getErrors() {
            return this.psPoints_.getErrors(this.ip_);
        }

        public String getLabel() {
            return this.psPoints_.getLabel(this.ip_);
        }

        public boolean isIncluded(int iset) {
            return PointSelection.this.subsets_[iset].isIncluded(this.ip_);
        }

        public void close() {
            this.ip_ = Integer.MIN_VALUE;
        }
    }
}

