/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.CheckBoxStack;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.TablesListComboBoxModel;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.WeakTopcatListener;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.MutableStyleSet;
import uk.ac.starlink.topcat.plot.OrderedSelectionRecorder;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.StyleWindow;
import uk.ac.starlink.ttools.plot.EmptyIcon;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class PointSelector
extends JPanel {
    private final AxesSelector axesSelector_;
    private final JComboBox tableSelector_;
    private final JScrollPane subsetScroller_;
    private final JScrollPane entryScroller_;
    private final OrderedSelectionRecorder subSelRecorder_;
    private final SelectionForwarder selectionForwarder_;
    private final List topcatListeners_;
    private final Map subsetFluffs_;
    private final TopcatListener tcListener_;
    private final TopcatListener weakTcListener_;
    private final ActionForwarder actionForwarder_;
    private final ActionListener errorModeListener_;
    private MutableStyleSet styles_;
    private TopcatModel tcModel_;
    private ListSelectionModel subSelModel_;
    private StyleAnnotator annotator_;
    private StyleWindow styleWindow_;
    private String selectorLabel_;
    public static final String TABLE_CHANGED = "TABLE_CHANGED";
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$PointSelector;

    public PointSelector(AxesSelector axesSelector, MutableStyleSet styles) {
        super(new BorderLayout());
        this.axesSelector_ = axesSelector;
        this.styles_ = styles;
        this.subsetFluffs_ = new HashMap();
        this.actionForwarder_ = new ActionForwarder();
        this.selectionForwarder_ = new SelectionForwarder();
        ListSelectionListener listActioner = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PointSelector.this.actionForwarder_.actionPerformed(new ActionEvent(this, 0, "Selection"));
            }
        };
        this.errorModeListener_ = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (PointSelector.this.annotator_ != null) {
                    PointSelector.this.annotator_.updateStyles();
                }
            }
        };
        this.axesSelector_.addActionListener(this.actionForwarder_);
        this.topcatListeners_ = new ArrayList();
        Box controlBox = Box.createHorizontalBox();
        this.add((Component)controlBox, "South");
        this.tcListener_ = new TopcatListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void modelChanged(TopcatEvent evt) {
                if (!$assertionsDisabled && evt.getModel() != PointSelector.this.tcModel_) {
                    throw new AssertionError();
                }
                int code = evt.getCode();
                if (code == 4) {
                    PointSelector.this.setDefaultSubsetSelection();
                } else if (code == 7) {
                    RowSubset rset = (RowSubset)evt.getDatum();
                    OptionsListModel subsets = PointSelector.this.tcModel_.getSubsets();
                    int nrsets = subsets.size();
                    for (int is = 0; is < nrsets; ++is) {
                        if (subsets.get(is) != rset) continue;
                        PointSelector.this.subSelModel_.removeSelectionInterval(is, is);
                        PointSelector.this.subSelModel_.addSelectionInterval(is, is);
                    }
                }
                Iterator it = PointSelector.this.topcatListeners_.iterator();
                while (it.hasNext()) {
                    ((TopcatListener)it.next()).modelChanged(evt);
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$PointSelector == null ? (class$uk$ac$starlink$topcat$plot$PointSelector = PointSelector.class$("uk.ac.starlink.topcat.plot.PointSelector")) : class$uk$ac$starlink$topcat$plot$PointSelector).desiredAssertionStatus();
            }
        };
        this.weakTcListener_ = new WeakTopcatListener(this.tcListener_);
        final Box entryBox = new Box(1);
        this.entryScroller_ = new JScrollPane(entryBox){

            public boolean isValidateRoot() {
                return false;
            }

            public Dimension getPreferredSize() {
                Dimension size = new Dimension(entryBox.getPreferredSize());
                Insets insets = this.getInsets();
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
                if (this.getVerticalScrollBarPolicy() != 21) {
                    size.width += this.getVerticalScrollBar().getPreferredSize().width;
                }
                if (this.getHorizontalScrollBarPolicy() != 31) {
                    size.height += this.getHorizontalScrollBar().getPreferredSize().height;
                }
                return size;
            }
        };
        this.setHorizontalEntryScrolling(true);
        this.setVerticalEntryScrolling(false);
        this.entryScroller_.setBorder(AuxWindow.makeTitledBorder("Data"));
        controlBox.add(this.entryScroller_);
        controlBox.add(Box.createHorizontalStrut(5));
        TablesListComboBoxModel tablesModel = new TablesListComboBoxModel();
        this.tableSelector_ = new JComboBox(tablesModel);
        this.tableSelector_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TopcatModel tcModel = (TopcatModel)PointSelector.this.tableSelector_.getSelectedItem();
                if (tcModel == null) {
                    tcModel = TopcatModel.createDummyModel();
                }
                PointSelector.this.configureForTable(tcModel);
            }
        });
        this.tableSelector_.addActionListener(this.actionForwarder_);
        Box tPanel = Box.createHorizontalBox();
        tPanel.add(new JLabel(" Table: "));
        tPanel.add((Component)new ShrinkWrapper((Component)this.tableSelector_));
        tPanel.add(Box.createHorizontalGlue());
        entryBox.add(tPanel);
        JPanel colPanel = new JPanel();
        colPanel.setLayout(new BoxLayout(colPanel, 0));
        colPanel.add(this.axesSelector_.getColumnSelectorPanel());
        entryBox.add(colPanel);
        entryBox.add(Box.createVerticalGlue());
        this.subsetScroller_ = new JScrollPane(new CheckBoxStack()){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((PointSelector)PointSelector.this).entryScroller_.getPreferredSize().height);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.subsetScroller_.setBorder(AuxWindow.makeTitledBorder("Row Subsets"));
        controlBox.add(this.subsetScroller_);
        this.subSelRecorder_ = new OrderedSelectionRecorder(){

            public boolean[] getModelState() {
                return PointSelector.this.getSubsetSelection();
            }
        };
        this.selectionForwarder_.add(this.subSelRecorder_);
        this.selectionForwarder_.add(listActioner);
        TopcatModel tcModel = (TopcatModel)this.tableSelector_.getSelectedItem();
        if (tcModel != null) {
            this.configureForTable(tcModel);
        }
    }

    public AxesSelector getAxesSelector() {
        return this.axesSelector_;
    }

    public boolean isReady() {
        return this.axesSelector_.isReady();
    }

    public void setHorizontalEntryScrolling(boolean isScroll) {
        int policy = isScroll ? 30 : 31;
        this.entryScroller_.setHorizontalScrollBarPolicy(policy);
    }

    public void setVerticalEntryScrolling(boolean isScroll) {
        int policy = isScroll ? 20 : 21;
        this.entryScroller_.setVerticalScrollBarPolicy(policy);
    }

    public void setStyleWindow(StyleWindow styler) {
        this.styleWindow_ = styler;
    }

    public StyleWindow getStyleWindow() {
        return this.styleWindow_;
    }

    public void setLabel(String label) {
        this.selectorLabel_ = label;
    }

    public String getLabel() {
        return this.selectorLabel_;
    }

    public TopcatModel getTable() {
        return this.tcModel_;
    }

    public void setTable(TopcatModel tcModel, boolean init) {
        this.tableSelector_.setSelectedItem(tcModel);
        if (init) {
            this.axesSelector_.initialiseSelectors();
        }
    }

    public void setSubsetSelection(boolean[] selected) {
        this.subSelModel_.setValueIsAdjusting(true);
        this.subSelModel_.clearSelection();
        int nset = this.getTable().getSubsets().getSize();
        for (int i = 0; i < nset; ++i) {
            if (!selected[i]) continue;
            this.subSelModel_.addSelectionInterval(i, i);
        }
        this.subSelModel_.setValueIsAdjusting(false);
    }

    public boolean[] getSubsetSelection() {
        TopcatModel tcModel = this.getTable();
        if (tcModel == null) {
            return new boolean[0];
        }
        int nset = tcModel.getSubsets().getSize();
        boolean[] flags = new boolean[nset];
        for (int i = 0; i < nset; ++i) {
            flags[i] = this.subSelModel_.isSelectedIndex(i);
        }
        return flags;
    }

    public int[] getOrderedSubsetSelection() {
        return this.subSelRecorder_.getOrderedSelection();
    }

    public Style getStyle(int isub) {
        return this.styles_.getStyle(isub);
    }

    private void resetStyle(int isub, Style style, String label, boolean hidden) {
        this.styles_.setStyle(isub, style);
        this.subsetFluffs_.put(new Integer(isub), new SubsetFluff(label, hidden));
        this.annotator_.setStyleIcon(isub, style);
        this.actionForwarder_.actionPerformed(new ActionEvent(this, 0, "Style change"));
    }

    public StyleSet getStyles() {
        return this.styles_;
    }

    public void setStyles(MutableStyleSet styles) {
        this.styles_ = styles;
        if (this.annotator_ != null) {
            this.annotator_.resetStyles(this.styles_);
            StyleWindow swin = this.getStyleWindow();
            if (swin != null) {
                swin.dispose();
            }
        }
    }

    public Icon getStyleLegendIcon(Style style) {
        return style instanceof MarkStyle ? ((MarkStyle)style).getLegendIcon(this.axesSelector_.getErrorModes()) : style.getLegendIcon();
    }

    public ActionListener getErrorModeListener() {
        return this.errorModeListener_;
    }

    public void addActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionForwarder_.removeListener(listener);
    }

    public void addSubsetSelectionListener(ListSelectionListener listener) {
        this.selectionForwarder_.add(listener);
    }

    public void removeSubsetSelectionListener(ListSelectionListener listner) {
        this.selectionForwarder_.remove(listner);
    }

    public void addTopcatListener(TopcatListener listener) {
        this.topcatListeners_.add(listener);
    }

    public void removeTopcatListener(TopcatListener listener) {
        this.topcatListeners_.remove(listener);
    }

    public void configureForTable(TopcatModel tcModel) {
        if (this.tcModel_ != null) {
            this.tcModel_.removeTopcatListener(this.weakTcListener_);
            this.axesSelector_.setTable(null);
        }
        this.tcModel_ = tcModel;
        this.tcModel_.addTopcatListener(this.weakTcListener_);
        StyleWindow styler = this.getStyleWindow();
        if (styler != null) {
            styler.dispose();
        }
        OptionsListModel subsets = tcModel.getSubsets();
        DefaultListSelectionModel selModel = new DefaultListSelectionModel();
        this.annotator_ = new StyleAnnotator(subsets, selModel);
        CheckBoxStack subStack = new CheckBoxStack(subsets, this.annotator_);
        subStack.setSelectionModel(selModel);
        Component oldStack = this.subsetScroller_.getViewport().getView();
        if (oldStack instanceof CheckBoxStack) {
            ((CheckBoxStack)oldStack).setListModel(new DefaultListModel());
        }
        this.subsetScroller_.setViewportView(subStack);
        boolean oldMin = false;
        boolean oldMax = false;
        if (this.subSelModel_ != null) {
            this.subSelModel_.removeListSelectionListener(this.selectionForwarder_);
            ListSelectionEvent evt = new ListSelectionEvent(this.subSelModel_, this.subSelModel_.getMinSelectionIndex(), this.subSelModel_.getMaxSelectionIndex(), false);
            this.selectionForwarder_.forwardEvent(evt);
        }
        this.subSelModel_ = subStack.getSelectionModel();
        this.subSelModel_.addListSelectionListener(this.selectionForwarder_);
        this.setDefaultSubsetSelection();
        this.axesSelector_.setTable(tcModel);
        this.actionForwarder_.actionPerformed(new ActionEvent(this, 0, TABLE_CHANGED));
        this.revalidate();
        this.repaint();
    }

    private void editStyle(final int index) {
        StyleWindow styler = this.getStyleWindow();
        TopcatModel tcModel = this.getTable();
        final StyleAnnotator annotator = this.annotator_;
        final StyleEditor editor = styler.getEditor();
        styler.setTarget(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (PointSelector.this.annotator_ == annotator) {
                    PointSelector.this.resetStyle(index, editor.getStyle(), editor.getLabel(), editor.getHideLegend());
                }
            }
        });
        editor.setState(this.getStyle(index), this.getSubsetLabel(index), this.getSubsetHidden(index));
        editor.setSetId(new SetId(this, index));
        styler.show();
    }

    private String getSubsetLabel(int isub) {
        String label;
        SubsetFluff fluff = (SubsetFluff)this.subsetFluffs_.get(new Integer(isub));
        String string = label = fluff == null ? null : fluff.label_;
        if (label == null) {
            label = ((RowSubset)this.getTable().getSubsets().get(isub)).getName();
            if (this.selectorLabel_ != null) {
                label = this.selectorLabel_ + "." + label;
            }
        }
        return label;
    }

    public String getSubsetDisplayLabel(int isub) {
        return this.getSubsetHidden(isub) ? "" : this.getSubsetLabel(isub);
    }

    private boolean getSubsetHidden(int isub) {
        SubsetFluff fluff = (SubsetFluff)this.subsetFluffs_.get(new Integer(isub));
        return fluff != null && fluff.hidden_;
    }

    private void setDefaultSubsetSelection() {
        RowSubset currentSet = this.tcModel_.getSelectedSubset();
        OptionsListModel subsets = this.tcModel_.getSubsets();
        this.subSelModel_.setValueIsAdjusting(true);
        this.subSelModel_.clearSelection();
        int nrsets = subsets.size();
        for (int i = 0; i < nrsets; ++i) {
            if (subsets.get(i) != currentSet) continue;
            this.subSelModel_.addSelectionInterval(i, i);
        }
        this.subSelModel_.setValueIsAdjusting(false);
    }

    static /* synthetic */ void access$1100(PointSelector x0, int x1) {
        x0.editStyle(x1);
    }

    private class SelectionForwarder
    implements ListSelectionListener {
        final List listeners_ = new ArrayList();

        private SelectionForwarder() {
        }

        void add(ListSelectionListener listener) {
            this.listeners_.add(listener);
        }

        void remove(ListSelectionListener listener) {
            this.listeners_.remove(listener);
        }

        public void valueChanged(ListSelectionEvent evt) {
            this.forwardEvent(evt);
        }

        void forwardEvent(ListSelectionEvent evt) {
            ListSelectionEvent fEvt = new ListSelectionEvent(PointSelector.this, evt.getFirstIndex(), evt.getLastIndex(), evt.getValueIsAdjusting());
            Iterator it = this.listeners_.iterator();
            while (it.hasNext()) {
                ((ListSelectionListener)it.next()).valueChanged(fEvt);
            }
        }
    }

    private class StyleAnnotator
    implements CheckBoxStack.Annotator,
    ListSelectionListener {
        private final List list_;
        private final ListSelectionModel selModel_;
        private final Map actions_;
        private final Icon blankIcon_;

        StyleAnnotator(List list, ListSelectionModel selModel) {
            this.list_ = list;
            this.selModel_ = selModel;
            this.actions_ = new HashMap();
            this.selModel_.addListSelectionListener(this);
            Icon sampleIcon = PointSelector.this.getStyle(0).getLegendIcon();
            this.blankIcon_ = new EmptyIcon(sampleIcon.getIconWidth(), sampleIcon.getIconHeight());
        }

        public Component createAnnotation(Object item) {
            int ix = this.list_.indexOf(item);
            if (ix >= 0) {
                JButton butt = new JButton(this.getAction(ix));
                butt.setMargin(new Insets(0, 0, 0, 0));
                return butt;
            }
            return null;
        }

        void resetStyles(StyleSet styles) {
            Iterator it = this.actions_.keySet().iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                this.clearStyle(index);
            }
            this.valueChanged(null);
        }

        private Action getAction(int index) {
            Integer key = new Integer(index);
            if (!this.actions_.containsKey(key)) {
                BasicAction act = new BasicAction(this, null, this.blankIcon_, "Edit style for subset " + this.list_.get(index), index){
                    private final /* synthetic */ int val$index;
                    private final /* synthetic */ StyleAnnotator this$1;
                    {
                        this.this$1 = this$1;
                        this.val$index = val$index;
                        super(x0, x1, x2);
                    }

                    public void actionPerformed(ActionEvent evt) {
                        PointSelector.access$1100(StyleAnnotator.access$1000(this.this$1), this.val$index);
                    }
                };
                this.actions_.put(key, act);
            }
            return (Action)this.actions_.get(key);
        }

        public void valueChanged(ListSelectionEvent evt) {
            for (int i = this.selModel_.getMinSelectionIndex(); i <= this.selModel_.getMaxSelectionIndex(); ++i) {
                if (!this.selModel_.isSelectedIndex(i) || this.hasStyle(i)) continue;
                this.setStyleIcon(i, PointSelector.this.getStyle(i));
            }
        }

        public void updateStyles() {
            for (int i = 0; i < this.list_.size(); ++i) {
                if (!this.hasStyle(i)) continue;
                this.setStyleIcon(i, PointSelector.this.getStyle(i));
            }
        }

        void setStyleIcon(int index, Style style) {
            this.getAction(index).putValue("SmallIcon", PointSelector.this.getStyleLegendIcon(style));
        }

        private boolean hasStyle(int index) {
            Integer key = new Integer(index);
            return this.actions_.containsKey(key) && ((Action)this.actions_.get(key)).getValue("SmallIcon") != this.blankIcon_;
        }

        private void clearStyle(int index) {
            Integer key = new Integer(index);
            if (this.actions_.containsKey(key)) {
                ((Action)this.actions_.get(key)).putValue("SmallIcon", this.blankIcon_);
            }
        }

        static /* synthetic */ PointSelector access$1000(StyleAnnotator x0) {
            return x0.PointSelector.this;
        }
    }

    private static class SubsetFluff {
        final String label_;
        final boolean hidden_;

        SubsetFluff(String label, boolean hidden) {
            this.label_ = label;
            this.hidden_ = hidden;
        }
    }
}

