/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import gnu.jel.CompilationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ColumnDataComboBoxModel;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.TopcatForwarder;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.topcat.plot.StyleWindow;

public abstract class PointSelectorSet
extends JPanel {
    private final JTabbedPane tabber_ = new JTabbedPane();
    private final ActionForwarder actionForwarder_ = new ActionForwarder();
    private final TopcatForwarder topcatForwarder_ = new TopcatForwarder();
    private final OrderRecorder orderRecorder_;
    private final Action addSelectorAction_;
    private final Action removeSelectorAction_;
    private BitSet usedMarkers_;
    private int selectorsCreated_ = 0;
    private StyleWindow styleWindow_;
    public static final String MAIN_TAB_NAME = "Main";
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$PointSelectorSet;

    public PointSelectorSet() {
        super(new BorderLayout());
        this.add((Component)this.tabber_, "Center");
        this.addSelectorAction_ = new BasicAction("Add Dataset", ResourceIcon.ADD_TAB, "Add a new data set"){

            public void actionPerformed(ActionEvent evt) {
                PointSelector psel = PointSelectorSet.this.createSelector();
                PointSelectorSet.this.addNewSelector(psel);
            }
        };
        this.removeSelectorAction_ = new BasicAction("Remove Dataset", ResourceIcon.REMOVE_TAB, "Remove the current dataset"){

            public void actionPerformed(ActionEvent evt) {
                PointSelectorSet.this.removeCurrentSelector();
            }
        };
        this.removeSelectorAction_.setEnabled(false);
        this.tabber_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PointSelectorSet.this.removeSelectorAction_.setEnabled(PointSelectorSet.this.tabber_.getSelectedIndex() > 0);
            }
        });
        this.orderRecorder_ = new OrderRecorder();
        this.addActionListener(this.orderRecorder_);
    }

    public int getSelectorCount() {
        return this.tabber_.getTabCount();
    }

    public PointSelector getSelector(int index) {
        return (PointSelector)this.tabber_.getComponentAt(index);
    }

    public Action getAddSelectorAction() {
        return this.addSelectorAction_;
    }

    public Action getRemoveSelectorAction() {
        return this.removeSelectorAction_;
    }

    protected abstract PointSelector createSelector();

    protected abstract StyleEditor createStyleEditor();

    public StyleWindow getStyleWindow() {
        if (this.styleWindow_ == null) {
            Frame parent = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
            StyleEditor ed = this.createStyleEditor();
            this.styleWindow_ = new StyleWindow(parent, ed);
            this.styleWindow_.setTitle("Plot Style Editor");
        }
        return this.styleWindow_;
    }

    public PointSelection getPointSelection() {
        ArrayList<PointSelector> activeList = new ArrayList<PointSelector>();
        for (int i = 0; i < this.getSelectorCount(); ++i) {
            PointSelector psel = this.getSelector(i);
            if (!psel.isReady()) continue;
            activeList.add(psel);
        }
        PointSelector[] activeSelectors = activeList.toArray(new PointSelector[0]);
        int[][] subsetPointers = this.orderRecorder_.getSubsetPointers(activeSelectors);
        int nset = subsetPointers.length;
        String[] setLabels = new String[nset];
        for (int iset = 0; iset < nset; ++iset) {
            int isel = subsetPointers[iset][0];
            int itset = subsetPointers[iset][1];
            PointSelector psel = activeSelectors[isel];
            setLabels[iset] = psel.getSubsetDisplayLabel(itset);
        }
        return new PointSelection(activeSelectors, subsetPointers, setLabels);
    }

    public PointSelector getMainSelector() {
        return this.tabber_.getTabCount() > 0 ? this.getSelector(0) : null;
    }

    public void addNewSelector(PointSelector psel) {
        this.addSelector(psel);
        this.tabber_.setSelectedComponent(psel);
    }

    public void removeCurrentSelector() {
        if (this.tabber_.getSelectedIndex() != 0) {
            this.removeSelector((PointSelector)this.tabber_.getSelectedComponent());
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionForwarder_.removeListener(listener);
    }

    public void addTopcatListener(TopcatListener listener) {
        this.topcatForwarder_.addListener(listener);
    }

    public void removeTopcatListener(TopcatListener listener) {
        this.topcatForwarder_.removeListener(listener);
    }

    private void addSelector(PointSelector psel) {
        psel.setStyleWindow(this.getStyleWindow());
        String label = this.getNextTabName();
        if (!label.equals(MAIN_TAB_NAME)) {
            psel.setLabel(label);
        }
        this.tabber_.add(label, psel);
        psel.addActionListener(this.actionForwarder_);
        psel.addTopcatListener(this.topcatForwarder_);
        if (this.tabber_.getTabCount() > 1) {
            psel.addActionListener(new AxisDefaulter(psel));
        }
        if (psel.getTable() != null) {
            this.action();
        }
    }

    private void removeSelector(PointSelector psel) {
        this.tabber_.remove(psel);
        psel.removeActionListener(this.actionForwarder_);
        this.action();
    }

    private void action() {
        this.actionForwarder_.actionPerformed(new ActionEvent(this, 0, "State change"));
        this.tabber_.revalidate();
    }

    private String getNextTabName() {
        return this.selectorsCreated_++ == 0 ? MAIN_TAB_NAME : new String(new char[]{(char)(65 + this.selectorsCreated_ - 2)});
    }

    private class AxisDefaulter
    implements ActionListener {
        private final PointSelector mainPsel_;
        private final PointSelector psel_;
        static final /* synthetic */ boolean $assertionsDisabled;

        AxisDefaulter(PointSelector psel) {
            this.psel_ = psel;
            this.mainPsel_ = PointSelectorSet.this.getMainSelector();
            if (this.mainPsel_ == this.psel_) {
                throw new IllegalArgumentException("Bad/unnecessary idea");
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if ("TABLE_CHANGED".equals(evt.getActionCommand()) && this.mainPsel_.getTable() != null && this.mainPsel_.getTable() != this.psel_.getTable()) {
                JComboBox[] mainSelectors;
                JComboBox[] selectors = this.psel_.getAxesSelector().getColumnSelectors();
                if (selectors.length != (mainSelectors = this.mainPsel_.getAxesSelector().getColumnSelectors()).length) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return;
                }
                for (int i = 0; i < selectors.length; ++i) {
                    ColumnData cdata;
                    ComboBoxModel model;
                    Object item = mainSelectors[i].getSelectedItem();
                    if (item == null || !((model = selectors[i].getModel()) instanceof ColumnDataComboBoxModel)) continue;
                    ColumnDataComboBoxModel cmodel = (ColumnDataComboBoxModel)model;
                    try {
                        cdata = cmodel.stringToColumnData(item.toString());
                    }
                    catch (CompilationException e) {
                        cdata = null;
                    }
                    if (cdata == null) continue;
                    cmodel.setSelectedItem(cdata);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$PointSelectorSet == null ? (class$uk$ac$starlink$topcat$plot$PointSelectorSet = PointSelectorSet.class$("uk.ac.starlink.topcat.plot.PointSelectorSet")) : class$uk$ac$starlink$topcat$plot$PointSelectorSet).desiredAssertionStatus();
        }
    }

    private class OrderRecorder
    implements ActionListener {
        final Map flagMap_ = new WeakHashMap();
        final List order_ = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        private OrderRecorder() {
        }

        int[][] getSubsetPointers(PointSelector[] selectors) {
            ArrayList<int[]> resultList = new ArrayList<int[]>();
            Iterator it = this.order_.iterator();
            block0: while (it.hasNext()) {
                Item item = (Item)it.next();
                for (int isel = 0; isel < selectors.length; ++isel) {
                    if (item.sel_ != selectors[isel]) continue;
                    resultList.add(new int[]{isel, item.isub_});
                    continue block0;
                }
            }
            return (int[][])resultList.toArray((T[])new int[0][]);
        }

        public void updateState() {
            for (int isel = 0; isel < PointSelectorSet.this.getSelectorCount(); ++isel) {
                PointSelector sel = PointSelectorSet.this.getSelector(isel);
                boolean[] oldFlags = this.flagMap_.containsKey(sel) ? (boolean[])this.flagMap_.get(sel) : new boolean[]{};
                boolean[] newFlags = sel.getSubsetSelection();
                this.flagMap_.put(sel, newFlags);
                for (int isub = 0; isub < Math.max(oldFlags.length, newFlags.length); ++isub) {
                    boolean oldFlag = isub < oldFlags.length ? oldFlags[isub] : false;
                    boolean newFlag = isub < newFlags.length ? newFlags[isub] : false;
                    Item item = new Item(sel, isub);
                    if (!oldFlag && newFlag) {
                        if (!$assertionsDisabled && this.order_.contains(item)) {
                            throw new AssertionError();
                        }
                        this.order_.add(item);
                        continue;
                    }
                    if (oldFlag && !newFlag) {
                        if (!$assertionsDisabled && !this.order_.contains(item)) {
                            throw new AssertionError();
                        }
                        this.order_.remove(item);
                        if (!$assertionsDisabled && this.order_.contains(item)) {
                            throw new AssertionError();
                        }
                        continue;
                    }
                    if (!$assertionsDisabled && oldFlag != newFlag) {
                        throw new AssertionError();
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateState();
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$PointSelectorSet == null ? (class$uk$ac$starlink$topcat$plot$PointSelectorSet = PointSelectorSet.class$("uk.ac.starlink.topcat.plot.PointSelectorSet")) : class$uk$ac$starlink$topcat$plot$PointSelectorSet).desiredAssertionStatus();
        }

        private class Item {
            final PointSelector sel_;
            final int isub_;

            Item(PointSelector sel, int isub) {
                this.sel_ = sel;
                this.isub_ = isub;
            }

            public boolean equals(Object other) {
                return other instanceof Item && ((Item)other).sel_ == this.sel_ && ((Item)other).isub_ == this.isub_;
            }

            public int hashCode() {
                return this.sel_.hashCode() * 23 + this.isub_;
            }

            public String toString() {
                return PointSelectorSet.this.tabber_.getTitleAt(PointSelectorSet.this.tabber_.indexOfComponent(this.sel_)) + ":" + this.isub_;
            }
        }
    }
}

