/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.plot.PlotSurface;

public abstract class PositionReporter
implements MouseMotionListener {
    private static final double LOG10 = Math.log(10.0);
    private final DecimalFormat sciFormat_ = new DecimalFormat("0.#E0");
    private final DecimalFormat dpFormat_ = new DecimalFormat(".0");
    private final PlotSurface surface_;
    private final ValueConverter xConv_;
    private final ValueConverter yConv_;
    private final Map convMap_;

    public PositionReporter(PlotSurface surface) {
        this(surface, null, null);
    }

    public PositionReporter(PlotSurface surface, ValueConverter xConv, ValueConverter yConv) {
        this.surface_ = surface;
        this.xConv_ = xConv;
        this.yConv_ = yConv;
        this.convMap_ = new HashMap();
    }

    protected abstract void reportPosition(String[] var1);

    public void mouseMoved(MouseEvent evt) {
        this.reportPosition(this.formatPosition(evt.getX(), evt.getY()));
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public String[] formatPosition(int px, int py) {
        double[] dpos = this.surface_.graphicsToData(px, py, true);
        if (dpos == null) {
            return null;
        }
        double dx = dpos[0];
        double dy = dpos[1];
        if (Double.isNaN(dx) || Double.isInfinite(dx) || Double.isNaN(dy) || Double.isInfinite(dy)) {
            return null;
        }
        double ex = Double.NaN;
        double ey = Double.NaN;
        double[] epos = this.surface_.graphicsToData(px + 1, py + 1, true);
        if (epos != null) {
            ex = epos[0];
            ey = epos[1];
            if (Double.isInfinite(ex)) {
                ex = Double.NaN;
            }
            if (Double.isInfinite(ey)) {
                ey = Double.NaN;
            }
        }
        if ((Double.isNaN(ex) || Double.isNaN(ey)) && (epos = this.surface_.graphicsToData(px - 1, py - 1, true)) != null) {
            if (Double.isNaN(ex)) {
                ex = epos[0];
            }
            if (Double.isNaN(ey)) {
                ey = epos[1];
            }
        }
        if (Double.isNaN(ex) || Double.isNaN(ey)) {
            return null;
        }
        return new String[]{this.formatValue(dx, Math.abs(ex - dx), this.xConv_), this.formatValue(dy, Math.abs(ey - dy), this.yConv_)};
    }

    private String formatValue(double value, double precision) {
        precision = Math.abs(precision);
        double aval = Math.abs(value);
        int nsf = Math.max(0, (int)Math.round(-Math.log(precision / aval) / LOG10));
        if (aval >= 1000000.0) {
            this.sciFormat_.setMaximumFractionDigits(nsf);
            this.sciFormat_.setMinimumFractionDigits(nsf);
            return this.sciFormat_.format(value);
        }
        if (aval < 1.0E-4) {
            this.sciFormat_.setMaximumFractionDigits(nsf);
            this.sciFormat_.setMinimumFractionDigits(nsf);
            return this.sciFormat_.format(value);
        }
        if (precision >= 0.9) {
            return Integer.toString((int)Math.round(value));
        }
        int ndp = (int)Math.round(Math.max(0.0, -Math.log(precision)) / LOG10);
        if (ndp == 0) {
            return Integer.toString((int)Math.round(value));
        }
        this.dpFormat_.setMaximumFractionDigits(ndp);
        this.dpFormat_.setMinimumFractionDigits(ndp);
        return this.dpFormat_.format(value);
    }

    private String formatValue(double value, double precision, ValueConverter conv) {
        if (conv == null) {
            return this.formatValue(value, precision);
        }
        if (!this.convMap_.containsKey(conv)) {
            this.convMap_.put(conv, new Integer(0));
        }
        int itrunc = (Integer)this.convMap_.get(conv);
        Object om = conv.unconvert((Object)new Double(value - precision));
        Object o0 = conv.unconvert((Object)new Double(value));
        Object op = conv.unconvert((Object)new Double(value + precision));
        String fm = om == null ? "" : om.toString();
        String f0 = o0 == null ? "" : o0.toString();
        String fp = op == null ? "" : op.toString();
        int lm = fm.length();
        int l0 = f0.length();
        int lp = fp.length();
        boolean diffm = false;
        boolean diffp = false;
        for (int i = 0; i < l0; ++i) {
            int c0 = i < l0 ? (int)f0.charAt(i) : 32;
            int cm = i < lm ? (int)fm.charAt(i) : 32;
            int cp = i < lp ? (int)fm.charAt(i) : 32;
            diffm = diffm || cm != c0;
            boolean bl = diffp = diffp || cp != c0;
            if (!diffm || !diffp) continue;
            if (i + 1 > itrunc) {
                itrunc = i + 1;
                this.convMap_.put(conv, new Integer(i + 1));
            }
            return PositionReporter.truncate(f0, itrunc);
        }
        if (f0.length() > itrunc) {
            this.convMap_.put(conv, new Integer(f0.length()));
        }
        return f0;
    }

    private static String truncate(String full, int iafter) {
        char c;
        int i;
        for (i = iafter; i < full.length(); ++i) {
            c = full.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return full.substring(0, i);
        }
        for (i = iafter - 1; i >= 0; --i) {
            c = full.charAt(i);
            if (c == '.') {
                return full.substring(0, iafter);
            }
            if (c >= '0' && c <= '9') continue;
            return full;
        }
        return full;
    }
}

