/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import javax.swing.AbstractSpinnerModel;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import uk.ac.starlink.topcat.plot.RoundingSpinner;
import uk.ac.starlink.ttools.plot.Rounder;

public class RoundingSpinner
extends JSpinner {
    private boolean isLog_;

    public RoundingSpinner() {
        this.setModel(new RoundingSpinnerModel(this));
        this.setEditor(new NumberEditor(this));
    }

    public double getNumericValue() {
        return ((Number)this.getValue()).doubleValue();
    }

    public void setNumericValue(double value) {
        this.setValue(new Double(value));
    }

    public void setLogarithmic(boolean isLog) {
        this.isLog_ = isLog;
    }

    public boolean isLogarithmic() {
        return this.isLog_;
    }

    public void setModel(SpinnerModel model) {
        super.setModel((RoundingSpinnerModel)model);
        this.setValue(model.getValue());
    }

    private Rounder getRounder() {
        return this.isLog_ ? Rounder.LOG : Rounder.LINEAR;
    }

    private static class NumberEditor
    extends JSpinner.DefaultEditor {
        NumberEditor(JSpinner spinner) {
            super(spinner);
            this.getTextField().setEditable(true);
            this.getTextField().setHorizontalAlignment(4);
            this.getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(this){
                private final /* synthetic */ NumberEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    return new JFormattedTextField.AbstractFormatter(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object stringToValue(String text) {
                            return Double.valueOf(text);
                        }

                        public String valueToString(Object value) {
                            return String.valueOf(value);
                        }
                    };
                }
            });
        }
    }

    public static class RoundingSpinnerModel
    extends AbstractSpinnerModel {
        private final RoundingSpinner spinner_;
        private double value_;

        RoundingSpinnerModel(RoundingSpinner spinner) {
            this.spinner_ = spinner;
        }

        public Object getNextValue() {
            return new Double(this.spinner_.getRounder().nextUp(this.value_));
        }

        public Object getPreviousValue() {
            return new Double(this.spinner_.getRounder().nextDown(this.value_));
        }

        public Object getValue() {
            return new Double(this.value_);
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(Object val) {
            void var2_2;
            double value;
            if (val instanceof Number) {
                value = ((Number)val).doubleValue();
            } else if (val instanceof String) {
                value = Double.parseDouble((String)val);
            } else {
                throw new IllegalArgumentException("Wrong class " + val);
            }
            this.value_ = var2_2;
            this.fireStateChanged();
        }
    }
}

