/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.ttools.plot.Shader;

public class ShaderListCellRenderer
extends BasicComboBoxRenderer {
    private static final Map rendererIconMap_ = new HashMap();

    public ShaderListCellRenderer(final JComboBox comboBox) {
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ShaderListCellRenderer.this.setEnabled(comboBox.isEnabled());
                }
            }
        });
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSel, boolean hasFocus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSel, hasFocus);
        if (comp instanceof JLabel && value instanceof Shader) {
            JLabel label = (JLabel)comp;
            Shader shader = (Shader)value;
            String text = shader.getName();
            if (!shader.isAbsolute()) {
                text = "* " + text;
            }
            label.setText(text);
            label.setIcon(ShaderListCellRenderer.getRendererIcon(shader));
        }
        return comp;
    }

    private static Icon getRendererIcon(Shader shader) {
        if (!rendererIconMap_.containsKey(shader)) {
            Icon icon = shader.createIcon(true, 48, 16, 4, 1);
            rendererIconMap_.put(shader, ResourceIcon.toImageIcon(icon));
        }
        return (Icon)rendererIconMap_.get(shader);
    }
}

