/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.MarkStyleEditor;
import uk.ac.starlink.topcat.plot.Plot3DWindow;
import uk.ac.starlink.topcat.plot.PointSelection;
import uk.ac.starlink.topcat.plot.PointSelector;
import uk.ac.starlink.topcat.plot.Points;
import uk.ac.starlink.topcat.plot.SphericalAxesSelector;
import uk.ac.starlink.topcat.plot.SphericalPolarPointStore;
import uk.ac.starlink.topcat.plot.StyleEditor;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.SphericalPlot3D;
import uk.ac.starlink.ttools.plot.SphericalPlotState;
import uk.ac.starlink.util.WrapUtils;

public class SphereWindow
extends Plot3DWindow {
    private final ToggleButtonModel logToggler_;
    private final ToggleButtonModel tangentErrorToggler_;
    private final ToggleButtonModel radialToggler_ = new ToggleButtonModel("Radial Coordinates", ResourceIcon.RADIAL, "Plot points with radial as well as angular coordinates");
    private final ErrorModeSelectionModel radialErrorModeModel_;
    private final ErrorModeSelectionModel[] tangentErrorModeModels_;
    private final ErrorModeSelectionModel[] errorModeModels3d_;
    private static final ErrorRenderer[] ERROR_RENDERERS = ErrorRenderer.getOptionsSpherical();
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$SphereWindow;

    public SphereWindow(Component parent) {
        super("Spherical Plot", new String[]{"Longitude", "Latitude", "Radius"}, 3, parent, new ErrorModeSelectionModel[0], (Plot3D)SphereWindow.createPlot());
        this.radialToggler_.addActionListener(this.getReplotListener());
        this.logToggler_ = new ToggleButtonModel("Log", ResourceIcon.XLOG, "Scale radius value logarithmically");
        this.logToggler_.addActionListener(this.getReplotListener());
        this.tangentErrorToggler_ = new ToggleButtonModel("Tangent errors", SphereWindow.createTangentErrorIcon(), "Draw tangential error regions");
        this.tangentErrorToggler_.addActionListener(this.getReplotListener());
        this.tangentErrorModeModels_ = new ErrorModeSelectionModel[]{new ErrorModeSelectionModel(0, "Longitude"), new ErrorModeSelectionModel(1, "Latitude")};
        this.tangentErrorToggler_.addActionListener(new ActionListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void actionPerformed(ActionEvent evt) {
                ErrorMode mode;
                boolean hasTan = SphereWindow.this.tangentErrorToggler_.isSelected();
                ErrorMode errorMode = mode = hasTan ? ErrorMode.SYMMETRIC : ErrorMode.NONE;
                if (SphereWindow.this.tangentErrorModeModels_[0].getErrorMode() != mode) {
                    if (!$assertionsDisabled && SphereWindow.this.tangentErrorModeModels_[1].getErrorMode() == mode) {
                        throw new AssertionError();
                    }
                    SphereWindow.this.tangentErrorModeModels_[0].setMode(mode);
                    SphereWindow.this.tangentErrorModeModels_[1].setMode(mode);
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$SphereWindow == null ? (class$uk$ac$starlink$topcat$plot$SphereWindow = SphereWindow.class$("uk.ac.starlink.topcat.plot.SphereWindow")) : class$uk$ac$starlink$topcat$plot$SphereWindow).desiredAssertionStatus();
            }
        });
        this.radialErrorModeModel_ = new ErrorModeSelectionModel(2, "Radial");
        this.radialErrorModeModel_.addActionListener(this.getReplotListener());
        this.errorModeModels3d_ = new ErrorModeSelectionModel[]{this.tangentErrorModeModels_[0], this.tangentErrorModeModels_[1], this.radialErrorModeModel_};
        JMenu errorMenu = new JMenu("Errors");
        JMenuItem[] radialItems = this.radialErrorModeModel_.createMenuItems();
        for (int i = 0; i < radialItems.length; ++i) {
            errorMenu.add(radialItems[i]);
        }
        errorMenu.addSeparator();
        errorMenu.add(this.tangentErrorToggler_.createMenuItem());
        this.getJMenuBar().add(errorMenu);
        this.getNorthModel().setDescription("Select whether North pole is always vertical on the screen");
        this.getNorthModel().setSelected(true);
        this.getJMenuBar().add(this.createMarkerStyleMenu(SphereWindow.getStandardMarkStyleSets()));
        this.getJMenuBar().add(this.createErrorRendererMenu(ERROR_RENDERERS));
        this.getPointSelectorToolBar().addSeparator();
        this.getPointSelectorToolBar().add(this.radialToggler_.createToolbarButton());
        this.getPointSelectorToolBar().addSeparator();
        this.getPointSelectorToolBar().add(this.tangentErrorToggler_.createToolbarButton());
        this.getPointSelectorToolBar().add(this.radialErrorModeModel_.createOnOffToolbarButton());
        this.getToolBar().addSeparator();
        this.addHelp("SphereWindow");
    }

    public int getMainRangeCount() {
        return 1;
    }

    protected PlotState createPlotState() {
        SphericalPlotState state = new SphericalPlotState(){

            public PlotData getPlotData() {
                PlotData data = super.getPlotData();
                SphereWindow.this.adjustPlotData(this, data);
                return data;
            }
        };
        ValueInfo rInfo = SphereWindow.getSphericalAxesSelector(this.getPointSelectors().getMainSelector()).getRadialInfo();
        state.setRadialInfo(rInfo);
        if (rInfo != null) {
            state.setRadialLog(this.logToggler_.isSelected());
        }
        return state;
    }

    public PlotState getPlotState() {
        PlotState state = super.getPlotState();
        if (state.getValid()) {
            double[][] bounds = state.getRanges();
            int naux = state.getShaders().length;
            Range[] viewRanges = this.getViewRanges();
            Range[] dataRanges = this.getDataRanges();
            boolean[] logFlags = state.getLogFlags();
            boolean[] flipFlags = state.getFlipFlags();
            int mainNdim = this.getMainRangeCount();
            for (int i = 0; i < naux; ++i) {
                logFlags[mainNdim + i] = logFlags[3 + i];
                flipFlags[mainNdim + i] = flipFlags[3 + i];
                Range range = new Range(dataRanges[mainNdim + i]);
                range.limit(viewRanges[mainNdim + i]);
                bounds[mainNdim + i] = range.getFiniteBounds(logFlags[mainNdim + i]);
            }
        }
        return state;
    }

    protected PointSelector createPointSelector() {
        final SphericalAxesSelector sphaxsel = new SphericalAxesSelector(this.logToggler_, this.tangentErrorToggler_, this.radialErrorModeModel_);
        this.radialToggler_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                sphaxsel.setRadialVisible(SphereWindow.this.radialToggler_.isSelected());
            }
        });
        sphaxsel.setRadialVisible(this.radialToggler_.isSelected());
        AxesSelector axsel = this.addExtraAxes(sphaxsel);
        PointSelector psel = new PointSelector(axsel, this.getStyles());
        ActionListener errorModeListener = psel.getErrorModeListener();
        this.tangentErrorToggler_.addActionListener(errorModeListener);
        this.radialErrorModeModel_.addActionListener(errorModeListener);
        return psel;
    }

    protected StyleEditor createStyleEditor() {
        return new MarkStyleEditor(false, true, ERROR_RENDERERS, ErrorRenderer.DEFAULT, this.errorModeModels3d_);
    }

    public ErrorModeSelectionModel[] getErrorModeModels() {
        return this.errorModeModels3d_;
    }

    private static SphericalAxesSelector getSphericalAxesSelector(PointSelector psel) {
        return (SphericalAxesSelector)WrapUtils.getWrapped((Object)psel.getAxesSelector());
    }

    public static Icon createTangentErrorIcon() {
        ErrorMode[] modes = new ErrorMode[]{ErrorMode.SYMMETRIC, ErrorMode.SYMMETRIC};
        final Icon icon = ErrorRenderer.TANGENT.getLegendIcon(modes, 24, 24, 1, 4);
        return new Icon(){

            public int getIconHeight() {
                return icon.getIconHeight();
            }

            public int getIconWidth() {
                return icon.getIconWidth();
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color oldColor = g.getColor();
                g.setColor(Color.BLACK);
                icon.paintIcon(c, g, x, y);
                g.setColor(Color.WHITE);
                int radius = 2;
                g.drawOval(x + this.getIconWidth() / 2 - radius, y + this.getIconHeight() / 2 - radius, radius * 2, radius * 2);
                g.setColor(oldColor);
            }
        };
    }

    private static SphericalPlot3D createPlot() {
        return new SphericalPlot3D(){

            protected boolean paintMemoryError(OutOfMemoryError e) {
                TopcatUtils.memoryErrorLater(e);
                return true;
            }
        };
    }

    private void adjustPlotData(SphericalPlotState state, PlotData data) {
        Object basePoints;
        Points points;
        if (data instanceof PointSelection && (points = ((PointSelection)data).getPoints()) != null && (basePoints = WrapUtils.getWrapped((Object)points)) instanceof SphericalPolarPointStore) {
            SphericalPolarPointStore sphPoints = (SphericalPolarPointStore)basePoints;
            Dimension size = this.getPlot().getSize();
            int scale = Math.max(size.width, size.height);
            double minTanErr = 1.0 / ((double)scale * state.getZoomScale());
            sphPoints.setMinimumTanError(minTanErr);
        }
    }
}

