/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ColumnSelector;
import uk.ac.starlink.topcat.ToggleButtonModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisDataSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.ColumnDataTable;
import uk.ac.starlink.topcat.plot.ConstantColumnData;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.topcat.plot.SphericalPolarPointStore;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class SphericalAxesSelector
implements AxesSelector {
    private final JComponent colBox_;
    private final ColumnSelector phiSelector_;
    private final ColumnSelector thetaSelector_;
    private final AxisDataSelector rSelector_;
    private final JComponent rContainer_;
    private final ColumnSelector tanerrSelector_;
    private final ToggleButtonModel logToggler_;
    private final ToggleButtonModel tangentErrorToggler_;
    private final ErrorModeSelectionModel radialErrorModeModel_;
    private boolean radialVisible_;
    private TopcatModel tcModel_;
    private static final Pattern TANERR_UCD_REGEX = Pattern.compile("pos\\.angDistance|pos\\.angResolution|pos\\.errorEllipse|(stat\\.(error|stdev);pos\\.(eq|galactic|supergalactic|ecliptic|earth\\.l..)[.a-z]*)");
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$SphericalAxesSelector;

    public SphericalAxesSelector(ToggleButtonModel logToggler, ToggleButtonModel tangentErrorToggler, ErrorModeSelectionModel radialErrorModeModel) {
        int i;
        this.logToggler_ = logToggler;
        this.tangentErrorToggler_ = tangentErrorToggler;
        this.radialErrorModeModel_ = radialErrorModeModel;
        this.colBox_ = Box.createVerticalBox();
        String[] axisNames = new String[]{"Longitude", "Latitude"};
        JComponent[] selectors = new JComponent[axisNames.length];
        this.phiSelector_ = new ColumnSelector((ValueInfo)Tables.RA_INFO, false);
        this.phiSelector_.setTable(null);
        this.phiSelector_.setEnabled(false);
        selectors[0] = this.phiSelector_;
        this.thetaSelector_ = new ColumnSelector((ValueInfo)Tables.DEC_INFO, false);
        this.thetaSelector_.setTable(null);
        this.thetaSelector_.setEnabled(false);
        selectors[1] = this.thetaSelector_;
        Box tandatBox = Box.createVerticalBox();
        JLabel[] axLabels = new JLabel[axisNames.length];
        for (int i2 = 0; i2 < axisNames.length; ++i2) {
            String aName = axisNames[i2];
            Box cPanel = Box.createHorizontalBox();
            axLabels[i2] = new JLabel(" " + aName + " Axis: ");
            cPanel.add(axLabels[i2]);
            cPanel.add((Component)new ShrinkWrapper((Component)selectors[i2]));
            cPanel.add(Box.createHorizontalStrut(5));
            cPanel.add(Box.createHorizontalGlue());
            tandatBox.add(Box.createVerticalStrut(5));
            tandatBox.add(cPanel);
        }
        Box tanerrContainer = Box.createHorizontalBox();
        final Box tanerrBox = Box.createHorizontalBox();
        tanerrBox.add(Box.createVerticalGlue());
        tanerrBox.add(tanerrContainer);
        tanerrBox.add(Box.createVerticalGlue());
        DefaultValueInfo sizeInfo = new DefaultValueInfo("Angular Size", Number.class, "Angular size or error");
        sizeInfo.setUnitString("radians");
        sizeInfo.setNullable(true);
        this.tanerrSelector_ = new ColumnSelector((ValueInfo)sizeInfo, false);
        this.tanerrSelector_.setTable(null);
        this.tanerrSelector_.setEnabled(false);
        ChangeListener tanerrListener = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                tanerrBox.removeAll();
                if (SphericalAxesSelector.this.tangentErrorToggler_.isSelected()) {
                    tanerrBox.add(new JLabel(" +/- "));
                    tanerrBox.add((Component)new ShrinkWrapper((Component)SphericalAxesSelector.this.tanerrSelector_));
                }
            }
        };
        this.tangentErrorToggler_.addChangeListener(tanerrListener);
        tanerrListener.stateChanged(null);
        Box tanBox = Box.createHorizontalBox();
        tanBox.add((Component)new ShrinkWrapper((Component)tandatBox));
        tanBox.add((Component)new ShrinkWrapper((Component)tanerrBox));
        tanBox.add(Box.createHorizontalGlue());
        this.colBox_.add(tanBox);
        this.rSelector_ = new AxisDataSelector("Radial", new String[]{"Log"}, new ToggleButtonModel[]{logToggler});
        this.rSelector_.setEnabled(false);
        this.rSelector_.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.rContainer_ = Box.createVerticalBox();
        this.colBox_.add(this.rContainer_);
        this.radialErrorModeModel_.setEnabled(this.radialVisible_);
        Dimension labelSize = new Dimension(0, 0);
        for (i = 0; i < axisNames.length; ++i) {
            Dimension s = axLabels[i].getPreferredSize();
            labelSize.width = Math.max(labelSize.width, s.width);
            labelSize.height = Math.max(labelSize.height, s.height);
        }
        for (i = 0; i < axisNames.length; ++i) {
            axLabels[i].setPreferredSize(labelSize);
        }
        ActionListener radialErrorListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SphericalAxesSelector.this.rSelector_.setErrorMode(SphericalAxesSelector.this.radialErrorModeModel_.getErrorMode());
            }
        };
        this.radialErrorModeModel_.addActionListener(radialErrorListener);
        radialErrorListener.actionPerformed(null);
    }

    public JComponent getColumnSelectorPanel() {
        return this.colBox_;
    }

    public JComboBox[] getColumnSelectors() {
        return this.rSelector_.getSelectors();
    }

    public int getNdim() {
        return 3;
    }

    public boolean isReady() {
        return this.tcModel_ != null && this.getPhi() != null && this.getTheta() != null;
    }

    public StarTable getData() {
        return new SphericalPolarTable(this.tcModel_, this.getPhi(), this.getTheta(), this.getR());
    }

    public StarTable getErrorData() {
        ErrorMode radialMode;
        ArrayList<ConstantColumnData> colList = new ArrayList<ConstantColumnData>();
        boolean hasTanerr = this.tangentErrorToggler_.isSelected();
        ErrorMode errorMode = radialMode = this.radialVisible_ ? this.radialErrorModeModel_.getErrorMode() : ErrorMode.NONE;
        if (hasTanerr) {
            ColumnData tData = this.tanerrSelector_.getColumnData();
            colList.add(tData == null ? ConstantColumnData.ZERO : tData);
        }
        if (radialMode != ErrorMode.NONE) {
            JComboBox[] rErrorSelectors = this.rSelector_.getErrorSelectors();
            for (int isel = 0; isel < rErrorSelectors.length; ++isel) {
                ColumnData rData = (ColumnData)rErrorSelectors[isel].getSelectedItem();
                colList.add(rData == null ? ConstantColumnData.ZERO : rData);
            }
        }
        ColumnData[] eCols = colList.toArray(new ColumnData[0]);
        return new ColumnDataTable(this.tcModel_, eCols);
    }

    public StarTable getLabelData() {
        return null;
    }

    public PointStore createPointStore(int npoint) {
        boolean hasTanerr = this.tangentErrorToggler_.isSelected();
        ErrorMode radialMode = this.radialVisible_ ? this.radialErrorModeModel_.getErrorMode() : ErrorMode.NONE;
        boolean radialLog = this.logToggler_.isSelected();
        return new SphericalPolarPointStore(radialMode, hasTanerr, radialLog, npoint);
    }

    public ErrorMode[] getErrorModes() {
        boolean hasTan = this.tangentErrorToggler_.isSelected();
        ErrorMode[] modes = new ErrorMode[]{hasTan ? ErrorMode.SYMMETRIC : ErrorMode.NONE, hasTan ? ErrorMode.SYMMETRIC : ErrorMode.NONE, this.radialVisible_ ? this.radialErrorModeModel_.getErrorMode() : ErrorMode.NONE};
        return modes;
    }

    public AxisEditor[] createAxisEditors() {
        final AxisEditor ed = new AxisEditor("Radial"){

            public void setAxis(ValueInfo axis) {
                super.setAxis(axis);
                this.loField_.setText("");
                this.loField_.setEnabled(false);
            }

            protected double getHigh() {
                double hi = super.getHigh();
                return SphericalAxesSelector.this.logToggler_.isSelected() ? Math.log(hi) : hi;
            }
        };
        this.logToggler_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ed.clearBounds();
            }
        });
        this.rSelector_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColumnData cdata = (ColumnData)SphericalAxesSelector.this.rSelector_.getMainSelector().getSelectedItem();
                ed.setAxis((ValueInfo)(cdata == null ? null : cdata.getColumnInfo()));
            }
        });
        return new AxisEditor[]{ed};
    }

    public void setTable(TopcatModel tcModel) {
        if (tcModel == null) {
            this.phiSelector_.getModel().getColumnModel().setSelectedItem(null);
            this.phiSelector_.getModel().getConverterModel().setSelectedItem(null);
            this.thetaSelector_.getModel().getColumnModel().setSelectedItem(null);
            this.thetaSelector_.getModel().getConverterModel().setSelectedItem(null);
            this.tanerrSelector_.getModel().getColumnModel().setSelectedItem(null);
            this.tanerrSelector_.getModel().getConverterModel().setSelectedItem(null);
        } else {
            ColumnData tanerr;
            this.phiSelector_.setTable(tcModel);
            this.thetaSelector_.setTable(tcModel);
            this.tanerrSelector_.setTable(tcModel);
            if (this.tanerrSelector_.getColumnData() == null && (tanerr = SphericalAxesSelector.guessTanerrColumn(tcModel, this.tanerrSelector_.getModel().getColumnModel())) != null) {
                this.tanerrSelector_.setColumnData(tanerr);
            }
            if (this.tanerrSelector_.getColumnData() == null && (tanerr = SphericalAxesSelector.guessTanerrParam(tcModel)) != null) {
                this.tanerrSelector_.setColumnData(tanerr);
            }
        }
        this.rSelector_.setTable(tcModel);
        this.phiSelector_.setEnabled(tcModel != null);
        this.thetaSelector_.setEnabled(tcModel != null);
        this.tanerrSelector_.setEnabled(tcModel != null);
        this.rSelector_.setEnabled(tcModel != null);
        this.tcModel_ = tcModel;
    }

    public void initialiseSelectors() {
    }

    public void addActionListener(ActionListener listener) {
        this.thetaSelector_.addActionListener(listener);
        this.phiSelector_.addActionListener(listener);
        this.rSelector_.addActionListener(listener);
        this.tanerrSelector_.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.thetaSelector_.removeActionListener(listener);
        this.phiSelector_.removeActionListener(listener);
        this.rSelector_.removeActionListener(listener);
        this.tanerrSelector_.removeActionListener(listener);
    }

    public void setRadialVisible(boolean vis) {
        if (vis != this.radialVisible_) {
            if (vis) {
                this.rContainer_.add(this.rSelector_);
            } else {
                this.rContainer_.remove(this.rSelector_);
            }
            this.radialVisible_ = vis;
            this.rContainer_.revalidate();
        }
        this.radialErrorModeModel_.setEnabled(this.radialVisible_);
    }

    public ValueInfo getRadialInfo() {
        if (!this.radialVisible_) {
            return null;
        }
        ColumnData cdata = (ColumnData)this.rSelector_.getMainSelector().getSelectedItem();
        if (cdata == null) {
            return null;
        }
        if (this.logToggler_.isSelected()) {
            return new LogColumnData(cdata).getColumnInfo();
        }
        return cdata.getColumnInfo();
    }

    private ColumnData getPhi() {
        return this.phiSelector_.getColumnData();
    }

    private ColumnData getTheta() {
        return this.thetaSelector_.getColumnData();
    }

    private ColumnData getR() {
        if (!this.radialVisible_) {
            return ConstantColumnData.ONE;
        }
        ColumnData cdata = (ColumnData)this.rSelector_.getMainSelector().getSelectedItem();
        if (cdata == null) {
            return ConstantColumnData.ONE;
        }
        if (this.logToggler_.isSelected()) {
            return new LogColumnData(cdata);
        }
        return cdata;
    }

    private static ColumnData guessTanerrColumn(TopcatModel tcModel, ListModel colModel) {
        ColumnData bestCol = null;
        int bestScore = 0;
        for (int icol = 0; icol < colModel.getSize(); ++icol) {
            int score;
            ColumnData colData = (ColumnData)colModel.getElementAt(icol);
            if (colData == null || (score = SphericalAxesSelector.getTanerrLikeness((ValueInfo)colData.getColumnInfo())) <= bestScore) continue;
            bestScore = score;
            bestCol = colData;
        }
        return bestCol;
    }

    private static ColumnData guessTanerrParam(TopcatModel tcModel) {
        ParameterColumnData bestCol = null;
        int bestScore = 0;
        List paramList = tcModel.getDataModel().getParameters();
        Iterator it = paramList.iterator();
        while (it.hasNext()) {
            int score;
            DescribedValue dval = (DescribedValue)it.next();
            ValueInfo info = dval.getInfo();
            Object value = dval.getValue();
            if (!(value instanceof Number) || (score = SphericalAxesSelector.getTanerrLikeness(info)) <= bestScore) continue;
            bestScore = score;
            bestCol = new ParameterColumnData(dval);
        }
        return bestCol;
    }

    private static int getTanerrLikeness(ValueInfo info) {
        if (!Number.class.isAssignableFrom(info.getContentClass())) {
            return 0;
        }
        int score = 0;
        String ucd = info.getUCD();
        String units = info.getUnitString();
        if (ucd != null && TANERR_UCD_REGEX.matcher(ucd).matches()) {
            score += 3;
        }
        if (units != null) {
            if (units.matches("arcsec[a-z]*")) {
                score += 2;
            } else if (units.matches("arcmin[a-z]*")) {
                ++score;
            }
        }
        return score;
    }

    private static class ParameterColumnData
    extends ColumnData {
        private final String name_;
        private final Object value_;
        static final /* synthetic */ boolean $assertionsDisabled;

        ParameterColumnData(DescribedValue dval) {
            this.value_ = dval.getValue();
            ColumnInfo info = new ColumnInfo(dval.getInfo());
            info.setContentClass(dval.getClass());
            this.setColumnInfo(info);
            this.name_ = info.getName();
            if (!$assertionsDisabled && this.value_ == null) {
                throw new AssertionError();
            }
        }

        public Object readValue(long irow) {
            return this.value_;
        }

        public String toString() {
            return "param$" + this.name_;
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ParameterColumnData) {
                ParameterColumnData other = (ParameterColumnData)((Object)o);
                return other.value_.equals(this.value_);
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$SphericalAxesSelector == null ? (class$uk$ac$starlink$topcat$plot$SphericalAxesSelector = SphericalAxesSelector.class$("uk.ac.starlink.topcat.plot.SphericalAxesSelector")) : class$uk$ac$starlink$topcat$plot$SphericalAxesSelector).desiredAssertionStatus();
        }
    }

    private static class SphericalPolarTable
    extends AbstractStarTable {
        private final TopcatModel tcModel_;
        private final ColumnData phiData_;
        private final ColumnData thetaData_;
        private final ColumnData rData_;

        public SphericalPolarTable(TopcatModel tcModel, ColumnData phiData, ColumnData thetaData, ColumnData rData) {
            this.tcModel_ = tcModel;
            this.phiData_ = phiData;
            this.thetaData_ = thetaData;
            this.rData_ = rData;
        }

        public int getColumnCount() {
            return 3;
        }

        public long getRowCount() {
            return this.tcModel_.getDataModel().getRowCount();
        }

        public ColumnInfo getColumnInfo(int icol) {
            DefaultValueInfo info = new DefaultValueInfo((new String[]{"X", "Y", "Z"})[icol], class$java$lang$Double == null ? (class$java$lang$Double = SphericalAxesSelector.class$("java.lang.Double")) : class$java$lang$Double, "Cartesian coordinate " + (icol + 1));
            info.setUnitString(this.rData_.getColumnInfo().getUnitString());
            return new ColumnInfo((ValueInfo)info);
        }

        public RowSequence getRowSequence() {
            long nrow = this.getRowCount();
            return new RowSequence(this, nrow){
                long lrow_;
                Object[] row_;
                private final /* synthetic */ long val$nrow;
                private final /* synthetic */ SphericalPolarTable this$0;
                {
                    this.this$0 = this$0;
                    this.val$nrow = val$nrow;
                    this.lrow_ = 0L;
                }

                public boolean next() throws IOException {
                    if (this.lrow_ < this.val$nrow) {
                        double r;
                        this.row_ = new Object[3];
                        Object oPhi = SphericalPolarTable.access$500(this.this$0).readValue(this.lrow_);
                        Object oTheta = SphericalPolarTable.access$600(this.this$0).readValue(this.lrow_);
                        Object oR = SphericalPolarTable.access$700(this.this$0).readValue(this.lrow_);
                        if (oPhi instanceof Number && oTheta instanceof Number && oR instanceof Number && (r = ((Number)oR).doubleValue()) > 0.0) {
                            double phi = ((Number)oPhi).doubleValue();
                            double theta = ((Number)oTheta).doubleValue();
                            double sinTheta = Math.sin(theta);
                            double cosTheta = Math.cos(theta);
                            double sinPhi = Math.sin(phi);
                            double cosPhi = Math.cos(phi);
                            double x = r * cosTheta * cosPhi;
                            double y = r * cosTheta * sinPhi;
                            double z = r * sinTheta;
                            this.row_[0] = new Double(x);
                            this.row_[1] = new Double(y);
                            this.row_[2] = new Double(z);
                        }
                        ++this.lrow_;
                        return true;
                    }
                    return false;
                }

                public Object[] getRow() {
                    return this.row_;
                }

                public Object getCell(int icol) {
                    return this.row_[icol];
                }

                public void close() {
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof SphericalPolarTable) {
                SphericalPolarTable other = (SphericalPolarTable)((Object)o);
                return other.tcModel_.equals(this.tcModel_) && other.phiData_.equals(this.phiData_) && other.thetaData_.equals(this.thetaData_) && other.rData_.equals(this.rData_);
            }
            return false;
        }

        public int hashCode() {
            int code = 999;
            code = 23 * code + this.tcModel_.hashCode();
            code = 23 * code + this.phiData_.hashCode();
            code = 23 * code + this.thetaData_.hashCode();
            code = 23 * code + this.rData_.hashCode();
            return code;
        }

        static /* synthetic */ ColumnData access$500(SphericalPolarTable x0) {
            return x0.phiData_;
        }

        static /* synthetic */ ColumnData access$600(SphericalPolarTable x0) {
            return x0.thetaData_;
        }

        static /* synthetic */ ColumnData access$700(SphericalPolarTable x0) {
            return x0.rData_;
        }
    }

    private static class LogColumnData
    extends ColumnData {
        private final ColumnData base_;

        LogColumnData(ColumnData base) {
            this.base_ = base;
            ColumnInfo cinfo = new ColumnInfo(base.getColumnInfo());
            String units = cinfo.getUnitString();
            if (units != null && units.trim().length() > 0) {
                cinfo.setUnitString("log(" + units + ")");
            }
            cinfo.setName("log(" + cinfo.getName() + ")");
            cinfo.setContentClass(class$java$lang$Double == null ? (class$java$lang$Double = SphericalAxesSelector.class$("java.lang.Double")) : class$java$lang$Double);
            this.setColumnInfo(cinfo);
        }

        public Object readValue(long irow) throws IOException {
            Object val = this.base_.readValue(irow);
            if (val instanceof Number) {
                double dval = ((Number)val).doubleValue();
                return dval > 0.0 ? new Double(Math.log(dval)) : null;
            }
            return null;
        }

        public boolean equals(Object o) {
            return o instanceof LogColumnData ? this.base_.equals(((LogColumnData)((Object)o)).base_) : false;
        }

        public int hashCode() {
            return this.base_.hashCode() * 999;
        }
    }
}

