/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import uk.ac.starlink.table.ValueStore;
import uk.ac.starlink.table.storage.ArrayPrimitiveStore;
import uk.ac.starlink.topcat.plot.CartesianPointStore;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.Matrices;

public class SphericalPolarPointStore
implements PointStore {
    private final ValueStore valueStore_;
    private final boolean hasTanerr_;
    private final boolean radialLog_;
    private final int npoint_;
    private final int nword_;
    private final int ntanWord_;
    private final int nradWord_;
    private final int nerrorWord_;
    private final int nerror_;
    private final RadialPairReader radialReader_;
    private final double[] coordBuf_;
    private final double[] tanBuf_;
    private final double[] radBuf_;
    private final double[] point_;
    private final double[] centre_;
    private final double[] rawerrs_;
    private final double[][] errors_;
    private final double[] pair_;
    private final double[][] rpair_;
    private final double[] transMatrix_;
    private int ipoint_;
    private double minTanError_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SphericalPolarPointStore(ErrorMode radialMode, boolean hasTanerr, boolean radialLog, int npoint) {
        this.hasTanerr_ = hasTanerr;
        this.radialLog_ = radialLog;
        this.npoint_ = npoint;
        this.radialReader_ = SphericalPolarPointStore.getRadialPairReader(radialMode);
        this.ntanWord_ = hasTanerr ? 1 : 0;
        this.nradWord_ = this.radialReader_.getWordCount();
        this.nerrorWord_ = this.ntanWord_ + this.nradWord_;
        this.nword_ = 3 + this.nerrorWord_;
        this.nerror_ = (hasTanerr ? 4 : 0) + (radialMode == ErrorMode.NONE ? 0 : 2);
        this.coordBuf_ = new double[3];
        this.tanBuf_ = new double[this.ntanWord_];
        this.radBuf_ = new double[this.nradWord_];
        this.point_ = new double[3];
        this.centre_ = new double[3];
        this.rawerrs_ = new double[this.nerrorWord_];
        this.errors_ = new double[this.nerror_][];
        this.pair_ = new double[2];
        double[] rlo = new double[3];
        double[] rhi = new double[3];
        this.rpair_ = new double[][]{rlo, rhi};
        this.transMatrix_ = new double[9];
        this.valueStore_ = new ArrayPrimitiveStore(Double.TYPE, this.nword_ * this.npoint_);
        if (!$assertionsDisabled && !Double.TYPE.equals(this.valueStore_.getType())) {
            throw new AssertionError();
        }
    }

    public void storePoint(Object[] coordRow, Object[] errorRow, String label) {
        long ioff = (long)this.ipoint_ * (long)this.nword_;
        for (int i = 0; i < 3; ++i) {
            this.coordBuf_[i] = CartesianPointStore.doubleValue(coordRow[i]);
        }
        this.valueStore_.put(ioff, (Object)this.coordBuf_, 0, 3);
        ioff += 3L;
        int ierr = 0;
        if (this.ntanWord_ > 0) {
            for (int i = 0; i < this.ntanWord_; ++i) {
                this.tanBuf_[i] = CartesianPointStore.doubleValue(errorRow[ierr++]);
            }
            this.valueStore_.put(ioff, (Object)this.tanBuf_, 0, this.ntanWord_);
            ioff += (long)this.ntanWord_;
        }
        if (this.nradWord_ > 0) {
            double r = Math.sqrt(this.coordBuf_[0] * this.coordBuf_[0] + this.coordBuf_[1] * this.coordBuf_[1] + this.coordBuf_[2] * this.coordBuf_[2]);
            if (this.radialLog_) {
                r = Math.exp(r);
            }
            double r1 = 1.0 / r;
            for (int i = 0; i < this.nradWord_; ++i) {
                double delta;
                this.radBuf_[i] = (delta = CartesianPointStore.doubleValue(errorRow[ierr++])) > 0.0 ? (r + delta) * r1 : 1.0;
            }
            this.valueStore_.put(ioff, (Object)this.radBuf_, 0, this.nradWord_);
            ioff += (long)this.nradWord_;
        }
        ++this.ipoint_;
    }

    public int getCount() {
        return this.npoint_;
    }

    public int getNdim() {
        return 3;
    }

    public double[] getPoint(int ipoint) {
        this.valueStore_.get((long)ipoint * (long)this.nword_, (Object)this.point_, 0, 3);
        return this.point_;
    }

    public int getNerror() {
        return this.nerror_;
    }

    public double[][] getErrors(int ipoint) {
        if (this.nerror_ > 0) {
            long off = (long)ipoint * (long)this.nword_;
            this.valueStore_.get(off, (Object)this.centre_, 0, 3);
            off += 3L;
            if (this.ntanWord_ > 0) {
                this.valueStore_.get(off, (Object)this.tanBuf_, 0, this.ntanWord_);
                off += (long)this.ntanWord_;
            }
            if (this.nradWord_ > 0) {
                this.valueStore_.get(off, (Object)this.radBuf_, 0, this.nradWord_);
                off += (long)this.nradWord_;
            }
            this.calcErrors(this.centre_, this.tanBuf_, this.radBuf_, this.errors_);
        }
        return this.errors_;
    }

    public boolean hasLabels() {
        return false;
    }

    public String getLabel(int ipoint) {
        return null;
    }

    public void setMinimumTanError(double minTanError) {
        this.minTanError_ = Math.max(0.0, minTanError);
    }

    public void calcErrors(double[] centre, double[] tanErrs, double[] radErrs, double[][] errors) {
        int pointOff = 0;
        if (this.ntanWord_ > 0) {
            if (!$assertionsDisabled && this.ntanWord_ != 1) {
                throw new AssertionError();
            }
            double theta = tanErrs[0];
            this.calcTangentErrors(centre, theta, errors, pointOff);
            pointOff += 4;
        }
        if (this.nradWord_ > 0) {
            this.radialReader_.convert(radErrs, this.pair_);
            this.calcRadialErrors(centre, this.pair_, errors, pointOff);
            pointOff += 2;
        }
    }

    private void calcTangentErrors(double[] centre, double tanErr, double[][] points, int pointOff) {
        double[] rotmat;
        if (tanErr >= this.minTanError_ && (rotmat = this.transformFrom001(centre)) != null) {
            double s = Math.sin(tanErr);
            double c = Math.cos(tanErr);
            points[pointOff++] = Matrices.mvMult((double[])rotmat, (double[])new double[]{-s, 0.0, c});
            points[pointOff++] = Matrices.mvMult((double[])rotmat, (double[])new double[]{s, 0.0, c});
            points[pointOff++] = Matrices.mvMult((double[])rotmat, (double[])new double[]{0.0, -s, c});
            points[pointOff++] = Matrices.mvMult((double[])rotmat, (double[])new double[]{0.0, s, c});
        } else {
            points[pointOff++] = null;
            points[pointOff++] = null;
            points[pointOff++] = null;
            points[pointOff++] = null;
        }
    }

    private void calcRadialErrors(double[] centre, double[] posFacts, double[][] points, int pointOff) {
        double cx = centre[0];
        double cy = centre[1];
        double cz = centre[2];
        for (int iend = 0; iend < 2; ++iend) {
            double[] rerr;
            double posFact = posFacts[iend];
            if (posFact > 1.0) {
                double fe;
                double fact;
                rerr = this.rpair_[iend];
                if (!$assertionsDisabled && iend != 0 && iend != 1) {
                    throw new AssertionError();
                }
                double d = fact = iend == 0 ? Math.max(2.0 - posFact, 0.0) : posFact;
                if (this.radialLog_) {
                    double logR = Math.sqrt(cx * cx + cy * cy + cz * cz);
                    fe = Math.max(1.0 + Math.log(fact) / logR, 0.0);
                } else {
                    fe = fact;
                }
                rerr[0] = fe * cx;
                rerr[1] = fe * cy;
                rerr[2] = fe * cz;
            } else {
                rerr = null;
            }
            points[pointOff++] = rerr;
        }
    }

    private double[] transformFrom001(double[] point) {
        double px = point[0];
        double py = point[1];
        double pz = point[2];
        double r2 = px * px + py * py + pz * pz;
        if (r2 == 0.0) {
            return null;
        }
        double rCosTheta = pz;
        double rSinTheta = Math.sqrt(r2 - rCosTheta * rCosTheta);
        double cosPhi = px / rSinTheta;
        double sinPhi = py / rSinTheta;
        double r = Math.sqrt(r2);
        double cosTheta = rCosTheta / r;
        double sinTheta = rSinTheta / r;
        this.transMatrix_[0] = r * cosPhi * cosTheta;
        this.transMatrix_[1] = -r * sinPhi;
        this.transMatrix_[2] = r * cosPhi * sinTheta;
        this.transMatrix_[3] = r * sinPhi * cosTheta;
        this.transMatrix_[4] = r * cosPhi;
        this.transMatrix_[5] = r * sinPhi * sinTheta;
        this.transMatrix_[6] = -r * sinTheta;
        this.transMatrix_[7] = 0.0;
        this.transMatrix_[8] = r * cosTheta;
        return this.transMatrix_;
    }

    private static RadialPairReader getRadialPairReader(ErrorMode mode) {
        if (ErrorMode.SYMMETRIC.equals(mode)) {
            return new RadialPairReader(1){

                protected void convert(double[] rawErrors, double[] factors) {
                    double raw;
                    factors[0] = raw = rawErrors[0];
                    factors[1] = raw;
                }
            };
        }
        if (ErrorMode.LOWER.equals(mode)) {
            return new RadialPairReader(1){

                protected void convert(double[] rawErrors, double[] factors) {
                    factors[0] = rawErrors[0];
                    factors[1] = 1.0;
                }
            };
        }
        if (ErrorMode.UPPER.equals(mode)) {
            return new RadialPairReader(1){

                protected void convert(double[] rawErrors, double[] factors) {
                    factors[0] = 1.0;
                    factors[1] = rawErrors[0];
                }
            };
        }
        if (ErrorMode.BOTH.equals(mode)) {
            return new RadialPairReader(2){

                protected void convert(double[] rawErrors, double[] factors) {
                    factors[0] = rawErrors[0];
                    factors[1] = rawErrors[1];
                }
            };
        }
        if (!$assertionsDisabled && !ErrorMode.NONE.equals(mode)) {
            throw new AssertionError();
        }
        return new RadialPairReader(0){

            protected void convert(double[] rawErrors, double[] factors) {
                factors[0] = 1.0;
                factors[1] = 1.0;
            }
        };
    }

    static {
        $assertionsDisabled = !SphericalPolarPointStore.class.desiredAssertionStatus();
    }

    private static abstract class RadialPairReader {
        private final double[] buf_;

        public RadialPairReader(int wordCount) {
            this.buf_ = new double[wordCount];
        }

        public int getWordCount() {
            return this.buf_.length;
        }

        protected abstract void convert(double[] var1, double[] var2);
    }
}

