/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.topcat.ActionForwarder;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.plot.SetId;
import uk.ac.starlink.ttools.plot.Style;

public abstract class StyleEditor
extends JPanel
implements ActionListener,
ChangeListener {
    private final JLabel legendLabel_;
    private final JTextField labelField_;
    private final JCheckBox labelHider_;
    private final ActionForwarder actionForwarder_;
    private boolean initialised_;
    private SetId setId_;
    private Style initialStyle_;
    private String initialLabel_;
    private boolean initialHideLegend_;

    public StyleEditor() {
        this.setLayout(new BoxLayout(this, 1));
        this.actionForwarder_ = new ActionForwarder();
        this.legendLabel_ = new JLabel();
        this.labelField_ = new JTextField();
        this.labelField_.addActionListener(this);
        this.labelHider_ = new JCheckBox("Hide Legend");
        this.labelHider_.addActionListener(this);
        Box legendBox = Box.createHorizontalBox();
        legendBox.add(new JLabel("Icon: "));
        legendBox.add(this.legendLabel_);
        legendBox.add(Box.createHorizontalStrut(10));
        legendBox.add(new JLabel("Label: "));
        legendBox.add(this.labelField_);
        legendBox.add(Box.createHorizontalStrut(10));
        legendBox.add(this.labelHider_);
        legendBox.add(Box.createHorizontalGlue());
        legendBox.setBorder(AuxWindow.makeTitledBorder("Legend"));
        this.add(legendBox);
    }

    public void setVisible(boolean visible) {
        if (visible && !this.initialised_) {
            this.init();
            this.initialised_ = true;
        }
        super.setVisible(visible);
    }

    protected void init() {
        this.setState(null, "", false);
    }

    public void setState(Style style, String label, boolean hideLegend) {
        this.initialStyle_ = style;
        this.initialLabel_ = label;
        this.initialHideLegend_ = hideLegend;
        this.labelField_.setText(label);
        this.labelHider_.setSelected(hideLegend);
        this.setStyle(style);
        this.refreshState();
    }

    public abstract void setStyle(Style var1);

    public abstract Style getStyle();

    public abstract String getHelpID();

    public String getLabel() {
        return this.labelField_.getText();
    }

    public boolean getHideLegend() {
        return this.labelHider_.isSelected();
    }

    public void setSetId(SetId id) {
        this.setId_ = id;
        this.refreshState();
    }

    public SetId getSetId() {
        return this.setId_;
    }

    public void cancelChanges() {
        this.setState(this.initialStyle_, this.initialLabel_, this.initialHideLegend_);
    }

    public void addActionListener(ActionListener listener) {
        this.actionForwarder_.addListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionForwarder_.removeListener(listener);
    }

    public void actionPerformed(ActionEvent evt) {
        this.refreshState();
        this.actionForwarder_.actionPerformed(evt);
    }

    public void stateChanged(ChangeEvent evt) {
        this.refreshState();
        this.actionForwarder_.stateChanged(evt);
    }

    protected void refreshState() {
        this.legendLabel_.setIcon(this.getLegendIcon());
        this.labelField_.setEnabled(!this.labelHider_.isSelected());
        this.repaint();
    }

    public Icon getLegendIcon() {
        return this.getStyle().getLegendIcon();
    }

    public static ComboBoxModel createNumberedModel(int count) {
        Object[] items = new Object[count];
        for (int i = 0; i < count; ++i) {
            items[i] = new Integer(i);
        }
        return new DefaultComboBoxModel<Object>(items);
    }
}

