/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import uk.ac.starlink.topcat.HelpAction;
import uk.ac.starlink.topcat.plot.StyleEditor;

public class StyleWindow
extends JDialog {
    private final Frame parent_;
    private final StyleEditor editor_;
    private final Action cancelAction_;
    private final Action applyAction_;
    private final Action okAction_;
    private ActionListener target_;
    private boolean seen_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.topcat.plot");

    public StyleWindow(Frame parent, StyleEditor editor) {
        super(parent);
        this.parent_ = parent;
        this.editor_ = editor;
        this.editor_.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)editor, "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(new HelpAction(this.editor_.getHelpID(), this));
        toolBar.addSeparator();
        this.getContentPane().add((Component)toolBar, "North");
        Box buttonBox = Box.createHorizontalBox();
        this.cancelAction_ = new StyleAction("Cancel");
        this.applyAction_ = new StyleAction("Apply");
        this.okAction_ = new StyleAction("OK");
        this.editor_.addActionListener(this.applyAction_);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(new JButton(this.cancelAction_));
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(new JButton(this.okAction_));
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)buttonBox, "South");
        this.pack();
    }

    public void show() {
        if (!this.seen_) {
            this.positionNear(this.parent_);
            this.seen_ = true;
        }
        super.show();
    }

    private void positionNear(Frame parent) {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (gc.equals(parent.getGraphicsConfiguration())) {
            Rectangle ppos = parent.getBounds();
            int bot = ppos.y + ppos.height;
            int side = ppos.x + ppos.width;
            Rectangle dpos = this.getBounds();
            Rectangle screen = gc.getBounds();
            int y = bot - dpos.height;
            int x = Math.min(side - 10, screen.width - dpos.width);
            this.setLocation(x, y);
        }
    }

    public void setTarget(ActionListener target) {
        this.target_ = target;
    }

    public StyleEditor getEditor() {
        return this.editor_;
    }

    private class StyleAction
    extends AbstractAction {
        StyleAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == StyleWindow.this.cancelAction_) {
                StyleWindow.this.editor_.cancelChanges();
            }
            if ((this == StyleWindow.this.applyAction_ || this == StyleWindow.this.okAction_ || this == StyleWindow.this.cancelAction_) && StyleWindow.this.target_ != null) {
                StyleWindow.this.target_.actionPerformed(evt);
            }
            if (this == StyleWindow.this.cancelAction_ || this == StyleWindow.this.okAction_) {
                StyleWindow.this.dispose();
            }
        }
    }
}

