/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Rectangle;
import java.util.AbstractList;
import uk.ac.starlink.topcat.plot.AxisZoomRegion;
import uk.ac.starlink.topcat.plot.XYZoomRegion;
import uk.ac.starlink.topcat.plot.ZoomRegion;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.SurfacePlot;

public abstract class SurfaceZoomRegionList
extends AbstractList {
    private final SurfacePlot plot_;
    private final Rectangle display_;
    private final Rectangle xTarget_;
    private final Rectangle yTarget_;
    private final ZoomRegion[] regions_;
    private boolean ok_;

    public SurfaceZoomRegionList(SurfacePlot plot) {
        this.plot_ = plot;
        this.display_ = new Rectangle();
        this.xTarget_ = new Rectangle();
        this.yTarget_ = new Rectangle();
        this.regions_ = new ZoomRegion[]{new XYZoomRegion(this.display_){

            public void zoomed(double[][] bounds) {
                double[] dArray;
                double[] dArray2;
                double x0 = SurfaceZoomRegionList.this.vToX(bounds[0][0]);
                double x1 = SurfaceZoomRegionList.this.vToX(bounds[0][1]);
                double y0 = SurfaceZoomRegionList.this.vToY(bounds[1][0]);
                double y1 = SurfaceZoomRegionList.this.vToY(bounds[1][1]);
                PlotState state = SurfaceZoomRegionList.this.plot_.getState();
                boolean xflip = state.getFlipFlags()[0];
                boolean yflip = state.getFlipFlags()[1];
                double[][] dArrayArray = new double[2][];
                if (xflip) {
                    double[] dArray3 = new double[2];
                    dArray3[0] = x1;
                    dArray2 = dArray3;
                    dArray3[1] = x0;
                } else {
                    double[] dArray4 = new double[2];
                    dArray4[0] = x0;
                    dArray2 = dArray4;
                    dArray4[1] = x1;
                }
                dArrayArray[0] = dArray2;
                if (yflip) {
                    double[] dArray5 = new double[2];
                    dArray5[0] = y0;
                    dArray = dArray5;
                    dArray5[1] = y1;
                } else {
                    double[] dArray6 = new double[2];
                    dArray6[0] = y1;
                    dArray = dArray6;
                    dArray6[1] = y0;
                }
                dArrayArray[1] = dArray;
                SurfaceZoomRegionList.this.requestZoom(dArrayArray);
            }
        }, new AxisZoomRegion(true, this.xTarget_, this.display_){

            public void zoomed(double[][] bounds) {
                double[] dArray;
                double x0 = SurfaceZoomRegionList.this.vToX(bounds[0][0]);
                double x1 = SurfaceZoomRegionList.this.vToX(bounds[0][1]);
                boolean xflip = SurfaceZoomRegionList.this.plot_.getState().getFlipFlags()[0];
                double[][] dArrayArray = new double[2][];
                if (xflip) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = x1;
                    dArray = dArray2;
                    dArray2[1] = x0;
                } else {
                    double[] dArray3 = new double[2];
                    dArray3[0] = x0;
                    dArray = dArray3;
                    dArray3[1] = x1;
                }
                dArrayArray[0] = dArray;
                dArrayArray[1] = null;
                SurfaceZoomRegionList.this.requestZoom(dArrayArray);
            }
        }, new AxisZoomRegion(false, this.yTarget_, this.display_){

            public void zoomed(double[][] bounds) {
                double[] dArray;
                double y0 = SurfaceZoomRegionList.this.vToY(bounds[0][0]);
                double y1 = SurfaceZoomRegionList.this.vToY(bounds[0][1]);
                boolean yflip = SurfaceZoomRegionList.this.plot_.getState().getFlipFlags()[1];
                double[][] dArrayArray = new double[2][];
                dArrayArray[0] = null;
                if (yflip) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = y0;
                    dArray = dArray2;
                    dArray2[1] = y1;
                } else {
                    double[] dArray3 = new double[2];
                    dArray3[0] = y1;
                    dArray = dArray3;
                    dArray3[1] = y0;
                }
                dArrayArray[1] = dArray;
                SurfaceZoomRegionList.this.requestZoom(dArrayArray);
            }
        }};
    }

    protected abstract void requestZoom(double[][] var1);

    public int size() {
        return this.ok_ ? this.regions_.length : 0;
    }

    public Object get(int index) {
        return this.ok_ ? this.regions_[index] : null;
    }

    public void reconfigure() {
        Rectangle display = this.plot_.getSurface().getClip().getBounds();
        if (display != null) {
            this.ok_ = true;
            this.display_.x = display.x;
            this.display_.y = display.y;
            this.display_.width = display.width;
            this.display_.height = display.height;
            this.xTarget_.x = display.x;
            this.xTarget_.y = display.y + display.height;
            this.xTarget_.width = display.width;
            this.xTarget_.height = this.plot_.getHeight() - this.display_.y - this.display_.height;
            this.yTarget_.x = 0;
            this.yTarget_.y = display.y;
            this.yTarget_.width = display.x;
            this.yTarget_.height = display.height;
        } else {
            this.ok_ = false;
        }
    }

    private double vToX(double v) {
        int i = (int)Math.round((double)this.display_.x + v * (double)this.display_.width);
        return this.plot_.getSurface().graphicsToData(i, this.display_.y, false)[0];
    }

    private double vToY(double v) {
        int i = (int)Math.round((double)this.display_.y + v * (double)this.display_.height);
        return this.plot_.getSurface().graphicsToData(this.display_.x, i, false)[1];
    }
}

