/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ConstantColumn;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperColumn;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.plot.AxesSelector;
import uk.ac.starlink.topcat.plot.AxisEditor;
import uk.ac.starlink.topcat.plot.CartesianAxesSelector;
import uk.ac.starlink.topcat.plot.CartesianPointStore;
import uk.ac.starlink.topcat.plot.ColumnDataTable;
import uk.ac.starlink.topcat.plot.ErrorModeSelectionModel;
import uk.ac.starlink.topcat.plot.PointStore;
import uk.ac.starlink.ttools.plot.ErrorMode;

public class WeightedAxesSelector
implements AxesSelector {
    private final AxesSelector baseSelector_;
    private final CartesianAxesSelector weightSelector_;
    private final JComponent selectorContainer_;
    private final JComponent selectorPanel_;
    private boolean weightEnabled_;
    private static final ColumnData UNIT_WEIGHT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WeightedAxesSelector(AxesSelector baseSelector) {
        this.baseSelector_ = baseSelector;
        this.weightSelector_ = new CartesianAxesSelector(new String[]{"Weight"}, null, null, new ErrorModeSelectionModel[0]);
        this.selectorPanel_ = Box.createVerticalBox();
        this.selectorPanel_.add(this.baseSelector_.getColumnSelectorPanel());
        this.selectorContainer_ = Box.createHorizontalBox();
        this.selectorContainer_.add(Box.createRigidArea(new Dimension(0, 60)));
        this.selectorContainer_.add(this.selectorPanel_);
    }

    public void enableWeights(boolean weightEnabled) {
        JComponent weightPanel = this.weightSelector_.getColumnSelectorPanel();
        this.selectorPanel_.remove(weightPanel);
        if (weightEnabled) {
            this.selectorPanel_.add(weightPanel);
        }
        this.weightEnabled_ = weightEnabled;
        this.selectorContainer_.revalidate();
    }

    public JComboBox getWeightSelector() {
        return this.weightSelector_.getColumnSelector(0);
    }

    public JComponent getColumnSelectorPanel() {
        return this.selectorContainer_;
    }

    public JComboBox[] getColumnSelectors() {
        JComboBox[] baseSelectors = this.baseSelector_.getColumnSelectors();
        JComboBox[] weightSelectors = this.weightSelector_.getColumnSelectors();
        JComboBox[] selectors = new JComboBox[baseSelectors.length + weightSelectors.length];
        System.arraycopy(baseSelectors, 0, selectors, 0, baseSelectors.length);
        System.arraycopy(weightSelectors, 0, selectors, baseSelectors.length, weightSelectors.length);
        return selectors;
    }

    public void setTable(TopcatModel tcModel) {
        this.baseSelector_.setTable(tcModel);
        this.weightSelector_.setTable(tcModel);
    }

    public void initialiseSelectors() {
        this.baseSelector_.initialiseSelectors();
    }

    public void addActionListener(ActionListener listener) {
        this.baseSelector_.addActionListener(listener);
        this.weightSelector_.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.baseSelector_.removeActionListener(listener);
        this.weightSelector_.removeActionListener(listener);
    }

    public int getNdim() {
        return this.baseSelector_.getNdim() + 1;
    }

    public boolean isReady() {
        return this.baseSelector_.isReady();
    }

    public StarTable getData() {
        ColumnDataTable baseData = (ColumnDataTable)this.baseSelector_.getData();
        baseData.addColumn(this.getWeightData());
        return baseData;
    }

    public StarTable getErrorData() {
        StarTable errorData = this.baseSelector_.getErrorData();
        if (!$assertionsDisabled && errorData.getColumnCount() != 0) {
            throw new AssertionError((Object)"Weighting of errors is not implemented");
        }
        return errorData;
    }

    public StarTable getLabelData() {
        return this.baseSelector_.getLabelData();
    }

    public AxisEditor[] createAxisEditors() {
        return this.baseSelector_.createAxisEditors();
    }

    public PointStore createPointStore(int npoint) {
        return new CartesianPointStore(this.getNdim(), this.getErrorModes(), npoint);
    }

    public ErrorMode[] getErrorModes() {
        return this.baseSelector_.getErrorModes();
    }

    public boolean hasWeights() {
        return this.weightEnabled_ && this.weightSelector_.getColumnSelector(0).getSelectedItem() != null;
    }

    private ColumnData getWeightData() {
        if (this.hasWeights()) {
            final ColumnData cdata = (ColumnData)this.weightSelector_.getColumnSelector(0).getSelectedItem();
            final ColumnInfo info = new ColumnInfo(cdata.getColumnInfo());
            info.setName("Weighted count");
            return new WrapperColumn(cdata){

                public ColumnInfo getColumnInfo() {
                    return info;
                }

                public boolean equals(Object other) {
                    return other instanceof WrapperColumn ? this.getBaseColumn().equals(((WrapperColumn)other).getBaseColumn()) : super.equals(other);
                }

                public int hashCode() {
                    return cdata.hashCode();
                }
            };
        }
        return UNIT_WEIGHT;
    }

    static {
        $assertionsDisabled = !WeightedAxesSelector.class.desiredAssertionStatus();
        UNIT_WEIGHT = new ConstantColumn(new ColumnInfo("Unity", Integer.class, "Unit weight"), (Object)new Integer(1));
    }
}

