/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.topcat.plot.ZoomDrag;
import uk.ac.starlink.topcat.plot.ZoomRegion;

public abstract class XYZoomRegion
extends ZoomRegion {
    private static final int BOX = 32;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$XYZoomRegion;

    public XYZoomRegion(Rectangle display) {
        this.setDisplay(display);
        this.setTarget(display);
    }

    public ZoomDrag createDrag(Component comp, Point start) {
        return new XyDrag(comp, start);
    }

    private class XyDrag
    implements ZoomDrag {
        final Graphics g_;
        final Point start_;
        final Point origin_;
        Boolean sense_;
        Point last_;
        static final /* synthetic */ boolean $assertionsDisabled;

        XyDrag(Component comp, Point start) {
            this.g_ = comp.getGraphics();
            this.start_ = start;
            this.origin_ = comp.getLocation();
            this.g_.setXORMode(Color.YELLOW);
        }

        public void dragTo(Point point) {
            Boolean dSense = point.x > this.start_.x && point.y > this.start_.y ? Boolean.TRUE : (point.x < this.start_.x && point.y < this.start_.y ? Boolean.FALSE : null);
            if (this.sense_ != null || dSense != null) {
                if (this.sense_ == null) {
                    this.sense_ = dSense;
                } else {
                    if (!$assertionsDisabled && this.last_ == null) {
                        throw new AssertionError();
                    }
                    this.xorRegion(this.start_, this.last_);
                }
                if (!$assertionsDisabled && this.sense_ == null) {
                    throw new AssertionError();
                }
                this.last_ = this.sense_.equals(dSense) ? point : this.start_;
                this.xorRegion(this.start_, this.last_);
            }
        }

        public double[][] boundsAt(Point end) {
            if (this.sense_ != null) {
                Rectangle zone = new Rectangle(XYZoomRegion.this.getDisplay());
                zone.translate(-this.origin_.x, -this.origin_.y);
                this.xorRegion(this.start_, this.last_);
                if (this.sense_.booleanValue()) {
                    Object object;
                    double x0 = (double)(this.start_.x - zone.x) / (double)zone.width;
                    double y0 = (double)(this.start_.y - zone.y) / (double)zone.height;
                    double x1 = (double)(end.x - zone.x) / (double)zone.width;
                    double y1 = (double)(end.y - zone.y) / (double)zone.height;
                    if (x1 > x0 && y1 > y0) {
                        double[][] dArrayArray = new double[2][];
                        dArrayArray[0] = new double[]{x0, x1};
                        object = dArrayArray;
                        dArrayArray[1] = new double[]{y0, y1};
                    } else {
                        object = null;
                    }
                    return object;
                }
                int dx = this.start_.x - end.x;
                int dy = this.start_.y - end.y;
                if (dx >= 0 && dy > 0 || dx > 0 && dy >= 0) {
                    double xrange = (double)(2 * dx + 32) / 32.0;
                    double yrange = (double)(2 * dy + 32) / 32.0;
                    double cx = (double)(this.start_.x - zone.x) / (double)zone.width;
                    double cy = (double)(this.start_.y - zone.y) / (double)zone.height;
                    double x0 = cx - xrange * 0.5;
                    double y0 = cy - yrange * 0.5;
                    double x1 = cx + xrange * 0.5;
                    double y1 = cy + yrange * 0.5;
                    return new double[][]{{x0, x1}, {y0, y1}};
                }
                return null;
            }
            return null;
        }

        private void xorRegion(Point p0, Point p1) {
            if (this.sense_.booleanValue()) {
                this.g_.drawRect(Math.min(p0.x, p1.x), Math.min(p0.y, p1.y), Math.abs(p1.x - p0.x), Math.abs(p1.y - p0.y));
            } else {
                int x0 = p0.x;
                int y0 = p0.y;
                int xrange = Math.abs(p1.x - p0.x);
                int yrange = Math.abs(p1.y - p0.y);
                this.g_.drawRect(x0 - 16, y0 - 16, 32, 32);
                this.g_.drawRect(x0 - 16 - xrange, y0 - 16 - yrange, 32 + xrange * 2, 32 + yrange * 2);
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$plot$XYZoomRegion == null ? (class$uk$ac$starlink$topcat$plot$XYZoomRegion = XYZoomRegion.class$("uk.ac.starlink.topcat.plot.XYZoomRegion")) : class$uk$ac$starlink$topcat$plot$XYZoomRegion).desiredAssertionStatus();
        }
    }
}

