/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.plot;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.MouseInputAdapter;
import uk.ac.starlink.topcat.plot.ZoomDrag;
import uk.ac.starlink.topcat.plot.ZoomRegion;

public class Zoomer
extends MouseInputAdapter {
    private List regionList_ = new ArrayList();
    private ZoomDrag drag_;
    private ZoomRegion dragRegion_;
    private Component cursorComponent_;

    public List getRegions() {
        return this.regionList_;
    }

    public void setRegions(List regionList) {
        this.regionList_ = regionList;
    }

    public void setCursorComponent(Component comp) {
        this.cursorComponent_ = comp;
    }

    public void mousePressed(MouseEvent evt) {
        if (evt.getButton() == 1 && this.drag_ == null) {
            Iterator it = this.regionList_.iterator();
            while (it.hasNext()) {
                ZoomRegion region = (ZoomRegion)it.next();
                Point point = this.getPoint(evt);
                if (region.getTarget() == null || !region.getTarget().contains(point)) continue;
                this.drag_ = region.createDrag((Component)evt.getSource(), point);
                this.dragRegion_ = region;
                return;
            }
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.configureCursor(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.drag_ != null) {
            this.drag_.dragTo(this.getPoint(evt));
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.drag_ != null) {
            double[][] zoomBounds = this.drag_.boundsAt(this.getPoint(evt));
            if (zoomBounds != null) {
                this.dragRegion_.zoomed(zoomBounds);
            }
            this.drag_ = null;
            this.dragRegion_ = null;
        }
        this.configureCursor(evt);
    }

    private Point getPoint(MouseEvent evt) {
        Point point = new Point(evt.getPoint());
        Point offset = ((Component)evt.getSource()).getLocation();
        point.translate(offset.x, offset.y);
        return point;
    }

    private void configureCursor(MouseEvent evt) {
        Component cursorComponent;
        Component component = cursorComponent = this.cursorComponent_ != null ? this.cursorComponent_ : (Component)evt.getSource();
        if (cursorComponent != null) {
            Point p = this.getPoint(evt);
            Iterator it = this.regionList_.iterator();
            while (it.hasNext()) {
                ZoomRegion region = (ZoomRegion)it.next();
                if (!region.getTarget().contains(p)) continue;
                cursorComponent.setCursor(region.getCursor());
                return;
            }
            cursorComponent.setCursor(null);
        }
    }
}

