/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat.soap;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.soap.AppHttpSOAPServer;
import uk.ac.starlink.soap.util.RemoteUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.topcat.ControlWindow;

public class TopcatSOAPServer {
    public static final String APP_NAME = "topcat";
    public static final int DEFAULT_PORT = 8085;
    private static TopcatSOAPServer instance_;
    private static final Logger logger_;
    private final ControlWindow control_;
    private final AppHttpSOAPServer server_;
    private final int port_;
    private final String cookie_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TopcatSOAPServer(ControlWindow control) throws Exception {
        this.control_ = control;
        URL deployURL = TopcatSOAPServer.class.getResource("topcat.wsdd");
        this.server_ = new AppHttpSOAPServer(8085);
        this.server_.start();
        this.server_.addSOAPService(deployURL);
        this.port_ = this.server_.getPort();
        logger_.info("SOAP services offered on port " + this.port_);
        this.cookie_ = RemoteUtilities.writeContactFile((int)this.port_, (String)APP_NAME);
    }

    public void displayTableByLocation(String cookie, String location, String handler) throws IOException {
        this.checkCookie(cookie);
        StarTableFactory factory = this.control_.getTableFactory();
        if (!$assertionsDisabled && !factory.requireRandom()) {
            throw new AssertionError();
        }
        StarTable table = factory.makeStarTable(location, handler);
        this.addRandomTable(table, location);
    }

    public void displayTable(String cookie, StarTable table, String location) throws IOException {
        this.checkCookie(cookie);
        table = this.control_.getTableFactory().randomTable(table);
        this.addRandomTable(table, location);
    }

    private void addRandomTable(final StarTable table, final String location) {
        if (!$assertionsDisabled && !table.isRandom()) {
            throw new AssertionError();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopcatSOAPServer.this.control_.addTable(table, location, true);
            }
        });
    }

    private void checkCookie(String cookie) throws IOException {
        if (cookie == null || !cookie.equals(this.cookie_)) {
            throw new IOException("Attempt to call SOAP service with bad cookie");
        }
    }

    public static void initServices(ControlWindow controlWindow) {
        try {
            instance_ = new TopcatSOAPServer(controlWindow);
        }
        catch (Exception e) {
            logger_.warning("SOAP service unavailable: " + e);
        }
    }

    public static TopcatSOAPServer getInstance() {
        return instance_;
    }

    static {
        $assertionsDisabled = !TopcatSOAPServer.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat.soap");
    }
}

