/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.pha.sdss.fits;

import edu.jhu.pha.sdss.fits.FITSImage;
import edu.jhu.pha.sdss.fits.Histogram;
import edu.jhu.pha.sdss.fits.ScaleUtils;
import edu.jhu.pha.sdss.fits.SlowScaleUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferUShort;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;

public class SlowFITSImage
extends FITSImage {
    protected Fits _fits;
    protected ImageHDU _imageHDU;
    protected BasicHDU[] _hdus;
    protected int _scaleMethod;
    protected short[] _scaledData = null;
    protected double _sigma = Double.NaN;
    protected double _min = Double.NaN;
    protected double _max = Double.NaN;
    protected Histogram _histogram;
    protected BufferedImage _delegate;

    public SlowFITSImage(Fits fits) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(fits, 0);
    }

    public SlowFITSImage(Fits fits, int scaleMethod) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(fits, SlowFITSImage.createScaledImage(fits, scaleMethod), scaleMethod);
    }

    public SlowFITSImage(Fits fits, BufferedImage delegate, int scaleMethod) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        super(delegate.getColorModel(), delegate.getRaster().createCompatibleWritableRaster(), true, (Hashtable)null);
        this.setFits(fits);
        this.setHistogram((Histogram)delegate.getProperty("histogram"));
        this.setDelegate(delegate);
        this._scaleMethod = scaleMethod;
        this._scaledData = (short[])delegate.getProperty("scaledData");
        ImageHDU imageHDU = (ImageHDU)delegate.getProperty("imageHDU");
        if (imageHDU == null || !(imageHDU instanceof ImageHDU)) {
            imageHDU = SlowFITSImage.findFirstImageHDU(fits);
        }
        this.setImageHDU(imageHDU);
        this._min = this.getHistogram().getMin();
        this._max = this.getHistogram().getMax();
        this._sigma = this.getHistogram().estimateSigma();
    }

    public SlowFITSImage(File file) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(new Fits(file));
    }

    public SlowFITSImage(File file, int scaleMethod) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(new Fits(file), scaleMethod);
    }

    public SlowFITSImage(String filename) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(new Fits(filename));
    }

    public SlowFITSImage(String filename, int scaleMethod) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(new Fits(filename), scaleMethod);
    }

    public SlowFITSImage(URL url) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(new Fits(url));
    }

    public SlowFITSImage(URL url, int scaleMethod) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        this(new Fits(url), scaleMethod);
    }

    public static String[] getScaleNames() {
        return ScaleUtils.getScaleNames();
    }

    public Fits getFits() {
        return this._fits;
    }

    public ImageHDU getImageHDU() {
        return this._imageHDU;
    }

    protected void setHistogram(Histogram histogram) {
        this._histogram = histogram;
    }

    public Histogram getHistogram() {
        return this._histogram;
    }

    public double getOriginalValue(int x, int y) throws FitsException {
        double result = Double.NaN;
        double bZero = this.getImageHDU().getBZero();
        double bScale = this.getImageHDU().getBScale();
        Object data = this.getImageHDU().getData().getData();
        switch (this.getImageHDU().getBitPix()) {
            case 8: {
                int dataVal = ((byte[][])data)[y][x];
                if (dataVal < 0) {
                    dataVal += 256;
                }
                result = bZero + bScale * (double)dataVal;
                break;
            }
            case 16: {
                result = bZero + bScale * (double)((short[][])data)[y][x];
                break;
            }
            case 32: {
                result = bZero + bScale * (double)((int[][])data)[y][x];
                break;
            }
            case -32: {
                result = bZero + bScale * (double)((float[][])data)[y][x];
                break;
            }
            case -64: {
                result = bZero + bScale * ((double[][])data)[y][x];
                break;
            }
        }
        return result;
    }

    public int getScaleMethod() {
        return this._scaleMethod;
    }

    public void setScaleMethod(int scaleMethod) {
        if (scaleMethod != this._scaleMethod) {
            try {
                this.setDelegate(SlowFITSImage.createScaledImage(this.getImageHDU(), this._scaledData, this.getHistogram(), this._min, this._max, this._sigma, scaleMethod));
                this._scaleMethod = scaleMethod;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void rescale(double min, double max, double sigma) {
        if (min != this._min || max != this._max || sigma != this._sigma) {
            try {
                this._min = min;
                this._max = max;
                this._sigma = sigma;
                this.setDelegate(SlowFITSImage.createScaledImage(this.getImageHDU(), this._scaledData, this.getHistogram(), min, max, sigma, this._scaleMethod));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected BufferedImage getDelegate() {
        return this._delegate;
    }

    protected void setDelegate(BufferedImage delegate) {
        this._delegate = delegate;
    }

    public WritableRaster copyData(WritableRaster outRaster) {
        return this.getDelegate().copyData(outRaster);
    }

    public Graphics2D createGraphics() {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public void flush() {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public WritableRaster getAlphaRaster() {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public ColorModel getColorModel() {
        return this.getDelegate().getColorModel();
    }

    public Raster getData() {
        return this.getDelegate().getData();
    }

    public Raster getData(Rectangle rect) {
        return this.getDelegate().getData(rect);
    }

    public Graphics getGraphics() {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public int getHeight() {
        return this.getDelegate().getHeight();
    }

    public int getHeight(ImageObserver observer) {
        return this.getDelegate().getHeight(observer);
    }

    public int getMinTileX() {
        return this.getDelegate().getMinTileX();
    }

    public int getMinTileY() {
        return this.getDelegate().getMinTileY();
    }

    public int getMinX() {
        return this.getDelegate().getMinX();
    }

    public int getMinY() {
        return this.getDelegate().getMinY();
    }

    public int getNumXTiles() {
        return this.getDelegate().getNumXTiles();
    }

    public int getNumYTiles() {
        return this.getDelegate().getNumYTiles();
    }

    public Object getProperty(String name) {
        return this.getDelegate().getProperty(name);
    }

    public Object getProperty(String name, ImageObserver observer) {
        return this.getDelegate().getProperty(name, observer);
    }

    public String[] getPropertyNames() {
        return this.getDelegate().getPropertyNames();
    }

    public WritableRaster getRaster() {
        return this.getDelegate().getRaster();
    }

    public int getRGB(int x, int y) {
        return this.getDelegate().getRGB(x, y);
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        return this.getDelegate().getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public SampleModel getSampleModel() {
        return this.getDelegate().getSampleModel();
    }

    public ImageProducer getSource() {
        return this.getDelegate().getSource();
    }

    public Vector getSources() {
        return this.getDelegate().getSources();
    }

    public BufferedImage getSubimage(int x, int y, int w, int h) {
        return this.getDelegate().getSubimage(x, y, w, h);
    }

    public Raster getTile(int tileX, int tileY) {
        return this.getDelegate().getTile(tileX, tileY);
    }

    public int getTileGridXOffset() {
        return this.getDelegate().getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return this.getDelegate().getTileGridYOffset();
    }

    public int getTileHeight() {
        return this.getDelegate().getTileHeight();
    }

    public int getTileWidth() {
        return this.getDelegate().getTileWidth();
    }

    public int getType() {
        return this.getDelegate().getType();
    }

    public int getWidth() {
        return this.getDelegate().getWidth();
    }

    public int getWidth(ImageObserver observer) {
        return this.getDelegate().getWidth(observer);
    }

    public WritableRaster getWritableTile(int tileX, int tileY) {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public Point[] getWritableTileIndices() {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public boolean hasTileWriters() {
        return false;
    }

    public boolean isAlphaPremultiplied() {
        return true;
    }

    public boolean isTileWritable(int tileX, int tileY) {
        return false;
    }

    public void releaseWritableTile(int tileX, int tileY) {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public void setData(Raster r) {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public void setRGB(int x, int y, int rgb) {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        throw new RuntimeException(new Exception().getStackTrace()[0].getMethodName() + " not supported");
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    protected void setFits(Fits fits) {
        this._fits = fits;
    }

    protected void setImageHDU(ImageHDU imageHDU) {
        this._imageHDU = imageHDU;
    }

    protected static ImageHDU findFirstImageHDU(Fits fits) throws FitsException, IOException {
        ImageHDU result = null;
        int i = 0;
        BasicHDU hdu = fits.getHDU(i);
        while (hdu != null && result == null) {
            if (hdu instanceof ImageHDU) {
                result = (ImageHDU)hdu;
            }
            ++i;
        }
        return result;
    }

    protected static BufferedImage createScaledImage(Fits fits, int scaleMethod) throws FitsException, DataTypeNotSupportedException, NoImageDataFoundException, IOException {
        BufferedImage result = null;
        ImageHDU imageHDU = SlowFITSImage.findFirstImageHDU(fits);
        if (imageHDU == null) {
            throw new NoImageDataFoundException();
        }
        result = SlowFITSImage.createScaledImage(imageHDU, scaleMethod);
        return result;
    }

    public static BufferedImage createScaledImage(ImageHDU hdu, int scaleMethod) throws FitsException, DataTypeNotSupportedException {
        int bitpix = hdu.getBitPix();
        int width = hdu.getAxes()[1];
        int height = hdu.getAxes()[0];
        double bZero = hdu.getBZero();
        double bScale = hdu.getBScale();
        Object data = hdu.getData().getData();
        Histogram hist = null;
        switch (bitpix) {
            case 8: {
                hist = ScaleUtils.computeHistogram((byte[][])data, bZero, bScale);
                break;
            }
            case 16: {
                hist = ScaleUtils.computeHistogram((short[][])data, bZero, bScale);
                break;
            }
            case 32: {
                hist = ScaleUtils.computeHistogram((int[][])data, bZero, bScale);
                break;
            }
            case -32: {
                hist = ScaleUtils.computeHistogram((float[][])data, bZero, bScale);
                break;
            }
            case -64: {
                hist = ScaleUtils.computeHistogram((double[][])data, bZero, bScale);
                break;
            }
            default: {
                throw new DataTypeNotSupportedException(bitpix);
            }
        }
        return SlowFITSImage.createScaledImage(hdu, null, hist, hist.getMin(), hist.getMax(), hist.estimateSigma(), scaleMethod);
    }

    public static BufferedImage createScaledImage(ImageHDU hdu, short[] result, Histogram hist, double min, double max, double sigma, int scaleMethod) throws FitsException, DataTypeNotSupportedException {
        int bitpix = hdu.getBitPix();
        Object data = hdu.getData().getData();
        int width = hdu.getAxes()[1];
        int height = hdu.getAxes()[0];
        double bZero = hdu.getBZero();
        double bScale = hdu.getBScale();
        short[] scaledData = SlowScaleUtils.scale(data, result, width, height, bZero, bScale, min, max, sigma, hist, scaleMethod);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 1);
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(width, height);
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("histogram", hist);
        properties.put("imageHDU", hdu);
        properties.put("scaledData", scaledData);
        DataBufferUShort db = new DataBufferUShort(scaledData, height);
        WritableRaster r = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(cm, r, false, properties);
    }

    public static String revision() {
        return "$Revision: 1.2 $";
    }

    public static class NoImageDataFoundException
    extends Exception {
        public NoImageDataFoundException() {
            super("No image data found in FITS file.");
        }
    }

    public static class DataTypeNotSupportedException
    extends Exception {
        public DataTypeNotSupportedException(int bitpix) {
            super(bitpix + " is not a valid FITS data type.");
        }
    }
}

