/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.pha.sdss.fits;

import edu.jhu.pha.sdss.fits.Histogram;
import edu.jhu.pha.sdss.fits.ScaleUtils;

public class SlowScaleUtils
extends ScaleUtils {
    public static final Scaler BYTE_SCALER = new ByteScaler();
    public static final Scaler SHORT_SCALER = new ShortScaler();
    public static final Scaler INT_SCALER = new IntScaler();
    public static final Scaler FLOAT_SCALER = new FloatScaler();
    public static final Scaler DOUBLE_SCALER = new DoubleScaler();

    public static short[] scale(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, double sigma, Histogram hist, int scaleMethod) {
        long startTime = System.currentTimeMillis();
        switch (scaleMethod) {
            case 1: {
                result = SlowScaleUtils.getScaler(data).logScaleToUShort(data, result, width, height, bZero, bScale, min, max);
                break;
            }
            case 2: {
                result = SlowScaleUtils.getScaler(data).sqrtScaleToUShort(data, result, width, height, bZero, bScale, min, max);
                break;
            }
            case 3: {
                result = SlowScaleUtils.getScaler(data).squareScaleToUShort(data, result, width, height, bZero, bScale, min, max);
                break;
            }
            case 4: {
                result = SlowScaleUtils.getScaler(data).histEQScaleToUShort(data, result, width, height, bZero, bScale, min, max, hist);
                break;
            }
            case 5: {
                result = SlowScaleUtils.getScaler(data).asinhScaleToUShort(data, result, width, height, bZero, bScale, min, max, sigma);
                break;
            }
            default: {
                result = SlowScaleUtils.getScaler(data).linearScaleToUShort(data, result, width, height, bZero, bScale, min, max);
            }
        }
        long endTime = System.currentTimeMillis();
        if (System.getProperty("debug", "").equals("on")) {
            System.err.println("scale took " + (endTime - startTime) + " ms");
        }
        return result;
    }

    public static Scaler getScaler(Object data) {
        Scaler result = null;
        if (data instanceof byte[][]) {
            result = BYTE_SCALER;
        } else if (data instanceof short[][]) {
            result = SHORT_SCALER;
        } else if (data instanceof int[][]) {
            result = INT_SCALER;
        } else if (data instanceof float[][]) {
            result = FLOAT_SCALER;
        } else if (data instanceof double[][]) {
            result = DOUBLE_SCALER;
        }
        return result;
    }

    public static String revision() {
        return "$Revision: 1.1 $";
    }

    public static class DoubleScaler
    implements Scaler {
        public short[] linearScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            double[][] vals = (double[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.max(0.0, Math.min(offset + bScale * vals[y][x], uBound)) * linearScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] logScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double log10 = Math.log(10.0);
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double logScaleFactor = nBins / (Math.log(nBins) / log10);
            double offset = bZero - min;
            double[][] vals = (double[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    double val = Math.max(0.0, Math.min(offset + bScale * vals[y][x], uBound));
                    short s = val <= 0.0 ? (short)0 : (short)(Math.log(val * linearScaleFactor) / log10 * logScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] sqrtScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double sqrtScaleFactor = nBins / Math.sqrt(uBound);
            double offset = bZero - min;
            double[][] vals = (double[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.sqrt(Math.max(0.0, Math.min(offset + bScale * vals[y][x], uBound))) * sqrtScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] squareScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
            double offset = bZero - min;
            double[][] vals = (double[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.pow(Math.max(0.0, Math.min(offset + bScale * vals[y][x], uBound)), 2.0) * squareScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] histEQScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, Histogram hist) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            double[][] vals = (double[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double val = Math.max(0.0, Math.min(offset + bScale * vals[y][x], uBound));
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] asinhScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double asinhScaleFactor = nBins / ScaleUtils.arcsinh(uBound / sigma);
            double offset = bZero - min;
            double[][] vals = (double[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(ScaleUtils.arcsinh(Math.max(0.0, Math.min(offset + bScale * vals[y][x], uBound)) / sigma) * asinhScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }
    }

    public static class FloatScaler
    implements Scaler {
        public short[] linearScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            float[][] vals = (float[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)) * linearScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] logScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double log10 = Math.log(10.0);
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double logScaleFactor = nBins / (Math.log(nBins) / log10);
            double offset = bZero - min;
            float[][] vals = (float[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    short s = val <= 0.0 ? (short)0 : (short)(Math.log(val * linearScaleFactor) / log10 * logScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] sqrtScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double sqrtScaleFactor = nBins / Math.sqrt(uBound);
            double offset = bZero - min;
            float[][] vals = (float[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.sqrt(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound))) * sqrtScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] squareScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
            double offset = bZero - min;
            float[][] vals = (float[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.pow(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)), 2.0) * squareScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] histEQScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, Histogram hist) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            float[][] vals = (float[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] asinhScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double asinhScaleFactor = nBins / ScaleUtils.arcsinh(uBound / sigma);
            double offset = bZero - min;
            float[][] vals = (float[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(ScaleUtils.arcsinh(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)) / sigma) * asinhScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }
    }

    public static class IntScaler
    implements Scaler {
        public short[] linearScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            int[][] vals = (int[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)) * linearScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] logScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double log10 = Math.log(10.0);
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double logScaleFactor = nBins / (Math.log(nBins) / log10);
            double offset = bZero - min;
            int[][] vals = (int[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    short s = val <= 0.0 ? (short)0 : (short)(Math.log(val * linearScaleFactor) / log10 * logScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] sqrtScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double sqrtScaleFactor = nBins / Math.sqrt(uBound);
            double offset = bZero - min;
            int[][] vals = (int[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.sqrt(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound))) * sqrtScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] squareScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
            double offset = bZero - min;
            int[][] vals = (int[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.pow(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)), 2.0) * squareScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] histEQScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, Histogram hist) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            int[][] vals = (int[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] asinhScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double asinhScaleFactor = nBins / ScaleUtils.arcsinh(uBound / sigma);
            double offset = bZero - min;
            int[][] vals = (int[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(ScaleUtils.arcsinh(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)) / sigma) * asinhScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }
    }

    public static class ShortScaler
    implements Scaler {
        public short[] linearScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            short[][] vals = (short[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)) * linearScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] logScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double log10 = Math.log(10.0);
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double logScaleFactor = nBins / (Math.log(nBins) / log10);
            double logLinearScaleFactor = Math.log(nBins / uBound);
            double offset = bZero - min;
            short[][] vals = (short[][])data;
            int minIndex = (int)Math.rint((min - bZero) / bScale);
            int maxIndex = (int)Math.rint((max - bZero) / bScale);
            double logBscale = Math.log(bScale);
            double logMax = Math.log(uBound);
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    int mapIndex = Math.max(minIndex, Math.min(maxIndex, vals[y][x])) - minIndex;
                    double logVal = Math.max(0.0, Math.min(logMax, logBscale + ScaleUtils.SHORT_LOG_MAP[mapIndex]));
                    short s = val <= 0.0 ? (short)0 : (short)((logVal + logLinearScaleFactor) / log10 * logScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] sqrtScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double sqrtScaleFactor = nBins / Math.sqrt(uBound);
            double offset = bZero - min;
            short[][] vals = (short[][])data;
            int minIndex = (int)Math.rint((min - bZero) / bScale);
            int maxIndex = (int)Math.rint((max - bZero) / bScale);
            double rootBscale = Math.sqrt(bScale);
            double rootMax = Math.sqrt(uBound);
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    int mapIndex = Math.max(minIndex, Math.min(maxIndex, vals[y][x])) - minIndex;
                    double sqrtVal = Math.max(0.0, Math.min(rootMax, rootBscale * ScaleUtils.SHORT_SQRT_MAP[mapIndex]));
                    short s = (short)(sqrtVal * sqrtScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] squareScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double squareScaleFactor = nBins / Math.pow(uBound, 2.0);
            double offset = bZero - min;
            short[][] vals = (short[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(Math.pow(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)), 2.0) * squareScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] histEQScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, Histogram hist) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            short[][] vals = (short[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound));
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] asinhScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double asinhScaleFactor = nBins / ScaleUtils.arcsinh(uBound / sigma);
            double offset = bZero - min;
            short[][] vals = (short[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(ScaleUtils.arcsinh(Math.max(0.0, Math.min(offset + bScale * (double)vals[y][x], uBound)) / sigma) * asinhScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }
    }

    public static class ByteScaler
    implements Scaler {
        public short[] linearScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            byte[][] vals = (byte[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    int shifted = vals[y][x];
                    if (shifted < 0) {
                        shifted += 256;
                    }
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, uBound));
                    short s = (short)(val * linearScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] logScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double log10 = Math.log(10.0);
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double logScaleFactor = nBins / (Math.log(nBins) / log10);
            double logLinearScaleFactor = Math.log(nBins / uBound);
            double offset = bZero - min;
            byte[][] vals = (byte[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            int minIndex = (int)Math.rint((min - bZero) / bScale);
            int maxIndex = (int)Math.rint((max - bZero) / bScale);
            double logBscale = Math.log(bScale);
            double logMax = Math.log(uBound);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    int shifted = vals[y][x];
                    if (shifted < 0) {
                        shifted += 256;
                    }
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, uBound));
                    int mapIndex = Math.max(minIndex, Math.min(maxIndex, shifted)) - minIndex;
                    double logVal = Math.max(0.0, Math.min(logMax, logBscale + ScaleUtils.BYTE_LOG_MAP[mapIndex]));
                    short s = val <= 0.0 ? (short)0 : (short)((logVal + logLinearScaleFactor) / log10 * logScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] sqrtScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double rootMax = Math.sqrt(uBound);
            double sqrtScaleFactor = nBins / rootMax;
            double offset = bZero - min;
            byte[][] vals = (byte[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            int minIndex = (int)Math.rint((min - bZero) / bScale);
            int maxIndex = (int)Math.rint((max - bZero) / bScale);
            double rootBscale = Math.sqrt(bScale);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    int shifted = vals[y][x];
                    if (shifted < 0) {
                        shifted += 256;
                    }
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, uBound));
                    int mapIndex = Math.max(minIndex, Math.min(maxIndex, shifted)) - minIndex;
                    double sqrtVal = Math.max(0.0, Math.min(rootMax, rootBscale * ScaleUtils.BYTE_SQRT_MAP[mapIndex]));
                    short s = (short)(sqrtVal * sqrtScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] squareScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double squareScaleFactor = nBins / Math.pow(uBound, 2.0);
            double offset = bZero - min;
            byte[][] vals = (byte[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bandedIndex = (y * width + x) * 3;
                    int shifted = vals[y][x];
                    if (shifted < 0) {
                        shifted += 256;
                    }
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, uBound));
                    short s = (short)(val * val * squareScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] histEQScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, Histogram hist) {
            int arraySize = width * height * 3;
            double uBound = max - min;
            double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / uBound;
            double offset = bZero - min;
            byte[][] vals = (byte[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int shifted = vals[y][x];
                    if (shifted < 0) {
                        shifted += 256;
                    }
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, uBound));
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }

        public short[] asinhScaleToUShort(Object data, short[] result, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
            int arraySize = width * height * 3;
            double nBins = Math.pow(2.0, 16.0) - 1.0;
            double uBound = max - min;
            double linearScaleFactor = nBins / uBound;
            double asinhScaleFactor = nBins / ScaleUtils.arcsinh(uBound / sigma);
            double offset = bZero - min;
            byte[][] vals = (byte[][])data;
            if (result == null || result.length != arraySize) {
                result = new short[arraySize];
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int shifted = vals[y][x];
                    if (shifted < 0) {
                        shifted += 256;
                    }
                    double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, uBound));
                    int bandedIndex = (y * width + x) * 3;
                    short s = (short)(ScaleUtils.arcsinh(val / sigma) * asinhScaleFactor);
                    result[bandedIndex + 2] = s;
                    result[bandedIndex + 1] = s;
                    result[bandedIndex] = s;
                }
            }
            return result;
        }
    }

    public static interface Scaler {
        public short[] linearScaleToUShort(Object var1, short[] var2, int var3, int var4, double var5, double var7, double var9, double var11);

        public short[] logScaleToUShort(Object var1, short[] var2, int var3, int var4, double var5, double var7, double var9, double var11);

        public short[] sqrtScaleToUShort(Object var1, short[] var2, int var3, int var4, double var5, double var7, double var9, double var11);

        public short[] squareScaleToUShort(Object var1, short[] var2, int var3, int var4, double var5, double var7, double var9, double var11);

        public short[] histEQScaleToUShort(Object var1, short[] var2, int var3, int var4, double var5, double var7, double var9, double var11, Histogram var13);

        public short[] asinhScaleToUShort(Object var1, short[] var2, int var3, int var4, double var5, double var7, double var9, double var11, double var13);
    }
}

