/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.votech.plastic.PlasticHubListener;
import org.votech.plastic.PlasticListener;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.ApplicationListModel;
import uk.ac.starlink.plastic.MessageId;
import uk.ac.starlink.plastic.PlasticHub;
import uk.ac.starlink.plastic.PlasticListWindow;
import uk.ac.starlink.plastic.PlasticMonitor;
import uk.ac.starlink.plastic.PlasticUtils;

public abstract class HubManager
implements PlasticListener {
    private final String applicationName_;
    private final URI[] supportedMessages_;
    private final JToggleButton.ToggleButtonModel registerToggle_;
    private URI plasticId_;
    private PlasticHubListener hub_;
    private ApplicationListModel appListModel_;
    private JFrame hubWindow_;
    private int autoRegInterval_;
    private Thread autoThread_;
    private static final URI[] INTERNAL_SUPPORTED_MESSAGES;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HubManager(String appName, URI[] supportedMessages) {
        this.applicationName_ = appName;
        this.supportedMessages_ = (URI[])supportedMessages.clone();
        this.registerToggle_ = new JToggleButton.ToggleButtonModel();
        this.registerToggle_.setSelected(false);
        this.registerToggle_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                boolean reg = HubManager.this.registerToggle_.isSelected();
                new Thread(this, "PLASTIC " + (reg ? "register" : "unregister"), reg){
                    private final /* synthetic */ boolean val$reg;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$reg = val$reg;
                        super(x0);
                    }

                    public void run() {
                        try {
                            if (this.val$reg) {
                                1.access$100(this.this$1).register();
                            } else {
                                1.access$100(this.this$1).unregister();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }.start();
            }

            static /* synthetic */ HubManager access$100(1 x0) {
                return x0.HubManager.this;
            }
        });
        this.updateState(false);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("PLASTIC hub unregister"){

                public void run() {
                    HubManager.this.unregister();
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public URI getRegisteredId() {
        return this.plasticId_;
    }

    public PlasticHubListener getHub() {
        return this.hub_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() throws IOException {
        block23: {
            boolean doRegister;
            HubManager hubManager = this;
            synchronized (hubManager) {
                if (this.plasticId_ == null) {
                    if (!$assertionsDisabled && this.hub_ != null) {
                        throw new AssertionError();
                    }
                    doRegister = true;
                } else {
                    if (!$assertionsDisabled && this.hub_ == null) {
                        throw new AssertionError();
                    }
                    try {
                        this.hub_.getHubId();
                        doRegister = false;
                    }
                    catch (Throwable e) {
                        this.setHub(null);
                        if (!$assertionsDisabled && this.hub_ != null) {
                            throw new AssertionError();
                        }
                        this.plasticId_ = null;
                        doRegister = true;
                    }
                }
            }
            try {
                if (!doRegister) break block23;
                if (!$assertionsDisabled && this.hub_ != null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.plasticId_ != null) {
                    throw new AssertionError();
                }
                try {
                    PlasticHubListener hub = PlasticUtils.getLocalHub();
                    HashSet<URI> supported = new HashSet<URI>();
                    if (this.supportedMessages_.length > 0) {
                        supported.addAll(Arrays.asList(this.supportedMessages_));
                        supported.addAll(Arrays.asList(INTERNAL_SUPPORTED_MESSAGES));
                    }
                    URI id = hub.registerRMI(this.applicationName_, new ArrayList(supported), this);
                    HubManager hubManager2 = this;
                    synchronized (hubManager2) {
                        this.setHub(hub);
                        if (!$assertionsDisabled && this.hub_ != hub) {
                            throw new AssertionError();
                        }
                        this.plasticId_ = id;
                    }
                    this.updateState(true);
                }
                catch (IOException e) {
                    this.updateState(false);
                    throw e;
                }
            }
            finally {
                if (this.autoRegInterval_ > 0) {
                    this.runAutoRegistration(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        PlasticHubListener hub;
        URI id;
        boolean doUnregister;
        if (this.plasticId_ != null) {
            this.runAutoRegistration(false);
        }
        HubManager hubManager = this;
        synchronized (hubManager) {
            if (this.plasticId_ != null) {
                if (!$assertionsDisabled && this.hub_ == null) {
                    throw new AssertionError();
                }
                doUnregister = true;
                id = this.plasticId_;
                hub = this.hub_;
                this.plasticId_ = null;
                this.setHub(null);
                if (!$assertionsDisabled && this.hub_ != null) {
                    throw new AssertionError();
                }
            } else {
                doUnregister = false;
                id = null;
                hub = null;
            }
        }
        if (doUnregister) {
            Thread unregThread = new Thread("PLASTIC unregister"){

                public void run() {
                    try {
                        hub.unregister(id);
                        logger_.config("PLASTIC unregistration successful");
                    }
                    catch (Throwable e) {
                        logger_.config("PLASTIC unregistration failed");
                    }
                    HubManager.this.updateState(false);
                }
            };
            unregThread.setDaemon(true);
            unregThread.start();
            try {
                unregThread.join(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private synchronized void runAutoRegistration(boolean active) {
        if (active && this.autoThread_ == null) {
            Thread autoThread = new Thread("PLASTIC Registration"){

                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            if (HubManager.this.plasticId_ == null && PlasticUtils.isHubRunning()) {
                                try {
                                    HubManager.this.register();
                                }
                                catch (IOException e) {
                                }
                                catch (RuntimeException e) {
                                }
                                catch (Error e) {
                                    // empty catch block
                                }
                            }
                            if (HubManager.this.autoRegInterval_ <= 0) continue;
                            Thread.sleep(HubManager.this.autoRegInterval_);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            autoThread.setDaemon(true);
            autoThread.start();
            this.autoThread_ = autoThread;
        } else if (!active && this.autoThread_ != null) {
            Thread autoThread = this.autoThread_;
            this.autoThread_ = null;
            autoThread.interrupt();
        }
    }

    public synchronized void setAutoRegister(int interval) {
        this.autoRegInterval_ = interval;
        this.runAutoRegistration(interval > 0);
    }

    public Action getRegisterAction(boolean reg) {
        return new RegisterAction(reg);
    }

    public Action getHubStartAction(final boolean internal) {
        final AbstractAction hubAct = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (internal) {
                        PlasticHub.startHub(null, null);
                    } else {
                        PlasticUtils.startExternalHub(true);
                    }
                }
                catch (Throwable e) {
                    Component parent = evt.getSource() instanceof Component ? (Component)evt.getSource() : null;
                    String[] errmsg = new String[]{"Failed to start new PLASTIC hub:", e.toString()};
                    JOptionPane.showMessageDialog(parent, errmsg, "Hub Start Error", 2);
                }
            }
        };
        hubAct.putValue("Name", "Start " + (internal ? "internal" : "external") + " PLASTIC Hub");
        hubAct.putValue("ShortDescription", "Start a PLASTIC hub running" + (internal ? " in this JVM" : " in a separate process"));
        this.registerToggle_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (!HubManager.this.registerToggle_.isSelected()) {
                    hubAct.setEnabled(true);
                } else {
                    hubAct.setEnabled(!PlasticUtils.isHubRunning());
                }
            }
        });
        if (!this.registerToggle_.isSelected()) {
            hubAct.setEnabled(true);
        } else {
            hubAct.setEnabled(!PlasticUtils.isHubRunning());
        }
        return hubAct;
    }

    public Action getHubWatchAction() {
        AbstractAction watchAct = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if (HubManager.this.hubWindow_ == null) {
                    HubManager.this.hubWindow_ = new PlasticListWindow(HubManager.this.getApplicationListModel());
                    HubManager.this.hubWindow_.setTitle("PLASTIC apps");
                    HubManager.this.hubWindow_.pack();
                }
                HubManager.this.hubWindow_.setVisible(true);
            }
        };
        watchAct.putValue("Name", "Show Registered Applications");
        watchAct.putValue("ShortDescription", "Display applications registered with the PLASTIC hub");
        return watchAct;
    }

    public JToggleButton.ToggleButtonModel getRegisterToggle() {
        return this.registerToggle_;
    }

    public synchronized ListModel getApplicationListModel() {
        if (this.appListModel_ == null) {
            final ApplicationListModel model = new ApplicationListModel();
            boolean[] done = new boolean[1];
            if (this.hub_ != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        model.setItems(PlasticUtils.getRegisteredApplications(HubManager.this.hub_));
                    }
                });
            }
            this.appListModel_ = model;
        }
        return this.appListModel_;
    }

    private void setHub(final PlasticHubListener hub) {
        this.hub_ = hub;
        final ApplicationListModel model = this.appListModel_;
        if (model != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ApplicationItem[] apps = hub == null ? new ApplicationItem[]{} : PlasticUtils.getRegisteredApplications(hub);
                    model.setItems(apps);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object perform(URI sender, URI message, List args) {
        URI id;
        logger_.config("Received PLASTIC message " + message);
        if (MessageId.HUB_STOPPING.equals(message)) {
            HubManager hubManager = this;
            synchronized (hubManager) {
                this.plasticId_ = null;
                this.setHub(null);
            }
            this.updateState(false);
        } else if (MessageId.HUB_APPREG.equals(message)) {
            try {
                id = HubManager.createURI(args.get(0).toString());
                this.appListModel_.register(id, this.hub_.getName(id), this.hub_.getUnderstoodMessages(id));
            }
            catch (Exception e) {}
        } else if (MessageId.HUB_APPUNREG.equals(message)) {
            try {
                id = HubManager.createURI(args.get(0).toString());
                this.appListModel_.unregister(id);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.supportedMessages_.length == 0 || Arrays.asList(this.supportedMessages_).contains(message)) {
            logger_.info("Processing supported message: " + message + " from " + sender);
            logger_.config("Message arguments: " + PlasticMonitor.stringify(args));
            try {
                Object ret = this.doPerform(sender, message, args);
                logger_.config("Message return: " + PlasticMonitor.stringify(ret));
                return ret;
            }
            catch (IOException e) {
                logger_.warning("PLASTIC message failed: " + e);
                return e;
            }
        }
        if (MessageId.TEST_ECHO.equals(message)) {
            return args.size() > 0 ? args.get(0) : null;
        }
        if (MessageId.INFO_GETNAME.equals(message)) {
            return this.applicationName_;
        }
        if (Arrays.asList(INTERNAL_SUPPORTED_MESSAGES).contains(message)) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported message" + message);
    }

    public abstract Object doPerform(URI var1, URI var2, List var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            new Thread("PLASTIC unregister"){

                public void run() {
                    HubManager.this.unregister();
                }
            }.start();
        }
        finally {
            super.finalize();
        }
    }

    private void updateState(final boolean registered) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HubManager.this.registerToggle_.setSelected(registered);
            }
        });
    }

    public static URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Bad URI: " + uri).initCause(e);
        }
    }

    public static boolean checkArgs(List args, Class[] types) throws IOException {
        String msg = null;
        if (args.size() < types.length) {
            msg = "Not enough arguments";
        } else {
            for (int i = 0; i < types.length; ++i) {
                Object arg = args.get(i);
                if (arg == null || types[i].isAssignableFrom(arg.getClass())) continue;
                msg = "Wrong type of arguments";
            }
        }
        if (msg == null) {
            return true;
        }
        StringBuffer sbuf = new StringBuffer("PLASTIC: ").append(msg).append("; (");
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Object arg = it.next();
            sbuf.append(arg == null ? "null" : arg.getClass().getName());
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        sbuf.append(") != (");
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(types[i].getName());
        }
        sbuf.append(')');
        throw new IOException(sbuf.toString());
    }

    static {
        $assertionsDisabled = !HubManager.class.desiredAssertionStatus();
        INTERNAL_SUPPORTED_MESSAGES = new URI[]{MessageId.TEST_ECHO, MessageId.INFO_GETNAME, MessageId.HUB_STOPPING, MessageId.HUB_APPREG, MessageId.HUB_APPUNREG};
        logger_ = Logger.getLogger("uk.ac.starlink.plastic");
    }

    private class RegisterAction
    extends AbstractAction
    implements ChangeListener {
        private final boolean reg_;

        RegisterAction(boolean reg) {
            super(reg ? "Register with PLASTIC" : "Unregister with PLASTIC");
            this.reg_ = reg;
            this.putValue("ShortDescription", reg ? "Accept interop requests from other tools" : "Ignore interop requests from other tools");
            HubManager.this.registerToggle_.addChangeListener(this);
            this.stateChanged(null);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.reg_) {
                try {
                    HubManager.this.register();
                }
                catch (IOException e) {
                    Component parent = evt.getSource() instanceof Component ? (Component)evt.getSource() : null;
                    String[] errmsg = new String[]{"Registration with PLASTIC hub failed:", e.toString()};
                    JOptionPane.showMessageDialog(parent, errmsg, "PLASTIC Error", 2);
                }
            } else {
                HubManager.this.unregister();
            }
        }

        public void stateChanged(ChangeEvent evt) {
            this.setEnabled(this.reg_ ^ HubManager.this.registerToggle_.isSelected());
        }
    }
}

