/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Font;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.grf.DefaultGrfFontManager;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstAxisLabels
extends AbstractPlotControlsModel {
    protected boolean isXSet;
    protected boolean isYSet;
    protected boolean xShown;
    protected boolean yShown;
    protected String xLabel;
    protected String yLabel;
    protected Font font;
    protected Color colour;
    protected double xGap;
    protected double yGap;
    public static final double GAP_MIN = -0.5;
    public static final double GAP_MAX = 0.5;
    public static final double GAP_STEP = 0.005;
    public static final String NULL_LABEL = "Using default label";
    protected int xEdge;
    protected int yEdge;
    protected boolean showXUnits;
    protected boolean showYUnits;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    protected DefaultGrfFontManager grfFontManager = DefaultGrfFontManager.getReference();

    public AstAxisLabels() {
        this.setDefaults();
    }

    public AstAxisLabels(String xLabel, String yLabel) {
        this.setDefaults();
        this.setXLabel(xLabel);
        this.setYLabel(yLabel);
    }

    public void setDefaults() {
        this.isXSet = true;
        this.isYSet = true;
        this.xShown = true;
        this.yShown = true;
        this.xLabel = NULL_LABEL;
        this.yLabel = NULL_LABEL;
        this.colour = Color.black;
        this.font = null;
        this.xGap = 0.01;
        this.yGap = 0.01;
        this.xEdge = 4;
        this.yEdge = 1;
        this.showXUnits = true;
        this.showYUnits = true;
        this.fireChanged();
    }

    public void setXState(boolean isXSet) {
        this.isXSet = isXSet;
    }

    public boolean getXState() {
        return this.isXSet;
    }

    public void setYState(boolean isYSet) {
        this.isYSet = isYSet;
    }

    public boolean getYState() {
        return this.isYSet;
    }

    public void setXShown(boolean xShown) {
        this.xShown = xShown;
        this.setXState(true);
        this.fireChanged();
    }

    public boolean getXShown() {
        return this.xShown;
    }

    public void setYShown(boolean yShown) {
        this.yShown = yShown;
        this.setYState(true);
        this.fireChanged();
    }

    public boolean getYShown() {
        return this.yShown;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
        if (xLabel != null && !xLabel.equals(NULL_LABEL)) {
            this.setXState(true);
        }
        this.fireChanged();
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
        if (yLabel != null && !yLabel.equals(NULL_LABEL)) {
            this.setYState(true);
        }
        this.fireChanged();
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.setXState(true);
            this.setYState(true);
            this.grfFontManager.add(font);
        }
        if (this.font != null) {
            this.grfFontManager.remove(this.font);
        }
        this.font = font;
        this.fireChanged();
    }

    public Font getFont() {
        return this.font;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.setXState(true);
            this.setYState(true);
        }
        this.fireChanged();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setXGap(double xGap) {
        this.xGap = xGap;
        if (xGap != DefaultGrf.BAD) {
            this.setXState(true);
        }
        this.fireChanged();
    }

    public double getXGap() {
        return this.xGap;
    }

    public void setYGap(double yGap) {
        this.yGap = yGap;
        if (yGap != DefaultGrf.BAD) {
            this.setYState(true);
        }
        this.fireChanged();
    }

    public double getYGap() {
        return this.yGap;
    }

    public void setXEdge(int xEdge) {
        this.xEdge = xEdge == 4 ? 4 : 3;
        this.setXState(true);
        this.fireChanged();
    }

    public int getXEdge() {
        return this.xEdge;
    }

    public void setYEdge(int yEdge) {
        this.yEdge = yEdge == 2 ? 2 : 1;
        this.setYState(true);
        this.fireChanged();
    }

    public int getYEdge() {
        return this.yEdge;
    }

    public void setShowXUnits(boolean showXUnits) {
        this.showXUnits = showXUnits;
        this.fireChanged();
    }

    public boolean getShowXUnits() {
        return this.showXUnits;
    }

    public void setShowYUnits(boolean showYUnits) {
        this.showYUnits = showYUnits;
        this.fireChanged();
    }

    public boolean getShowYUnits() {
        return this.showYUnits;
    }

    public String getAstOptions() {
        if (!this.isXSet && !this.isYSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.font != null) {
            buffer.append(",Font(TextLab)=");
            buffer.append(this.grfFontManager.getIndex(this.font));
        }
        if (this.colour != null) {
            buffer.append(",Colour(TextLab)=");
            int value = DefaultGrf.encodeColor(this.colour);
            if (value == -1) {
                value = 0;
            }
            buffer.append(value);
        }
        if (this.isXSet && this.xShown) {
            buffer.append(",TextLab(1)=1");
            if (this.xLabel != null && !this.xLabel.equals("") && !this.xLabel.equals(NULL_LABEL)) {
                buffer.append(",label(1)=");
                buffer.append(this.xLabel);
            }
            if (this.xGap != DefaultGrf.BAD) {
                buffer.append(",TextLabGap(1)=");
                buffer.append(this.xGap);
            }
            if (this.xEdge == 3) {
                buffer.append(",Edge(1)=top");
            } else {
                buffer.append(",Edge(1)=bottom");
            }
            if (this.showXUnits) {
                buffer.append(",LabelUnits(1)=1");
            } else {
                buffer.append(",LabelUnits(1)=0");
            }
        } else if (this.isXSet && !this.xShown) {
            buffer.append(",TextLab(1)=0");
        }
        if (this.isYSet && this.yShown) {
            buffer.append(",TextLab(2)=1");
            if (this.yLabel != null && !this.yLabel.equals("") && !this.yLabel.equals(NULL_LABEL)) {
                buffer.append(",label(2)=");
                buffer.append(this.yLabel);
            }
            if (this.yGap != DefaultGrf.BAD) {
                buffer.append(",TextLabGap(2)=");
                buffer.append(this.yGap);
            }
            if (this.yEdge == 2) {
                buffer.append(",Edge(2)=right");
            } else {
                buffer.append(",Edge(2)=left");
            }
            if (this.showYUnits) {
                buffer.append(",LabelUnits(2)=1");
            } else {
                buffer.append(",LabelUnits(2)=0");
            }
        } else if (this.isYSet && !this.yShown) {
            buffer.append(",TextLab(2)=0");
        }
        buffer.deleteCharAt(0);
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "axislabels";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "isXSet", this.isXSet);
        this.addChildElement(rootElement, "isYSet", this.isYSet);
        this.addChildElement(rootElement, "xShown", this.xShown);
        this.addChildElement(rootElement, "yShown", this.yShown);
        this.addChildElement(rootElement, "xLabel", this.xLabel);
        this.addChildElement(rootElement, "yLabel", this.yLabel);
        if (this.font != null) {
            this.addChildElement(rootElement, "font", this.font);
        }
        if (this.colour != null) {
            this.addChildElement(rootElement, "colour", this.colour);
        }
        this.addChildElement(rootElement, "xGap", this.xGap);
        this.addChildElement(rootElement, "yGap", this.yGap);
        this.addChildElement(rootElement, "xEdge", this.xEdge);
        this.addChildElement(rootElement, "yEdge", this.yEdge);
        this.addChildElement(rootElement, "showXUnits", this.showXUnits);
        this.addChildElement(rootElement, "showYUnits", this.showYUnits);
    }

    public void setFromString(String name, String value) {
        if (name.equals("isXSet")) {
            this.setXState(this.booleanFromString(value));
            return;
        }
        if (name.equals("isYSet")) {
            this.setYState(this.booleanFromString(value));
            return;
        }
        if (name.equals("xShown")) {
            this.setXShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("yShown")) {
            this.setYShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("xLabel")) {
            this.setXLabel(value);
            return;
        }
        if (name.equals("yLabel")) {
            this.setYLabel(value);
            return;
        }
        if (name.equals("font")) {
            this.setFont(this.fontFromString(value));
            return;
        }
        if (name.equals("colour")) {
            this.setColour(this.colorFromString(value));
            return;
        }
        if (name.equals("xGap")) {
            this.setXGap(this.doubleFromString(value));
            return;
        }
        if (name.equals("yGap")) {
            this.setYGap(this.doubleFromString(value));
            return;
        }
        if (name.equals("xEdge")) {
            this.setXEdge(this.intFromString(value));
            return;
        }
        if (name.equals("yEdge")) {
            this.setYEdge(this.intFromString(value));
            return;
        }
        if (name.equals("showXUnits")) {
            this.setShowXUnits(this.booleanFromString(value));
            return;
        }
        if (name.equals("showYUnits")) {
            this.setShowYUnits(this.booleanFromString(value));
            return;
        }
        System.err.println("AstAxisLabels: unknown configuration property:" + name + " (" + value + ")");
    }
}

