/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import uk.ac.starlink.ast.gui.AstDouble;
import uk.ac.starlink.ast.gui.PlotController;

public class AstDoubleDocument
extends PlainDocument {
    private PlotController controller;
    private int axis;

    public AstDoubleDocument(PlotController controller, int axis) {
        this.controller = controller;
        this.axis = axis;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + str + afterOffset;
        if (str.equals("<bad>")) {
            super.remove(0, this.getLength());
        } else if (proposedResult.equals("")) {
            super.insertString(offs, str, a);
        } else {
            double value = this.controller.getPlotCurrentFrame().unformat(this.axis, proposedResult);
            if (!AstDouble.isBad(value)) {
                super.insertString(offs, str, a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void remove(int offs, int len) throws BadLocationException {
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(len + offs, currentText.length());
        String proposedResult = beforeOffset + afterOffset;
        if (currentText.equals("<bad>")) {
            super.remove(0, this.getLength());
        } else if (proposedResult.equals("")) {
            super.remove(offs, len);
        } else {
            double value = this.controller.getPlotCurrentFrame().unformat(this.axis, proposedResult);
            if (!AstDouble.isBad(value)) {
                super.remove(offs, len);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

