/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.Plot;
import uk.ac.starlink.ast.gui.AstFigureProps;
import uk.ac.starlink.ast.gui.AstPlotSource;
import uk.ac.starlink.ast.xml.XAstReader;
import uk.ac.starlink.ast.xml.XAstWriter;
import uk.ac.starlink.diva.DrawFigure;
import uk.ac.starlink.diva.DrawFigureStore;
import uk.ac.starlink.diva.FigureProps;
import uk.ac.starlink.util.PrimitiveXMLEncodeDecode;
import uk.ac.starlink.util.SourceReader;

public class AstFigureStore
extends DrawFigureStore {
    protected AstPlotSource plotSource = null;
    public static final String PLOT_TAG = "plotframeset";
    private XAstWriter astWriter = null;
    private XAstReader astReader = null;

    public AstFigureStore(AstPlotSource plotSource, String application, String storeFile, String tagName) {
        super(application, storeFile, tagName);
        this.plotSource = plotSource;
    }

    public void saveState(Element rootElement) {
        this.savePlot(rootElement);
        super.saveState(rootElement);
    }

    public void restoreState(Element rootElement) {
        List children = PrimitiveXMLEncodeDecode.getChildElements(rootElement);
        int size = children.size();
        Element element = null;
        String name = null;
        AstFigureProps props = null;
        DrawFigure figure = null;
        Plot oldMapping = null;
        Plot newMapping = this.plotSource.getPlot();
        for (int i = 0; i < size; ++i) {
            props = new AstFigureProps();
            element = (Element)children.get(i);
            name = PrimitiveXMLEncodeDecode.getElementName(element);
            if (PLOT_TAG.equals(name)) {
                oldMapping = this.restorePlot(element);
            }
            if (!props.getTagName().equals(name)) continue;
            props.decode(element, oldMapping, newMapping);
            figure = this.figureFactory.create((FigureProps)props);
            this.drawActions.addDrawFigure(figure);
            figure.repaint();
        }
    }

    protected void savePlot(Element rootElement) {
        Plot plot;
        if (this.plotSource != null && (plot = this.plotSource.getPlot()) != null) {
            if (this.astWriter == null) {
                this.astWriter = new XAstWriter();
            }
            Element plotElement = PrimitiveXMLEncodeDecode.addChildElement(rootElement, PLOT_TAG);
            plotElement.setAttribute("encoding", "AST-XML");
            DOMResult result = new DOMResult(plotElement);
            Source source = this.astWriter.makeSource(plot);
            Transformer trans = new SourceReader().getTransformer();
            try {
                trans.transform(source, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Plot restorePlot(Element rootElement) {
        if (this.astReader == null) {
            this.astReader = new XAstReader();
        }
        List children = PrimitiveXMLEncodeDecode.getChildElements(rootElement);
        Element plotElement = (Element)children.get(0);
        try {
            return (Plot)this.astReader.makeAst(plotElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

