/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstGrid
extends AbstractPlotControlsModel {
    protected boolean isSet;
    protected boolean show;
    protected Color colour;
    protected int style;
    protected double width;
    public static int MIN_WIDTH = 1;
    public static int MAX_WIDTH = 20;

    public AstGrid() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.isSet = false;
        this.show = false;
        this.colour = Color.black;
        this.style = 1;
        this.width = 1.0;
        this.fireChanged();
    }

    public void setState(boolean isSet) {
        this.isSet = isSet;
    }

    public boolean getState() {
        return this.isSet;
    }

    public void setShown(boolean show) {
        this.show = show;
        this.setState(true);
        this.fireChanged();
    }

    public boolean getShown() {
        return this.show;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setWidth(double width) {
        this.width = width;
        if (width != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getWidth() {
        return this.width;
    }

    public void setStyle(int style) {
        this.style = style;
        this.setState(true);
        this.fireChanged();
    }

    public int getStyle() {
        return this.style;
    }

    public String getAstOptions() {
        if (!this.isSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.show) {
            buffer.append("Grid=1");
            if (this.colour != null) {
                buffer.append(",Colour(grid)=");
                int value = DefaultGrf.encodeColor(this.colour);
                if (value == -1) {
                    value = 0;
                }
                buffer.append(value);
            }
            if (this.width != DefaultGrf.BAD) {
                buffer.append(",Width(grid)=");
                buffer.append(this.width);
            }
            buffer.append(",Style(grid)=");
            buffer.append(this.style);
        } else {
            buffer.append("Grid=0");
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "grid";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "isSet", this.isSet);
        this.addChildElement(rootElement, "show", this.show);
        if (this.colour != null) {
            this.addChildElement(rootElement, "colour", this.colour);
        }
        this.addChildElement(rootElement, "style", this.style);
        this.addChildElement(rootElement, "width", this.width);
    }

    public void setFromString(String name, String value) {
        if (name.equals("isSet")) {
            this.setState(this.booleanFromString(value));
            return;
        }
        if (name.equals("show")) {
            this.setShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("colour")) {
            this.setColour(this.colorFromString(value));
            return;
        }
        if (name.equals("style")) {
            this.setStyle(this.intFromString(value));
            return;
        }
        if (name.equals("width")) {
            this.setWidth(this.doubleFromString(value));
            return;
        }
        System.err.println("AstGrid: unknown configuration property:" + name + " (" + value + ")");
    }
}

