/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import java.awt.Font;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.grf.DefaultGrfFontManager;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstNumberLabels
extends AbstractPlotControlsModel {
    protected boolean isXSet;
    protected boolean isYSet;
    protected boolean xShown;
    protected boolean yShown;
    protected boolean logLabelSet;
    protected boolean xLogLabel;
    protected boolean yLogLabel;
    protected Font font;
    protected Color colour;
    protected double xGap;
    protected double yGap;
    protected int digits;
    protected boolean yRotated;
    protected boolean xRotated;
    public static final double GAP_MIN = -0.5;
    public static final double GAP_MAX = 0.5;
    public static final double GAP_STEP = 0.005;
    protected DefaultGrfFontManager grfFontManager = DefaultGrfFontManager.getReference();

    public AstNumberLabels() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.isXSet = false;
        this.isYSet = false;
        this.xShown = true;
        this.yShown = true;
        this.logLabelSet = false;
        this.xLogLabel = false;
        this.yLogLabel = false;
        this.colour = Color.black;
        this.font = null;
        this.xGap = 0.01;
        this.yGap = 0.01;
        this.digits = -1;
        this.xRotated = true;
        this.yRotated = true;
        this.fireChanged();
    }

    public void setXState(boolean isXSet) {
        this.isXSet = isXSet;
    }

    public boolean getXState() {
        return this.isXSet;
    }

    public void setYState(boolean isYSet) {
        this.isYSet = isYSet;
    }

    public boolean getYState() {
        return this.isYSet;
    }

    public void setXShown(boolean xShown) {
        this.xShown = xShown;
        this.setXState(true);
        this.fireChanged();
    }

    public boolean getXShown() {
        return this.xShown;
    }

    public void setYShown(boolean yShown) {
        this.yShown = yShown;
        this.setYState(true);
        this.fireChanged();
    }

    public boolean getYShown() {
        return this.yShown;
    }

    public void setLogLabelSet(boolean logLabelSet) {
        this.logLabelSet = logLabelSet;
    }

    public boolean getLogLabelSet() {
        return this.logLabelSet;
    }

    public void setXLogLabel(boolean xLogLabel) {
        this.xLogLabel = xLogLabel;
        this.setXState(true);
        this.fireChanged();
    }

    public boolean getXLogLabel() {
        return this.xLogLabel;
    }

    public void setYLogLabel(boolean yLogLabel) {
        this.yLogLabel = yLogLabel;
        this.setYState(true);
        this.fireChanged();
    }

    public boolean getYLogLabel() {
        return this.yLogLabel;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.setXState(true);
            this.setYState(true);
            this.grfFontManager.add(font);
        }
        if (this.font != null) {
            this.grfFontManager.remove(this.font);
        }
        this.font = font;
        this.fireChanged();
    }

    public Font getFont() {
        return this.font;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.setXState(true);
            this.setYState(true);
        }
        this.fireChanged();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setXGap(double xGap) {
        this.xGap = xGap;
        if (xGap != DefaultGrf.BAD) {
            this.setXState(true);
        }
        this.fireChanged();
    }

    public double getXGap() {
        return this.xGap;
    }

    public void setYGap(double yGap) {
        this.yGap = yGap;
        if (yGap != DefaultGrf.BAD) {
            this.setYState(true);
        }
        this.fireChanged();
    }

    public double getYGap() {
        return this.yGap;
    }

    public void setDigits(int digits) {
        this.digits = digits;
        if (digits != -1) {
            this.setXState(true);
            this.setYState(true);
        }
        this.fireChanged();
    }

    public int getDigits() {
        return this.digits;
    }

    public void setXRotated(boolean xRotated) {
        this.xRotated = xRotated;
    }

    public boolean getXRotated() {
        return this.xRotated;
    }

    public void setYRotated(boolean yRotated) {
        this.yRotated = yRotated;
    }

    public boolean getYRotated() {
        return this.yRotated;
    }

    public String getAstOptions() {
        if (!this.isXSet && !this.isYSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.font != null) {
            buffer.append(",Font(NumLab)=");
            buffer.append(this.grfFontManager.getIndex(this.font));
        }
        if (this.colour != null) {
            buffer.append(",Colour(NumLab)=");
            int value = DefaultGrf.encodeColor(this.colour);
            if (value == -1) {
                value = 0;
            }
            buffer.append(value);
        }
        if (this.digits != -1) {
            buffer.append(",Digits=");
            buffer.append(this.digits);
        }
        if (this.isXSet) {
            if (this.xShown) {
                buffer.append(",NumLab(1)=1");
                if (this.xGap != DefaultGrf.BAD) {
                    buffer.append(",NumLabGap(1)=");
                    buffer.append(this.xGap);
                }
                if (this.logLabelSet) {
                    if (this.xLogLabel) {
                        buffer.append(",LogLabel(1)=1");
                    } else {
                        buffer.append(",LogLabel(1)=0");
                    }
                }
            } else {
                buffer.append(",NumLab(1)=0");
            }
        }
        if (this.isYSet) {
            if (this.yShown) {
                buffer.append(",NumLab(2)=1");
                if (this.yGap != DefaultGrf.BAD) {
                    buffer.append(",NumLabGap(2)=");
                    buffer.append(this.yGap);
                }
                if (this.logLabelSet) {
                    if (this.yLogLabel) {
                        buffer.append(",LogLabel(2)=1");
                    } else {
                        buffer.append(",LogLabel(2)=0");
                    }
                }
            } else {
                buffer.append(",NumLab(2)=0");
            }
        }
        if (this.xRotated) {
            buffer.append(",LabelUp(1)=0");
        } else {
            buffer.append(",LabelUp(1)=1");
        }
        if (this.yRotated) {
            buffer.append(",LabelUp(2)=0");
        } else {
            buffer.append(",LabelUp(2)=1");
        }
        buffer.deleteCharAt(0);
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "numberlabels";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "isXSet", this.isXSet);
        this.addChildElement(rootElement, "isYSet", this.isYSet);
        this.addChildElement(rootElement, "xShown", this.xShown);
        this.addChildElement(rootElement, "yShown", this.yShown);
        this.addChildElement(rootElement, "logLabelSet", this.logLabelSet);
        this.addChildElement(rootElement, "xLogLabel", this.xLogLabel);
        this.addChildElement(rootElement, "yLogLabel", this.yLogLabel);
        this.addChildElement(rootElement, "xRotated", this.xRotated);
        this.addChildElement(rootElement, "yRotated", this.yRotated);
        if (this.font != null) {
            this.addChildElement(rootElement, "font", this.font);
        }
        if (this.colour != null) {
            this.addChildElement(rootElement, "colour", this.colour);
        }
        this.addChildElement(rootElement, "xGap", this.xGap);
        this.addChildElement(rootElement, "yGap", this.yGap);
        this.addChildElement(rootElement, "digits", this.digits);
    }

    public void setFromString(String name, String value) {
        if (name.equals("isXSet")) {
            this.setXState(this.booleanFromString(value));
            return;
        }
        if (name.equals("isYSet")) {
            this.setYState(this.booleanFromString(value));
            return;
        }
        if (name.equals("xShown")) {
            this.setXShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("yShown")) {
            this.setYShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("xLogLabel")) {
            this.setXLogLabel(this.booleanFromString(value));
            return;
        }
        if (name.equals("logLabelSet")) {
            this.setLogLabelSet(this.booleanFromString(value));
            return;
        }
        if (name.equals("yLogLabel")) {
            this.setYLogLabel(this.booleanFromString(value));
            return;
        }
        if (name.equals("xRotated")) {
            this.setXRotated(this.booleanFromString(value));
            return;
        }
        if (name.equals("yRotated")) {
            this.setYRotated(this.booleanFromString(value));
            return;
        }
        if (name.equals("font")) {
            this.setFont(this.fontFromString(value));
            return;
        }
        if (name.equals("colour")) {
            this.setColour(this.colorFromString(value));
            return;
        }
        if (name.equals("xGap")) {
            this.setXGap(this.doubleFromString(value));
            return;
        }
        if (name.equals("yGap")) {
            this.setYGap(this.doubleFromString(value));
            return;
        }
        if (name.equals("digits")) {
            this.setDigits(this.intFromString(value));
            return;
        }
        System.err.println("AstNumberLabels: unknown configuration property:" + name + " (" + value + ")");
    }
}

