/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.gui;

import java.awt.Color;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.grf.DefaultGrf;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;

public class AstTicks
extends AbstractPlotControlsModel {
    protected boolean isSet;
    protected boolean show;
    protected boolean logSpacingSet;
    protected boolean xLogSpacing;
    protected boolean yLogSpacing;
    protected Color colour;
    protected double xGap;
    protected double yGap;
    protected int xLogGap;
    protected int yLogGap;
    protected double majorXTicklen;
    protected double majorYTicklen;
    protected double minorXTicklen;
    protected double minorYTicklen;
    protected int minorXDivisions;
    protected int minorYDivisions;
    protected int style;
    protected double width;
    protected boolean tickAll;
    public static final double MAX_LENGTH = 0.1;
    public static final double MIN_LENGTH = -0.1;
    public static final double STEP_LENGTH = 0.005;

    public AstTicks() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.isSet = false;
        this.show = true;
        this.logSpacingSet = false;
        this.xLogSpacing = true;
        this.yLogSpacing = true;
        this.colour = Color.black;
        this.xGap = DefaultGrf.BAD;
        this.yGap = DefaultGrf.BAD;
        this.xLogGap = 0;
        this.yLogGap = 0;
        this.majorXTicklen = 0.015;
        this.majorYTicklen = 0.015;
        this.minorXTicklen = 0.007;
        this.minorYTicklen = 0.007;
        this.minorXDivisions = 0;
        this.minorYDivisions = 0;
        this.style = 1;
        this.width = 1.0;
        this.tickAll = true;
        this.fireChanged();
    }

    public void setState(boolean isSet) {
        this.isSet = isSet;
    }

    public boolean getState() {
        return this.isSet;
    }

    public void setShown(boolean show) {
        this.show = show;
        this.setState(true);
        this.fireChanged();
    }

    public boolean getShown() {
        return this.show;
    }

    public void setLogSpacingSet(boolean logSpacingSet) {
        this.logSpacingSet = logSpacingSet;
        if (logSpacingSet) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public boolean getLogSpacingSet() {
        return this.logSpacingSet;
    }

    public void setXLogSpacing(boolean xLogSpacing) {
        this.xLogSpacing = xLogSpacing;
        this.setState(true);
        this.fireChanged();
    }

    public boolean getXLogSpacing() {
        return this.xLogSpacing;
    }

    public void setYLogSpacing(boolean yLogSpacing) {
        this.yLogSpacing = yLogSpacing;
        this.setState(true);
        this.fireChanged();
    }

    public boolean getYLogSpacing() {
        return this.yLogSpacing;
    }

    public void setColour(Color colour) {
        this.colour = colour;
        if (colour != null) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public Color getColour() {
        return this.colour;
    }

    public void setXGap(double xGap) {
        this.xGap = xGap == 0.0 ? DefaultGrf.BAD : xGap;
        if (xGap != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getXGap() {
        return this.xGap;
    }

    public void setYGap(double yGap) {
        this.yGap = yGap == 0.0 ? DefaultGrf.BAD : yGap;
        if (yGap != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getYGap() {
        return this.yGap;
    }

    public void setXLogGap(int xLogGap) {
        this.xLogGap = xLogGap;
        if (xLogGap != 0) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public int getXLogGap() {
        return this.xLogGap;
    }

    public void setYLogGap(int yLogGap) {
        this.yLogGap = yLogGap;
        if (yLogGap != 0) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public int getYLogGap() {
        return this.yLogGap;
    }

    public void setWidth(double width) {
        this.width = width;
        if (width != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getWidth() {
        return this.width;
    }

    public void setStyle(int style) {
        this.style = style;
        this.setState(true);
        this.fireChanged();
    }

    public double getStyle() {
        return this.style;
    }

    public void setTickAll(boolean tickAll) {
        this.tickAll = tickAll;
        this.setState(true);
        this.fireChanged();
    }

    public boolean getTickAll() {
        return this.tickAll;
    }

    public void setMajorXTicklength(double majorXTicklen) {
        this.majorXTicklen = majorXTicklen;
        if (majorXTicklen != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public void setMajorYTicklength(double majorYTicklen) {
        this.majorYTicklen = majorYTicklen;
        if (this.majorXTicklen != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getMajorXTicklength() {
        return this.majorXTicklen;
    }

    public double getMajorYTicklength() {
        return this.majorYTicklen;
    }

    public void setMinorXTicklength(double minorXTicklen) {
        this.minorXTicklen = minorXTicklen;
        if (minorXTicklen != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public void setMinorYTicklength(double minorYTicklen) {
        this.minorYTicklen = minorYTicklen;
        if (minorYTicklen != DefaultGrf.BAD) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public double getMinorXTicklength() {
        return this.minorXTicklen;
    }

    public double getMinorYTicklength() {
        return this.minorYTicklen;
    }

    public void setMinorXDivisions(int minorXDivisions) {
        this.minorXDivisions = minorXDivisions;
        if (minorXDivisions != 0) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public int getMinorXDivisions() {
        return this.minorXDivisions;
    }

    public void setMinorYDivisions(int minorYDivisions) {
        this.minorYDivisions = minorYDivisions;
        if (minorYDivisions != 0) {
            this.setState(true);
        }
        this.fireChanged();
    }

    public int getMinorYDivisions() {
        return this.minorYDivisions;
    }

    public String getAstOptions() {
        if (!this.isSet) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.show) {
            buffer.append("MajTicklen=0.0");
            buffer.append(",MinTicklen=0.0");
            return buffer.toString();
        }
        buffer.append("Style(ticks)=");
        buffer.append(this.style);
        if (this.colour != null) {
            buffer.append(",Colour(ticks)=");
            int value = DefaultGrf.encodeColor(this.colour);
            if (value == -1) {
                value = 0;
            }
            buffer.append(value);
        }
        if (this.width != DefaultGrf.BAD) {
            buffer.append(",Width(ticks)=");
            buffer.append(this.width);
        }
        if (this.tickAll) {
            buffer.append(",TickAll=1");
        } else {
            buffer.append(",TickAll=0");
        }
        if (this.logSpacingSet) {
            if (this.xLogSpacing) {
                buffer.append(",LogTicks(1)=1");
            } else {
                buffer.append(",LogTicks(1)=0");
            }
            if (this.yLogSpacing) {
                buffer.append(",LogTicks(2)=1");
            } else {
                buffer.append(",LogTicks(2)=0");
            }
        }
        if (this.xLogGap != 0) {
            buffer.append(",LogGap(1)=");
            buffer.append(Math.pow(10.0, this.xLogGap));
        }
        if (this.yLogGap != 0) {
            buffer.append(",LogGap(2)=");
            buffer.append(Math.pow(10.0, this.yLogGap));
        }
        if (this.xGap != DefaultGrf.BAD) {
            buffer.append(",Gap(1)=");
            buffer.append(this.xGap);
        }
        if (this.yGap != DefaultGrf.BAD) {
            buffer.append(",Gap(2)=");
            buffer.append(this.yGap);
        }
        if (this.majorXTicklen != DefaultGrf.BAD) {
            buffer.append(",MajTicklen(1)=");
            buffer.append(this.majorXTicklen);
        }
        if (this.majorYTicklen != DefaultGrf.BAD) {
            buffer.append(",MajTicklen(2)=");
            buffer.append(this.majorYTicklen);
        }
        if (this.minorXTicklen != DefaultGrf.BAD) {
            buffer.append(",MinTicklen(1)=");
            buffer.append(this.minorXTicklen);
        }
        if (this.minorYTicklen != DefaultGrf.BAD) {
            buffer.append(",MinTicklen(2)=");
            buffer.append(this.minorYTicklen);
        }
        if (this.minorXDivisions != 0) {
            buffer.append(",MinTick(1)=");
            buffer.append(this.minorXDivisions);
        }
        if (this.minorYDivisions != 0) {
            buffer.append(",MinTick(2)=");
            buffer.append(this.minorYDivisions);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getAstOptions();
    }

    public String getTagName() {
        return "ticks";
    }

    public void encode(Element rootElement) {
        this.addChildElement(rootElement, "isSet", this.isSet);
        this.addChildElement(rootElement, "show", this.show);
        if (this.colour != null) {
            this.addChildElement(rootElement, "colour", this.colour);
        }
        this.addChildElement(rootElement, "logSpacingSet", this.logSpacingSet);
        this.addChildElement(rootElement, "xLogSpacing", this.xLogSpacing);
        this.addChildElement(rootElement, "yLogSpacing", this.yLogSpacing);
        this.addChildElement(rootElement, "xLogGap", this.xLogGap);
        this.addChildElement(rootElement, "yLogGap", this.yLogGap);
        this.addChildElement(rootElement, "xGap", this.xGap);
        this.addChildElement(rootElement, "yGap", this.yGap);
        this.addChildElement(rootElement, "majorXTicklen", this.majorXTicklen);
        this.addChildElement(rootElement, "majorYTicklen", this.majorYTicklen);
        this.addChildElement(rootElement, "minorXTicklen", this.minorXTicklen);
        this.addChildElement(rootElement, "minorYTicklen", this.minorYTicklen);
        this.addChildElement(rootElement, "minorXDivisions", this.minorXDivisions);
        this.addChildElement(rootElement, "minorYDivisions", this.minorYDivisions);
        this.addChildElement(rootElement, "style", this.style);
        this.addChildElement(rootElement, "width", this.width);
        this.addChildElement(rootElement, "tickAll", this.tickAll);
    }

    public void setFromString(String name, String value) {
        if (name.equals("isSet")) {
            this.setState(this.booleanFromString(value));
            return;
        }
        if (name.equals("show")) {
            this.setShown(this.booleanFromString(value));
            return;
        }
        if (name.equals("logSpacingSet")) {
            this.setLogSpacingSet(this.booleanFromString(value));
            return;
        }
        if (name.equals("xLogSpacing")) {
            this.setXLogSpacing(this.booleanFromString(value));
            return;
        }
        if (name.equals("yLogSpacing")) {
            this.setYLogSpacing(this.booleanFromString(value));
            return;
        }
        if (name.equals("xLogGap")) {
            this.setXLogGap(this.intFromString(value));
            return;
        }
        if (name.equals("yLogGap")) {
            this.setYLogGap(this.intFromString(value));
            return;
        }
        if (name.equals("colour")) {
            this.setColour(this.colorFromString(value));
            return;
        }
        if (name.equals("xGap")) {
            this.setXGap(this.doubleFromString(value));
            return;
        }
        if (name.equals("yGap")) {
            this.setYGap(this.doubleFromString(value));
            return;
        }
        if (name.equals("majorXTicklen")) {
            this.setMajorXTicklength(this.doubleFromString(value));
            return;
        }
        if (name.equals("majorYTicklen")) {
            this.setMajorYTicklength(this.doubleFromString(value));
            return;
        }
        if (name.equals("minorXTicklen")) {
            this.setMinorXTicklength(this.doubleFromString(value));
            return;
        }
        if (name.equals("minorYTicklen")) {
            this.setMinorYTicklength(this.doubleFromString(value));
            return;
        }
        if (name.equals("minorXDivisions")) {
            this.setMinorXDivisions(this.intFromString(value));
            return;
        }
        if (name.equals("minorYDivisions")) {
            this.setMinorYDivisions(this.intFromString(value));
            return;
        }
        if (name.equals("style")) {
            this.setStyle(this.intFromString(value));
            return;
        }
        if (name.equals("width")) {
            this.setWidth(this.doubleFromString(value));
            return;
        }
        if (name.equals("tickAll")) {
            this.setTickAll(this.booleanFromString(value));
            return;
        }
        System.err.println("AstTicks: unknown configuration property: " + name + " (" + value + ")");
    }
}

